/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.multilang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.filter.CompareCategory;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.multilang.ParameterUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MultiLangDataLoad
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangDataLoad.class);
    private static final String UNIQUE = "unique";
    private static final String FILENAME = "filename";

    public ApiResult doCustomService(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<Map<String, Map<String, String>>> list;
            String unique;
            Map checkResult;
            Object orgAuthorFilter;
            String urlFormat = "/app/mdl/MultiLangDataLoad";
            Object objResult = DispatchServiceHelper.invokeService((String)"kd.bos.openapi.servicehelper", (String)"bos", (String)"OpenApiEntityService", (String)"getUserConfig", (Object[])new Object[]{urlFormat});
            if (objResult instanceof Map && (orgAuthorFilter = (checkResult = (Map)objResult).get("org_author_filter")) instanceof Boolean && ((Boolean)orgAuthorFilter).booleanValue() && !this.isHasRight()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"MultiLangDataLoad_2", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
            ParameterUtil util = new ParameterUtil(params);
            switch (unique = util.getParam(UNIQUE)) {
                case "BOS_BillFunctionTypes": {
                    list = this.getFunctionTypes();
                    break;
                }
                case "FilterMetadata": {
                    list = this.getFilterMetadata();
                    break;
                }
                default: {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25", (String)"MultiLangDataLoad_1", (String)"bos-mservice-form", (Object[])new Object[0]));
                }
            }
            result.put(UNIQUE, unique);
            result.put(FILENAME, util.getParam(FILENAME));
            result.put("localeData", list);
            return ApiResult.success((Object)util.toEncrypt(SerializationUtils.toJsonString(result)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25: ", (Throwable)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25%s", (String)"MultiLangDataLoad_0", (String)"bos-mservice-form", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private List<Map<String, Map<String, String>>> getFunctionTypes() {
        HashMap<String, LocaleString> langData;
        ArrayList<Map<String, Map<String, String>>> list = new ArrayList<Map<String, Map<String, String>>>(16);
        FunctionTypes functionTypes = FunctionTypes.get();
        for (FunctionGroup functionGroup : functionTypes.getFunctionGroups()) {
            langData = new HashMap<String, LocaleString>(16);
            langData.put("FunctionGroup_" + functionGroup.getId(), functionGroup.getName());
            list.add(langData);
        }
        for (FunctionType functionType : functionTypes.getFunctionTypes()) {
            langData = new HashMap(16);
            langData.put("FunctionType_" + functionType.getId(), functionType.getName());
            langData.put("FunctionType_" + functionType.getId() + "_desc", functionType.getDesc());
            list.add(langData);
        }
        return list;
    }

    private List<Map<String, Map<String, String>>> getFilterMetadata() {
        ArrayList<Map<String, Map<String, String>>> list = new ArrayList<Map<String, Map<String, String>>>(16);
        FilterMetadata filterMetadata = FilterMetadata.get();
        for (CompareCategory type : filterMetadata.getCompareCategories()) {
            HashMap<String, LocaleString> langData = new HashMap<String, LocaleString>(16);
            langData.put("CompareCategory_" + type.getId(), type.getName());
            list.add(langData);
            for (CompareType compareType : type.getCompareTypes()) {
                langData = new HashMap(16);
                langData.put("CompareType_" + type.getId() + "|" + compareType.getId(), compareType.getName());
                list.add(langData);
            }
        }
        return list;
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, null, (String)"pc_devportal_main", (String)"47150e89000000ac");
        return flag == 1;
    }
}

