/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.multilang;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.service.metadata.util.GzipUtils;

class ParameterUtil {
    private static final String ENCRYPT = "isEncrypt";
    private Map<String, Object> params;
    private boolean isEncrypt;

    public ParameterUtil(Map<String, Object> params) {
        this.params = params;
        this.isEncrypt = Boolean.TRUE.equals(Boolean.valueOf(String.valueOf(params.get(ENCRYPT))));
    }

    public String getParam(String key) throws IOException {
        String result = this.getUnCompress(key);
        if (result == null) {
            result = (String)this.params.get(key);
        }
        return result;
    }

    private String getUnCompress(String key) throws IOException {
        if (this.isEncrypt) {
            return GzipUtils.uncompress((String)this.params.get(key), "utf-8");
        }
        return null;
    }

    public List<Map<String, Map<String, String>>> getParamList(String key) throws IOException {
        String list = this.getUnCompress(key);
        if (list != null) {
            return (List)SerializationUtils.fromJsonString((String)list, List.class);
        }
        return (List)this.params.get(key);
    }

    public void putEncrypt(Map<String, Object> params, String key, Object data) throws IOException {
        if (this.isEncrypt) {
            params.computeIfAbsent(ENCRYPT, k -> Boolean.TRUE);
            String text = data instanceof String ? (String)data : SerializationUtils.toJsonString((Object)data);
            params.put(key, GzipUtils.compress(text, "utf-8"));
        } else {
            params.put(key, data);
        }
    }

    public String toEncrypt(String jsonData) throws IOException {
        if (this.isEncrypt) {
            return GzipUtils.compress(jsonData, "utf-8");
        }
        return jsonData;
    }
}

