/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.tips;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.CacheKeyUtil;

class HotTipsCacheManager {
    private static final String BOS_HOT_TIPS_TYPE = "BOS_HOTTIPS_REGION";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BOS_HOTTIPS_REGION", new DistributeCacheHAPolicy());

    HotTipsCacheManager() {
    }

    protected static List<Object> getFromCache(String formId, int formType) {
        List<Object> tipsList = HotTipsLocalCache.getTipsFromLocal(formId, formType);
        if (tipsList == null && (tipsList = HotTipsCacheManager.getFromRedisCache(formId, formType)) != null) {
            HotTipsLocalCache.putToLocalCache(formId, formType, tipsList);
        }
        return tipsList;
    }

    protected static void putToCache(String formId, int formType, List<Object> tipsList) {
        HotTipsCacheManager.putToRedisCache(formId, formType, tipsList);
        HotTipsLocalCache.putToLocalCache(formId, formType, tipsList);
    }

    protected static void clearCache(List<Tuple<String, Integer>> formList) {
        if (formList == null || formList.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(10);
        for (Tuple<String, Integer> form : formList) {
            String key = HotTipsLocalCache.genTipsCacheKey((String)form.item1, (Integer)form.item2);
            keys.add(key);
        }
        HotTipsLocalCache.getLocalCache().remove(keys.toArray(new String[keys.size()]));
        cache.remove(HotTipsCacheManager.getRootCacheKey(), keys.toArray(new String[keys.size()]));
    }

    protected static void clearCache() {
        HotTipsLocalCache.getLocalCache().clear();
        cache.remove(HotTipsCacheManager.getRootCacheKey());
    }

    private static void putToRedisCache(String formId, int formType, List<Object> tipsList) {
        if (tipsList == null) {
            return;
        }
        String rootCacheKey = HotTipsCacheManager.getRootCacheKey();
        String key = HotTipsLocalCache.genTipsCacheKey(formId, formType);
        String tipsListStr = SerializationUtils.toJsonString(tipsList);
        cache.put(rootCacheKey, key, (Object)tipsListStr);
    }

    private static List<Object> getFromRedisCache(String formId, int formType) {
        String key;
        String rootCacheKey = HotTipsCacheManager.getRootCacheKey();
        String tipsListStr = (String)cache.get(rootCacheKey, key = HotTipsLocalCache.genTipsCacheKey(formId, formType));
        if (tipsListStr == null) {
            return null;
        }
        List tipsList = (List)SerializationUtils.fromJsonString((String)tipsListStr, List.class);
        return tipsList;
    }

    private static String getRootCacheKey() {
        return String.format("%s_%s_%s", CacheKeyUtil.getAcctId(), BOS_HOT_TIPS_TYPE, "CACHE_KEY");
    }

    static class HotTipsLocalCache {
        HotTipsLocalCache() {
        }

        protected static void putToLocalCache(String formId, int formType, List<Object> tipsList) {
            String key = HotTipsLocalCache.genTipsCacheKey(formId, formType);
            HotTipsLocalCache.getLocalCache().put(key, tipsList);
        }

        protected static List<Object> getTipsFromLocal(String formId, int formType) {
            String key = HotTipsLocalCache.genTipsCacheKey(formId, formType);
            return (List)HotTipsLocalCache.getLocalCache().get(key);
        }

        protected static String genTipsCacheKey(String formId, int formType) {
            return (formId + "_" + formType + ".cache_key").toLowerCase();
        }

        protected static LocalMemoryCache getLocalCache() {
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(43200);
            info.setMaxItemSize(500);
            return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), HotTipsCacheManager.BOS_HOT_TIPS_TYPE, info);
        }
    }
}

