/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.service.upgrade.DeployPackageInfo;
import kd.bos.service.upgrade.MQDeployServiceImpl;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;

public class DeployConsumer
implements MessageConsumer {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private Log logger = LogFactory.getLog(DeployConsumer.class);
    private long taskid;
    private String ver;
    private String dmUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        MQDeployServiceImpl mqDeployService = new MQDeployServiceImpl();
        try {
            this.logger.info("\u63a5\u6536\u5230\u6d88\u606f\uff1amessage:" + body + " resend:" + resend);
            if (body == null) {
                this.logger.warn("dm\u5305\u5347\u7ea7\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u9000\u51fa\u6d88\u8d39\u3002body\uff1a" + body);
                return;
            }
            if (body instanceof DeployParam) {
                DeployParam param = (DeployParam)body;
                this.logger.info("deployParam:" + param.toString());
                this.taskid = param.getTaskId();
                this.ver = param.getFullVer();
                this.dmUrl = param.getDmUrl();
                if (resend) {
                    DeployLog.warn(this.taskid, this.ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"dm:%s \u88ab\u91cd\u65b0\u6d88\u8d39\uff0c\u5e94\u8be5\u662fdm\u5305\u6267\u884c\u4e2d\u5fae\u670d\u52a1\u6302\u4e86\u3002", (String)"DeployConsumer_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.dmUrl));
                }
                DeployLog.info(this.taskid, this.ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"dm:%s\u5f00\u59cb\u6d88\u8d39\u3002", (String)"DeployConsumer_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.dmUrl));
                mqDeployService.deployDM(param);
                DeployLog.info(this.taskid, this.ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"dm:%s\u6d88\u8d39\u5b8c\u6210\u3002", (String)"DeployConsumer_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.dmUrl));
            } else {
                this.logger.warn("message\u4e0d\u662fDeployParam\u7c7b\u578b");
                HashMap message = (HashMap)body;
                this.taskid = (Long)message.get("id");
                this.ver = (String)message.get("ver");
                this.dmUrl = (String)message.get("dmUrl");
                if (resend) {
                    DeployLog.warn(this.taskid, this.ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"dm:%s \u88ab\u91cd\u65b0\u6d88\u8d39\uff0c\u5e94\u8be5\u662fdm\u5305\u6267\u884c\u4e2d\u5fae\u670d\u52a1\u6302\u4e86\u3002", (String)"DeployConsumer_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.dmUrl));
                }
                mqDeployService.deployDM(this.taskid, this.ver, this.dmUrl);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6d88\u8d39\u5347\u7ea7\u6d88\u606f\u51fa\u9519\uff0cERR:" + e.getMessage(), (Throwable)e);
            String result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"Deploy dm error,\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0czip\u5305\u90e8\u7f72\u5347\u7ea7\u5931\u8d25\u3002", (String)"DeployConsumer_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
            try {
                DeployLog.error(this.taskid, this.ver, DeployCategory.Package, result, e);
                DeployPackageInfo.saveErrorDeployInfo(this.taskid, this.ver, null);
            }
            catch (Exception e2) {
                this.logger.error("Deploy dm error and save error DeployInfo error.", (Throwable)e2);
            }
        }
        finally {
            acker.ack(messageId);
        }
    }
}

