/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

class DmCheckUtils {
    private static Log log = LogFactory.getLog(DmCheckUtils.class);
    private static String UPGRADE_LOGIN_API = "/api/upgradeLogin.do";
    private static String CHECK_UID_API = "/kapi/v2/mc/upgrade/checkUid";
    private static final String DEPLOY_CHECK_UID_MC_TOKEN = "DEPLOY_CHECK_UID_MC_TOKEN";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String APPLICATION_JSONANDCHARSET = "application/json;charset=UTF-8";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String MC_SERVER_URL = "mc.server.url";
    private static final String MC_SYSTEM_PROFILE = "mc.system.profile";
    private static final String SUCCESS = "success";
    private static final int TOKEN_CACHE_TIMEOUT = 3600;
    private static int CONNECTION_TIMEOUT = 1000;
    private static int READ_TIMEOUT = 1000;
    private static boolean enableCheckDm = false;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("DEPLOY_CHECK_UID_MC_TOKEN", new DistributeCacheHAPolicy());

    DmCheckUtils() {
    }

    private static Map<String, Object> loadMCProfile() {
        try {
            String config = System.getProperty(MC_SYSTEM_PROFILE);
            if (StringUtils.isBlank((CharSequence)config)) {
                return new HashMap<String, Object>(0);
            }
            Map configMap = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
            return configMap;
        }
        catch (Exception e) {
            log.error(String.format("loadMCProfile fail msg:%s", e.getMessage(), e));
            return new HashMap<String, Object>(0);
        }
    }

    protected static boolean checkDmParam(DeployParam deployParam, String uid) {
        DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format("beigin - check DM param %s.", enableCheckDm));
        if (!enableCheckDm) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)uid)) {
            log.info(String.format(ResManager.loadKDString((String)"taskid %s uid \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5mc\u7684\u7248\u672c", (String)"DmCheckUtils_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), deployParam.getTaskId()));
        }
        String dmUrl = deployParam.getDmUrl();
        String accessToken = DmCheckUtils.getAccessToken(deployParam);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            accessToken = DmCheckUtils.getAccessToken(deployParam);
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, ResManager.loadKDString((String)"\u767b\u5f55mc\u5931\u8d25\uff0c\u8bf7\u4ecemonitor\u67e5\u770b\u8be6\u7ec6\u9519\u8bef\u3002", (String)"DmCheckUtils_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return false;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("api", "true");
        header.put("accessToken", accessToken);
        header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
        HashMap<String, String> postData = new HashMap<String, String>(1);
        postData.put("dmurl", dmUrl);
        postData.put("uid", uid);
        try {
            String resultStr = MCApiUtil.callMcApiService((String)CHECK_UID_API, (String)"text/json", header, postData, (int)CONNECTION_TIMEOUT);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                resultStr = MCApiUtil.callMcApiService((String)CHECK_UID_API, (String)"text/json", header, postData, (int)CONNECTION_TIMEOUT);
            }
            if (StringUtils.isNotBlank((CharSequence)resultStr)) {
                JSONObject resp = JSONObject.parseObject((String)resultStr);
                String errorCode = resp.getString("errorCode");
                if ("404".equalsIgnoreCase(errorCode)) {
                    log.info(String.format("taskid\uff1a %s checkUid 404 msg:%s", deployParam.getTaskId(), resp.getString("message")));
                    return true;
                }
                if ("0".equalsIgnoreCase(errorCode)) {
                    boolean status;
                    boolean bl = status = resp.get((Object)"status") == null ? false : (Boolean)resp.get((Object)"status");
                    if (!status) {
                        DeployLog.error(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"check DM param \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u53c2\u6570\uff0cMC\u54cd\u5e94: %s ", (String)"DmCheckUtils_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), resp.getString("message")), new KDException("check DM param fail."));
                    }
                    return status;
                }
                DeployLog.error(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"check DM param \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u53c2\u6570\uff0cMC\u54cd\u5e94: %s ", (String)"DmCheckUtils_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), resp.getString("message")), new KDException("check DM param faile."));
                return false;
            }
            DeployLog.error(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"check DM param MC\u54cd\u5e94: %s ", (String)"DmCheckUtils_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), resultStr), new KDException("check DM param fail MC response is null."));
            return false;
        }
        catch (Exception e) {
            DeployLog.error(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"check DM param fail\uff0c msg: %s ", (String)"DmCheckUtils_5", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage()), e);
            return false;
        }
    }

    private static String getAccessToken(DeployParam deployParam) {
        String cacheToken = (String)cache.get(DmCheckUtils.getTokenCacheKey());
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            return cacheToken;
        }
        HashMap<String, String> postData = new HashMap<String, String>(2);
        postData.put("accountId", "");
        postData.put("tenantid", "");
        HashMap headers = new HashMap();
        try {
            String state;
            String resultStr = MCApiUtil.callMcApiService((String)UPGRADE_LOGIN_API, (String)"text/json", headers, postData, (int)READ_TIMEOUT);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                log.info(String.format(ResManager.loadKDString((String)"taskid:%s \u83b7\u53d6MC token \u54cd\u5e94\u4e3a\u7a7a", (String)"DmCheckUtils_6", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), deployParam.getTaskId()));
                return "";
            }
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            String string = state = result.get("state") == null ? "" : (String)result.get("state");
            if (SUCCESS.equals(state)) {
                Map data;
                Map map = data = result.get("data") == null ? null : (Map)result.get("data");
                if (data != null) {
                    String accessToken = data.get("access_token") == null ? "" : (String)data.get("access_token");
                    cache.put(DmCheckUtils.getTokenCacheKey(), (Object)accessToken, 3600);
                    return accessToken;
                }
            } else {
                log.info(String.format(ResManager.loadKDString((String)"taskid\uff1a%1$s \u83b7\u53d6MC token\u5931\u8d25\uff0cres:%2$s", (String)"DmCheckUtils_7", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), deployParam.getTaskId(), resultStr));
            }
        }
        catch (Exception e) {
            DeployLog.error(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u83b7\u53d6MC token\u5931\u8d25,err:%s", (String)"DmCheckUtils_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), e.getMessage()), e);
        }
        return "";
    }

    protected static void removeTokenCache() {
        cache.remove(DmCheckUtils.getTokenCacheKey());
    }

    private static String getTokenCacheKey() {
        return String.format("%s_%s", CacheKeyUtil.getAcctId(), DEPLOY_CHECK_UID_MC_TOKEN);
    }

    static {
        Map<String, Object> configMap = DmCheckUtils.loadMCProfile();
        enableCheckDm = configMap.get("validate") == null ? false : (Boolean)configMap.get("validate");
        ConfigurationUtil.observeChange((String)MC_SYSTEM_PROFILE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                Map configMap = DmCheckUtils.loadMCProfile();
                enableCheckDm = configMap.get("validate") == null ? false : (Boolean)configMap.get("validate");
            }
        });
    }
}

