/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.util.FileUtils;

public class DownloadDir {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";

    protected static File cloneFile(DeployParam param) {
        File tempFile = DownloadDir.createTempDir();
        String localRoot = tempFile.getPath() + "/datamodel";
        File root = new File(localRoot = localRoot.replace("\\", "/"));
        if (!root.exists()) {
            root.mkdir();
        }
        String rootDirPath = param.getDmUrl();
        String remotePath = rootDirPath + "/datamodel";
        String txtFileName = "/filelist.txt";
        String txtRemotePath = remotePath + txtFileName;
        File txtFile = new File(localRoot, txtFileName);
        DeployLog.info(param.getTaskId(), param.getFullVer(), DeployCategory.Package, String.format("txtFile\uff1a%s", txtFile));
        List<String> paths = DownloadDir.readFileList(param, txtRemotePath, txtFile);
        for (String path : paths) {
            String remoteFilePath = remotePath + path;
            remoteFilePath = remoteFilePath.replace("\\", "/");
            String localFilePath = root.getPath() + path;
            localFilePath = localFilePath.replace("\\", "/");
            File localFile = new File(localFilePath = DownloadDir.cleanString(localFilePath.replace("../", "#")));
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            DownloadDir.downloadFile(param, remoteFilePath, localFile);
        }
        return tempFile;
    }

    private static List<String> readFileList(DeployParam param, String remotePath, File localFile) {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        ArrayList<String> fileList = new ArrayList<String>();
        boolean success = true;
        try {
            urlfile = new URL(remotePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(httpUrl.getInputStream()));
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(localFile)));){
                String lineText = null;
                while ((lineText = br.readLine()) != null) {
                    fileList.add(lineText);
                    writer.write(lineText);
                    writer.newLine();
                }
            }
            httpUrl.disconnect();
        }
        catch (Exception e) {
            success = false;
            String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
            DeployLog.error(param.getTaskId(), param.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5217\u8868\u8bfb\u53d6\u51fa\u9519\uff0cremoteURL\uff1a%1$s localFilePath:%2$s stack:%3$s", (String)"DownloadDir_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), remotePath, localFile.getPath(), stackMsg), e);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5217\u8868\u8bfb\u53d6\u51fa\u9519\uff0cremoteURL\uff1a%1$s localFilePath:%2$s stack:%3$s", (String)"DownloadDir_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), remotePath, localFile.getPath(), stackMsg)});
        }
        return fileList;
    }

    private static void downloadFile(DeployParam param, String remoteFilePath, File localFile) {
        for (int i = 0; i < 10; ++i) {
            if (DownloadDir.downloadStreamFile(param, remoteFilePath, localFile)) {
                if (i <= 0) break;
                DeployLog.warn(param.getTaskId(), param.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"remoteFilePath\uff1a%s \u7b2c\uff1a%d \u6b21\u5c1d\u8bd5\u4e0b\u8f7d\u6210\u529f\uff01", (String)"DownloadDir_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), remoteFilePath, i));
                break;
            }
            DeployLog.warn(param.getTaskId(), param.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"remoteFilePath\uff1a%s \u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u5c06\u8fdb\u884c\u91cd\u8bd5...\u5f53\u524d\u91cd\u8bd5\u6b21\u6570\uff1a%d", (String)"DownloadDir_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), remoteFilePath, i));
        }
    }

    private static boolean downloadStreamFile(DeployParam param, String remoteFilePath, File localFile) {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        boolean success = true;
        try {
            urlfile = new URL(FileUtils.cleanString((String)remoteFilePath));
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            success = DownloadDir.downloadStreamFileInner(localFile, httpUrl);
            httpUrl.disconnect();
        }
        catch (Exception e) {
            success = false;
            String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
            DeployLog.error(param.getTaskId(), param.getFullVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519\uff0cremoteURL\uff1a%1$s localFilePath:%2$s stack:%3$s", (String)"DownloadDir_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), remoteFilePath, localFile.getPath(), stackMsg), e);
        }
        return success;
    }

    private static boolean downloadStreamFileInner(File localFile, HttpURLConnection httpUrl) throws IOException {
        boolean success = true;
        try (BufferedInputStream bis = new BufferedInputStream(httpUrl.getInputStream());
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(localFile));){
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (IOException e) {
            success = false;
            throw e;
        }
        return success;
    }

    private static File createTempDir() {
        File baseDir = new File(DownloadDir.cleanString(System.getProperty("java.io.tmpdir")));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    private static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("../", "#");
        StringBuilder cleanString = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            cleanString.append(DownloadDir.cleanChar(str.charAt(i)));
        }
        return cleanString.toString();
    }

    private static char cleanChar(char c) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        switch (c) {
            case 58: {
                return ':';
            }
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
        }
        if (((char)c + "").equals("\\")) {
            return (char)c;
        }
        return '%';
    }
}

