/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.bind.JAXBException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.db.tx.TXImplicitHint;
import kd.bos.dbversion.IndustryVersionService;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.dlock.DLock;
import kd.bos.entity.DBVersion;
import kd.bos.entity.gray.GrayAppInfo;
import kd.bos.entity.gray.GrayInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.upgrade.IUpgradePlugin;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metagray.MetaGrayService;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.perflog.PerfLogger;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.service.CloudAppMappingDictionary;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.DeployPackageInfo;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.DeployPackageType;
import kd.bos.service.upgrade.DeployPublisher;
import kd.bos.service.upgrade.DmCheckUtils;
import kd.bos.service.upgrade.DownloadDir;
import kd.bos.service.upgrade.IndustryVersion;
import kd.bos.service.upgrade.MQDeployService;
import kd.bos.service.upgrade.MyX509TrustManager;
import kd.bos.service.upgrade.ReleaseGrayRunnable;
import kd.bos.service.upgrade.StandUpgradePlugin;
import kd.bos.service.upgrade.StandardVersion;
import kd.bos.service.upgrade.StopGrayRunnable;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.service.upgrade.XmlFileHandler;
import kd.bos.service.upgrade.after.DeployPackageServiceImpl;
import kd.bos.service.upgrade.deploy.DeplayDataModelBase;
import kd.bos.service.upgrade.deploy.DeployDataModel;
import kd.bos.service.upgrade.deploy.UndoDataModel;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployParam;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.service.upgrade.entity.UpGradeScript;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;

public class MQDeployServiceImpl
implements MQDeployService {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Log log = LogFactory.getLog(MQDeployServiceImpl.class);
    private static final String T_BAS_SQLVERSION = "T_BAS_SQLVERSION";
    private static final String DEPLOY_PROGRESS = "deploy_progress";
    public static final String DEPLOY_RESEND_STATE = "deploy_resend_state";
    public static final String DEPLOY_SYSTEM_UPGRADE_STATE = "bos_deploy_cache_system_upgrade_state";
    public static final int CACHE_TIMEOUT = 3600;
    private static final String STATUS = "status";
    private static final String BOS_DEPLOY_CACHE = "bos_deploy_cache_";
    private static final String LOGID = "logid";
    private static final String ERROR = "error";
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String ERROR_INFO = "errorInfo";
    private static final String STATE = "state";
    private static final String MESSAGE = "message";
    private static final String PARAMS = "params";
    private static final String APPGROUP = "appGroup";
    private static final String DMURL = "dmurl";
    private static final String TASKID = "taskid";
    private static final String UNZIP = "unzip";
    private static final String ISUNDO = "isUndo";
    private static final String ISLOCAL = "isLocal";
    private static final String DBROUTE = "dbroute: ";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String PRODUCT_NUMBER = "productNumber\uff1a";
    public static final String EXEC_DEPRECATEDMETHOD = "kd.deployapi.execdeprecatedmethod";
    private static String SCHEME_HTTPS = "https";
    private static String SCHEME_HTTP = "http";
    private static String BIG_TABLE_PACK = "bigTablePack";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String APPLICATION_JSONANDCHARSET = "application/json;charset=UTF-8";
    private static final String MC_SERVER_URL = "mc.server.url";
    private static String deploy_dm_forceunzip = "deploy.dm.forceunzip";
    private static boolean forceUnZip = false;
    private static String deploy_dm_zip = "deploy.dm.zip";
    private static boolean deployZip = false;
    private static String deploy_publish_thread = "deploy.publish.thread";
    private static boolean publishThread = true;
    private static String deploy_after_publish_thread = "deploy.after.publish.thread";
    private static boolean afterPublishThread = true;
    private static String deploy_thread_core = "deploy.thread.core";
    private static int deployThreadCore = 6;
    private static String deploy_after_thread_core = "deploy.after.thread.core";
    private static int deAfterThreadCore = 3;
    private static final String REBUILD_INSTANCE_ID = "rebuild_instance_id";
    protected static ExecutorService es;
    private static ExecutorService dpAfterEs;
    private static Object lockObj;
    private static final HostnameVerifier DO_NOT_VERIFY;

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    }

    public Map<String, Object> excuteStatus(long taskid) {
        Object[] params = new Object[]{taskid};
        String sql = "select FRESULT from t_bas_deployinfo where FID = ?";
        String result = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String result = "";
                if (rs.next()) {
                    result = rs.getString(1);
                }
                return result;
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)result)) {
            String instanceId;
            DeployState deployState = new DeployState(taskid);
            map.put(STATUS, 2);
            map.put("progress", deployState.getPropgress());
            String resendState = deployState.getDeployResendState();
            if (StringUtils.isNotBlank((CharSequence)resendState) && "1".equals(resendState)) {
                map.put(STATUS, 3);
                log.warn(String.format("taskid %s \u5df2\u88ab\u91cd\u65b0\u6d88\u8d39\uff0c\u539f\u5fae\u670d\u52a1\u53ef\u80fd\u88ab\u91cd\u542f\u3002", taskid));
            }
            if (!this.isAlive(taskid, instanceId = deployState.getDeployInstanceId())) {
                log.warn(String.format("taskid %s \u5fae\u670d\u52a1\u5b9e\u4f8b %s \u5b58\u6d3b\u6027\u68c0\u67e5\u4e3a\u4e0d\u5b58\u6d3b\u53ef\u80fd\u88ab\u91cd\u542f\u3002", taskid, instanceId));
                map.put(STATUS, 6);
            }
        } else {
            int res = Integer.parseInt(result);
            if (res == 5) {
                res = 1;
                map.put("warn", true);
            }
            map.put(STATUS, res);
        }
        return map;
    }

    public Map<String, Object> getLogs(long taskid, final long logid) {
        Object[] params = new Object[]{taskid, logid};
        String sql = "select FID, FCONTENT, FDATETIME from T_LOG_DEPLOY where FPACKAGEID = ? and FID > ? ORDER BY FID";
        Map result = (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>();
                long maxid = 0L;
                StringBuilder sb = new StringBuilder();
                while (rs.next()) {
                    maxid = rs.getLong(1);
                    sb.append(rs.getString(2)).append(System.lineSeparator());
                }
                if (maxid == 0L) {
                    maxid = logid;
                }
                result.put(MQDeployServiceImpl.LOGID, maxid);
                result.put("logs", sb.toString());
                return result;
            }
        });
        log.info(String.format("getLogs taskid %s logid %s maxid %s", taskid, logid, result.get(LOGID)));
        return result;
    }

    private boolean isAlive(long taskid, String instanceId) {
        boolean isAlive = true;
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return isAlive;
        }
        for (int i = 0; i < 5 && !(isAlive = LivingServiceUtils.isInstanceAlive((String)instanceId)); ++i) {
            log.info(String.format("taskId %s \u5b9e\u4f8bId\uff1a%s \u7b2c %s \u6b21\u68c0\u6d4b\u4e3a\u4e0d\u5b58\u6d3b...", taskid, instanceId, i + 1));
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return isAlive;
    }

    protected String deployDM(long taskId, String ver, String dmUrl) {
        return this.deployDM(taskId, ver, dmUrl, "", 0);
    }

    private String deployDM(long taskId, String fullVer, String dmUrl, String appIds, int category) {
        DeployParam param = new DeployParam(taskId, fullVer, dmUrl, appIds, " ", " ", " ", null, category);
        return this.deployDM(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String deployDM(DeployParam param) {
        long actionStartTimeStamp;
        DeployResult result;
        block39: {
            DeployInfo packageInfo;
            File tempFile;
            DeplayDataModelBase deployDataModel;
            AbsractVersion verInfo;
            DeployState dp;
            String appGroup;
            String fullVer;
            long taskId;
            block38: {
                result = new DeployResult();
                taskId = param.getTaskId();
                fullVer = param.getFullVer();
                appGroup = param.getAppGroup();
                String instanceId = Instance.getInstanceId();
                dp = new DeployState(taskId);
                dp.setDeployInstanceId(instanceId);
                DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5347\u7ea7\u5305\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u7684\u670d\u52a1\u5b9e\u4f8b\u4e3a\uff1a%s", (String)"MQDeployServiceImpl_48", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), instanceId));
                DeployLog.info(taskId, fullVer, DeployCategory.Package, "begin - check dataCenter version");
                DB.__setIgnoreCheckThreadGetMaxConnectionCount((boolean)true);
                verInfo = this.getVerInfo(param);
                String dbVer = verInfo.getVer();
                deployDataModel = param.isUndo() ? new UndoDataModel() : new DeployDataModel();
                deployDataModel.setBigTablePack(param.isBigTablePack());
                if (StringUtils.isNotBlank((CharSequence)appGroup)) {
                    deployDataModel.setAppGroup(appGroup);
                }
                deployDataModel.setDeployState(dp);
                deployDataModel.setLocaleId(param.getLocaleId());
                if (!deployDataModel.checkVer(verInfo)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u68c0\u67e5\u6216\u4f9d\u8d56\u7248\u68c0\u67e5\u5931\u8d25\uff0cfullVer:%1$s, dbVer: %2$s, relyOn:%3$s ", (String)"MQDeployServiceImpl_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), fullVer, dbVer, param.getRelyOn());
                    result.addError(msg);
                    DeployLog.info(taskId, fullVer, DeployCategory.Package, msg);
                    DeployPackageInfo.saveErrorDeployInfo(taskId, fullVer, null);
                    return SerializationUtils.toJsonString((Object)result);
                }
                tempFile = null;
                packageInfo = null;
                actionStartTimeStamp = System.currentTimeMillis();
                if (!this.isExistField()) {
                    DLock lock = DLock.create((String)("bos/deploy/createdeployinfo" + RequestContext.get().getAccountId())).fastMode();
                    try {
                        if (lock.tryLock()) {
                            try {
                                this.checkTable(taskId, fullVer);
                                break block38;
                            }
                            catch (Exception e) {
                                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u90e8\u7f72\u6570\u636e\u6a21\u578b\u521b\u5efa\u8868\u5931\u8d25(\u5305id:%1$s)\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"MQDeployServiceImpl_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskId, ExceptionUtils.getExceptionStackTraceMessage((Exception)e))});
                            }
                        }
                        lock.lock();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "begin - create temp dir");
            if (deployZip) {
                tempFile = this.downloadFile(param, result);
            } else if (param.isUnzip()) {
                long start = System.currentTimeMillis();
                tempFile = DownloadDir.cloneFile(param);
                long end = System.currentTimeMillis();
                DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u62c9\u53d6\u6587\u4ef6\u76ee\u5f55\u8017\u65f6\uff1a%s", (String)"MQDeployServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), end - start));
            } else {
                tempFile = this.downloadFile(param, result);
            }
            String[] appids = param.getAppIds().trim().toLowerCase().split(",");
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "begin - read deploy info.");
            packageInfo = this.readDeployInfo(taskId, fullVer, param.getIsv(), tempFile, param.isUndo());
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "end - read deploy info.");
            packageInfo.setProductNumber(param.getProductNumber());
            packageInfo.setResult('1');
            if (param.isBigTablePack()) {
                packageInfo.setDescription("big table pack");
            }
            int i = 0;
            if (appids.length > 0 && StringUtils.isNotEmpty((CharSequence)param.getAppIds())) {
                for (String appid : appids) {
                    DeployAppInfo appInfo = packageInfo.getApp().get(appid);
                    if (appInfo == null) {
                        packageInfo.setResult('0');
                        result.addError(String.format(ResManager.loadKDString((String)"\u90e8\u7f72\u5305\u4e2d\u4e0d\u5b58\u5728appid:%s\u7684\u5e94\u7528\u3002", (String)"MQDeployServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appid));
                        DeployLog.error(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u90e8\u7f72\u5305\u4e2d\u4e0d\u5b58\u5728appid:%s\u7684\u5e94\u7528\u3002", (String)"MQDeployServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), appid), null);
                        continue;
                    }
                    this.deployByAppId(deployDataModel, appInfo, result, param.getCategory(), fullVer);
                    ++i;
                }
            } else {
                int size = packageInfo.getApp().size();
                for (DeployAppInfo appInfo : packageInfo.getApp().values()) {
                    this.deployByAppId(deployDataModel, appInfo, result, param.getCategory(), fullVer);
                    ++i;
                }
            }
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "result error size is:" + result.getError().size());
            if (result.getError().size() > 0) {
                packageInfo.setResult('0');
            }
            dp.finish();
            if (packageInfo.getResult() == '1') {
                try {
                    this.saveVerInfo(packageInfo, verInfo, appGroup);
                    DeployLog.info(taskId, fullVer, DeployCategory.Package, taskId + " update version finish!");
                }
                catch (Exception e) {
                    packageInfo.setResult('5');
                    String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
                    DeployLog.warn(taskId, fullVer, DeployCategory.Package, taskId + " update version fail!, stacktrace:" + stackMsg);
                }
            }
            if (packageInfo.getResult() == '1' && result.getWarn().size() > 0) {
                packageInfo.setResult('5');
                DeployLog.warn(taskId, fullVer, DeployCategory.Package, taskId + " update warn !!!");
            }
            DeployPackageInfo.saveDeployPackageInfo(packageInfo, packageInfo.getClass());
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("save deployinfo %s finish!", packageInfo.getId()));
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "packageInfo result is:" + packageInfo.getResult());
            dp.finish();
            if (tempFile == null) break block39;
            try {
                if (forceUnZip || param.isUnzip() || !param.isUnzip() && StringUtils.isBlank((CharSequence)param.getDmSecret())) {
                    this.deleteFile(tempFile);
                    DeployLog.info(taskId, fullVer, DeployCategory.Package, "deploy delete temp file finish!");
                }
                break block39;
            }
            catch (Exception e) {
                String msg = String.format("deploy error: tempfile %s delete failed!", tempFile.getName());
                result.addError(msg);
                DeployLog.error(taskId, fullVer, DeployCategory.Package, msg, e);
            }
            break block39;
            catch (Throwable e) {
                try {
                    String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
                    DeployLog.error(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"deploy error.\u5806\u6808%s", (String)"MQDeployServiceImpl_4", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), stackMsg), e);
                    result.addError(e.getMessage());
                    DeployPackageInfo.saveErrorDeployInfo(taskId, fullVer, packageInfo);
                    dp.finish();
                    if (tempFile == null) break block39;
                }
                catch (Throwable throwable) {
                    dp.finish();
                    if (tempFile != null) {
                        try {
                            if (forceUnZip || param.isUnzip() || !param.isUnzip() && StringUtils.isBlank((CharSequence)param.getDmSecret())) {
                                this.deleteFile(tempFile);
                                DeployLog.info(taskId, fullVer, DeployCategory.Package, "deploy delete temp file finish!");
                            }
                        }
                        catch (Exception e2) {
                            String msg = String.format("deploy error: tempfile %s delete failed!", tempFile.getName());
                            result.addError(msg);
                            DeployLog.error(taskId, fullVer, DeployCategory.Package, msg, e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (forceUnZip || param.isUnzip() || !param.isUnzip() && StringUtils.isBlank((CharSequence)param.getDmSecret())) {
                        this.deleteFile(tempFile);
                        DeployLog.info(taskId, fullVer, DeployCategory.Package, "deploy delete temp file finish!");
                    }
                }
                catch (Exception e3) {
                    String msg = String.format("deploy error: tempfile %s delete failed!", tempFile.getName());
                    result.addError(msg);
                    DeployLog.error(taskId, fullVer, DeployCategory.Package, msg, e3);
                }
            }
        }
        long actionCost = System.currentTimeMillis() - actionStartTimeStamp;
        PerfLogger.logCost((String)"formAction", (long)actionCost, null);
        return SerializationUtils.toJsonString((Object)result);
    }

    private void deployByAppId(DeplayDataModelBase deployDataModel, DeployAppInfo appInfo, DeployResult result, int category, String fullVer) throws IOException {
        try (TXImplicitHint hint = TXImplicitHint.newHint((boolean)false);){
            deployDataModel.deployByAppId(appInfo, result, category);
        }
        DeployPackageInfo.saveDeployInfo(appInfo, appInfo.getClass());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, "save deploy app info finish!");
    }

    private void lowerVerInfo(DeployInfo packageInfo, String appGroup) {
        String fullVer = packageInfo.getFullVer();
        Object[] params = new Object[]{fullVer};
        boolean isGray = false;
        if (StringUtils.isNotBlank((CharSequence)appGroup)) {
            isGray = true;
        }
        DeployParam param = new DeployParam();
        param.setFullVer(fullVer);
        String productNumber = packageInfo.getProductNumber();
        AbsractVersion verInfo = StringUtils.isBlank((CharSequence)productNumber) ? new StandardVersion(param) : (StandardVersion.BIZ_NUMBER.equalsIgnoreCase(productNumber) || StandardVersion.BOS_NUMBER.equalsIgnoreCase(productNumber) ? new StandardVersion(param) : new IndustryVersion(param));
        try (TXHandle h = TX.required();){
            verInfo.getDeployParam().setFullVer(fullVer);
            verInfo.saveVer();
            if (isGray) {
                this.saveGrayVersion(packageInfo, fullVer, appGroup);
            } else {
                this.saveAppVersion(packageInfo, fullVer);
            }
        }
        catch (Exception e) {
            packageInfo.setResult('0');
            String msg = String.format("update ver error ! error stack: %s ", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            DeployLog.error(packageInfo.getId(), fullVer, DeployCategory.Package, msg, e);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"update ver error ! error message:" + e.getMessage()});
        }
    }

    private void saveVerInfo(DeployInfo packageInfo, AbsractVersion verInfo, String appGroup) {
        String fullVer = packageInfo.getFullVer();
        Object[] params = new Object[]{fullVer};
        boolean isGray = false;
        if (StringUtils.isNotBlank((CharSequence)appGroup)) {
            isGray = true;
        }
        try (TXHandle h = TX.required();){
            verInfo.getDeployParam().setFullVer(fullVer);
            verInfo.saveVer();
            if (isGray) {
                this.saveGrayVersion(packageInfo, fullVer, appGroup);
            } else {
                this.saveAppVersion(packageInfo, fullVer);
            }
        }
        catch (Exception e) {
            packageInfo.setResult('0');
            String msg = String.format("update ver error ! error stack: %s ", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            DeployLog.error(packageInfo.getId(), fullVer, DeployCategory.Package, msg, e);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"update ver error ! error message:" + e.getMessage()});
        }
        IndustryVersionService.clearCache((String)packageInfo.getProductNumber(), (String)packageInfo.getIsv());
    }

    private void saveGrayVersion(DeployInfo packageInfo, String fullVer, String appGroup) {
        GrayInfo grayInfo = new GrayInfo();
        grayInfo.setAppGroup(appGroup);
        grayInfo.setVer(fullVer);
        grayInfo.setCreateTime(packageInfo.getExecTime());
        grayInfo.setReleaseStatus("0");
        ArrayList<GrayAppInfo> list = new ArrayList<GrayAppInfo>();
        for (Map.Entry<String, DeployAppInfo> entry : packageInfo.getApp().entrySet()) {
            if (entry.getValue().getResult() != 1) continue;
            String appId = entry.getKey();
            GrayAppInfo gai = new GrayAppInfo();
            gai.setId(DB.genGlobalLongId());
            gai.setAppId(appId);
            gai.setAppGroup(appGroup);
            gai.setVersion(fullVer);
            gai.setIteration(packageInfo.getIteration());
            list.add(gai);
        }
        MetaGrayService mgs = new MetaGrayService();
        mgs.saveGrayInfo(grayInfo);
        mgs.saveGrayAppInfo(list);
    }

    private void saveAppVersion(DeployInfo packageInfo, String fullVer) {
        String insAppVerSql = "insert into T_BAS_APPVERSION (FID, FAPPID, FITERATION, FUPGRADETIME, FDBVERSION) values(?, ?, ?, getdate(), ?);";
        String updAppVerSql = "update T_META_BIZAPP set FVERSION = ? where FNUMBER = ?;";
        for (Map.Entry<String, DeployAppInfo> entry : packageInfo.getApp().entrySet()) {
            if (entry.getValue().getResult() != 1) continue;
            String appId = entry.getKey();
            Object[] appIds = new Object[]{appId};
            DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_APPVERSION where FAPPID = ? ;", (Object[])appIds);
            Object[] insAppParams = new Object[]{DB.genGlobalLongId(), appId, packageInfo.getIteration(), fullVer};
            DB.execute((DBRoute)DBRoute.meta, (String)insAppVerSql, (Object[])insAppParams);
            Object[] updBizAppParams = new Object[]{appId, fullVer};
            DB.execute((DBRoute)DBRoute.meta, (String)updAppVerSql, (Object[])updBizAppParams);
        }
    }

    private void checkTable(long taskid, String fullver) {
        DeployLog.info(taskid, fullver, DeployCategory.Package, "check table");
        boolean isCreateTable = this.checkCreateTables();
        UpGradeScript.executeScript();
        if (isCreateTable) {
            DeployLog.info(taskid, fullver, DeployCategory.Package, "create table finish");
            DeployInfo.upgradeData10();
            DeployLog.info(taskid, fullver, DeployCategory.Package, "upgrade history table finish");
        } else if (DeployScriptInfo.checkTableCount()) {
            DeployLog.info(taskid, fullver, DeployCategory.Package, "T_BAS_DEPLOYINFODETAIL has no history");
            DeployInfo.upgradeData10();
            DeployLog.info(taskid, fullver, DeployCategory.Package, "upgrade history table finish");
        }
    }

    private boolean checkCreateTables() {
        boolean deploy = DeployInfo.checkCreateTable();
        boolean deployApp = DeployAppInfo.checkCreateTable();
        boolean deployScript = DeployScriptInfo.checkCreateTable();
        return deploy || deployApp || deployScript;
    }

    private DeployInfo readDeployInfo(long taskId, String fullVer, String isv, File tempFile, boolean isUndo) throws Exception {
        Path unZipFilePath = Paths.get(tempFile.getPath(), "datamodel");
        XmlFileHandler xmlDMHandler = new XmlFileHandler(taskId, fullVer);
        xmlDMHandler.setIsv(isv);
        xmlDMHandler.setUndo(isUndo);
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin - read xml : %s", unZipFilePath.toString()));
        xmlDMHandler.readXml(unZipFilePath.toString());
        return xmlDMHandler.getDeployInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadFile(DeployParam param, DeployResult result) {
        String dmSecret = param.getDmSecret();
        long taskId = param.getTaskId();
        String fullVer = param.getFullVer();
        File tempFile = null;
        Object object = lockObj;
        synchronized (object) {
            if (param.isLocal()) {
                return this.downloadFromLocal(param, result);
            }
            if (StringUtils.isNotBlank((CharSequence)dmSecret) && !forceUnZip) {
                File baseDir = new File(MQDeployServiceImpl.cleanString(System.getProperty("java.io.tmpdir").replace("../", "#")));
                dmSecret = MQDeployServiceImpl.cleanString(dmSecret.replace("../", "#"));
                tempFile = new File(baseDir, dmSecret);
                DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("temp dir. path:%s dmSecret%s", tempFile.getPath(), dmSecret));
                File datamodel = new File(tempFile, "datamodel/datamodel.xml");
                if (!tempFile.exists() || !datamodel.exists()) {
                    tempFile = MQDeployServiceImpl.createTempDirMD5(tempFile);
                    this.downloadStreamFile(taskId, fullVer, param.getDmUrl(), result, tempFile);
                }
            } else {
                tempFile = MQDeployServiceImpl.createTempDir();
                this.downloadStreamFile(taskId, fullVer, param.getDmUrl(), result, tempFile);
            }
        }
        return tempFile;
    }

    private File downloadFromLocal(DeployParam param, DeployResult result) {
        long taskId = param.getTaskId();
        String fullVer = param.getFullVer();
        String dmUrl = param.getDmUrl();
        File tempFile = MQDeployServiceImpl.createTempDir();
        Path dmPath = Paths.get(dmUrl, new String[0]);
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin - local unzip package, url : %s", dmUrl));
        try (InputStream ins = Files.newInputStream(dmPath, new OpenOption[0]);){
            Path target = tempFile.toPath();
            this.unZipFile(param.getTaskId(), param.getFullVer(), ins, target.toString());
        }
        catch (Exception e) {
            String msg = String.format("deploy downloadFromLocal faild  -- error:%s -- Stack:%s ", e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            if (tempFile.exists()) {
                this.deleteFile(tempFile);
            }
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
        }
        return tempFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadStreamFile(long taskId, String fullVer, String dmUrl, DeployResult result, File tempFile) {
        boolean success = true;
        InputStream ins = null;
        try {
            long start = System.currentTimeMillis();
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin - download zip package, url : %s", dmUrl));
            URL url = new URL(dmUrl);
            URI uri = new URI(dmUrl);
            if (SCHEME_HTTPS.equals(uri.getScheme())) {
                TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, tm, new SecureRandom());
                HttpsURLConnection htpscon = (HttpsURLConnection)url.openConnection();
                htpscon.setSSLSocketFactory(new CustomSSLSocketFactory(sslContext.getSocketFactory()));
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                htpscon.setHostnameVerifier(DO_NOT_VERIFY);
                htpscon.setRequestMethod("GET");
                htpscon.setDoOutput(true);
                htpscon.setDoInput(true);
                htpscon.setUseCaches(false);
                htpscon.setConnectTimeout(10000);
                htpscon.setReadTimeout(10000);
                ins = htpscon.getInputStream();
            } else {
                URLConnection htpcon = url.openConnection();
                htpcon.setDoOutput(true);
                htpcon.setDoInput(true);
                htpcon.setUseCaches(false);
                htpcon.setConnectTimeout(10000);
                htpcon.setReadTimeout(10000);
                if (SCHEME_HTTP.equals(uri.getScheme())) {
                    ((HttpURLConnection)htpcon).setRequestMethod("GET");
                }
                ins = htpcon.getInputStream();
            }
            Path target = tempFile.toPath();
            this.unZipFile(taskId, fullVer, ins, target.toString());
            long end = System.currentTimeMillis();
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"end - download zip package, taskid: %1$s zip url:%2$s \u4e0b\u8f7d\u8017\u65f6\uff1a%3$s", (String)"MQDeployServiceImpl_20", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskId, dmUrl, end - start));
            if (ins == null) return success;
        }
        catch (Exception e) {
            try {
                String msg = String.format("deploy downloadStreamFile faild  -- error:%s -- Stack:%s ", e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                if (tempFile.exists()) {
                    this.deleteFile(tempFile);
                }
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg, e});
            }
            catch (Throwable throwable) {
                if (ins == null) throw throwable;
                try {
                    ins.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    success = false;
                    String msg = String.format("deploy downloadStreamFile close faild  -- error:%s -- Stack:%s ", e2.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e2));
                    log.error(msg, (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            ins.close();
            return success;
        }
        catch (IOException e) {
            success = false;
            String msg = String.format("deploy downloadStreamFile close faild  -- error:%s -- Stack:%s ", e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            log.error(msg, (Throwable)e);
            return success;
        }
    }

    private void unZipFile(long taskId, String fullVer, InputStream ins, String zipPath) throws IOException {
        if (ins == null) {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, "InputStream is null");
            return;
        }
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format("begin unZipFile to Path : %s", zipPath));
        long start = System.currentTimeMillis();
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(ins));){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 1);
                    File entryFile = new File(MQDeployServiceImpl.cleanString((zipPath + File.separatorChar + name).replace("../", "#")));
                    entryFile.mkdirs();
                    continue;
                }
                String childPath = zipPath + File.separator + entry.getName();
                File child = new File(MQDeployServiceImpl.cleanString((childPath = childPath.replace("\\", "/")).replace("../", "#")));
                if (!child.getParentFile().exists()) {
                    child.getParentFile().mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(child));
                Throwable throwable = null;
                try {
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    in.closeEntry();
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            in.close();
        }
        long end = System.currentTimeMillis();
        DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"unZipFile end url:%1$s \u89e3\u538b\u8017\u65f6\uff1a%2$s", (String)"MQDeployServiceImpl_21", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), zipPath, end - start));
    }

    private static File createTempDir() {
        File baseDir = new File(MQDeployServiceImpl.cleanString(System.getProperty("java.io.tmpdir").replace("../", "#")));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    private static synchronized File createTempDirMD5(File tempDir) {
        if (tempDir.exists()) {
            return tempDir;
        }
        if (tempDir.mkdir()) {
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory.");
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteFile(files[i]);
                }
                file.delete();
            }
        }
    }

    public void rebuildApps(long taskid, String ver, String apps) {
        HashMap<String, Serializable> appsMap = new HashMap<String, Serializable>();
        boolean success = true;
        DeployState dp = new DeployState(taskid);
        try {
            dp.setDeployRebuildStatus("2");
            DeployLog.info(taskid, ver, DeployCategory.Package, String.format("begin rebuild taskId %s apps %s", taskid, apps));
            List<String> rebuidAppParams = Arrays.asList(apps.split(","));
            MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            Map result = metadataService.rebuildByApps(true, rebuidAppParams);
            ArrayList appInfoList = new ArrayList(10);
            for (Map.Entry entry : result.entrySet()) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                Map appResult = (Map)entry.getValue();
                if (appResult.get(FAILED) != null && ((List)appResult.get(FAILED)).size() > 0) {
                    success = false;
                    map.put(SUCCESS, false);
                    map.put("successInfo", (Boolean)appResult.get(SUCCESS));
                    map.put(ERROR_INFO, (Boolean)appResult.get(FAILED));
                } else {
                    map.put(SUCCESS, true);
                    map.put("successInfo", (Boolean)appResult.get(SUCCESS));
                }
                map.put("appId", (Boolean)entry.getKey());
                map.put("count", (Boolean)appResult.get("count"));
                appInfoList.add(map);
            }
            if (result.isEmpty()) {
                success = false;
            }
            appsMap.put(SUCCESS, Boolean.valueOf(success));
            appsMap.put("rebuildInfo", appInfoList);
            String resString = JSON.toJSONString(appsMap, (boolean)true);
            dp.setDeployRebuildResult(resString);
            dp.setDeployRebuildStatus("1");
            DeployLog.info(taskid, ver, DeployCategory.Package, String.format("rebuild taskId %s apps %s", taskid, apps));
            DeployLog.info(taskid, ver, DeployCategory.Package, resString);
        }
        catch (Exception e) {
            dp.setDeployRebuildStatus("0");
            DeployLog.error(taskid, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u5143\u6570\u636e\u5931\u8d25\uff01taskId %1$s ERR:%2$s", (String)"MQDeployServiceImpl_23", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskid, e.getMessage()), e);
        }
    }

    public Map<String, Object> getRebuildResult(long taskid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int state = 2;
        String rebuildRet = "";
        try {
            if (StringUtils.isBlank((Object)taskid)) {
                state = 0;
                log.warn(String.format("\u83b7\u53d6\u91cd\u5efa\u5143\u6570\u636e\u7ed3\u679c\u7684taskId\u4e3a\u7a7a taskId %s ", taskid));
            } else {
                DeployState ds = new DeployState(taskid);
                String resendState = ds.getDeployResendState();
                if (StringUtils.isNotBlank((CharSequence)resendState) && "1".equals(resendState)) {
                    result.put(STATE, 3);
                    result.put("result", rebuildRet);
                    log.warn(String.format("taskid %s \u5df2\u88ab\u91cd\u65b0\u6d88\u8d39\uff0c\u539f\u5fae\u670d\u52a1\u53ef\u80fd\u88ab\u91cd\u542f\u3002", taskid));
                    return result;
                }
                String stateStr = ds.getDeployRebuildStatus();
                state = StringUtils.isBlank((CharSequence)stateStr) ? state : Integer.parseInt(stateStr);
                rebuildRet = ds.getDeployRebuildResult();
            }
        }
        catch (Exception e) {
            state = 0;
            rebuildRet = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u91cd\u5efa\u5143\u6570\u636e\u7ed3\u679c\u5931\u8d25!taskId %1$s ERR:%2$s", (String)"MQDeployServiceImpl_24", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskid, e.getMessage());
            log.error(rebuildRet, (Throwable)e);
        }
        result.put(STATE, state);
        result.put("result", rebuildRet);
        return result;
    }

    public Map<String, Object> deployMC(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<Object, Object> mapRetInfo = new HashMap<String, Object>();
        boolean success = true;
        Object type = params.get("type");
        log.info("\u63a5\u6536\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(params));
        if (type != null) {
            Map param = (Map)params.get(PARAMS);
            if (param == null) {
                result.put(SUCCESS, false);
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"MQDeployServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return result;
            }
            String action = (String)type;
            if (action.equalsIgnoreCase("u")) {
                String dmUrl = (String)param.get(DMURL);
                String ver = (String)param.get("ver");
                ver = this.formatFullVer(ver);
                param.put("ver", ver);
                long id = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, id);
                mapRetInfo.put("progress", 0);
                param.put("id", id);
                DeployParam deployParam = this.convertDeployParam(param, id);
                String uid = (String)param.get("uid");
                if (!DmCheckUtils.checkDmParam(deployParam, uid)) {
                    result.put(SUCCESS, false);
                    result.put(MESSAGE, String.format(ResManager.loadKDString((String)"taskId:%1$s ,\u53c2\u6570\u6821\u9a8c\u5931\u8d25", (String)"MQDeployServiceImpl_64", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id));
                    return result;
                }
                DeployLog.info(deployParam.getTaskId(), deployParam.getFullVer(), DeployCategory.Package, "end - check DM param.");
                if (publishThread) {
                    DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin Deploy runnable! dmUrl:%s", id, dmUrl));
                    try {
                        es.execute(new DeployRunnable(RequestContext.get(), deployParam));
                    }
                    catch (Exception e) {
                        String stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        String msg = String.format(ResManager.loadKDString((String)"taskId:%1$s ,\u6295\u5165\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u7ebf\u7a0b\u6570\u5df2\u6ee1\uff0c\u5806\u6808\uff1a%2$s", (String)"MQDeployServiceImpl_49", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id, stack);
                        DeployLog.error(id, ver, DeployCategory.Package, msg, e);
                        result.put(SUCCESS, false);
                        result.put(MESSAGE, msg);
                    }
                } else {
                    DeployLog.info(id, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"taskId:%1$s begin Deploy publish! dmUrl:%2$s", (String)"MQDeployServiceImpl_52", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id, dmUrl));
                    try {
                        DeployPublisher.sendMessage(deployParam);
                    }
                    catch (Exception e) {
                        String stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        String msg = String.format(ResManager.loadKDString((String)"taskId:%1$s ,\u6295\u5165\u6d88\u606f\u961f\u5217\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5RabbitMQ\uff0c\u5806\u6808\uff1a%2$s", (String)"MQDeployServiceImpl_51", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id, stack);
                        DeployLog.error(id, ver, DeployCategory.Package, msg, e);
                        result.put(SUCCESS, false);
                        result.put(MESSAGE, msg);
                    }
                }
                DeployLog.info(id, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"taskId:%1$s end Deploy publish! dmUrl:%2$s", (String)"MQDeployServiceImpl_58", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id, dmUrl));
            } else if (action.equalsIgnoreCase("l")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    mapRetInfo = this.getLogs(Long.parseLong((String)taskid), Long.parseLong((String)logid));
                }
            } else if (action.equalsIgnoreCase("p")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.excuteStatus(task);
                }
            } else if (action.equalsIgnoreCase("s")) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.getLogs(task, l);
                    mapRetInfo.putAll(this.excuteStatus(task));
                }
            } else if ("upgrade".equals(action)) {
                DistributeSessionlessCache cache = MQDeployServiceImpl.getCache();
                String upgradeState = (String)cache.get("bos_deploy_cache_upgradedeployinfo");
                if (upgradeState == null || "0".equals(upgradeState)) {
                    cache.put("bos_deploy_cache_upgradedeployinfo", (Object)"1", 3600);
                    log.info("begin upgradeData");
                    DeployInfo.upgradeData10();
                    mapRetInfo.put("msg", ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5df2\u5b8c\u6210,\u8bf7\u52ff\u91cd\u590d\u5237\u65b0\u9875\u9762\u3002", (String)"MQDeployServiceImpl_26", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                } else {
                    mapRetInfo.put("msg", ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u5237\u65b0\u9875\u9762\u3002", (String)"MQDeployServiceImpl_27", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                }
            } else if (STATE.equals(action) || "getState".equals(action)) {
                mapRetInfo.putAll(this.updateSystemState(action, param));
            } else if ("releaseGray".equalsIgnoreCase(action)) {
                Object appGroup = param.get(APPGROUP);
                String ver = (String)param.get("ver");
                ver = this.formatFullVer(ver);
                param.put("ver", ver);
                long id = DB.genGlobalLongId();
                param.put("id", id);
                mapRetInfo.put(TASKID, id);
                DeployParam deployParam = this.convertDeployParam(param, id);
                if (appGroup != null) {
                    DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin releaseGray runnable! appGroup:%s", id, appGroup));
                    boolean grayDeployAsync = Boolean.parseBoolean(System.getProperty("grayDeployAsync", "false"));
                    if (grayDeployAsync) {
                        ReleaseGrayRunnable runnable = new ReleaseGrayRunnable(RequestContext.get(), deployParam);
                        Map<String, Object> retMap = this.execAsyncRunnable(deployParam, runnable);
                        success = (Boolean)retMap.get(SUCCESS);
                        mapRetInfo.putAll(retMap);
                    } else {
                        Map<String, Object> retMap = this.executeReleaseGray(deployParam);
                        if (!"1".equals(retMap.get("result"))) {
                            success = false;
                        }
                        mapRetInfo.putAll(retMap);
                    }
                }
            } else if ("stopGray".equalsIgnoreCase(action)) {
                Object appGroup = param.get(APPGROUP);
                String ver = (String)param.get("ver");
                ver = this.formatFullVer(ver);
                param.put("ver", ver);
                long id = DB.genGlobalLongId();
                param.put("id", id);
                mapRetInfo.put(TASKID, id);
                DeployParam deployParam = this.convertDeployParam(param, id);
                if (appGroup != null) {
                    DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin stopGray runnable! appGroup:%s", id, appGroup));
                    boolean grayDeployAsync = Boolean.parseBoolean(System.getProperty("grayDeployAsync", "false"));
                    if (grayDeployAsync) {
                        StopGrayRunnable runnable = new StopGrayRunnable(RequestContext.get(), deployParam);
                        Map<String, Object> retMap = this.execAsyncRunnable(deployParam, runnable);
                        success = (Boolean)retMap.get(SUCCESS);
                        mapRetInfo.putAll(retMap);
                    } else {
                        Map<String, Object> retMap = this.stopGray(deployParam);
                        if (!"1".equals(retMap.get("result"))) {
                            success = false;
                        }
                        mapRetInfo.putAll(retMap);
                    }
                }
            } else if ("dropGrayBackTable".equalsIgnoreCase(action)) {
                Object appGroup = param.get(APPGROUP);
                if (appGroup == null) {
                    result.put(MESSAGE, "appGroup is null.");
                    success = false;
                } else {
                    DeployDataModel deployDataModel = new DeployDataModel();
                    deployDataModel.setAppGroup((String)appGroup);
                    try {
                        deployDataModel.dropGrayBackTable(param);
                        result.put(MESSAGE, "clearGrayData finish.");
                    }
                    catch (Exception e) {
                        result.put(MESSAGE, e.getMessage());
                        success = false;
                    }
                }
            } else if ("reduceVer".equalsIgnoreCase(action)) {
                String[] appArray;
                String productNumber = (String)param.get("productNumber");
                String ver = (String)param.get("ver");
                String lowerVer = (String)param.get("lowerVer");
                String appListStr = (String)param.get("appList");
                String iteration = (String)param.get("iteration");
                String appGroup = (String)param.get(APPGROUP);
                DeployInfo packageInfo = new DeployInfo();
                for (String appId : appArray = appListStr.split(",")) {
                    DeployAppInfo appInfo = new DeployAppInfo(appId.trim(), "");
                    packageInfo.addApp(appInfo);
                }
                packageInfo.setProductNumber(productNumber);
                packageInfo.setIteration(iteration);
                packageInfo.setVer(lowerVer);
                long taskId = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, taskId);
                if (!this.checkReduceVer(taskId, ver, lowerVer)) {
                    this.lowerVerInfo(packageInfo, appGroup);
                    success = true;
                    mapRetInfo.put(MESSAGE, "lower version finish.");
                    DeployLog.info(taskId, ver, DeployCategory.Package, String.format("lower version finish. version:%s -- lowerversion:%s", ver, lowerVer));
                } else {
                    success = false;
                    mapRetInfo.put(MESSAGE, "lower version error.");
                    DeployLog.info(taskId, ver, DeployCategory.Package, String.format("lower version error: cannot cross-version. version:%s -- lowerversion:%s", ver, lowerVer));
                }
            } else {
                success = false;
                result.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a%s", (String)"MQDeployServiceImpl_28", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), action));
            }
            result.put("data", mapRetInfo);
        } else {
            success = false;
            result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"MQDeployServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        result.put(SUCCESS, success);
        return result;
    }

    private Map<String, Object> updateSystemState(String action, Map<String, Object> param) {
        HashMap<String, Object> mapRetInfo = new HashMap<String, Object>();
        DistributeSessionlessCache cache = MQDeployServiceImpl.getCache();
        if (STATE.equals(action)) {
            if (param == null || param.isEmpty() || param.get(STATUS) == null) {
                mapRetInfo.put("msg", ResManager.loadKDString((String)"status\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MQDeployServiceImpl_30", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return mapRetInfo;
            }
            String status = (String)param.get(STATUS);
            cache.put(DEPLOY_SYSTEM_UPGRADE_STATE + RequestContext.get().getAccountId(), (Object)status);
            mapRetInfo.put("msg", String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u72b6\u6001status:%s\u66f4\u65b0\u6210\u529f\uff01", (String)"MQDeployServiceImpl_31", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), status));
        } else {
            String status = (String)cache.get(DEPLOY_SYSTEM_UPGRADE_STATE + RequestContext.get().getAccountId());
            mapRetInfo.put(STATUS, status);
        }
        return mapRetInfo;
    }

    private DeployParam convertDeployParam(Map<String, Object> params, long taskid) {
        HashMap<String, String> verCaption;
        LinkedHashMap<String, String> relyOn;
        String dmUrl = params.get(DMURL) == null ? "" : (String)params.get(DMURL);
        String ver = params.get("ver") == null ? "" : (String)params.get("ver");
        String appIds = params.get("appIds") == null ? "" : (String)params.get("appIds");
        String productNumber = params.get("productNumber") == null ? " " : (String)params.get("productNumber");
        String productName = params.get("productName") == null ? " " : (String)params.get("productName");
        String isv = params.get("isv") == null ? " " : (String)params.get("isv");
        String dmSecret = params.get("md5") == null ? " " : (String)params.get("md5");
        String categoryStr = (String)params.get("category");
        int category = categoryStr == null || StringUtils.isBlank((CharSequence)categoryStr) ? 0 : Integer.parseInt(categoryStr);
        String deployPackageStr = params.get("deployPackagetId") == null ? "" : (String)params.get("deployPackagetId");
        long deployPackagetId = StringUtils.isBlank((CharSequence)deployPackageStr) ? 0L : Long.parseLong(deployPackageStr);
        String appGroup = params.get(APPGROUP) == null ? "" : (String)params.get(APPGROUP);
        boolean isUnzip = false;
        if (params.get(UNZIP) != null && StringUtils.isNotBlank((CharSequence)params.get(UNZIP).toString())) {
            isUnzip = Boolean.parseBoolean(params.get(UNZIP).toString());
        }
        boolean isUndo = false;
        if (params.get(ISUNDO) != null && StringUtils.isNotBlank((CharSequence)params.get(ISUNDO).toString())) {
            isUndo = Boolean.parseBoolean(params.get(ISUNDO).toString());
        }
        boolean isLocal = false;
        if (params.get(ISLOCAL) != null && StringUtils.isNotBlank((CharSequence)params.get(ISLOCAL).toString())) {
            isLocal = Boolean.parseBoolean(params.get(ISLOCAL).toString());
        }
        if ((relyOn = (LinkedHashMap<String, String>)params.get("relyOn")) == null) {
            relyOn = new LinkedHashMap<String, String>();
        }
        boolean isBigTablePack = false;
        if (params.get(BIG_TABLE_PACK) != null && StringUtils.isNotBlank((CharSequence)params.get(BIG_TABLE_PACK).toString())) {
            isBigTablePack = Boolean.parseBoolean(params.get(BIG_TABLE_PACK).toString());
        }
        if ((verCaption = (HashMap<String, String>)params.get("vercaption")) == null) {
            verCaption = new HashMap<String, String>();
        }
        String localeId = params.get("language") == null ? " " : (String)params.get("language");
        DeployParam deployParam = new DeployParam(taskid, ver, dmUrl, appIds, productNumber, productName, isv, relyOn, category);
        deployParam.setUnzip(isUnzip);
        deployParam.setDmSecret(dmSecret);
        deployParam.setDeployPackagetId(deployPackagetId);
        deployParam.setUndo(isUndo);
        deployParam.setLocal(isLocal);
        deployParam.setBigTablePack(isBigTablePack);
        deployParam.setAppGroup(appGroup);
        deployParam.setVerCaption(verCaption);
        deployParam.setLocaleId(localeId);
        return deployParam;
    }

    public Map<String, Object> rebuildDym(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<Object, Object> mapRetInfo = new HashMap<String, Object>();
        boolean success = true;
        Object type = params.get("type");
        log.info("\u63a5\u53d7\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(params));
        if (type != null) {
            Map param = (Map)params.get(PARAMS);
            if (param == null) {
                result.put(SUCCESS, false);
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"MQDeployServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return result;
            }
            String action = (String)type;
            if ("rebuildApp".equalsIgnoreCase(action)) {
                if (StringUtils.isBlank(param.get("apps"))) {
                    success = false;
                    result.put(MESSAGE, ResManager.loadKDString((String)"apps\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MQDeployServiceImpl_33", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                } else {
                    mapRetInfo.putAll(this.rebuildAction(param));
                }
            } else if ("getRebuildResult".equalsIgnoreCase(action)) {
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null && logid != null) {
                    long task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo = this.getLogs(task, l);
                    mapRetInfo.putAll(this.getRebuildResult(task));
                } else {
                    success = false;
                    result.put(MESSAGE, ResManager.loadKDString((String)"taskid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"MQDeployServiceImpl_34", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                }
            } else {
                success = false;
                result.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u63d0\u4f9b\u6307\u4ee4\uff1a%s", (String)"MQDeployServiceImpl_28", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), action));
            }
            if (success) {
                result.put("data", mapRetInfo);
            }
        } else {
            success = false;
            result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"MQDeployServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        result.put(SUCCESS, success);
        return result;
    }

    public Map<String, Object> rebuildAction(Map<String, Object> param) {
        HashMap<String, Object> mapRetInfo = new HashMap<String, Object>();
        String ver = this.getVer();
        ver = StringUtils.isBlank((CharSequence)ver) ? " " : ver;
        long id = DB.genGlobalLongId();
        param.put("id", id);
        mapRetInfo.put(TASKID, id);
        if (publishThread) {
            DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin rebuild runnable!", id));
            String apps = (String)param.get("apps");
            es.execute(new RebuildRunnable(RequestContext.get(), id, ver, apps));
        } else {
            DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin rebuild publish!", id));
            DeployPublisher.sendRebuildMessage(param);
        }
        DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s end rebuild publish!", id));
        return mapRetInfo;
    }

    @Deprecated
    public Map<String, Object> deploySql(Map<String, Object> params, List<String> sqlList) {
        Serializable sqlResult;
        Object idxSQL;
        DBRoute dbRoute;
        DBType dbType;
        this.deprecatedMethodCheck();
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean success = true;
        String type = (String)params.get("type");
        String dbKey = (String)params.get("dbkey");
        String ksqlName = (String)params.get("ksqlname");
        String version = (String)params.get("version");
        String appName = (String)params.get("appname");
        String pkname = (String)params.get("pkname");
        String pluginElement = (String)params.get("plugin");
        Object el = params.get("el");
        if (!("KSQL".equals(type) || "all".equalsIgnoreCase(dbKey) || (dbType = DB.getDBType((DBRoute)(dbRoute = new DBRoute(dbKey)))).toString().equalsIgnoreCase(type))) {
            map.put(SUCCESS, success);
            return map;
        }
        Boolean isexisttable = DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_SQLVERSION);
        boolean syncSQLVerTable = false;
        if (!isexisttable.booleanValue()) {
            try (TXHandle h = TX.notSupported();){
                String sqlCreateTable = "create table T_BAS_SQLVERSION (FID bigint primary key, FVER varchar(10),FFILENAME varchar(500),EXECTIME DATETIME NOT NULL,FAPPID varchar(50),PKNAME varchar(50));";
                DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
                idxSQL = "CREATE INDEX IDX_BAS_SQLVERSION_FNUMBER ON T_BAS_SQLVERSION ( fver,ffilename,fappid);";
                DB.execute((DBRoute)DBRoute.meta, (String)idxSQL, null);
                syncSQLVerTable = true;
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5efa\u8868 T_BAS_SQLVERSION \u5931\u8d25", (String)"MQDeployServiceImpl_35", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                log.error(msg, (Throwable)e);
            }
        }
        Boolean isexistBOSTable = DB.exitsTable((DBRoute)DBRoute.basedata, (String)"T_BOS_SQLVERSION");
        if (syncSQLVerTable && isexistBOSTable.booleanValue()) {
            String insSQL = "insert into T_BAS_SQLVERSION  select FID, FVER, FFILENAME, EXECTIME, FAPPID, PKNAME from t_bos_sqlversion;";
            try {
                TXHandle h = TX.required();
                idxSQL = null;
                try {
                    DB.execute((DBRoute)DBRoute.meta, (String)insSQL, null);
                }
                catch (Throwable throwable) {
                    idxSQL = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (idxSQL != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)idxSQL).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"T_BAS_SQLVERSION \u6570\u636e\u540c\u6b65\u5931\u8d25", (String)"MQDeployServiceImpl_36", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]);
                log.error(msg, (Throwable)e);
            }
        }
        String ksqlisexist = "select 1 from T_BAS_SQLVERSION where fver=? and ffilename = ? and fappid = ?";
        Object[] dbParams = new Object[]{version, ksqlName, appName};
        try (DataSet dataset = DB.queryDataSet((String)"deployServiceImpl", (DBRoute)DBRoute.meta, (String)ksqlisexist, (Object[])dbParams);){
            Iterator its = dataset.iterator();
            if (its.hasNext()) {
                map.put(SUCCESS, success);
                StringBuilder checkinfoSB = new StringBuilder(ResManager.loadKDString((String)"\u811a\u672c:", (String)"MQDeployServiceImpl_37", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).append(ksqlName).append(ResManager.loadKDString((String)"\u5df2\u88ab\u6267\u884c\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff01", (String)"MQDeployServiceImpl_38", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                map.put("checkinfo", checkinfoSB.toString());
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
        }
        ArrayList errorInfo = new ArrayList();
        StringBuilder checkinfoSB = new StringBuilder("type:").append(type).append(" sql ");
        IUpgradePlugin plugin = null;
        String iteration = "";
        this.logInfo(String.format("deploy plugin create begining, the xml plugin element is: %s", pluginElement), "deploySql");
        checkinfoSB.append("deploy plugin create begining, the xml plugin element is:").append(pluginElement);
        if (StringUtils.isNotBlank((CharSequence)pluginElement)) {
            plugin = this.createPlugin(appName, pluginElement);
        }
        String pluginClassName = plugin == null ? "null" : plugin.getClassQualifiedName();
        this.logInfo(String.format("deploy plugin create end, the plugin is: %s", pluginClassName), "deploySql");
        checkinfoSB.append("deploy plugin create end, the plugin is: ").append(pluginClassName);
        if (plugin != null) {
            checkinfoSB.append(String.format("deploy plugin: %s beforeExecuteSql begin...", plugin.getClassQualifiedName()));
            this.logInfo(String.format("deploy plugin: %s beforeExecuteSql begin...", plugin.getClassQualifiedName()), "deploySql");
            UpgradeResult result = plugin.beforeExecuteSql(version, iteration, dbKey, ksqlName);
            checkinfoSB.append(result.getLog()).append(System.lineSeparator());
            if (!result.isSuccess()) {
                HashMap<String, String> sqlResult2 = new HashMap<String, String>();
                sqlResult2.put("err", DBROUTE + dbKey + ", " + result.getErrorInfo());
                errorInfo.add(sqlResult2);
                log.error(result.getErrorInfo());
                if (ERROR.equals(result.getEl())) {
                    map.put("el", ERROR);
                }
            }
            success = success && result.isSuccess();
            checkinfoSB.append(String.format(ResManager.loadKDString((String)"deploy puglin: %s beforeExecuteSql \u5b8c\u6210.", (String)"MQDeployServiceImpl_8", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName()));
            this.logInfo(String.format("deploy puglin: %s beforeExecuteSql finish...", plugin.getClassQualifiedName()), "deploySql");
        }
        boolean isAll = false;
        HashMap<String, DBRoute> dbRoutes = new HashMap<String, DBRoute>();
        if ("all".equalsIgnoreCase(dbKey)) {
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            List dbs = account.getDBInstanceList();
            for (DBInstance dbInstance : dbs) {
                String insid = String.format("%s.%s.%s.%s.%s", dbInstance.getDbtype(), dbInstance.getDbip(), dbInstance.getDbport(), dbInstance.getDBInsatnce(), dbInstance.getDbuser());
                if (dbRoutes.containsKey(insid)) continue;
                dbRoutes.put(insid, new DBRoute(dbInstance.getRouteKey()));
            }
            checkinfoSB.append("to be exec in all DB : -- ");
            isAll = true;
        } else {
            dbRoutes.put(dbKey, new DBRoute(dbKey));
            checkinfoSB.append("to be exec single DB : -- ");
        }
        for (String sql : sqlList) {
            try {
                if (!"KSQL".equals(type)) {
                    sql = sql.trim();
                    sql = "/*dialect*/" + sql;
                }
                for (DBRoute dbRoute2 : dbRoutes.values()) {
                    DBType dbType2 = DB.getDBType((DBRoute)dbRoute2);
                    if (!"KSQL".equalsIgnoreCase(type) && !dbType2.toString().equalsIgnoreCase(type)) continue;
                    if (isAll) {
                        checkinfoSB.append("execute -- dbKey:").append(dbRoute2.getRouteKey()).append(", dbType:").append(dbType2.toString());
                        if (sql.length() > 30) {
                            checkinfoSB.append(", sql:").append(sql.substring(0, 29)).append(" ... ").append(System.lineSeparator());
                        } else {
                            checkinfoSB.append(", sql:").append(sql).append(" ... ").append(System.lineSeparator());
                        }
                    }
                    TXHandle h = TX.required();
                    Throwable throwable = null;
                    try {
                        DB.execute((DBRoute)dbRoute2, (String)sql, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
            catch (Exception e) {
                success = false;
                sqlResult = new HashMap<String, String>();
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                sqlResult.put("sql", sql);
                sqlResult.put("err", DBROUTE + dbKey + ", " + msg);
                errorInfo.add(sqlResult);
                log.error(msg, (Throwable)e);
                if (!ERROR.equals(el)) continue;
                map.put("el", ERROR);
                break;
            }
        }
        if (plugin != null) {
            this.logInfo(String.format("deploy plugin: %s afterExecuteSql begin...", plugin.getClassQualifiedName()), "deploySql");
            checkinfoSB.append(String.format("deploy plugin: %s afterExecuteSql begin...", plugin.getClassQualifiedName())).append(System.lineSeparator());
            UpgradeResult result = plugin.afterExecuteSql(version, iteration, dbKey, ksqlName);
            checkinfoSB.append(result.getLog()).append(System.lineSeparator());
            if (!result.isSuccess()) {
                HashMap<String, String> sqlResult3 = new HashMap<String, String>();
                sqlResult3.put("err", DBROUTE + dbKey + ", " + result.getErrorInfo());
                errorInfo.add(sqlResult3);
                log.error(result.getErrorInfo());
                if (ERROR.equals(result.getEl())) {
                    map.put("el", ERROR);
                }
            }
            success = success && result.isSuccess();
            checkinfoSB.append(String.format(ResManager.loadKDString((String)"deploy plugin: %s afterExecuteSql \u5b8c\u6210.", (String)"MQDeployServiceImpl_39", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), plugin.getClassQualifiedName())).append(System.lineSeparator());
            this.logInfo(String.format("deploy plugin: %s afterExecuteSql finish...", plugin.getClassQualifiedName()), "deploySql");
        }
        if (success) {
            Object[] insertParams = new Object[]{version, ksqlName, appName, DB.genGlobalLongId(), pkname};
            String insertKSQL = "insert into T_BAS_SQLVERSION(fver,ffilename,fappid,exectime,FID,PKNAME) values(?,?,?,NOW(),?,?);";
            try {
                TXHandle h = TX.required();
                sqlResult = null;
                try {
                    DB.execute((DBRoute)DBRoute.meta, (String)insertKSQL, (Object[])insertParams);
                }
                catch (Throwable throwable) {
                    sqlResult = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (sqlResult != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)sqlResult).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                String msg = new StringBuffer(ksqlName).append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u4f46\u662f\u63d2\u5165\u6267\u884c\u8bb0\u5f55\u5931\u8d25", (String)"MQDeployServiceImpl_40", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                log.error(msg, (Throwable)e);
            }
        }
        map.put(SUCCESS, success);
        map.put(ERROR_INFO, errorInfo);
        map.put("checkinfo", checkinfoSB.toString());
        return map;
    }

    private IUpgradePlugin createPlugin(String appNumber, String pluginNameElement) {
        Object splugin;
        if (StringUtils.isBlank((CharSequence)pluginNameElement)) {
            return null;
        }
        String[] pluginParams = pluginNameElement.split(",");
        if (pluginParams == null || pluginParams.length == 0) {
            return null;
        }
        String type = "js";
        String pluginName = "";
        String cloud = "";
        String app = appNumber;
        for (String param : pluginParams) {
            String[] sp = param.split(":");
            if (sp.length == 2) {
                if ("cloud".equalsIgnoreCase(sp[0])) {
                    cloud = sp[1];
                    continue;
                }
                if ("app".equalsIgnoreCase(sp[0])) {
                    app = sp[1];
                    continue;
                }
                type = sp[0];
                pluginName = sp[1];
                continue;
            }
            if (sp.length != 1) continue;
            pluginName = sp[0];
        }
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)app)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u63d2\u4ef6app\u540d\u79f0\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"MQDeployServiceImpl_41", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
        }
        if ("class".equalsIgnoreCase(type)) {
            if (StringUtils.isBlank((CharSequence)cloud)) {
                cloud = CloudAppMappingDictionary.getCloudIdBy((String)app);
            }
            if (StringUtils.isBlank((CharSequence)cloud)) {
                String getCloudSql = "select a.fnumber from t_meta_bizcloud a inner join t_meta_bizapp b on a.fid = b.fbizcloudid where b.fnumber = ?";
                Object[] getCloudParams = new Object[]{app};
                cloud = (String)DB.query((DBRoute)DBRoute.meta, (String)getCloudSql, (Object[])getCloudParams, (ResultSetHandler)new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            String tmp = rs.getString("fnumber");
                            return StringUtils.isNotBlank((CharSequence)tmp) ? tmp.toLowerCase() : tmp;
                        }
                        return "";
                    }
                });
            }
            if (StringUtils.isBlank((CharSequence)cloud)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u63d2\u4ef6\u6240\u5c5ecloud\uff0c\u8bf7\u68c0\u67e5", (String)"MQDeployServiceImpl_42", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
            }
            splugin = new StandUpgradePlugin();
            ((StandUpgradePlugin)((Object)splugin)).setDispatchParams(cloud, app, pluginName);
            return splugin;
        }
        try {
            splugin = this.createDynamicScriptPlugin(pluginName);
            return splugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public List<String> deployDym(Map<String, Object> params, String content) {
        this.deprecatedMethodCheck();
        List<String> formIds = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)content)) {
            return formIds;
        }
        String type = (String)params.get("type");
        if ("js".equals(type)) {
            MetadataDao.deployScript((String)content);
        } else if ("card".equals(type)) {
            MetadataDao.deployCard((String)content);
        } else if ("sch".equals(type)) {
            MetadataDao.deploySchema((String)content);
        } else if ("cld".equals(type)) {
            MetadataDao.deployCloud((String)content);
        } else if ("app".equals(type)) {
            MetadataDao.deployAppMetadata((String)content);
        } else {
            formIds = MetadataDao.deployMetadata((String)content);
        }
        return formIds;
    }

    @Deprecated
    public Map<String, Object> deployXML(Map<String, Object> params, String content) {
        this.deprecatedMethodCheck();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String type = (String)params.get("type");
        try {
            PreInsDataScriptWriter wr = new PreInsDataScriptWriter();
            wr.insertPreInsData(content);
            map.put(SUCCESS, true);
        }
        catch (JAXBException e) {
            map.put(SUCCESS, false);
            map.put(ERROR_INFO, ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e)));
        }
        return map;
    }

    private AbsractVersion getVerInfo(DeployParam param) {
        AbsractVersion verInfo = null;
        String productNumber = param.getProductNumber();
        String fullVer = param.getFullVer();
        long taskId = param.getTaskId();
        if (StringUtils.isBlank((CharSequence)productNumber)) {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"productNumber\uff1a%s \u4e3a\u7a7a\uff0c\u5c06\u8bfb\u53d6\u6807\u51c6db version", (String)"MQDeployServiceImpl_43", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), productNumber));
            verInfo = new StandardVersion(param);
        } else if (StandardVersion.BIZ_NUMBER.equalsIgnoreCase(productNumber) || StandardVersion.BOS_NUMBER.equalsIgnoreCase(productNumber)) {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"productNumber\uff1a%s \u5c06\u8bfb\u53d6\u6807\u51c6db version", (String)"MQDeployServiceImpl_44", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), productNumber));
            verInfo = new StandardVersion(param);
        } else {
            DeployLog.info(taskId, fullVer, DeployCategory.Package, String.format(ResManager.loadKDString((String)"productNumber\uff1a%s \u5c06\u8bfb\u53d6Industry version", (String)"MQDeployServiceImpl_45", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), productNumber));
            verInfo = new IndustryVersion(param);
        }
        return verInfo;
    }

    public String getVer() {
        return DBVersion.getVer();
    }

    public String getAppIteration(String appId) {
        return DBVersion.getAppIteration((String)appId);
    }

    private IUpgradePlugin createDynamicScriptPlugin(String scriptNumber) throws IOException {
        String scriptContent = this.getScript(scriptNumber);
        if (StringUtils.isBlank((CharSequence)scriptContent)) {
            return null;
        }
        try (InputStream in = FormConfig.class.getResourceAsStream("/FormPlugin.js");){
            String envScript = FormConfig.getContent((InputStream)in);
            ScriptExecutor scriptExecutor = ScriptExecutor.getOrCreate();
            scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            scriptExecutor.begin();
            scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo("/FormPlugin.js", envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
            IUpgradePlugin iUpgradePlugin = (IUpgradePlugin)scriptExecutor.getContext().get("plugin");
            return iUpgradePlugin;
        }
    }

    private String getScript(String scriptNumber) {
        HashMap<String, String> map;
        block15: {
            map = new HashMap<String, String>();
            String sql = "select fscriptnumber,fscriptcontext_tag,fscripttype from t_meta_pluginscript where fclassname = ?";
            Object[] params = new Object[]{scriptNumber};
            try (DataSet ds = DB.queryDataSet((String)"FormConfig.t_meta_pluginscript.getScriptInfo", (DBRoute)DBRoute.meta, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    map.put("scriptnumber", row.getString("fscriptnumber"));
                    map.put("scripttype", row.getString("fscripttype"));
                    map.put("scriptcontext", row.getString("fscriptcontext_tag"));
                    break block15;
                }
                String string = null;
                return string;
            }
        }
        return (String)map.get("scripttype");
    }

    private String formatFullVer(String fullVer) {
        String ver = "";
        if (StringUtils.isNotBlank((CharSequence)fullVer)) {
            String[] verStrs = fullVer.split("\\.");
            String iterator = "0";
            if (verStrs.length > 2) {
                iterator = verStrs[2];
            }
            ver = String.format("%s.%s.%s", verStrs[0], verStrs[1], iterator);
        }
        return ver;
    }

    public Map<String, Object> AppDeploy(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> mapRetInfo = new HashMap<String, Object>();
        boolean success = true;
        Object type = params.get("type");
        log.info("AppDeploy\u63a5\u6536\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(params));
        if (type != null) {
            Map param = (Map)params.get(PARAMS);
            if (param == null) {
                result.put(SUCCESS, false);
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"MQDeployServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return result;
            }
            String action = (String)type;
            if (action.equalsIgnoreCase("u")) {
                String dmUrl = (String)param.get(DMURL);
                String ver = (String)param.get("ver");
                ver = this.formatFullVer(ver);
                param.put("ver", ver);
                long id = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, id);
                param.put("id", id);
                DeployParam deployParam = this.convertDeployParam(param, id);
                String bigTablePack = "";
                if (deployParam.isBigTablePack()) {
                    bigTablePack = "big table pack";
                }
                log.debug(String.format("taskId:%s begin Deploy %s publish! dmUrl:%s", id, bigTablePack, dmUrl));
                try {
                    this.deployDM(deployParam);
                    mapRetInfo.putAll(this.excuteStatus(id));
                }
                catch (Exception e) {
                    success = false;
                    log.error("\u5347\u7ea7dm\u5305\u51fa\u9519\uff0cERR:" + e.getMessage(), (Throwable)e);
                    String errMsg = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"Deploy dm error,\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0czip\u5305\u90e8\u7f72\u5347\u7ea7\u5931\u8d25\u3002", (String)"DeployConsumer_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                    try {
                        DeployLog.error(id, ver, DeployCategory.Package, errMsg, e);
                        DeployPackageInfo.saveErrorDeployInfo(id, ver, null);
                    }
                    catch (Exception e2) {
                        log.error("Deploy dm error and save error DeployInfo error.", (Throwable)e2);
                    }
                }
                log.debug(String.format("taskId:%s end Deploy %s dm! dmUrl:%s", id, bigTablePack, dmUrl));
            }
        } else {
            success = false;
            result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"MQDeployServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        result.put("data", mapRetInfo);
        result.put(SUCCESS, success);
        return result;
    }

    public Map<String, Object> excutePackageStatus(long taskid) {
        Object[] params = new Object[]{taskid};
        String sql = "select FRESULT from t_bas_deploypackage where FID = ?";
        String result = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String result = "";
                if (rs.next()) {
                    result = rs.getString(1);
                }
                return result;
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)result)) {
            DeployState deployState = new DeployState(taskid);
            map.put(STATUS, 2);
            map.put("progress", deployState.getPropgress());
            String instanceId = deployState.getDeployInstanceId();
            if (!this.isAlive(taskid, instanceId)) {
                log.warn(String.format("taskid %s \u5fae\u670d\u52a1\u5b9e\u4f8b %s \u5b58\u6d3b\u6027\u68c0\u67e5\u4e3a\u4e0d\u5b58\u6d3b\u53ef\u80fd\u88ab\u91cd\u542f\u3002", taskid, instanceId));
                map.put(STATUS, 6);
            }
        } else {
            int res = Integer.parseInt(result);
            map.put(STATUS, res);
        }
        return map;
    }

    public Map<String, Object> DeployPackageMC(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> mapRetInfo = new HashMap<String, Object>();
        boolean success = true;
        String type = params.get("type") == null ? "" : (String)params.get("type");
        String action = params.get("action") == null ? "" : (String)params.get("action");
        log.info("DeployPackageMC\u63a5\u6536\u5230\u8bf7\u6c42\uff0cparams:" + SerializationUtils.toJsonString(params));
        if (StringUtils.isNotBlank((CharSequence)action) && StringUtils.isNotBlank((CharSequence)type)) {
            Map param = (Map)params.get(PARAMS);
            if (param == null) {
                result.put(SUCCESS, false);
                result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230params", (String)"MQDeployServiceImpl_25", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
                return result;
            }
            if (type.equalsIgnoreCase("u")) {
                String pkName = param.get("pkName") == null ? "" : (String)param.get("pkName");
                String ver = param.get("ver") == null ? "" : (String)param.get("ver");
                String isv = param.get("isv") == null ? "" : (String)param.get("isv");
                String allAppGray = param.get("allAppGray") == null ? "false" : (String)param.get("allAppGray");
                String appGroup = param.get(APPGROUP) == null ? "" : (String)param.get(APPGROUP);
                ver = this.formatFullVer(ver);
                param.put("ver", ver);
                long id = DB.genGlobalLongId();
                mapRetInfo.put(TASKID, id);
                param.put("id", id);
                DeployPackageParam dpParam = new DeployPackageParam(id, ver, isv, pkName);
                dpParam.setType(DeployPackageType.Before.getValue());
                if (action.equalsIgnoreCase("after")) {
                    dpParam.setType(DeployPackageType.After.getValue());
                }
                dpParam.setAppGroup(appGroup);
                dpParam.setAllAppGray(Boolean.parseBoolean(allAppGray));
                try {
                    if (afterPublishThread) {
                        DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin deployPackage runnable!", id));
                        dpAfterEs.execute(new DeployPackageRunnable(RequestContext.get(), dpParam));
                    } else {
                        DeployLog.info(id, ver, DeployCategory.Package, String.format("taskId:%s begin deployPackage publish!", id));
                        DeployPublisher.sendDeployPackageMessage(dpParam);
                    }
                }
                catch (Exception e) {
                    success = false;
                    String errMsg = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"Deploy package error,\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad", (String)"MQDeployServiceImpl_59", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                    DeployLog.error(id, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"\u6267\u884cpackage\u51fa\u9519\uff0cERR:%s", (String)"MQDeployServiceImpl_60", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), errMsg), e);
                }
                DeployLog.info(id, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"taskId:%s end running!", (String)"MQDeployServiceImpl_61", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), id));
            } else if (type.equalsIgnoreCase("s")) {
                long task;
                Object taskid = param.get(TASKID);
                Object logid = param.get(LOGID);
                if (taskid != null) {
                    task = Long.parseLong((String)taskid);
                    mapRetInfo.putAll(this.excutePackageStatus(task));
                }
                if (taskid != null && logid != null) {
                    task = Long.parseLong((String)taskid);
                    long l = Long.parseLong((String)logid);
                    mapRetInfo.putAll(this.getLogs(task, l));
                }
            }
        } else {
            success = false;
            result.put(MESSAGE, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f\u975e\u6cd5\uff0c\u672a\u627e\u5230type", (String)"MQDeployServiceImpl_29", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
        }
        result.put("data", mapRetInfo);
        result.put(SUCCESS, success);
        return result;
    }

    private Map<String, Object> executeReleaseGray(DeployParam deployParam) {
        DeployDataModel deployDataModel = new DeployDataModel();
        return deployDataModel.releaseGray(deployParam);
    }

    private Map<String, Object> stopGray(DeployParam deployParam) {
        DeployDataModel deployDataModel = new DeployDataModel();
        return deployDataModel.stopGray(deployParam);
    }

    private Map<String, Object> execAsyncRunnable(DeployParam deployParam, Runnable runnable) {
        long taskId = deployParam.getTaskId();
        String ver = deployParam.getFullVer();
        try {
            es.execute(runnable);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            DeployLog.error(taskId, ver, DeployCategory.Package, String.format(ResManager.loadKDString((String)"taskId:%1$s ,\u6295\u5165\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u7ebf\u7a0b\u6570\u5df2\u6ee1\uff0c\u5806\u6808\uff1a%2$s", (String)"MQDeployServiceImpl_65", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), taskId, msg), e);
            throw new KDException(msg);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(10);
        retMap.put(SUCCESS, true);
        return retMap;
    }

    private boolean checkReduceVer(long taskId, String ver, String lowerVer) {
        try {
            if (kd.bos.util.StringUtils.isBlank((String)ver) || kd.bos.util.StringUtils.isBlank((String)lowerVer)) {
                return false;
            }
            String[] lowerVerStrs = lowerVer.split("\\.");
            Integer[] intLowerVers = new Integer[lowerVerStrs.length];
            for (int i = 0; i < lowerVerStrs.length; ++i) {
                intLowerVers[i] = Integer.parseInt(lowerVerStrs[i]);
            }
            String[] verStrs = ver.split("\\.");
            int length = verStrs.length;
            if (lowerVerStrs.length > verStrs.length) {
                length = lowerVerStrs.length;
            }
            Integer[] intVers = new Integer[length];
            for (int i = 0; i < lowerVerStrs.length; ++i) {
                intVers[i] = i >= verStrs.length ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(verStrs[i]));
            }
            int result = 0;
            for (int i = 0; i < length; ++i) {
                if (intLowerVers[i] > intVers[i]) {
                    result = 1;
                    break;
                }
                if (intLowerVers[i] >= intVers[i]) continue;
                result = -1;
                break;
            }
            if (result == 1 || intLowerVers[0] < intVers[0]) {
                String msg = String.format(ResManager.loadKDString((String)"\u56de\u6eda\u7248\u672c%1$s\u5927\u4e8e\u7cfb\u7edf\u7248\u672c%2$s\u6216\u8005\u8de8\u7248\u672c\u964d\u7ea7\uff0c\u4e0d\u80fd\u56de\u6eda\uff01", (String)"MQDeployServiceImpl_66", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), lowerVer, ver);
                DeployLog.info(taskId, ver, DeployCategory.Package, msg);
                return false;
            }
            DeployLog.info(taskId, ver, DeployCategory.Package, ResManager.loadKDString((String)"Standard Version \u6821\u9a8c\u901a\u8fc7...", (String)"StandardVersion_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]));
            return true;
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7248\u672c\u51fa\u9519\uff0c\u5806\u6808\uff1a%s", (String)"StandardVersion_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), stackMsg);
            DeployLog.error(taskId, lowerVer, DeployCategory.Package, msg, e);
            return false;
        }
    }

    private boolean isExistField() {
        List fields = DB.getColumnNames((DBRoute)DBRoute.meta, (String)"T_BAS_DEPLOYINFO");
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        return fields.contains("FRELEASETIME");
    }

    private String getErrorMsg(Exception e) {
        String err = e.getMessage();
        if (StringUtils.isBlank((CharSequence)err)) {
            err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return err;
    }

    private void deprecatedMethodCheck() {
        boolean execDeprecated = Boolean.parseBoolean(System.getProperty(EXEC_DEPRECATEDMETHOD, "false"));
        if (!execDeprecated) {
            throw new KDException(BosErrorCode.methodInvocation, new Object[]{"deprecated method access."});
        }
    }

    private static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("../", "#");
        StringBuilder cleanString = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            cleanString.append(MQDeployServiceImpl.cleanChar(str.charAt(i)));
        }
        return cleanString.toString();
    }

    private static char cleanChar(char c) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        switch (c) {
            case 58: {
                return ':';
            }
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
            case 126: {
                return '~';
            }
        }
        if (((char)c + "").equals("\\")) {
            return (char)c;
        }
        return '%';
    }

    private void logInfo(String content, String method) {
        log.info(String.format("%s %s", method, content));
    }

    private boolean checkParam(Map<String, Object> param) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
        String dmUrl = (String)param.get(DMURL);
        String uid = (String)param.get("uid");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(DMURL, dmUrl);
        params.put("uid", uid);
        String host = System.getProperty(MC_SERVER_URL);
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                String sHttpResponse = MCApiUtil.callMcApiService((String)"kapi/v2/mc/upgrade/checkUid", (String)"text/json", header, params, (int)60);
                log.info(String.format("checkUid res:%s", sHttpResponse));
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse)) {
                    JSONObject resp = JSONObject.parseObject((String)sHttpResponse);
                    boolean status = resp.get((Object)STATUS) == null ? false : (Boolean)resp.get((Object)STATUS);
                    return status;
                }
            }
            catch (Exception e) {
                log.warn("mc\u5347\u7ea7\u53c2\u6570\u68c0\u67e5\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        return false;
    }

    static {
        forceUnZip = Boolean.parseBoolean(System.getProperty(deploy_dm_forceunzip));
        ConfigurationUtil.observeChange((String)deploy_dm_forceunzip, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                forceUnZip = Boolean.parseBoolean(System.getProperty(deploy_dm_forceunzip));
            }
        });
        deployZip = Boolean.parseBoolean(System.getProperty(deploy_dm_zip));
        ConfigurationUtil.observeChange((String)deploy_dm_zip, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                deployZip = Boolean.parseBoolean(System.getProperty(deploy_dm_zip));
            }
        });
        publishThread = Boolean.parseBoolean(System.getProperty(deploy_publish_thread, "true"));
        ConfigurationUtil.observeChange((String)deploy_publish_thread, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                publishThread = Boolean.parseBoolean(System.getProperty(deploy_publish_thread, "true"));
            }
        });
        afterPublishThread = Boolean.parseBoolean(System.getProperty(deploy_after_publish_thread, "true"));
        ConfigurationUtil.observeChange((String)deploy_after_publish_thread, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                afterPublishThread = Boolean.parseBoolean(System.getProperty(deploy_after_publish_thread, "true"));
            }
        });
        deployThreadCore = Integer.parseInt(System.getProperty(deploy_thread_core, "6"));
        deAfterThreadCore = Integer.parseInt(System.getProperty(deploy_after_thread_core, "3"));
        es = ThreadPools.newExecutorService((String)"MQDeployServiceImpl-Thread", (int)deployThreadCore);
        dpAfterEs = ThreadPools.newExecutorService((String)"MQDeployServiceImpl-After-Thread", (int)deAfterThreadCore);
        lockObj = new Object();
        DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    static class CustomSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory base;

        public CustomSSLSocketFactory(SSLSocketFactory base) {
            this.base = base;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.base.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.base.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            SSLSocket socket = (SSLSocket)this.base.createSocket(s, host, port, autoClose);
            socket.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"});
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
            socket.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"});
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket socket = (SSLSocket)this.base.createSocket(host, port, localHost, localPort);
            socket.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"});
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket socket = (SSLSocket)this.base.createSocket(host, port);
            socket.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"});
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket socket = (SSLSocket)this.base.createSocket(address, port, localAddress, localPort);
            socket.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"});
            return socket;
        }
    }

    public class DeployPackageRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(DeployRunnable.class);
        private DeployPackageParam dpParam;
        private RequestContext ctx;

        public DeployPackageRunnable(RequestContext ctx, DeployPackageParam dpParam) {
            this.dpParam = dpParam;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            DeployPackageServiceImpl deployPackageService = new DeployPackageServiceImpl();
            try {
                if (this.dpParam.getType() == DeployPackageType.Before.getValue()) {
                    deployPackageService.deployPackageBefore(this.dpParam);
                } else {
                    deployPackageService.deployPackageAfter(this.dpParam);
                }
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"deployPackage\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad", (String)"MQDeployServiceImpl_67", (String)MQDeployServiceImpl.BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                log.error("deploy package error err:" + result);
            }
        }
    }

    public class RebuildRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(RebuildRunnable.class);
        private long id;
        private RequestContext ctx;
        private String ver;
        private String apps;

        public RebuildRunnable(RequestContext ctx, long id, String ver, String apps) {
            this.id = id;
            this.ctx = ctx;
            this.ver = ver;
            this.apps = apps;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            try {
                MQDeployServiceImpl deployService = new MQDeployServiceImpl();
                deployService.rebuildApps(this.id, this.ver, this.apps);
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"rebuild apps error, \u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0c\u91cd\u5efa\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"MQDeployServiceImpl_47", (String)MQDeployServiceImpl.BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                DeployLog.error(this.id, this.ver, DeployCategory.Package, result, e);
            }
        }
    }

    public class DeployRunnable
    implements Runnable {
        private final Log loger = LogFactory.getLog(DeployRunnable.class);
        private DeployParam deployParam;
        private RequestContext ctx;

        public DeployRunnable(RequestContext ctx, DeployParam deployParam) {
            this.deployParam = deployParam;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            String result = "";
            RequestContext.copyAndSet((RequestContext)this.ctx);
            MQDeployServiceImpl deployService = new MQDeployServiceImpl();
            try {
                deployService.deployDM(this.deployParam);
            }
            catch (Exception e) {
                result = ExceptionHandler.HandlerErr(e, ResManager.loadKDString((String)"Deploy dm error,\u672a\u77e5\u7684\u5f02\u5e38\u4e2d\u65ad\uff0czip\u5305\u90e8\u7f72\u5347\u7ea7\u5931\u8d25\u3002", (String)"MQDeployServiceImpl_46", (String)MQDeployServiceImpl.BOS_MSERVICE_FORM, (Object[])new Object[0])).toString();
                try {
                    DeployLog.error(this.deployParam.getTaskId(), this.deployParam.getFullVer(), DeployCategory.Package, result, e);
                    DeployPackageInfo.saveErrorDeployInfo(this.deployParam.getTaskId(), this.deployParam.getFullVer(), null);
                }
                catch (Exception e2) {
                    this.loger.error("Deploy dm error and save error DeployInfo error.", (Throwable)e2);
                }
            }
        }
    }
}

