/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.env.EnvContext;
import kd.bos.exception.KDException;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.after.DePaUtil;
import kd.bos.service.upgrade.after.RebuildType;
import kd.bos.service.upgrade.entity.BuildResult;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class DeployPackageApp {
    private static final String APP_META_DATA = "AppMetadata";
    private static ExecutorService es = ThreadPools.newExecutorService((String)"DeployPackageApp-Thread", (int)DePaUtil.MAX_Threads);

    protected void rebuildRuntimeAppMetaByNumber(String number) {
        MetadataDao.rebuildRuntimeAppMetaByNumber((String)number);
    }

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APP_META_DATA, new DistributeCacheHAPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAfterRebuildApps(Set<String> appIds) {
        block16: {
            try (DLock lock = DLock.create((String)("AfterRebuildApps_" + RequestContext.get().getAccountId())).fastMode();){
                if (lock.tryLock(60000L)) {
                    try {
                        Set<String> appIdList = DeployPackageApp.getNeedRebuildApps();
                        appIdList.addAll(appIds);
                        DeployPackageApp.getCache().put(DeployPackageApp.getCacheKey("AfterRebuildApps", CacheKeyUtil.getAcctId()), (Object)SerializationUtils.toJsonString(appIdList));
                        break block16;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new RuntimeException(ResManager.loadKDString((String)"\u7b49\u5f85\u91cd\u5efa\u5143\u6570\u636e\u9501\u8d85\u65f6(1\u5206\u949f)", (String)"DeployPackageApp_7", (String)"bos-mservice-form", (Object[])new Object[0]));
            }
        }
    }

    private static Set<String> getNeedRebuildApps() {
        String appIds = (String)DeployPackageApp.getCache().get(DeployPackageApp.getCacheKey("AfterRebuildApps", CacheKeyUtil.getAcctId()));
        HashSet<String> appIdList = StringUtils.isBlank((CharSequence)appIds) ? new HashSet(1) : (Set)SerializationUtils.fromJsonString((String)appIds, Set.class);
        return appIdList;
    }

    private static void removeAfterRebuildApps() {
        DeployPackageApp.getCache().remove(DeployPackageApp.getCacheKey("AfterRebuildApps", CacheKeyUtil.getAcctId()));
    }

    private static String getCacheKey(String key, String number) {
        return String.format("%s_%s_%s", key, AppGroupUtils.getCurrentAppGroup(), number);
    }

    public Map<String, Object> rebuildAllAppMeta(DeployPackageParam dpParam, String buildAppGroup, DeployState deployState, RebuildType rebuildType) {
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5e94\u7528\u91cd\u5efa\uff0c\u91cd\u5efa\u7c7b\u578b\uff1a%s\u3002", (String)"DeployPackageApp_8", (String)"bos-mservice-form", (Object[])new Object[0]), rebuildType.name()));
        HashMap<String, Object> appResult = new HashMap<String, Object>(16);
        AppDesignMetaReader admr = new AppDesignMetaReader();
        admr.setAppGroup(buildAppGroup);
        long start = System.currentTimeMillis();
        ArrayList<String> appList = new ArrayList<String>(10);
        if (rebuildType == RebuildType.Deploy) {
            appList.addAll(DeployPackageApp.getNeedRebuildApps());
        } else if (rebuildType == RebuildType.RebuildAllApp && dpParam.getAppList() != null && !dpParam.getAppList().isEmpty()) {
            appList.addAll(dpParam.getAppList());
        } else {
            Map apps = admr.getAllOriAppNumbers();
            appList.addAll(apps.values());
        }
        long getEnd = System.currentTimeMillis();
        long getCost = getEnd - start;
        ArrayList<AppBuilder> tasks = new ArrayList<AppBuilder>(10);
        List appSuccessResult = Collections.synchronizedList(new ArrayList());
        List appFailedResult = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < appList.size(); i += DePaUtil.BATCH_SIZE) {
            int startIndex = i;
            int endIndex = i + DePaUtil.BATCH_SIZE;
            if (endIndex > appList.size()) {
                endIndex = appList.size();
            }
            AppBuilder task = new AppBuilder(appList.subList(startIndex, endIndex), buildAppGroup, RequestContext.get());
            task.setTime(System.currentTimeMillis());
            tasks.add(task);
        }
        try {
            int count = tasks == null ? 0 : tasks.size();
            int times = (int)Math.ceil((double)count / (double)this.getMaxThreads());
            if (DePaUtil.isSplit) {
                DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u91cd\u5efa\u67e5\u8be2\u5230\u5e94\u7528\u5171\uff1a %1$s\u4e2a\uff0c\u67e5\u8be2\u8017\u65f6\uff1a%2$s ms\uff0c\u5206\u4e3a\uff1a%3$s\u6279\uff0c\u6bcf\u6279%4$s\u4e2a", (String)"DeployPackageApp_2", (String)"bos-mservice-form", (Object[])new Object[0]), appList.size(), getCost, times, DePaUtil.BATCH_SIZE));
            }
            int iterator = 1;
            for (int i = 0; i < tasks.size(); i += this.getMaxThreads()) {
                int startIndex = i;
                int endIndex = i + this.getMaxThreads();
                if (endIndex > tasks.size()) {
                    endIndex = tasks.size();
                }
                if (DePaUtil.isSplit) {
                    DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7b2c  %s \u6279", (String)"DeployPackageApp_3", (String)"bos-mservice-form", (Object[])new Object[0]), iterator));
                }
                ArrayList batchTasks = new ArrayList(tasks.subList(startIndex, endIndex));
                long time = System.currentTimeMillis();
                for (AppBuilder builder : batchTasks) {
                    builder.setTime(time);
                }
                List<Future<List<BuildResult>>> result = es.invokeAll(batchTasks);
                Map<String, Object> r = this.handleBuildResult(result);
                String rebuildMsg = JSON.toJSONString(r, (boolean)true);
                appSuccessResult.addAll((List)r.get("success"));
                appFailedResult.addAll((List)r.get("failed"));
                if (DePaUtil.isSplit) {
                    DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u7b2c  %1$s \u6279\u91cd\u5efa\u7ed3\u679c\u4e3a\uff1a%2$s", (String)"DeployPackageApp_4", (String)"bos-mservice-form", (Object[])new Object[0]), iterator, rebuildMsg));
                }
                BigDecimal current = BigDecimal.valueOf(iterator).divide(BigDecimal.valueOf(times), 10, RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(0.3));
                BigDecimal proVal = BigDecimal.valueOf(0.7).add(current);
                deployState.setProgress(proVal);
                ++iterator;
            }
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            DeployLog.error(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"taskId:%1$s ,\u6295\u5165\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u7ebf\u7a0b\u6570\u5df2\u6ee1\uff0c\u5806\u6808\uff1a%2$s", (String)"DeployPackageApp_5", (String)"bos-mservice-form", (Object[])new Object[0]), dpParam.getTaskId(), msg), e);
            throw new KDException(msg);
        }
        DeployPackageApp.removeAfterRebuildApps();
        long rebuildCost = System.currentTimeMillis() - getEnd;
        appResult.put("failed", appFailedResult);
        appResult.put("success", appSuccessResult);
        appResult.put("count", appList.size());
        appResult.put("getCost", getCost);
        appResult.put("rebuildCost", rebuildCost);
        return appResult;
    }

    private Map<String, Object> handleBuildResult(List<Future<List<BuildResult>>> results) {
        HashMap<String, Object> appResult = new HashMap<String, Object>(16);
        List appSuccessResult = Collections.synchronizedList(new ArrayList());
        List appFailedResult = Collections.synchronizedList(new ArrayList());
        appResult.put("failed", appFailedResult);
        appResult.put("success", appSuccessResult);
        if (results == null) {
            return appResult;
        }
        long buildTimeOut = this.getBuildTimeOut();
        results.forEach(result -> {
            try {
                List list = (List)result.get(buildTimeOut, TimeUnit.MINUTES);
                if (list != null) {
                    list.forEach(r -> {
                        if (r.isSuccess()) {
                            appSuccessResult.add(r);
                        } else {
                            appFailedResult.add(r);
                        }
                    });
                }
            }
            catch (Exception e) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u6784\u5efaApp\u5143\u6570\u636e\u5931\u8d25\uff1a%s", (String)"DeployPackageApp_6", (String)"bos-mservice-form", (Object[])new Object[0]), this.getErrorMsg(e));
                BuildResult errResult = new BuildResult();
                errResult.setSuccess(false);
                errResult.setMessage(errMsg);
                appFailedResult.add(errResult);
            }
        });
        return appResult;
    }

    private long getBuildTimeOut() {
        int timeout = 120;
        String buildTimeout = System.getProperty("build.timeout");
        if (!StringUtils.isEmpty((CharSequence)buildTimeout)) {
            timeout = Integer.parseInt(buildTimeout);
        }
        return timeout;
    }

    private String getErrorMsg(Exception e) {
        String err = e.getMessage();
        if (StringUtils.isBlank((CharSequence)err)) {
            err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return err;
    }

    private int getMaxThreads() {
        return DePaUtil.MAX_Threads == 0 ? 1 : DePaUtil.MAX_Threads;
    }

    private class AppBuilder
    implements Callable<List<BuildResult>> {
        private List<String> appList;
        private RequestContext requestContext;
        private long time;

        public AppBuilder(List<String> appList, String appGroup, RequestContext rc) {
            this.requestContext = rc;
            this.appList = appList;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public List<BuildResult> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            String message = "";
            long start = System.currentTimeMillis();
            long wait = start - this.time;
            ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
            ArrayList<BuildResult> result = new ArrayList<BuildResult>(10);
            int i = 0;
            for (String number : this.appList) {
                boolean success = true;
                long ts = System.currentTimeMillis();
                long cost = 0L;
                try {
                    this.setEnvContext("bos", number, number, "rebuildRuntimeAppMetaByNumber", "MetadataDao");
                    DeployPackageApp.this.rebuildRuntimeAppMetaByNumber(number);
                    cost = System.currentTimeMillis() - ts;
                    message = String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u5143\u6570\u636e\u6210\u529f\uff01cost: %2$s ms", (String)"DeployPackageApp_0", (String)"bos-mservice-form", (Object[])new Object[0]), number, cost);
                }
                catch (Exception e) {
                    success = false;
                    String err = DeployPackageApp.this.getErrorMsg(e);
                    cost = System.currentTimeMillis() - ts;
                    message = String.format(ResManager.loadKDString((String)"\u6784\u5efa\u5e94\u7528\u3010%1$s\u3011\u5143\u6570\u636e\u5931\u8d25\uff1acost: %2$s ms, %3$s", (String)"DeployPackageApp_1", (String)"bos-mservice-form", (Object[])new Object[0]), number, cost, err);
                }
                if (i == 0) {
                    result.add(new BuildResult(number, number, wait, success, 1, message, cost));
                } else {
                    result.add(new BuildResult(number, number, 0L, success, 1, message, cost));
                }
                ++i;
            }
            ThreadCache.remove((Object)"AppMetaDao.querySubApp.ignoreExtApp");
            return result;
        }

        private void setEnvContext(String appId, String formId, String formname, String method, String opKey) {
            EnvContext.thread().set("appId", (Object)appId);
            EnvContext.thread().set("formId", (Object)formId);
            EnvContext.thread().set("formname", (Object)formname);
            EnvContext.thread().set("methodName", (Object)method);
            EnvContext.thread().set("opkey", (Object)opKey);
        }
    }
}

