/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.env.EnvContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.metadata.BuildFormDesignMeta;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.businessfield.BasedataEntitymetaReader;
import kd.bos.mservice.form.ExceptionHandler;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.after.BuildTaskGroup;
import kd.bos.service.upgrade.after.DePaUtil;
import kd.bos.service.upgrade.after.RebuildService;
import kd.bos.service.upgrade.after.RebuildStrategy;
import kd.bos.service.upgrade.after.RebuildType;
import kd.bos.service.upgrade.entity.BuildResult;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.threads.ThreadPools;

public class DeployPackageMeta {
    private static ExecutorService es = ThreadPools.newExecutorService((String)"DeployPackageMeta-Thread", (int)DePaUtil.MAX_Threads);

    protected int rebuildRuntimeMetaById(String formId, String runtimeVer, String appGroup) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return 2;
        }
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        mr.rebuildRuntimeMetaById(formId);
        return 1;
    }

    public Map<String, Object> rebuildAllMeta(DeployPackageParam dpParam, DeployState deployState) {
        RebuildType rebuildType = dpParam.getRebuildType() == null ? RebuildType.Deploy : dpParam.getRebuildType();
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5143\u6570\u636e\u91cd\u5efa\uff0c\u91cd\u5efa\u7c7b\u578b\uff1a%1$s ,diffVer:%2$s\u3002", (String)"DeployPackageMeta_8", (String)"bos-mservice-form", (Object[])new Object[0]), rebuildType.name(), dpParam.isDiffVer()));
        HashMap<String, Object> metaResult = new HashMap(16);
        BigDecimal factor = rebuildType == RebuildType.Deploy ? BigDecimal.valueOf(0.7) : new BigDecimal(1);
        long start = System.currentTimeMillis();
        List<BuildFormDesignMeta> metas = this.getNeedRebuildMetas(dpParam, dpParam.getAppGroup());
        deployState.setProgress(BigDecimal.valueOf(0.1).multiply(factor));
        long getEnd = System.currentTimeMillis();
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u9700\u8981\u91cd\u5efa\u7684\u5143\u6570\u636e%1$s\u4e2a\uff0c\u8017\u65f6\uff1a%2$s \uff0c \u5f00\u59cb\u6309\u63a7\u5236\u7b56\u7565\u5206\u5272...", (String)"DeployPackageMeta_9", (String)"bos-mservice-form", (Object[])new Object[0]), metas.size(), getEnd - start));
        List<BuildTaskGroup> taskGroupList = RebuildStrategy.getTaskGroup(metas, dpParam);
        deployState.setProgress(BigDecimal.valueOf(0.2).multiply(factor));
        long splitEnd = System.currentTimeMillis();
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u6309\u63a7\u5236\u7b56\u7565\u4f9b\u5206\u5272\u4e3a\uff1a%1$s\u4e2a\u4efb\u52a1\u7ec4\uff0c\u8017\u65f6\uff1a%2$s, \u5f00\u59cb\u6267\u884c\u8282\u70b9\u5206\u53d1...", (String)"DeployPackageMeta_10", (String)"bos-mservice-form", (Object[])new Object[0]), taskGroupList.size(), splitEnd - getEnd));
        metaResult = RebuildService.dispatch(taskGroupList, deployState, factor);
        deployState.setProgress(factor);
        long dispatchEnd = System.currentTimeMillis();
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u91cd\u5efa\u6267\u884c\u7ed3\u675f\uff0c\u672c\u6b21\u5168\u90e8\u91cd\u5efa\u6267\u884c\u8017\u65f6\uff1a%s", (String)"DeployPackageMeta_11", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchEnd - splitEnd));
        BasedataEntitymetaReader.removeLocalCache();
        return metaResult;
    }

    public Map<String, Object> batchRebuildForm(Map<String, Object> param) {
        HashMap<String, Object> metaResult = new HashMap<String, Object>(16);
        List ids = (List)param.get("ids");
        long taskId = (Long)param.get("taskId");
        String ver = (String)param.get("ver");
        long dispatchTaskId = (Long)param.get("dispatchTaskId");
        DeployLog.info(taskId, ver, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"dispatchTaskId\uff1a%1$s \u6267\u884c\u670d\u52a1\u5b9e\u4f8b\u4e3a\uff1a%2$s", (String)"DeployPackageMeta_12", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchTaskId, Instance.getInstanceId()));
        if (ids == null) {
            return metaResult;
        }
        BasedataEntitymetaReader.removeLocalCache();
        long start = System.currentTimeMillis();
        List<BuildFormDesignMeta> metas = DeployPackageMeta.getRebuildFormDesignMeta(ids);
        Map<String, String> dbRouteMap = this.getDBRouteKey(metas);
        metas.forEach(meta -> {
            if (dbRouteMap.containsKey(meta.getId())) {
                meta.setDbRouteKey((String)dbRouteMap.get(meta.getId()));
            }
        });
        long getEnd = System.currentTimeMillis();
        long getCost = getEnd - start;
        int count = metas == null ? 0 : metas.size();
        int times = (int)Math.ceil((double)count / (double)this.getMetaBatchSize());
        if (DePaUtil.isSplit) {
            DeployLog.info(taskId, ver, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"dispatchTaskId\uff1a%1$s \u672c\u6b21\u9700\u91cd\u5efa\u5143\u6570\u636e\u5171\uff1a %2$s\u4e2a\uff0c\u67e5\u8be2\u8017\u65f6\uff1a%3$s ms\uff0c\u5206\u4e3a\uff1a%4$s\u6279, \u6bcf\u6279\uff1a%5$s\u4e2a", (String)"DeployPackageMeta_5", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchTaskId, count, getCost, times, this.getMetaBatchSize()));
        }
        List<BuildResult> successResult = Collections.synchronizedList(new ArrayList());
        List<BuildResult> failedResult = Collections.synchronizedList(new ArrayList());
        int iterator = 1;
        for (int i = 0; i < metas.size(); i += this.getMetaBatchSize()) {
            int startIndex = i;
            int endIndex = i + this.getMetaBatchSize();
            if (endIndex > metas.size()) {
                endIndex = metas.size();
            }
            if (DePaUtil.isSplit) {
                DeployLog.info(taskId, ver, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"dispatchTaskId: %1$s \u6b63\u5728\u6267\u884c\u7b2c  %2$s \u6279", (String)"DeployPackageMeta_1", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchTaskId, iterator));
            }
            Map<String, Object> result = this.rebuildFormMetas(metas.subList(startIndex, endIndex));
            this.mergeResult(successResult, failedResult, result);
            String rebuildMsg = JSON.toJSONString(result, (boolean)true);
            if (DePaUtil.isSplit) {
                DeployLog.info(taskId, ver, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"dispatchTaskId: %1$s \u7b2c  %2$s \u6279\u91cd\u5efa\u7ed3\u679c\u4e3a\uff1a%3$s", (String)"DeployPackageMeta_6", (String)"bos-mservice-form", (Object[])new Object[0]), dispatchTaskId, iterator, rebuildMsg));
            }
            ++iterator;
        }
        long rebuildCost = System.currentTimeMillis() - getEnd;
        metaResult.put("failed", failedResult);
        metaResult.put("success", successResult);
        metaResult.put("count", count);
        metaResult.put("getCost", getCost);
        metaResult.put("rebuildCost", rebuildCost);
        return metaResult;
    }

    private static List<BuildFormDesignMeta> getRebuildFormDesignMeta(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<BuildFormDesignMeta>(0);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, Fnumber, FModelType, FType, FMasterId from t_meta_formdesign WHERE ", new Object[0]).appendIn("fid", ids.toArray());
        return DeployPackageMeta.queryBuildFormDesignMeta(sqlBuilder);
    }

    private List<BuildFormDesignMeta> getNeedRebuildMetas(DeployPackageParam dpParam, String buildAppGroup) {
        ArrayList<BuildFormDesignMeta> metas = new ArrayList<BuildFormDesignMeta>(10);
        MetaRebuilder mr = new MetaRebuilder(buildAppGroup);
        List forms = mr.getAllRebuildFormDesignMeta();
        if (forms == null) {
            return metas;
        }
        if (!dpParam.isDiffVer()) {
            return forms;
        }
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (BuildFormDesignMeta meta : forms) {
            numbers.add(meta.getNumber());
        }
        Map runtimeVerMap = MetadataDao.getRuntimeMetaVersion(numbers);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u91cd\u5efa\u67e5\u8be2\u5230\u5143\u6570\u636e\u4e2a\u6570\uff1a%1$s\uff0c\u8fd0\u884c\u65f6\u7248\u672c\u4e2a\u6570\uff1a%2$s\uff0c\u5f00\u59cb\u6bd4\u8f83\u7248\u672c...", (String)"DeployPackageMeta_7", (String)"bos-mservice-form", (Object[])new Object[0]), numbers.size(), runtimeVerMap.size()));
        for (BuildFormDesignMeta meta : forms) {
            String runtimeVer = (String)runtimeVerMap.get(meta.getNumber());
            String mergerVersion = meta.getMergeVersion();
            if (MetadataDao.compareRuntimeVersion((String)mergerVersion, (String)runtimeVer)) continue;
            meta.setRuntimeVer(runtimeVer);
            metas.add(meta);
        }
        return metas;
    }

    private static List<BuildFormDesignMeta> queryBuildFormDesignMeta(SqlBuilder sqlBuilder) {
        ResultSetHandler<List<BuildFormDesignMeta>> action = new ResultSetHandler<List<BuildFormDesignMeta>>(){

            public List<BuildFormDesignMeta> handle(ResultSet rs) throws Exception {
                ArrayList<BuildFormDesignMeta> list = new ArrayList<BuildFormDesignMeta>(10);
                while (rs.next()) {
                    String modelType = rs.getString("FModelType");
                    BuildFormDesignMeta meta = new BuildFormDesignMeta();
                    meta.setId(rs.getString("FId"));
                    meta.setNumber(rs.getString("FNumber"));
                    meta.setModelType(modelType);
                    meta.setDevType(rs.getString("FType"));
                    meta.setMasterId(rs.getString("FMasterId"));
                    list.add(meta);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return list;
    }

    private Map<String, String> getDBRouteKey(List<BuildFormDesignMeta> metas) {
        HashMap<String, String> dbRouteMap = new HashMap<String, String>(16);
        if (metas == null) {
            return dbRouteMap;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fdbroute ,b.fformid from T_Meta_BizApp a inner join T_Meta_BizUnitRelForm b on a.fid = b.fbizappid", new Object[0]);
        ArrayList formIdList = new ArrayList(metas.size());
        metas.forEach(meta -> formIdList.add(meta.getId()));
        sql.append(" where ", new Object[0]).appendIn("b.fformid", formIdList.toArray(new Object[formIdList.size()]));
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> dbRouteMap = new HashMap<String, String>(16);
                while (rs.next()) {
                    String dbRoute = rs.getString(1);
                    String formId = rs.getString(2);
                    if (!StringUtils.isNotBlank((CharSequence)formId)) continue;
                    dbRouteMap.put(formId, dbRoute);
                }
                return dbRouteMap;
            }
        });
    }

    private void mergeResult(List<BuildResult> successResult, List<BuildResult> failedResult, Map<String, Object> result) {
        if (result != null && result.get("failed") != null) {
            failedResult.addAll((Collection)result.get("failed"));
        }
        if (result != null && result.get("success") != null) {
            successResult.addAll((Collection)result.get("success"));
        }
    }

    private Map<String, Object> rebuildFormMetas(List<BuildFormDesignMeta> metas) {
        List successResult = Collections.synchronizedList(new ArrayList());
        List failedResult = Collections.synchronizedList(new ArrayList());
        ArrayList<Builder> tasks = new ArrayList<Builder>(10);
        for (int i = 0; i < metas.size(); i += DePaUtil.BATCH_SIZE) {
            int startIndex = i;
            int endIndex = i + DePaUtil.BATCH_SIZE;
            if (endIndex > metas.size()) {
                endIndex = metas.size();
            }
            Builder builder = new Builder(metas.subList(startIndex, endIndex), RequestContext.get());
            builder.setTime(System.currentTimeMillis());
            tasks.add(builder);
        }
        try {
            ArrayList results = new ArrayList(tasks.size());
            for (int i = 0; i < tasks.size(); i += DePaUtil.MAX_Threads) {
                int startIndex = i;
                int endIndex = i + DePaUtil.MAX_Threads;
                if (endIndex > tasks.size()) {
                    endIndex = tasks.size();
                }
                ArrayList batchTasks = new ArrayList(tasks.subList(startIndex, endIndex));
                long time = System.currentTimeMillis();
                for (Builder builder : batchTasks) {
                    builder.setTime(time);
                }
                results.addAll(es.invokeAll(batchTasks));
            }
            long buildTimeOut = DePaUtil.getBuildTimeOut();
            results.forEach(result -> {
                try {
                    List brs = (List)result.get(buildTimeOut, TimeUnit.MINUTES);
                    if (brs != null) {
                        brs.forEach(r -> {
                            if (r.isSuccess()) {
                                successResult.add(r);
                            } else {
                                failedResult.add(r);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    BuildResult rErr = new BuildResult();
                    rErr.setSuccess(false);
                    rErr.setMessage(String.format(ResManager.loadKDString((String)"\u6784\u5efaForm\u5143\u6570\u636e\u5931\u8d25\uff1a", (String)"DeployPackageMeta_4", (String)"bos-mservice-form", (Object[])new Object[0]), DePaUtil.getErrorMsg(e)));
                    failedResult.add(rErr);
                }
            });
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("BOS_META", e.getMessage());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.put("count", metas.size());
        result2.put("failed", failedResult);
        result2.put("success", successResult);
        return result2;
    }

    private int getMetaBatchSize() {
        return DePaUtil.META_BATCH_SIZE == 0 ? 10 : DePaUtil.META_BATCH_SIZE;
    }

    private class Builder
    implements Callable<List<BuildResult>> {
        private List<BuildFormDesignMeta> metas;
        private RequestContext requestContext;
        private long time;
        private String appGroup;

        public Builder(List<BuildFormDesignMeta> metas, RequestContext rc) {
            this.requestContext = rc;
            this.metas = metas;
            DB.__setIgnoreCheckThreadGetMaxConnectionCount((boolean)true);
        }

        public void setAppGroup(String appGroup) {
            this.appGroup = appGroup;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public List<BuildResult> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            ThreadCache.put((Object)"rebuild.speed.model", (Object)"true");
            ArrayList<BuildResult> results = new ArrayList<BuildResult>(10);
            if (this.metas != null) {
                long ts = System.currentTimeMillis();
                long waitCost = ts - this.time;
                boolean i = false;
                for (BuildFormDesignMeta meta : this.metas) {
                    if (!i) {
                        results.add(this.buildSingleMeta(meta, waitCost));
                        continue;
                    }
                    results.add(this.buildSingleMeta(meta, 0L));
                }
            }
            return results;
        }

        private BuildResult buildSingleMeta(BuildFormDesignMeta meta, long waitCost) {
            String number = meta.getNumber();
            String formId = meta.getId();
            String runtimeVer = meta.getRuntimeVer();
            String modelType = meta.getModelType();
            String dbRouteKey = meta.getDbRouteKey() == null ? "" : meta.getDbRouteKey();
            long ts = System.currentTimeMillis();
            boolean success = true;
            String message = "";
            long cost = 0L;
            int ret = 1;
            try {
                FormConfig config;
                String caption;
                this.setEnvContext("bos", number, number, "rebuildRuntimeMetaByNumber", "MetadataDao");
                ThreadCache.put((Object)(formId + ".DBRouteKey"), (Object)dbRouteKey);
                ret = DeployPackageMeta.this.rebuildRuntimeMetaById(formId, runtimeVer, this.appGroup);
                ThreadCache.remove((Object)(formId + ".DBRouteKey"));
                if (ret == 2) {
                    cost = System.currentTimeMillis() - ts;
                    message = String.format("%s is null : BUILD WARNING!! cost: %s ms", number, cost);
                } else if (ret == 3) {
                    caption = "";
                    if (AppGroupUtils.getCurrentAppGroup().equals(this.appGroup)) {
                        config = FormMetadataCache.getFormConfig((String)number);
                        caption = config.getCaption().toString();
                    }
                    cost = System.currentTimeMillis() - ts;
                    message = String.format("%s:%s BUILD SUCCESSFUL(same version, not rebuilding)! cost: %s ms", number, caption, cost);
                }
                if (ret == 1) {
                    if (!"PrintModel".equalsIgnoreCase(modelType)) {
                        caption = "";
                        if (AppGroupUtils.getCurrentAppGroup().equals(this.appGroup)) {
                            config = FormMetadataCache.getFormConfig((String)number);
                            caption = config.getCaption().toString();
                        }
                        cost = System.currentTimeMillis() - ts;
                        message = String.format("%s:%s BUILD SUCCESSFUL! cost: %s ms", number, caption, cost);
                    } else {
                        cost = System.currentTimeMillis() - ts;
                        message = String.format("PrintModel:%s BUILD SUCCESSFUL! cost: %s ms", number, cost);
                    }
                }
            }
            catch (Exception e) {
                success = false;
                ret = 0;
                String cacheId = MetaCacheUtils.getDistributeCache((String)number, (String)"formid", (int)0);
                cost = System.currentTimeMillis() - ts;
                message = String.format("%s  error: BUILD FAILED!!!, %s,formid:%s,cacheid\uff1a%s, cost:%s ms\u3002", number, ExceptionHandler.HandlerErr(e, number), formId, cacheId, cost);
            }
            return new BuildResult(formId, number, waitCost, success, ret, message, cost);
        }

        private void setEnvContext(String appId, String formId, String formname, String method, String opKey) {
            EnvContext.thread().set("appId", (Object)appId);
            EnvContext.thread().set("formId", (Object)formId);
            EnvContext.thread().set("formname", (Object)formname);
            EnvContext.thread().set("methodName", (Object)method);
            EnvContext.thread().set("opkey", (Object)opKey);
        }
    }
}

