/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.instance.Instance;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.gray.GrayMetaTableCreator;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.metadata.IBOTPMetadataReaderProxy;
import kd.bos.service.upgrade.DeployPackageInfo;
import kd.bos.service.upgrade.DeployPackageParam;
import kd.bos.service.upgrade.after.DePaUtil;
import kd.bos.service.upgrade.after.DeployPackageApp;
import kd.bos.service.upgrade.after.DeployPackageMeta;
import kd.bos.service.upgrade.after.RebuildType;
import kd.bos.service.upgrade.entity.BuildResult;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployState;

public class DeployPackageServiceImpl {
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String COUNT = "count";
    private static boolean isSplit = Boolean.parseBoolean(System.getProperty("deploy.after.rebuild.split", "true"));

    protected Map<String, Object> rebuildAllAppMeta(DeployPackageParam dpParam, String buildAppGroup, DeployState deployState) {
        DeployPackageApp deployPackageApp = new DeployPackageApp();
        return deployPackageApp.rebuildAllAppMeta(dpParam, buildAppGroup, deployState, RebuildType.Deploy);
    }

    protected Map<String, Object> rebuildAllMeta(DeployPackageParam dpParam, String buildAppGroup, DeployState deployState) {
        DeployPackageMeta deployPackageMeta = new DeployPackageMeta();
        dpParam.setDiffVer(true);
        dpParam.setRebuildType(RebuildType.Deploy);
        dpParam.setAppGroup(buildAppGroup);
        return deployPackageMeta.rebuildAllMeta(dpParam, deployState);
    }

    public void deployPackageBefore(DeployPackageParam dpParam) {
        try {
            GrayMetaTableCreator creator;
            long start = System.currentTimeMillis();
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, "deployPackageBefore begin exec");
            if (DeployPackageInfo.checkCreateTable()) {
                DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, "deploy package table create success.");
            }
            if (StringUtils.isNotBlank((CharSequence)dpParam.getAppGroup())) {
                creator = new GrayMetaTableCreator(dpParam.getAppGroup());
                creator.createTable();
            }
            if (dpParam.isAllAppGray()) {
                creator = new GrayMetaTableCreator(dpParam.getAppGroup());
                creator.initAllAppGrayMeta();
            }
            DeployPackageInfo dpInfo = new DeployPackageInfo(dpParam.getTaskId(), dpParam.getPkName(), dpParam.getType(), dpParam.getVer(), 1);
            dpInfo.setIsv(dpParam.getIsv());
            dpInfo.setContent(ResManager.loadKDString((String)"deployPackageBefore \u6267\u884c\u6210\u529f", (String)"DeployPackageServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]));
            DeployPackageInfo.saveDeployInfo(dpInfo, dpInfo.getClass());
            long end = System.currentTimeMillis();
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"deployPackageBefore end exec \u6267\u884c\u8017\u65f6\uff1a%s", (String)"DeployPackageServiceImpl_15", (String)"bos-mservice-form", (Object[])new Object[0]), end - start));
        }
        catch (Exception e) {
            String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
            this.saveErrorDeployPackage(dpParam, null, stackMsg);
            DeployLog.error(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, stackMsg, e);
        }
    }

    public void deployPackageAfter(DeployPackageParam dpParam) {
        try {
            DeployState deployState = new DeployState(dpParam.getTaskId());
            String instanceId = Instance.getInstanceId();
            deployState.setDeployInstanceId(instanceId);
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format("deployPackageAfter in instance: %s begin exec", instanceId));
            long start = System.currentTimeMillis();
            DeployPackageMeta deployPackageMeta = new DeployPackageMeta();
            Map<String, Object> rebuildResult = this.rebuildAllDiffVer(dpParam, deployState);
            String rebuildMsg = JSON.toJSONString(rebuildResult, (boolean)true);
            if (!isSplit) {
                DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, rebuildMsg);
            }
            DeployPackageInfo dpInfo = new DeployPackageInfo(dpParam.getTaskId(), dpParam.getPkName(), dpParam.getType(), dpParam.getVer(), 1);
            dpInfo.setIsv(dpParam.getIsv());
            dpInfo.setContent(String.format(ResManager.loadKDString((String)"deployPackageAfter \u6267\u884c\u6210\u529f!\u5143\u6570\u636e\u91cd\u5efa\u7ed3\u679c\u4e3a\uff1a%s", (String)"DeployPackageServiceImpl_16", (String)"bos-mservice-form", (Object[])new Object[0]), rebuildMsg));
            long saveStart = System.currentTimeMillis();
            DeployPackageInfo.saveDeployInfo(dpInfo, dpInfo.getClass());
            long saveEnd = System.currentTimeMillis();
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, "deployPackageAfter schedule service start\u3002");
            try {
                ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.refreshScheduleWheel();
            }
            catch (Exception e) {
                String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
                DeployLog.warn(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format("deployPackageAfter schedule service execute error,err:%s", stackMsg));
            }
            long scheduleEnd = System.currentTimeMillis();
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format("deployPackageAfter schedule service end\u3002 cost:%s", scheduleEnd - saveEnd));
            long end = System.currentTimeMillis();
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, String.format(ResManager.loadKDString((String)"deployPackageAfter exec \u6267\u884c\u8017\u65f6\uff1a%1$s\uff0csave\uff1a%2$s ,schedule:%3$s", (String)"DeployPackageServiceImpl_22", (String)"bos-mservice-form", (Object[])new Object[0]), end - start, saveEnd - saveStart, scheduleEnd - saveEnd));
        }
        catch (Exception e) {
            String stackMsg = DeployLog.getExceptionStackTraceMessage(e);
            this.saveErrorDeployPackage(dpParam, null, stackMsg);
            DeployLog.error(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Package, stackMsg, e);
        }
    }

    protected Map<String, Object> rebuildAllDiffVer(DeployPackageParam dpParam, DeployState deployState) {
        long start = System.currentTimeMillis();
        HashMap<String, Object> rebuildResult = new HashMap<String, Object>(16);
        List successResult = Collections.synchronizedList(new ArrayList());
        List failedResult = Collections.synchronizedList(new ArrayList());
        MetadataDao.cleanAllAppMetadataCache();
        MetadataDao.cleanPreinsdataCache();
        long clearCacheCost = System.currentTimeMillis() - start;
        long rebuildStart = System.currentTimeMillis();
        String buildAppGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)dpParam.getAppGroup())) {
            buildAppGroup = dpParam.getAppGroup();
        }
        if (deployState == null) {
            deployState = new DeployState(dpParam.getTaskId());
        }
        deployState.setProgress(new BigDecimal(0));
        Map<String, Object> metaResult = this.rebuildAllMeta(dpParam, buildAppGroup, deployState);
        successResult.addAll((List)metaResult.get(SUCCESS));
        failedResult.addAll((List)metaResult.get(FAILED));
        deployState.setProgress(BigDecimal.valueOf(0.7));
        long rebuildEnd = System.currentTimeMillis();
        long rebuildCost = rebuildEnd - rebuildStart;
        ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).clearAllConvertRuleCache();
        ((IBOTPMetadataReaderProxy)BOTPServiceFactory.getSingletonService(IBOTPMetadataReaderProxy.class)).clearAllWriteBackRuleCache();
        long botpCost = System.currentTimeMillis() - rebuildEnd;
        long appStart = System.currentTimeMillis();
        Map<String, Object> appResult = this.rebuildAllAppMeta(dpParam, buildAppGroup, deployState);
        successResult.addAll((List)appResult.get(SUCCESS));
        failedResult.addAll((List)appResult.get(FAILED));
        long rebuildAppCost = System.currentTimeMillis() - appStart;
        long end = System.currentTimeMillis();
        long cost = end - start;
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u603b\u8017\u65f6(\u91cd\u5efa\u5f00\u59cb->\u91cd\u5efa\u7ed3\u675f)\uff1a%1$s ms \n \u6e05\u9664\u5e94\u7528\u53ca\u6570\u636e\u7f13\u5b58\u8017\u65f6\uff1a%2$s ms \n \u91cd\u5efa\u5e94\u7528\u8017\u65f6\uff1a%3$s ms \n \u91cd\u5efa\u5143\u6570\u636e\u8017\u65f6\uff1a%4$s ms \n \u6e05\u9664botp\u7f13\u5b58\u8017\u65f6\uff1a%5$s ms", (String)"DeployPackageServiceImpl_17", (String)"bos-mservice-form", (Object[])new Object[0]), cost, clearCacheCost, rebuildAppCost, rebuildCost, botpCost));
        int appCount = appResult.get(COUNT) == null ? 0 : (Integer)appResult.get(COUNT);
        int metaCount = metaResult.get(COUNT) == null ? 0 : (Integer)metaResult.get(COUNT);
        int count = appCount + metaCount;
        rebuildResult.put(FAILED, failedResult);
        rebuildResult.put(SUCCESS, successResult);
        rebuildResult.put(COUNT, count);
        if (DePaUtil.enableCostLog) {
            DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, ResManager.loadKDString((String)"\u6839\u636e\u5143\u6570\u636e\u548c\u5e94\u7528\u91cd\u5efa\u7ed3\u679c\u8fdb\u884c\u8017\u65f6\u8be6\u60c5\u7edf\u8ba1\u5206\u6790\u5982\u4e0b\uff1a", (String)"DeployPackageServiceImpl_28", (String)"bos-mservice-form", (Object[])new Object[0]));
            this.costLog(dpParam, appResult, metaResult);
        }
        deployState.finish();
        return rebuildResult;
    }

    private void saveErrorDeployPackage(DeployPackageParam dpParam, DeployPackageInfo dpInfo, String errMsg) {
        if (dpInfo == null) {
            dpInfo = new DeployPackageInfo(dpParam.getTaskId(), dpParam.getPkName(), dpParam.getType(), dpParam.getVer(), 0);
            dpInfo.setIsv(dpParam.getIsv());
            dpInfo.setContent(errMsg);
        }
        DeployPackageInfo.saveDeployInfo(dpInfo, dpInfo.getClass());
    }

    private void costLog(DeployPackageParam dpParam, Map<String, Object> appResult, Map<String, Object> metaResult) {
        int cpuCore;
        Map<String, Object> map;
        long costTotal = 0L;
        long waitCostTotal = 0L;
        long appCostTotal = 0L;
        long appWaitCostTotal = 0L;
        long metaCostTotal = 0L;
        long metaWaitCostTotal = 0L;
        ArrayList<BuildResult> appTopCost = new ArrayList<BuildResult>(10);
        ArrayList<BuildResult> appTopWaitCost = new ArrayList<BuildResult>(10);
        ArrayList<BuildResult> metaTopCost = new ArrayList<BuildResult>(10);
        ArrayList<BuildResult> metaTopWaitCost = new ArrayList<BuildResult>(10);
        if (appResult != null && (map = this.parseResult(appResult, appTopCost, appTopWaitCost)) != null) {
            appCostTotal = map.get("costTotal") == null ? 0L : (Long)map.get("costTotal");
            appWaitCostTotal = map.get("waitCostTotal") == null ? 0L : (Long)map.get("waitCostTotal");
            costTotal += appCostTotal;
            waitCostTotal += appWaitCostTotal;
        }
        if (metaResult != null && (map = this.parseResult(metaResult, metaTopCost, metaTopWaitCost)) != null) {
            metaCostTotal = map.get("costTotal") == null ? 0L : (Long)map.get("costTotal");
            metaWaitCostTotal = map.get("waitCostTotal") == null ? 0L : (Long)map.get("waitCostTotal");
            costTotal += metaCostTotal;
            waitCostTotal += metaWaitCostTotal;
        }
        long thread = (cpuCore = Runtime.getRuntime().availableProcessors()) < DePaUtil.MAX_Threads ? (long)cpuCore : (long)DePaUtil.MAX_Threads;
        long appIdealCost = appCostTotal / thread;
        int appCount = appResult == null || appResult.get(COUNT) == null ? 0 : (Integer)appResult.get(COUNT);
        int appTasks = 0;
        long appAverageCost = 0L;
        long appAverageWaitCost = 0L;
        if (appCount > 0) {
            appTasks = appCount / DePaUtil.BATCH_SIZE;
            appAverageCost = appIdealCost < (long)appCount ? appIdealCost % (long)appCount : appIdealCost / (long)appCount;
            appAverageWaitCost = appWaitCostTotal < (long)appTasks ? appWaitCostTotal % (long)appTasks : appWaitCostTotal / (long)appTasks;
        }
        int metaCount = metaResult == null || metaResult.get(COUNT) == null ? 0 : (Integer)metaResult.get(COUNT);
        long metaIdealCost = metaCostTotal / thread;
        int metaTasks = 0;
        long metaAverageCost = 0L;
        long metaAverageWaitCost = 0L;
        if (metaCount > 0) {
            metaTasks = metaCount / DePaUtil.BATCH_SIZE;
            metaAverageCost = metaIdealCost < (long)metaCount ? metaIdealCost % (long)metaCount : metaIdealCost / (long)metaCount;
            metaAverageWaitCost = metaWaitCostTotal < (long)metaTasks ? metaWaitCostTotal % (long)metaTasks : metaWaitCostTotal / (long)metaTasks;
        }
        String costMsg = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u53ca\u5143\u6570\u636e\u91cd\u5efa\u5b9e\u9645\u6267\u884c\u603b\u8017\u65f6\uff08\u4e0d\u8003\u8651\u5e76\u884c\u6267\u884c\u7684\u5355\u4e2a\u5143\u6570\u636e\u91cd\u5efa\u5b9e\u9645\u6267\u884c\u8017\u65f6\u7d2f\u52a0\uff09\uff1a%1$s ms \n \u5e94\u7528\u6267\u884c\u8017\u65f6\uff1a%2$s ms \n \u5143\u6570\u636e\u6267\u884c\u8017\u65f6\uff1a%3$s ms", (String)"DeployPackageServiceImpl_18", (String)"bos-mservice-form", (Object[])new Object[0]), costTotal, appCostTotal, metaCostTotal);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, costMsg);
        String appCostDetailMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u91cd\u5efa%1$s\u4e2a\u5e94\u7528\uff0c\u5206\u4e3a%2$s\u4e2a\u7ebf\u7a0b\u4efb\u52a1\uff0c\u6bcf\u4e2a\u7ebf\u7a0b\u4efb\u52a1\u6279\u91cf\u6267\u884c%3$s\u4e2a\u5e94\u7528\uff0c\u7ebf\u7a0b\u6c60\u6838\u5fc3\u7ebf\u7a0b\u6570\u4e3a\uff1a%4$s\uff0c\u670d\u52a1\u5668cpu\u6838\u6570\uff1a%5$s\uff0c\u9884\u8ba1\u7406\u60f3\u6267\u884c\u8017\u65f6\u5e94\u4e3a\uff1a %6$s / %7$s = %8$s ms\uff0c\u5e73\u5747\u8017\u65f6\uff1a%9$s ms", (String)"DeployPackageServiceImpl_19", (String)"bos-mservice-form", (Object[])new Object[0]), appCount, appTasks, DePaUtil.BATCH_SIZE, DePaUtil.MAX_Threads, cpuCore, appCostTotal, thread, appIdealCost, appAverageCost);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, appCostDetailMsg);
        String metaCostDetailMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u91cd\u5efa%1$s\u4e2a\u5143\u6570\u636e\uff0c\u5206\u4e3a%2$s\u4e2a\u7ebf\u7a0b\u4efb\u52a1\uff0c\u6bcf\u4e2a\u7ebf\u7a0b\u4efb\u52a1\u6279\u91cf\u6267\u884c%3$s\u4e2a\u5143\u6570\u636e\uff0c\u7ebf\u7a0b\u6c60\u6838\u5fc3\u7ebf\u7a0b\u6570\u4e3a\uff1a%4$s\uff0c\u670d\u52a1\u5668cpu\u6838\u6570\uff1a%5$s\uff0c\u9884\u8ba1\u7406\u60f3\u6267\u884c\u8017\u65f6\u5e94\u4e3a\uff1a %6$s / %7$s = %8$s ms\uff0c\u5e73\u5747\u8017\u65f6\uff1a%9$s ms", (String)"DeployPackageServiceImpl_20", (String)"bos-mservice-form", (Object[])new Object[0]), metaCount, metaTasks, DePaUtil.BATCH_SIZE, DePaUtil.MAX_Threads, cpuCore, metaCostTotal, thread, metaIdealCost, metaAverageCost);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, metaCostDetailMsg);
        String waitCostMsg = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u53ca\u5143\u6570\u636e\u7ebf\u7a0b\u7b49\u5f85\u6267\u884c\u673a\u4f1a\u603b\u8017\u65f6\uff1a%1$s ms", (String)"DeployPackageServiceImpl_21", (String)"bos-mservice-form", (Object[])new Object[0]), waitCostTotal) + "\n" + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7ebf\u7a0b\u7b49\u5f85\u8017\u65f6\uff1a%1$s ms", (String)"DeployPackageServiceImpl_23", (String)"bos-mservice-form", (Object[])new Object[0]), appWaitCostTotal) + "\n" + String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7ebf\u7a0b\u4efb\u52a1\u6570\u4e3a\uff1a%1$s", (String)"DeployPackageServiceImpl_24", (String)"bos-mservice-form", (Object[])new Object[0]), appTasks) + "\uff0c" + String.format(ResManager.loadKDString((String)"\u5e73\u5747\u7b49\u5f85\u8017\u65f6\uff1a%1$s ms\uff1b", (String)"DeployPackageServiceImpl_27", (String)"bos-mservice-form", (Object[])new Object[0]), appAverageWaitCost) + "\n\n" + String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7ebf\u7a0b\u7b49\u5f85\u8017\u65f6\uff1a%1$s ms", (String)"DeployPackageServiceImpl_25", (String)"bos-mservice-form", (Object[])new Object[0]), metaWaitCostTotal) + "\n" + String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7ebf\u7a0b\u4efb\u52a1\u6570\u4e3a\uff1a%1$s", (String)"DeployPackageServiceImpl_26", (String)"bos-mservice-form", (Object[])new Object[0]), metaTasks) + "\uff0c" + String.format(ResManager.loadKDString((String)"\u5e73\u5747\u7b49\u5f85\u8017\u65f6\uff1a%1$s ms\uff1b", (String)"DeployPackageServiceImpl_27", (String)"bos-mservice-form", (Object[])new Object[0]), metaAverageWaitCost);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, waitCostMsg);
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u6267\u884c\u8017\u65f6TOP:%s", (String)"DeployPackageServiceImpl_11", (String)"bos-mservice-form", (Object[])new Object[0]), JSON.toJSONString(appTopCost, (boolean)true)));
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u6267\u884c\u8017\u65f6TOP:%s", (String)"DeployPackageServiceImpl_12", (String)"bos-mservice-form", (Object[])new Object[0]), JSON.toJSONString(metaTopCost, (boolean)true)));
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7ebf\u7a0b\u7b49\u5f85\u8017\u65f6TOP:%s", (String)"DeployPackageServiceImpl_13", (String)"bos-mservice-form", (Object[])new Object[0]), JSON.toJSONString(appTopWaitCost, (boolean)true)));
        DeployLog.info(dpParam.getTaskId(), dpParam.getVer(), DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7ebf\u7a0b\u7b49\u5f85\u8017\u65f6TOP:%s", (String)"DeployPackageServiceImpl_14", (String)"bos-mservice-form", (Object[])new Object[0]), JSON.toJSONString(metaTopWaitCost, (boolean)true)));
    }

    private Map<String, Object> parseResult(Map<String, Object> result, List<BuildResult> subTopCost, List<BuildResult> subTopWaitCost) {
        long costTotal = 0L;
        long waitCostTotal = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        ArrayList<BuildResult> list = new ArrayList<BuildResult>(10);
        if (result.get(SUCCESS) != null) {
            list.addAll((List)result.get(SUCCESS));
        }
        if (result.get(FAILED) != null) {
            list.addAll((List)result.get(FAILED));
        }
        for (BuildResult r : list) {
            costTotal += r.getCost();
            waitCostTotal += r.getWaitCost();
        }
        list.sort(Comparator.comparing(BuildResult::getCost).reversed());
        int count = list.size();
        int topSize = DePaUtil.TOP_COST_SIZE > count ? count : DePaUtil.TOP_COST_SIZE;
        int waitTopSize = DePaUtil.TOP_WAIT_COST_SIZE > count ? count : DePaUtil.TOP_WAIT_COST_SIZE;
        subTopCost.addAll(list.subList(0, topSize));
        list.sort(Comparator.comparing(BuildResult::getWaitCost).reversed());
        subTopWaitCost.addAll(list.subList(0, waitTopSize));
        map.put("costTotal", costTotal);
        map.put("waitCostTotal", waitCostTotal);
        return map;
    }
}

