/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.after;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.after.BuildTaskGroup;
import kd.bos.service.upgrade.after.DePaUtil;
import kd.bos.service.upgrade.after.FormMetaBuilder;
import kd.bos.service.upgrade.entity.BuildResult;
import kd.bos.service.upgrade.entity.DeployState;
import kd.bos.threads.ThreadPools;

class RebuildService {
    protected static String SERVICE_NODE = "bos";
    protected static String METADATA_SERVICE = "MetadataService";
    private static ExecutorService es = ThreadPools.newExecutorService((String)"RebuildServiceDispatch-Thread", (int)DePaUtil.SERVICE_MAXNODES);
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";

    RebuildService() {
    }

    protected static Map<String, Object> dispatch(List<BuildTaskGroup> taskGroupList, DeployState deployState, BigDecimal factor) {
        if (taskGroupList == null || taskGroupList.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        ArrayList<FormMetaBuilder> formMetaBuilders = new ArrayList<FormMetaBuilder>(taskGroupList.size());
        for (BuildTaskGroup taskGroup : taskGroupList) {
            formMetaBuilders.add(new FormMetaBuilder(taskGroup, deployState, factor, RequestContext.get()));
        }
        HashMap<String, Object> metaResult = new HashMap<String, Object>(16);
        List successResult = Collections.synchronizedList(new ArrayList());
        List failedResult = Collections.synchronizedList(new ArrayList());
        AtomicInteger count = new AtomicInteger();
        AtomicLong getCost = new AtomicLong();
        AtomicLong rebuildCost = new AtomicLong();
        try {
            ArrayList results = new ArrayList(formMetaBuilders.size());
            results.addAll(es.invokeAll(formMetaBuilders));
            long buildTimeOut = DePaUtil.getBuildTimeOut();
            results.forEach(result -> {
                try {
                    Map brs = (Map)result.get(buildTimeOut, TimeUnit.MINUTES);
                    if (brs != null) {
                        if (brs.get("success") != null) {
                            successResult.addAll((List)brs.get("success"));
                        }
                        if (brs.get("failed") != null) {
                            failedResult.addAll((List)brs.get("failed"));
                        }
                        if (brs.get("count") != null) {
                            count.addAndGet((Integer)brs.get("count"));
                        }
                        if (brs.get("getCost") != null) {
                            getCost.addAndGet((Long)brs.get("getCost"));
                        }
                        if (brs.get("rebuildCost") != null) {
                            rebuildCost.addAndGet((Long)brs.get("rebuildCost"));
                        }
                    }
                }
                catch (Exception e) {
                    BuildResult rErr = new BuildResult();
                    rErr.setSuccess(false);
                    rErr.setMessage(String.format(ResManager.loadKDString((String)"\u91cd\u5efa\u670d\u52a1\u5206\u53d1\u5f02\u5e38\uff0cstack:%s", (String)"RebuildService_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), DePaUtil.getErrorMsg(e)));
                    failedResult.add(rErr);
                }
            });
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("bos_error", ""), "RebuildService dispatch error", (Throwable)e);
        }
        metaResult.put("success", successResult);
        metaResult.put("failed", failedResult);
        metaResult.put("count", count.intValue());
        metaResult.put("getCost", getCost.longValue());
        metaResult.put("rebuildCost", rebuildCost.longValue());
        return metaResult;
    }
}

