/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.deploy;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.upgrade.AbsractVersion;
import kd.bos.service.upgrade.deploy.DeplayDataModelBase;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.DeployCategory;
import kd.bos.service.upgrade.entity.DeployLog;
import kd.bos.service.upgrade.entity.DeployResult;
import kd.bos.service.upgrade.entity.DeployScriptInfo;

public class UndoDataModel
extends DeplayDataModelBase {
    @Override
    public boolean checkVer(AbsractVersion deployingVer) {
        return deployingVer.checkUndoVer() && deployingVer.checkRely();
    }

    @Override
    public void deployByAppId(DeployAppInfo appInfo, DeployResult result, int category) throws IOException {
        String fullVer = String.format("%s.%s", appInfo.getVer(), appInfo.getDeployInfo().getIteration());
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("begin undo app %s  ...", appInfo.getName()));
        ArrayList<String> existSqlFile = new ArrayList<String>(10);
        if (!appInfo.getScriptInfoList().isEmpty() || !appInfo.getXmlFileList().isEmpty()) {
            long start = new Date().getTime();
            existSqlFile.addAll(DeployScriptInfo.existScript(appInfo));
            long end = new Date().getTime();
            long cost = end - start;
            DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Dym, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528%1$s\u4e0b\u811a\u672c\u6267\u884c\u8bb0\u5f55\u8017\u65f6:%2$s.", (String)"UndoDataModel_0", (String)"bos-mservice-form", (Object[])new Object[0]), appInfo.getName(), cost));
        }
        this.undoScript(appInfo, category, result, existSqlFile);
        appInfo.setProgVal(new BigDecimal(1));
        DeployLog.info(appInfo.getPkgId(), fullVer, DeployCategory.Package, String.format("end undo app %s.", appInfo.getName()));
    }

    private void undoScript(DeployAppInfo appInfo, int category, DeployResult result, List<String> existSqlFile) throws IOException {
        this.deployScript(appInfo, category, result, existSqlFile);
    }
}

