/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.upgrade.entity.DeployInfo;
import kd.bos.service.upgrade.entity.DeployScriptInfo;
import kd.bos.util.StringUtils;

@DataEntityTypeAttribute(tableName="T_BAS_DEPLOYINFOENTRY", dbRouteKey="sys.meta")
public class DeployAppInfo {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    protected static String BAS_DEPLOYINFOENTRY = "T_BAS_DEPLOYINFOENTRY";
    private long id;
    private long pkgId;
    private String name;
    private String ver;
    private String configName;
    private String path;
    private String pkgName;
    private int result = 2;
    private List<DeployScriptInfo> scriptInfoList;
    private List<String> metaFileList;
    private List<String> xmlFileList;
    private DeployInfo deployInfo;
    private BigDecimal progVal = new BigDecimal(0);
    private BigDecimal metaProgVal = new BigDecimal(0);
    private BigDecimal xmlProgVal = new BigDecimal(0);

    public BigDecimal getProgVal() {
        if (this.progVal.compareTo(new BigDecimal(1)) == 0) {
            return this.progVal;
        }
        int i = 0;
        for (DeployScriptInfo scriptInfo : this.scriptInfoList) {
            if (scriptInfo.getProgVal().compareTo(new BigDecimal(1)) != 0) continue;
            ++i;
        }
        if (this.scriptInfoList.isEmpty() && this.metaFileList.isEmpty()) {
            return new BigDecimal(1);
        }
        BigDecimal scriptRate = new BigDecimal(0);
        if (!this.scriptInfoList.isEmpty()) {
            BigDecimal tmp = new BigDecimal(i).divide(new BigDecimal(this.scriptInfoList.size()), 10, RoundingMode.HALF_EVEN);
            scriptRate = tmp.divide(new BigDecimal(this.scriptInfoList.size() + this.metaFileList.size() + this.xmlFileList.size()), 10, RoundingMode.HALF_EVEN);
        }
        BigDecimal metaRate = new BigDecimal(0);
        if (!this.metaFileList.isEmpty()) {
            metaRate = this.metaProgVal.divide(new BigDecimal(this.scriptInfoList.size() + this.metaFileList.size() + this.xmlFileList.size()), 10, RoundingMode.HALF_EVEN);
        }
        BigDecimal xmlRate = new BigDecimal(0);
        if (!this.xmlFileList.isEmpty()) {
            xmlRate = this.xmlProgVal.divide(new BigDecimal(this.scriptInfoList.size() + this.metaFileList.size() + this.xmlFileList.size()), 10, RoundingMode.HALF_EVEN);
        }
        this.progVal = scriptRate.add(metaRate).add(xmlRate);
        return this.progVal;
    }

    public void setProgVal(BigDecimal progVal) {
        this.progVal = progVal;
    }

    public void setMetaProgVal(BigDecimal progVal) {
        this.metaProgVal = progVal;
    }

    public void setXmlProgVal(BigDecimal progVal) {
        this.xmlProgVal = progVal;
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FENTRYID", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FID", dbType=-5)
    public long getPkgId() {
        return this.pkgId;
    }

    public void setPkgId(long pkgId) {
        this.pkgId = pkgId;
    }

    @SimplePropertyAttribute(alias="FAPPID", dbType=12)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVer() {
        return this.ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getConfigName() {
        if (StringUtils.isBlank((String)this.configName)) {
            this.configName = this.name;
        }
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @SimplePropertyAttribute(alias="FPKNAME", dbType=12)
    public String getPkgName() {
        return this.pkgName;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public List<DeployScriptInfo> getScriptInfoList() {
        return this.scriptInfoList;
    }

    public void addScriptInfo(DeployScriptInfo scriptInfoList) {
        this.scriptInfoList.add(scriptInfoList);
    }

    public List<String> getMetaFileList() {
        return this.metaFileList;
    }

    public List<String> getXmlFileList() {
        return this.xmlFileList;
    }

    public DeployInfo getDeployInfo() {
        return this.deployInfo;
    }

    public void setDeployInfo(DeployInfo deployInfo) {
        this.deployInfo = deployInfo;
    }

    public DeployAppInfo(String name, String path) {
        this.name = name;
        this.path = path;
        this.scriptInfoList = new ArrayList<DeployScriptInfo>();
        this.metaFileList = new ArrayList<String>();
        this.xmlFileList = new ArrayList<String>();
    }

    public DeployAppInfo(String name, String path, String configName) {
        this(name, path);
        this.configName = configName;
    }

    public void addMetaFileList(String metaFile) {
        this.metaFileList.add(metaFile);
    }

    public void addXmlFileList(String xmlFile) {
        this.xmlFileList.add(xmlFile);
    }

    public String getCloudNumber() {
        String getCloudSql = "select a.fnumber from t_meta_bizcloud a inner join t_meta_bizapp b on a.fid = b.fbizcloudid where b.fnumber = ?";
        Object[] getCloudParams = new Object[]{this.getName()};
        String cloudNumber = (String)DB.query((DBRoute)DBRoute.meta, (String)getCloudSql, (Object[])getCloudParams, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
        if (StringUtils.isBlank((String)cloudNumber)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u5e94\u7528%s\u5bf9\u5e94\u7684\u4e91\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u7f16\u7801\u4e3a\u7a7a(t_meta_bizcloud)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeployAppInfo_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), this.getName())});
        }
        return cloudNumber;
    }

    public static boolean checkCreateTable() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)BAS_DEPLOYINFOENTRY)) {
            DeployAppInfo.createTable();
            return true;
        }
        try (TXHandle h = TX.notSupported();){
            String alterTablepkname = " IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_BAS_DEPLOYINFOENTRY' AND KSQL_COL_NAME ='FPKNAME')  ALTER TABLE T_BAS_DEPLOYINFOENTRY ADD (FPKNAME VARCHAR(80) DEFAULT ' ' NOT NULL );";
            DB.execute((DBRoute)DBRoute.meta, (String)alterTablepkname, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u4fee\u6539 T_BAS_DEPLOYINFOENTRY \u5931\u8d25", (String)"DeployAppInfo_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
        }
        return false;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table " + BAS_DEPLOYINFOENTRY + " (FENTRYID bigint not null primary key, FID                  bigint               not null, FAPPID               varchar(36)          not null, FPKNAME              varchar(80)          not null default ' ' ) ";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5efa\u8868 T_BAS_DEPLOYINFOENTRY \u5931\u8d25", (String)"DeployAppInfo_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])});
        }
    }
}

