/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.upgrade.entity;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.entity.DeployAppInfo;
import kd.bos.service.upgrade.entity.SqlScript;

@DataEntityTypeAttribute(tableName="T_BAS_DEPLOYINFODETAIL", dbRouteKey="sys.meta")
public class DeployScriptInfo {
    private static final long serialVersionUID = 468123344725928657L;
    private static final Log log = LogFactory.getLog(DeployScriptInfo.class);
    private static final String T_BAS_DEPLOYINFODETAIL = "T_BAS_DEPLOYINFODETAIL";
    private long id;
    private long entryId;
    private String ver;
    private String fileName;
    private Date execTime;
    private String appId;
    private SqlScript sqlScript;
    private boolean isBigTable;
    private boolean isBatchSql;
    private BigDecimal progVal = new BigDecimal(0);

    public BigDecimal getProgVal() {
        return this.progVal;
    }

    public void finish() {
        this.progVal = new BigDecimal(1);
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FDetailID", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FENTRYID", dbType=-5)
    public long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public String getVer() {
        return this.ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    @SimplePropertyAttribute(alias="FFILENAME", dbType=12)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @SimplePropertyAttribute(alias="FEXECTIME", dbType=91)
    public Date getExecTime() {
        return this.execTime;
    }

    public void setExecTime(Date execTime) {
        this.execTime = execTime;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public SqlScript getSqlScript() {
        return this.sqlScript;
    }

    public void setSqlScript(SqlScript sqlScript) {
        this.sqlScript = sqlScript;
    }

    public boolean isBigTable() {
        return this.isBigTable;
    }

    public void setBigTable(boolean isBigTable) {
        this.isBigTable = isBigTable;
    }

    public boolean isBatchSql() {
        return this.isBatchSql;
    }

    public void setBatchSql(boolean batchSql) {
        this.isBatchSql = batchSql;
    }

    public static List<String> existScript(DeployAppInfo deployApp) {
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("FAPPID", 12, (Object)deployApp.getName())};
        String sql = "select a.FFILENAME from t_bas_deployinfodetail a inner join T_BAS_DEPLOYINFOENTRY b on a.FENTRYID = b.FENTRYID inner join T_BAS_DEPLOYINFO c on b.FID = c.FID where b.FAPPID = ? ";
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ret = new ArrayList<String>(10);
                while (rs.next()) {
                    ret.add(rs.getString(1));
                }
                return ret;
            }
        });
    }

    public static boolean checkCreateTable() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_DEPLOYINFODETAIL)) {
            DeployScriptInfo.createTable();
            return true;
        }
        return false;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table T_BAS_DEPLOYINFODETAIL (FDetailID bigint not null primary key, FENTRYID                  bigint               not null, FEXECTIME            datetime             not null, FFILENAME            varchar(500)         not null ) ";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5efa\u8868 T_BAS_DEPLOYINFODETAIL \u5931\u8d25", (String)"DeployScriptInfo_0", (String)"bos-mservice-form", (Object[])new Object[0])});
        }
    }

    public static boolean checkTableCount() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_DEPLOYINFODETAIL)) {
            log.warn("\u4e0d\u5b58\u5728T_BAS_DEPLOYINFODETAIL\u8868\uff0c\u9000\u51fa\u68c0\u67e5...");
            return false;
        }
        String sqlCount = "select count(a.FDetailID) from t_bas_deployinfodetail a";
        List ret = (List)DB.query((DBRoute)DBRoute.meta, (String)sqlCount, (ResultSetHandler)new ResultSetHandler<List<Integer>>(){

            public List<Integer> handle(ResultSet rs) throws Exception {
                ArrayList<Integer> ret = new ArrayList<Integer>(10);
                while (rs.next()) {
                    ret.add(rs.getInt(1));
                }
                return ret;
            }
        });
        return !ret.isEmpty() && (Integer)ret.get(0) == 0;
    }
}

