/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.extreport;

import com.caucho.hessian.io.Hessian2Output;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.QingReportLicenseException;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.model.server.ServerRemoteCallMessage;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.framework.web.AbstractQingAction;
import com.kingdee.bos.qing.common.framework.web.ServerFileAccesser;
import com.kingdee.bos.qing.common.framework.web.dependency.QingWebRequestDispatcher;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.mservice.qingshared.common.login.LoginUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.web.qing.QingSharedAction;
import kd.bos.web.qing.impl.QingMServiceDispatcher;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class ExtReportAction
extends QingSharedAction {
    private static String appID = "qing_rpt";
    private static final String QING_RPT_SNAPCENTER = "qing_rpt_snapcenter";
    private static final String EDIT_PUBLIC_SNAP_GROUP_PERMITEMID = "2JN0/YXOJ8+C";
    private static final String QING_RPT_HANDOVER = "qing_rpt_handover";
    private static final String QUERY_HANDOVER_PERMITEMID = "47150e89000000ac";
    private static final String QUERY_PUBLIC_SNAP_GROUP_PERMITEMID = "47150e89000000ac";

    protected String getAppID() {
        return appID;
    }

    public void doExtReportManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            String title = Messages.getMLS((QingContext)qingIntegratedContext, (String)"qingRptPageTitle", (String)"\u8f7b\u62a5\u8868", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-manage.html");
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDataSetDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingContext = new QingIntegratedContext();
            LoginUtil.checkReplicatedLogin((QingContext)qingContext);
            String dataSetType = request.getParameter("dataSetType");
            String dataSetId = request.getParameter("dataSetId");
            String dataSetName = request.getParameter("dataSetName");
            String title = Messages.getMLS((QingContext)qingContext, (String)"datasetDesignerPageTitle", (String)"\u6570\u636e\u96c6\u8bbe\u8ba1\u5668-", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS) + dataSetName;
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "dataset-designer.html");
            safetyURL.appendParamToUrl("dataSetType", dataSetType);
            safetyURL.appendParamToUrl("dataSetId", dataSetId);
            safetyURL.appendParamToUrl("dataSetName", dataSetName);
            safetyURL.appendParamToUrl("isPreset", request.getParameter("isPreset"));
            safetyURL.appendParamToUrl("isPresetGroupPerm", request.getParameter("isPresetGroupPerm"));
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doPreviewExtReportEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String res;
            Map resultMap;
            Object errCodeObj;
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingContext = new QingIntegratedContext();
            LoginUtil.checkReplicatedLogin((QingContext)qingContext);
            String extReportName = request.getParameter("extReportName");
            String extReportId = request.getParameter("extReportId");
            String paramCacheId = request.getParameter("paramCacheId");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("extReportId", extReportId);
            parameters.put("paramCacheId", paramCacheId);
            parameters.put("checkPermission", "true");
            byte[] data = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)qingContext, (String)appID, (String)"/qing_rpt/runtime.do", (String)"initExtReport", (Object[])new Object[]{parameters});
            if (data != null && data.length > 0 && (errCodeObj = (resultMap = (Map)JsonUtil.decodeFromString((String)(res = new String(data, "UTF-8")), Map.class)).get("errorCode")) instanceof Double) {
                String errorCode = String.valueOf(((Double)errCodeObj).intValue());
                this.handlerError(request, response, errorCode);
                return;
            }
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, extReportName, "extreport-runtime.html");
            safetyURL.appendParamToUrl("extReportId", extReportId);
            safetyURL.appendParamToUrl("paramCacheId", paramCacheId);
            safetyURL.appendParamToUrl("isPreview", String.valueOf(true));
            safetyURL.appendParamToUrl("isPreset", request.getParameter("isPreset") == null ? "false" : request.getParameter("isPreset"));
            String isGuiPreview = request.getParameter("isGuiPreview");
            if (Boolean.parseBoolean(isGuiPreview)) {
                String dataName = request.getParameter("dataName");
                safetyURL.appendParamToUrl("isGuiPreview", isGuiPreview);
                safetyURL.appendParamToUrl("dataName", dataName);
                safetyURL.appendParamToUrl("extReportName", extReportName);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doHyperLinkExtReportEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String res;
            Map resultMap;
            Object errCodeObj;
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingContext = new QingIntegratedContext();
            LoginUtil.checkReplicatedLogin((QingContext)qingContext);
            String extReportName = request.getParameter("extReportName");
            String extReportId = request.getParameter("extReportId");
            String paramCacheId = request.getParameter("paramCacheId");
            String isPreview = request.getParameter("isPreview");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("extReportId", extReportId);
            parameters.put("isHyperlink", "true");
            parameters.put("paramCacheId", paramCacheId);
            parameters.put("checkPermission", "false");
            byte[] data = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)qingContext, (String)appID, (String)"/qing_rpt/runtime.do", (String)"initExtReport", (Object[])new Object[]{parameters});
            if (data != null && data.length > 0 && (errCodeObj = (resultMap = (Map)JsonUtil.decodeFromString((String)(res = new String(data, "UTF-8")), Map.class)).get("errorCode")) instanceof Double) {
                String errorCode = String.valueOf(((Double)errCodeObj).intValue());
                this.handlerError(request, response, errorCode);
                return;
            }
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, extReportName, "extreport-runtime.html");
            if (Boolean.parseBoolean(isPreview)) {
                safetyURL.appendParamToUrl("isPreview", isPreview);
            }
            safetyURL.appendParamToUrl("isHyperlink", "true");
            safetyURL.appendParamToUrl("extReportId", extReportId);
            safetyURL.appendParamToUrl("paramCacheId", paramCacheId);
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doExtReportHandOverEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            this.checkQingReportHandOverPermission();
            String title = Messages.getMLS((QingContext)qingIntegratedContext, (String)"qingRptHandOverTitle", (String)"\u8f7b\u62a5\u8868\u7ba1\u7406-\u79fb\u4ea4", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-hand-over.html");
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doPreviewDataSetEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingContext = new QingIntegratedContext();
            LoginUtil.checkReplicatedLogin((QingContext)qingContext);
            String dataSetName = request.getParameter("dataSetName");
            String dataSetId = request.getParameter("dataSetId");
            String cacheId = request.getParameter("cacheId");
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, dataSetName, "dataset-preview.html");
            safetyURL.appendParamToUrl("cacheId", cacheId);
            safetyURL.appendParamToUrl("dataSetId", dataSetId);
            safetyURL.appendParamToUrl("dataSetName", dataSetName);
            safetyURL.appendParamToUrl("isPreset", request.getParameter("isPreset") == null ? "false" : request.getParameter("isPreset"));
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doPreviewSnapEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            String extReportId = request.getParameter("extReportId");
            String snapId = request.getParameter("snapId");
            String snapName = request.getParameter("snapName");
            String snapGroupType = request.getParameter("snapGroupType");
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, snapName, "extreport-runtime.html");
            safetyURL.appendParamToUrl("extReportId", extReportId);
            safetyURL.appendParamToUrl("snapId", snapId);
            safetyURL.appendParamToUrl("snapName", snapName);
            safetyURL.appendParamToUrl("snapGroupType", snapGroupType);
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void upload(HttpServletRequest request, HttpServletResponse response) throws IOException, FileUploadException {
        try {
            QingIntegratedContext qingContext = new QingIntegratedContext();
            List fileItems = ExtReportAction.getFileItem((HttpServletRequest)request);
            if (!fileItems.isEmpty()) {
                FileItem fileItem = (FileItem)fileItems.get(0);
                QingSharedAction.protectedUpload((QingContext)qingContext, (String)appID, (FileItem)fileItem, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            ExtReportAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
        catch (FileUploadException e) {
            ExtReportAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
    }

    public void doHession(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getMethod().equals("POST")) {
            this.handlerError(request, response, "");
            return;
        }
        QingIntegratedContext qingContext = new QingIntegratedContext();
        String objectId = request.getParameter("id");
        String clientID = request.getParameter("clientID");
        String callID = request.getParameter("callID");
        String isSync = request.getParameter("isSync");
        response.setContentType("x-application/hessian");
        ServletInputStream in = request.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy((InputStream)in, (OutputStream)byteArrayOutputStream);
        byte[] requestBytes = byteArrayOutputStream.toByteArray();
        try {
            ExtReportAction.checkQingReportLicense();
            byte[] result = null;
            if (Boolean.parseBoolean(isSync)) {
                result = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)qingContext, (String)appID, (String)"Hessian", (String)"invoke", (Object[])new Object[]{objectId, requestBytes});
                AbstractResponseWrap data = AbstractResponseWrap.decodeFromBytes((byte[])result);
                this.handleHessianResult(response, (QingContext)qingContext, data);
            } else {
                result = QingWebRequestDispatcher.asynDispatcher((QingContext)qingContext, (String)appID, (String)"Hessian", (String)clientID, (String)callID, (String)"invoke", (Object[])new Object[]{objectId, requestBytes});
                if (result != null) {
                    ServerRemoteCallMessage serverMessage = new ServerRemoteCallMessage();
                    serverMessage.fromJson(new String(result, "UTF-8"));
                    this.handleHessianResult(response, (QingContext)qingContext, serverMessage.getData());
                }
            }
        }
        catch (AbstractQingException e) {
            this.handleHessianException(response, (Exception)((Object)e));
        }
    }

    public void doHessionPolling(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getMethod().equals("POST")) {
            this.handlerError(request, response, "");
            return;
        }
        QingIntegratedContext qingContext = new QingIntegratedContext();
        String clientID = request.getParameter("clientID");
        String callID = request.getParameter("callID");
        response.setContentType("x-application/hessian");
        ServerRemoteCallMessage serverMessageWraper = ClientCallManager.getCallResult((String)clientID, (String)callID);
        AbstractResponseWrap data = null;
        if (serverMessageWraper != null) {
            data = serverMessageWraper.getData();
        } else if (!ClientCallManager.isCallWorkingInServer((ServerRequestInvokeContext.CheckerName)ServerRequestInvokeContext.CheckerName.Web, (String)clientID, (String)callID, (boolean)true)) {
            data = new ResponseErrorWrap(0, "web server stop call");
        } else if (!ClientCallManager.isCallWorkingInServer((ServerRequestInvokeContext.CheckerName)ServerRequestInvokeContext.CheckerName.RPCServer, (String)clientID, (String)callID, (boolean)true)) {
            data = new ResponseErrorWrap(0, "rpc server stop call");
        }
        this.handleHessianResult(response, (QingContext)qingContext, data);
    }

    public void doSnapCenterEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            ExtReportAction.checkQingReportLicense();
            this.checkQingReportSnapCenterModule();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            String title = Messages.getMLS((QingContext)qingIntegratedContext, (String)"snapCenterPageTitle", (String)"\u5feb\u7167\u4e2d\u5fc3", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-snapcenter.html");
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doScheduleCenterEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String scheduleId = request.getParameter("sourceId");
            ExtReportAction.checkQingReportLicense();
            this.checkQingReportSnapCenterModule();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            String title = Messages.getMLS((QingContext)qingIntegratedContext, (String)"scheduleCenterPageTitle", (String)"\u8c03\u5ea6\u7ba1\u7406", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-snap-schedule.html");
            safetyURL.appendParamToUrl("scheduleId", scheduleId);
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doCreateStatisticEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String scheduleId = request.getParameter("sourceId");
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            String title = Messages.getMLS((String)"createStatisticPageTitle", (String)"\u7528\u6237\u521b\u5efa\u5185\u5bb9\u7edf\u8ba1", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-create-statistic.html");
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doAccessStatisticEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String scheduleId = request.getParameter("sourceId");
            ExtReportAction.checkQingReportLicense();
            QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
            AppInfo app = AppMetadataCache.getAppInfo((String)appID);
            if (app == null || !PermissionServiceHelper.checkUserBizApp((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId()).booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
                return;
            }
            LoginUtil.checkReplicatedLogin((QingContext)qingIntegratedContext);
            String title = Messages.getMLS((String)"accessStatisticPageTitle", (String)"\u53d1\u5e03\u5185\u5bb9\u8bbf\u95ee\u7edf\u8ba1", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, "extreport-access-statistic.html");
            safetyURL.appendParamToUrl("access_token", RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    private void handleHessianException(HttpServletResponse response, Exception e) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        LogUtil.error((String)e.getMessage(), (Throwable)e);
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
        if (e instanceof QingReportLicenseException) {
            hessian2Output.writeFault(String.valueOf(((QingReportLicenseException)e).getErrorCode()), e.getMessage(), null);
        } else {
            hessian2Output.writeFault(e.getMessage(), e.getMessage(), null);
        }
        hessian2Output.close();
    }

    private void handleHessianResult(HttpServletResponse response, QingContext qingContext, Object data) throws IOException {
        if (data != null) {
            if (data instanceof ResponseErrorWrap) {
                ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)data;
                String errorCode = responseErrorWrap.getErrorCode() + "";
                ServletOutputStream out = response.getOutputStream();
                String errorMessage = responseErrorWrap.getErrorMessage();
                Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
                hessian2Output.writeFault(errorCode, errorMessage, null);
                hessian2Output.close();
            } else if (data instanceof ResponseSuccessWrap) {
                ResponseSuccessWrap successWrap = (ResponseSuccessWrap)data;
                Object dataObj = successWrap.getData();
                ServerFileAccesser.loadFile((QingContext)qingContext, (String)appID, (String)dataObj.toString(), (AbstractQingFileType)QingTempFileType.EXPORT, (OutputStream)response.getOutputStream());
            }
        }
    }

    private void checkQingReportSnapCenterModule() throws AbstractQingException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)"qing_rpt", (String)"QingLicenseService", (String)"checkQingReportSnapCenterModule", (Object[])new Object[0]);
        switch (checkResult) {
            case 0: {
                AppInfo app = AppMetadataCache.getAppInfo((String)appID);
                QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId(), (String)QING_RPT_SNAPCENTER, (String)"47150e89000000ac");
                if (!hasPermission) {
                    throw new QingReportLicenseException(Messages.getMLS((QingContext)qingIntegratedContext, (String)"noSnapCenter", (String)"\u6ca1\u6709\u5feb\u7167\u4e2d\u5fc3\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650", (Messages.ProjectName)Messages.ProjectName.EXTREPORT_WEBACTIONS));
                }
                return;
            }
            case 3010007: {
                throw QingReportLicenseException.NoSnapCenterModuleException;
            }
        }
        throw new QingReportLicenseException("check Qing Report SnapCenter License failed");
    }

    private void checkQingReportHandOverPermission() throws QingReportLicenseException {
        AppInfo app = AppMetadataCache.getAppInfo((String)appID);
        QingIntegratedContext qingIntegratedContext = new QingIntegratedContext();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)Long.valueOf(qingIntegratedContext.getUserId()), (String)app.getId(), (String)QING_RPT_HANDOVER, (String)"47150e89000000ac");
        if (!hasPermission) {
            throw new QingReportLicenseException(Messages.getMLS((QingContext)qingIntegratedContext, (String)"noHandOverPerm", (String)"\u6ca1\u6709\u79fb\u4ea4\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS));
        }
    }
}

