/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.launcher.action;

import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.url.UrlService;
import kd.bos.web.qing.QingSharedAction;

public class LauncherAction
extends QingSharedAction {
    private static final Charset UTF_8 = Charset.forName("utf-8");
    private static final String JAR_FILE_TEMPLATE = "\t\t<jar href=\"%s\" main=\"%s\"/>\r\n";
    private static final String JAR_FILE_PATH = "lib/%s?version=%s";
    private static final String ENV_PROP_TEMPLATE = "\t\t<property name=\"%s\" value=\"%s\"/>\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getJNLPFileData(HttpServletRequest request) throws IOException {
        String contextUrl = UrlService.getDomainContextUrl();
        String cosmiRootURL = contextUrl;
        if (!cosmiRootURL.endsWith("/")) {
            cosmiRootURL = cosmiRootURL + "/";
        }
        Properties properties = new Properties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            inputStream = LauncherAction.class.getResourceAsStream("JNLPTemplate.xml");
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            inputStream = LauncherAction.class.getResourceAsStream("JNLPFile.properties");
            properties.load(inputStream);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream, outputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream, outputStream});
        Set<String> keys = properties.stringPropertyNames();
        StringBuilder jarFilesString = new StringBuilder(13500);
        String webVersion = null;
        for (String key : keys) {
            String mainJar = "false";
            if ("qing-rpt-launcher-1.0.jar".equals(key)) {
                mainJar = "true";
            }
            if ("version".equals(key)) {
                webVersion = properties.getProperty(key);
                continue;
            }
            String jarFilePath = String.format(JAR_FILE_PATH, key, properties.getProperty(key));
            jarFilesString.append(String.format(JAR_FILE_TEMPLATE, jarFilePath, mainJar));
        }
        if (webVersion != null) {
            jarFilesString.append(String.format(ENV_PROP_TEMPLATE, "jnlp.webVersion", webVersion));
        }
        jarFilesString.append(String.format(ENV_PROP_TEMPLATE, "jnlp.serverUrl", contextUrl));
        String jnlp = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        String userToken = request.getParameter("token");
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            jarFilesString.append(String.format(ENV_PROP_TEMPLATE, "jnlp.token", userToken));
            jnlp = jnlp.replaceAll("\\{\\$userToken\\}", userToken);
        }
        jnlp = jnlp.replaceAll("\\{\\$cosmiRootURL\\}", cosmiRootURL);
        jnlp = jnlp.replaceAll("\\{\\$JNLP_LIB_LIST\\}", jarFilesString.toString());
        return jnlp.getBytes(UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJNLP(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Pargma", "no-cache");
        response.setHeader("Expires", "0");
        response.setContentType("application/x-java-jnlp-file");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=Launcher.jnlp");
        response.setDateHeader("Last-Modified", System.currentTimeMillis());
        byte[] data = LauncherAction.getJNLPFileData(request);
        response.addHeader("Content-Length", "" + data.length);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ServletOutputStream responseOutputStream = response.getOutputStream();
        try {
            IOUtil.copy((InputStream)inputStream, (OutputStream)responseOutputStream);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
    }

    public void doVersionCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        Properties properties = new Properties();
        InputStream inputStream = LauncherAction.class.getResourceAsStream("JNLPFile.properties");
        properties.load(inputStream);
        HashMap<String, String> jnlpFileProps = new HashMap<String, String>(1);
        jnlpFileProps.put("jnlp.webVersion", properties.getProperty("version"));
        ServletOutputStream responseOutputStream = response.getOutputStream();
        ByteArrayInputStream propsStream = new ByteArrayInputStream(JsonUtil.encodeToString(jnlpFileProps).getBytes());
        IOUtil.copy((InputStream)propsStream, (OutputStream)responseOutputStream);
    }
}

