/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.qing;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.exception.QingLicenseException;
import com.kingdee.bos.qing.common.framework.web.AbstractQingAction;
import com.kingdee.bos.qing.common.framework.web.dependency.QingWebRequestDispatcher;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SphixUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.URLUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.mservice.qingshared.common.login.LoginUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.web.qing.QingSharedAction;
import kd.bos.web.qing.exception.FileUploadFailException;
import kd.bos.web.qing.exception.RemoteCallFailException;
import kd.bos.web.qing.i18n.Messages;
import kd.bos.web.qing.impl.QingMServiceDispatcher;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class QingAction
extends QingSharedAction {
    private static final String DEFAULT_APP_ID = "qing";
    private static final String APP_ID = "appID";
    private static final String APP_TYPE = "appType";
    private static final String QING_WEBACTIONS = "qing-webactions";
    private static final String DEV_CTRL = "devctrl";
    private static final String CTR_KEY = "ctrKey";
    private static final String MOBILE_CTRL = "mobileCtrl";
    private static final String QING_ANALYSIS_CONTROL = "qingAnalysisControl";
    private static final String QING_VIEW_VALUE = "qingView";
    private static final String QING_VIEW_ID = "qingAnalysisView";
    private static final String PAGE_ID = "pageId";
    private static final String FROM_PAGE_CLIENT_ID = "fromPageClientId";
    private static final String CURRENT_PAGE_CLIENT_ID = "currentPageClientId";
    private static final String CHECK_THEME_PERMISSION = "checkThemePermission";
    private static final String IS_ANONYMOUS_VIEW = "isAnonymousView";
    private static final String BIZ_TAG = "bizTag";
    private static final String THEME_NAME = "themeName";
    private static final String CARD_SCENE = "cardScene";
    private static final String SCHEMA_ADDITIONAL_TAG = "schemaAdditionalTag";
    private static final String THEME_Id = "themeId";
    private static final String THEME_ID = "themeID";
    private static final String HAS_MAIN_VIEW = "hasMainView";
    private static final String QING_HOME_PAGE_ID = "qingHomePage";
    private static final String SUBSCRIBE_KEY = "subscribeKey";
    private static final String SINGLE_SELECT = "singleSelect";
    private static final String SUPPORT_DSB = "supportDsb";
    private static final String FROM_PAGE_ID = "fromPageId";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFERENCE = "ref";
    private static final String REFERENCE_UUID = "refUid";
    private static final String DSB_PUBLISH_ID = "dsbPublishId";
    private static final String REF_PK = "refPK";
    private static final String SCHEMA_TAG = "schemaTag";
    private static final String CHECK_MAP_PERMISSION = "checkMapPermission";
    private static final String MAP_HOME_PAGE_ID = "mapLibHomePage";
    private static final String MAP_ID = "mapId";
    private static final String IS_USER = "isUser";
    private static final String FILE_NAME = "fileName";
    private static final String DO_IMPORT = "doImport";
    private static final String IMPORT_QHF_ID = "importQHF";
    private static final String SCENE_TYPE = "sceneType";
    private static final String DASHBOARD_UNIQUE_ID = "dashboardUniqueId";
    private static final String ERROR_PAGE_ID = "errorPage";
    private static final String DOC_ID_TYPE = "docIdType";
    private static final String DOC_ID = "docType";
    private static final String PRODUCT_ID = "productId";
    private static final String MANAGE_TYPE = "manageType";
    private static final String PUBLISH_TARGET_TYPE = "publishTargetType";
    private static final String CARD_ID = "cardId";
    private static final String PUBLISH_NAME = "publishName";
    private static final String PUBLISH_ID = "publishId";
    private static final String CARD_NAME = "cardName";
    private static final String PUBLISH_SOURCE_TYPE = "publishSourceType";
    private static final String QING_ANALYSIS_CENTER_ID = "qingAnalysisCenter";
    private static final String EMAIL_TIMED_PUSH_SCENE = "timedPush";
    private static final String QING_NOCODE_CARD_ID = "qingNocodeCard";
    private static final String QING_CARDS_SETTING_ID = "qingAnalysisCardConfiguration";
    private static final String QING_ANALYSIS_CARDS_ID = "qingAnalysisCard";
    private static final String QING_ANALYSIS_ID = "analysisId";
    private static final String REFRESH = "refresh";
    private static final String PORTRAIT = "portrait";
    private static final String PUSH_TARGET = "pushTarget";
    private static final String CONFIG_ID = "configId";
    private static final String LONGER = "longer";
    private static final String SQUARE = "square";
    private static final String DASHBOARD = "dashboard";
    private static final String DASHBOARD_ID = "dsbId";
    private static final String SUBJECT = "subject";
    private static final String BILL = "bill";
    private static final String BILL_FORM_ID = "billFormId";
    private static final String EXTREPORT = "extreport";
    private static final String QING_REPORT_APPID = "qing_rpt";
    private static final String QING_MODELER_APPID = "qing_modeler";
    private static final String EXTREPORT_ID = "extReportId";
    private static final String EXTREPORT_PAGE_ID = "extPageId";
    private static final String EXTREPORT_NAME = "extReportName";
    private static final String IS_QINGREPORT_IN_DSB = "isQingreportInDsb";
    private static final String EXHIBITION_SCENE = "exhibitionScene";
    private static final String HYPER_LINK_LEVEL = "hyperlinkLevel";
    private static final String HAS_SCHEME_EDIT_PERM = "hasSchemeEditPerm";
    private static final String EXTREPORT_WIDGET_ID = "extreportWidgetId";
    private static final String IS_FULL_SCREEN = "isFullScreen";
    private static final String QING_LIGHTAPP_HTML = "qing-lightapp.html";
    private static final String LIGHTAPP_RESOURCE_ID = "lightapp";
    private static final String LAPP_ID = "lappId";
    private static final String LAPP_USER_TYPE = "lappUserType";
    private static final String QING_LAPP_CARDS_ID = "qingLightAPPCard";
    private static final String HAVE_TO_CARRY_DATA = "haveToCarryData";
    private static final String IS_PRESET = "isPreset";
    private static final String FORM_TYPE = "formType";
    private static final String SCHEMA_TYPE = "schemaType";
    private static final String SCHEMA_ID = "schemaId";
    private static final String IS_FILE_UPGRADING = "isFileUpgrading";
    private static final String UPGRADING = "upgrading";
    private static final String SHARING_TARGET_ID = "sharingTargetId";
    private static final String LAPP_HOME_PAGE_URL = "lappHomePageUrl";
    private static final String DINGDING_OFFLINE = "dingdingoffline";
    private static final String DINGDING = "dd";
    private static final String DINGDING_ORIENTATION = "dd_orientation";
    private static final String YZJ_PORTAL = "yzjPortal";
    private static final String IS_MOBILE = "isMobile";
    private static final String LAPP = "lapp";
    private static final String EMAIL = "email";
    private static final String LAPP_TIMED_PUSH = "lappTimedPush";
    private static final String PUSH_TARGET_TYPE = "pushTargetType";
    private static final String EMAIL_TIMED_PUSH = "emailTimedPush";
    private static final String DING_DING_APP_TYPE = "apptype";
    private static final String QING_APP_TYPE = "qingAppType";
    private static final String QING_LIGHT_APP_HOME_PAGE = "qingLightAppHomePage";
    private static final String QING_GALLERY_CLOUD_HTMl = "qing-gallery.html";
    private static final String QING_GALLERY_CLOUD_ENTRANCE_HTMl = "qing-gallery-entrance.html";
    private static final String GALLERY_IS_GROUP = "isGroup";
    private static final String IS_GALLERY_ENTRANCE = "isEntrance";
    private static final String GALLERY_RESOURCE_ID = "resourceId";
    private static final String GALLERY_NAME = "name";
    private static final String QING_GALLERY_URL = "https://q.kingdee.com/qing-gallery/";
    private static final String QING_GALLERY_URL_KEY = "qing.gallery.apiserver";
    private static final String GALLERY_HOME_URL = "galleryUrl";
    private static final String AI_ANALYSIS_ENTRANCE_KEY = "qing.ai.analysis.enable";
    private static final String CARD_CTRL_REF = "ctrlRefId";
    private static final String DEV_CTRL_ID = "ctrlId";
    private static final String DEV_FORM_ID = "formId";
    private static final String CARD_CTRL_PAGE_ID = "cardCtrlPageId";
    private static final String HAS_CUSTOM_SCHEMA = "hasCustomSchema";
    private static final String CARD_CTRL = "cardctrl";
    private static final String DESIGN_TIME = "designTime";
    private static final String CTRL_NAME = "ctrlName";
    private static final String MOBILE_CTRL_FULLSCREEN = "mobileCtrl_FullScreen";
    private static final String FULLSCREEN = "fullScreen";
    private static final String PARENT_PAGEID = "parentPageId";
    private static final String TITLE = "title";
    private static final String SKIN = "skin";
    private static final String IS_HYPER_LINK = "isHyperlink";
    private static final String DEFAULT = "default";
    private static final String TIME = "time";
    private static final String TAG = "tag";
    private static final String TAG_ID = "tagId";
    private static final String TOKEN = "token";
    private static final String DATACENTERUUID = "datacenterUUID";
    private static final String TOKEN_PREFIX = "kdedcba";
    private static final String REMOTE_METHOD = "rm";
    private static final String VIEW = "view";
    private static final String LICENSE = "li";
    private static final String DPI = "dpi";
    private static final String FID = "fid";
    private static final String UNDEFINED = "undefined";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String NULL = "null";
    private static final String QING_ARTICLE_URL = "https://q.kingdee.com";
    private static final String QING_ARTICLE_URL_KEY = "qing.article.apiserver";
    private static final String PARAM_VALUES = "paramValues";
    private static final String PARAM_CACHE_ID = "paramCacheId";
    private static final String METRIC_LIB_ID = "metricLibId";
    private static final String REFTYPE = "refType";
    private static final String WIDGET_BIZ_ID = "widgetBizId";
    private static final String WORKBENCH_ID = "workbenchId";
    private static final String OPEN_FROM = "openFrom";
    private static final String DELETE_PUBLISH_INFO_METHOD = "deletePublishInfo";
    private static final String INIT_EXTREPORT_METHOD = "initExtReport";
    private static final String GET_RUNTIME_PUBLISH_INFO_FOR_LAPPDSB = "getRuntimePublishInfoForLappDsb";
    private static final String GET_RUNTIME_PUBLISH_INFO = "getRuntimePublishInfo";
    private static final String GET_PUBLISH_INFO_FOR_EDIT_SCHEMA_METHOD = "getPublishInfoForEditSchema";
    private static final String GET_LAPP_CONTEXT_TOKEN = "getLappContextToken";
    private static final String CHECK_LAPP_PUSH_OWNERSHIP_METHOD = "checkLappPushOwnership";
    private static final String CHECK_EMAIL_PUSH_OWNERSHIP_METHOD = "checkEmailPushOwnership";
    private static final String CHECK_MACRO_PERMISSION_METHOD = "checkMacroPermission";
    private static final String CHECK_HANDOVER_MANAGE_PERMISSION_METHOD = "checkHandOverManagePermission";
    private static final String CHECK_DBMANAGE_PERMISSION_METHOD = "checkDBManagePermission";
    private static final String CHECK_FONT_LIBRARY_PERMISSION_METHOD = "checkFontLibManagePermission";
    private static final String GET_PUBLISH_DSB_REF_INFO_METHOD = "getPublishDsbRefInfo";
    private static final String GET_REF_INFO_BY_REFID = "getRefInfoByRefId";
    private static final String GET_CARD_CTRL_REF_INFO_BY_CTRLID = "getRefInfoByCtrlId";
    private static final String CLEAR_INVALID_CARD_CTRL_REF = "clearInvalidCardCtrlRef";
    private static final String CACHE_PARAM_VALUES = "cacheParamValues";
    private static final String LOAD_CARD_INFO = "loadCardInfo";
    private static final String UNSET_CARD_SOURCE = "unsetCardSource";
    private static final String IERP_BLUE = "ierp_blue";
    private static final String IS_FIRST_FROM_CACHE = "isFirstFromCache";
    private static final String GRID_CONTAINER_PAGE_ID = "gridContainerPageId";
    private static final String GRID_CONTAINER_CARD_ID = "gridContainerCardId";
    private static final String QING_THEME_ANALYSIS_HTML = "qing-theme-analysis.html";
    private static final String QING_THEME_SQUARE_HTML = "qing-theme-square.html";
    private static final String QING_THEME_DASHBOARD_HTML = "qing-theme-dashboard.html";
    private static final String QING_THEME_MANAGE_HTML = "qing-theme-manage.html";
    private static final String QING_ANALYSISCENTER_HTML = "qing-analysiscenter.html";
    private static final String QING_DB_MANAGE_HTML = "qing-db-manage.html";
    private static final String QING_CARD_SELECT_HTML = "qing-cardselect.html";
    private static final String QING_CARD_ERROR_HTML = "qing-card-error.html";
    private static final String QING_CARD_DSB_HTML = "qing-card-dsb.html";
    private static final String QING_CARD_HTML = "qing-card.html";
    private static final String QING_CARD_SQUARE_HTML = "qing-card-square.html";
    private static final String QING_CARD_ANALYSIS_HTML = "qing-card-analysis.html";
    private static final String QING_EMBEDDED_VIEW_HTML = "qing-embedded-view.html";
    private static final String QING_EMBEDDED_CTRL_HTML = "qing-embedded-ctrl.html";
    private static final String QING_DATA_MODELING_HTML = "qing-data-modeling.html";
    private static final String QING_PUBLISH_EMAIL_ANALYSIS_HTML = "qing-publish-email-analysis.html";
    private static final String QING_PUBLISH_DASHBOARD_HTML = "qing-publish-dashboard.html";
    private static final String QING_PUBLISH_ANALYSIS_HTML = "qing-publish-analysis.html";
    private static final String QING_PUBLISH_EDITCONTENT_HTML = "qing-publish-editcontent.html";
    private static final String QING_PUBLISH_DASHBOARD_ANALYSIS_HTML = "qing-publish-dashboard-analysis.html";
    private static final String QING_MAP_MANAGE_HTML = "qing-map-manage.html";
    private static final String QING_MAP_DESIGNER_HTML = "qing-map-designer.html";
    private static final String QING_QHF_DM_HTML = "qing-qhf-dm.html";
    private static final String QING_QHF_HTML = "qing-qhf.html";
    private static final String QING_QHF_PUBLISHED_DSB_ANALYSIS_HTML = "qing-qhf-published-dsb-analysis.html";
    private static final String QING_MANAGEMENT_HAND_OVER_HTML = "qing-management-hand-over.html";
    private static final String EXTREPORT_RUNTIME_HTML = "extreport-runtime.html";
    private static final String EXTREPORT_RUNTIME_HTML_CARD = "extreport-runtime-card.html";
    private static final String QING_MACRO_DESIGNER_HTML = "qing-macro-designer.html";
    private static final String QING_IMAGE_LIBRARY_HTML = "qing-image-library.html";
    private static final String QING_ACCESSANALYSIS_HTML = "qing-accessanalysis.html";
    private static final String QING_RESOURCE_STATISTICS_HTMl = "qing-resource-statistics.html";
    private static final String QING_FONT_LIBRARY_HTML = "qing-font-library.html";
    private static final String QING_FONT_LIBRARY_DETAIL = "qing-font-library-detail.html";
    private static final String QING_WORKBENCH_HTML = "qing-workbench.html";
    private static final String QING_WORKBECNH_WIDGET_ANALYSIS_HTML = "qing-workbench-widget-analysis.html";
    private static final String QING_METRIC_SQUARE_HTML = "qing-metric-square.html";
    private static Map<String, String> presetCacheMap = new ConcurrentHashMap<String, String>(16);
    private static final String QING_APP_ID = "qing";
    private static final String CACHE_KEY_FINISHED = "Qing.Preset.Finished";
    private static final String STATUS_FINISHED = "FINISHED";

    protected String getAppID() {
        return "qing";
    }

    private boolean isUpgrading(HttpServletRequest request, HttpServletResponse response) {
        String appId = request.getParameter(APP_ID);
        if (appId == null || !QING_REPORT_APPID.equals(appId)) {
            appId = "qing";
        }
        if (((Boolean)QingMServiceDispatcher.dispatch((String)appId, (String)"QingService", (String)IS_FILE_UPGRADING, (Object[])new Object[0])).booleanValue()) {
            this.handlerError(request, response, UPGRADING);
            return true;
        }
        return false;
    }

    private String getCurrentAppId(String appId) {
        boolean isOtherAppId;
        boolean bl = isOtherAppId = !QING_REPORT_APPID.equals(appId) && !QING_MODELER_APPID.equals(appId);
        if (appId == null || isOtherAppId) {
            appId = "qing";
        }
        return appId;
    }

    public void upload(HttpServletRequest request, HttpServletResponse response) throws IOException, FileUploadException, FileUploadFailException {
        try {
            QingIntegratedContext qingContext = new QingIntegratedContext();
            List fileItems = QingAction.getFileItem((HttpServletRequest)request);
            String appId = this.getCurrentAppId(request.getParameter(APP_ID));
            if (!fileItems.isEmpty()) {
                FileItem fileItem = (FileItem)fileItems.get(0);
                this.checkUploadFile(fileItem);
                QingAction.protectedUpload((QingContext)qingContext, (String)appId, (FileItem)fileItem, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            QingAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
        catch (FileUploadException e) {
            QingAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
        catch (FileUploadFailException e) {
            QingAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
    }

    public void loadImg(HttpServletRequest request, HttpServletResponse response) throws IOException {
        QingIntegratedContext qingContext = new QingIntegratedContext();
        QingAction.protectedLoadImg((QingContext)qingContext, (String)"qing", (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        QingIntegratedContext qingContext = new QingIntegratedContext();
        QingAction.protectedDownload((QingContext)qingContext, (String)"qing", (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void doLappPreviewEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            this.dispatcherToUrl(request, response, QING_LIGHTAPP_HTML);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doLappEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        if (this.isLappPrivateEntrance(request)) {
            this.doLappPrivateEntrance(request, response);
            return;
        }
        String appType = request.getParameter(APP_TYPE);
        String sharingTargetId = request.getParameter(SHARING_TARGET_ID);
        String dingdingAppType = request.getParameter(DING_DING_APP_TYPE);
        String qingLightAppHomePage = request.getParameter(QING_LIGHT_APP_HOME_PAGE);
        String qingAppType = request.getParameter(QING_APP_TYPE);
        if (StringUtils.isBlank((CharSequence)appType) && StringUtils.isNotBlank((CharSequence)qingAppType)) {
            appType = qingAppType;
        }
        boolean isQingLightAppHomePage = false;
        if (DINGDING.equals(dingdingAppType) && StringUtils.isBlank((CharSequence)sharingTargetId)) {
            appType = DINGDING_OFFLINE;
            isQingLightAppHomePage = true;
        } else {
            isQingLightAppHomePage = TRUE.equals(qingLightAppHomePage);
        }
        if (isQingLightAppHomePage) {
            try {
                Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_LAPP_CONTEXT_TOKEN, (Object[])new Object[]{appType});
                Map data = (Map)resultMap.get("data");
                String redirect = (String)data.get(LAPP_HOME_PAGE_URL);
                redirect = URLUtil.appendParamToUrl((String)redirect, (String)APP_TYPE, (String)appType);
                redirect = URLUtil.appendParamToUrl((String)redirect, (String)TOKEN, (String)((String)data.get(TOKEN)));
                redirect = URLUtil.appendParamToUrl((String)redirect, (String)DATACENTERUUID, (String)((String)data.get(DATACENTERUUID)));
                response.sendRedirect(redirect);
                return;
            }
            catch (IOException ex) {
                LogUtil.error((String)ex.getMessage(), (Throwable)ex);
                return;
            }
        }
        boolean checkForShare = true;
        String analysisId = request.getParameter(QING_ANALYSIS_ID);
        String li = request.getParameter(LICENSE);
        if (li != null) {
            try {
                li = SphixUtil.aa((String)li);
                if (li.startsWith(analysisId) && li.endsWith("f")) {
                    checkForShare = false;
                }
            }
            catch (InvalidCipherTextException e) {
                this.handlerException(request, response, e);
                return;
            }
        }
        try {
            String ddOrientation;
            String fId = request.getParameter(PUBLISH_ID);
            if (checkForShare) {
                QingAction.checkLicenseForPublish((String)"qing", (String)fId);
            }
            String remoteMethod = request.getParameter(REMOTE_METHOD);
            String view = request.getParameter(VIEW);
            if (DPI.equals(remoteMethod)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(FID, fId);
                params.put(PUBLISH_TARGET_TYPE, "2");
                byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)DELETE_PUBLISH_INFO_METHOD, (Object[])new Object[]{params});
                QingAction.writeSuccessJsonResponse((byte[])result, (HttpServletResponse)response, (boolean)true);
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PUBLISH_ID, fId);
            params.put("shared", String.valueOf(StringUtils.isNotBlank((CharSequence)li)));
            byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO_FOR_LAPPDSB, (Object[])new Object[]{params});
            String res = new String(result, Charset.forName("utf-8"));
            Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
            if (resultMap.containsKey("errorCode")) {
                ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
                this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
                return;
            }
            Map data = (Map)resultMap.get("data");
            String publishName = data.get(PUBLISH_NAME).toString();
            String title = Messages.getMLS((String)LIGHTAPP_RESOURCE_ID, (String)"\u79fb\u52a8\u8f7b\u5e94\u7528-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createLappSafetyURL(request, title + publishName, QING_LIGHTAPP_HTML);
            safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
            safetyURL.appendParamToUrl(PUBLISH_ID, fId);
            safetyURL.appendParamToUrl(BIZ_TAG, fId);
            safetyURL.appendParamToUrl(QING_ANALYSIS_ID, analysisId);
            safetyURL.appendParamToUrl(REFRESH, request.getParameter(REFRESH));
            safetyURL.appendParamToUrl(PORTRAIT, request.getParameter(PORTRAIT));
            safetyURL.appendParamToUrl(ACCESS_TOKEN, request.getParameter(ACCESS_TOKEN));
            String publishSourceType = data.get(PUBLISH_SOURCE_TYPE).toString();
            if (DASHBOARD.equals(publishSourceType)) {
                safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
            }
            if (!StringUtils.isEmpty((CharSequence)sharingTargetId)) {
                safetyURL.appendParamToUrl(SHARING_TARGET_ID, sharingTargetId);
            }
            if (!StringUtils.isEmpty((CharSequence)view)) {
                safetyURL.appendParamToUrl(VIEW, view);
            }
            if (!StringUtils.isEmpty((CharSequence)appType)) {
                safetyURL.appendParamToUrl(APP_TYPE, appType);
            }
            if (StringUtils.isNotBlank((CharSequence)(ddOrientation = request.getParameter(DINGDING_ORIENTATION)))) {
                safetyURL.appendParamToUrl(DINGDING_ORIENTATION, ddOrientation);
            }
            safetyURL.appendParamToUrl(ACCESS_TOKEN, RequestContext.get().getGlobalSessionId());
            safetyURL.appendParamToUrl(TIME, request.getParameter(TIME));
            safetyURL.appendParamToUrl(YZJ_PORTAL, request.getParameter(YZJ_PORTAL));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerLappException(request, response, e);
        }
    }

    public void doCardSelectEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((String)QING_CARDS_SETTING_ID, (String)"\u8f7b\u5206\u6790\u5361\u7247\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), QING_CARD_SELECT_HTML);
            safetyURL.appendParamToUrl(SINGLE_SELECT, request.getParameter(SINGLE_SELECT));
            safetyURL.appendParamToUrl(SUPPORT_DSB, request.getParameter(SUPPORT_DSB));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void syncExecutePresetPkg() {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        if (tenantId == null || accountId == null) {
            return;
        }
        String finishedCacheKey = CACHE_KEY_FINISHED + tenantId + "-" + accountId;
        if (null != finishedCacheKey) {
            String status = presetCacheMap.get(finishedCacheKey);
            if (STATUS_FINISHED.equals(status)) {
                return;
            }
            try {
                DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"importPreset", (Object[])new Object[0]);
                presetCacheMap.put(finishedCacheKey, STATUS_FINISHED);
            }
            catch (Exception e) {
                presetCacheMap.remove(finishedCacheKey);
            }
        }
    }

    public void doCardEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        String cardName = request.getParameter(CARD_NAME);
        try {
            String isMobile = request.getParameter(IS_MOBILE);
            String publishId = request.getParameter(PUBLISH_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId});
            String title = Messages.getMLS((String)QING_ANALYSIS_CARDS_ID, (String)"\u8f7b\u5206\u6790\u5361\u7247-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = null;
            if (resultMap.containsKey("errorCode")) {
                safetyURL = this.createSafetyURL(request, title + cardName, QING_CARD_ERROR_HTML);
                safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
                safetyURL.appendParamToUrl("errorCode", resultMap.get("errorCode").toString());
                safetyURL.appendParamToUrl(CARD_NAME, cardName);
                safetyURL.sendRedirect(response);
                return;
            }
            Map data = (Map)resultMap.get("data");
            cardName = data.get(PUBLISH_NAME).toString();
            String publishSourceType = data.get(PUBLISH_SOURCE_TYPE).toString();
            String publishTargetType = data.get(PUBLISH_TARGET_TYPE).toString();
            String haveToCarryData = data.get(HAVE_TO_CARRY_DATA).toString();
            String isPreset = data.get(IS_PRESET).toString();
            cardName = StringUtils.encodeToBase64String((String)cardName);
            if (DASHBOARD.equals(publishSourceType)) {
                safetyURL = this.createSafetyURL(request, cardName, QING_CARD_DSB_HTML);
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
                safetyURL.appendParamToUrl(IS_PRESET, isPreset);
                safetyURL.appendParamToUrl(CARD_NAME, cardName);
            } else if (!Boolean.parseBoolean(isMobile)) {
                safetyURL = this.createSafetyURL(request, title + cardName, QING_CARD_HTML);
                String tag = UUID.randomUUID().toString();
                safetyURL.appendParamToUrl(TAG, tag);
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(BIZ_TAG, publishId);
                String cardId = request.getParameter(CARD_ID);
                safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, cardId);
                safetyURL.appendParamToUrl(CARD_NAME, cardName);
            } else {
                safetyURL = this.createLappSafetyURL(request, title + cardName, QING_LIGHTAPP_HTML);
                safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(BIZ_TAG, publishId);
                safetyURL.appendParamToUrl(SKIN, IERP_BLUE);
                safetyURL.appendParamToUrl(VIEW, "10");
                safetyURL.appendParamToUrl(CARD_NAME, cardName);
                EncryptAcessTokenURLAppender.appendParamToUrl(safetyURL);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Exception e2) {
            RemoteCallFailException e2;
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, cardName, QING_CARD_ERROR_HTML);
            if (!(e2 instanceof AbstractQingException)) {
                e2 = new RemoteCallFailException((Throwable)e2);
            }
            safetyURL.appendParamToUrl("errorCode", "" + ((AbstractQingException)e2).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e2.getMessage());
            safetyURL.appendParamToUrl(CARD_NAME, cardName);
            try {
                safetyURL.sendRedirect(response);
            }
            catch (IOException e1) {
                LogUtil.error((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void doDevCtrlCardEntrance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isUpgrading(request, response)) {
            return;
        }
        String cardName = request.getParameter(CTRL_NAME);
        try {
            String parentPageId;
            boolean mobileCtrl = Boolean.parseBoolean(request.getParameter(MOBILE_CTRL));
            if (!mobileCtrl) {
                LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            }
            QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)CLEAR_INVALID_CARD_CTRL_REF, (Object[])new Object[0]);
            String ctrlRefId = request.getParameter(CARD_CTRL_REF);
            String title = Messages.getMLS((String)QING_ANALYSIS_CARDS_ID, (String)"\u8f7b\u5206\u6790\u5361\u7247-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            if (StringUtils.isEmpty((CharSequence)ctrlRefId) || UNDEFINED.equals(ctrlRefId) || NULL.equals(ctrlRefId)) {
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_CARD_ERROR_HTML);
                safetyURL.appendParamToUrl("errorCode", UNSET_CARD_SOURCE);
                safetyURL.sendRedirect(response);
                return;
            }
            Map refInfo = (Map)QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)GET_REF_INFO_BY_REFID, (Object[])new Object[]{ctrlRefId});
            if (refInfo == null || refInfo.isEmpty()) {
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_CARD_ERROR_HTML);
                safetyURL.appendParamToUrl("errorCode", UNSET_CARD_SOURCE);
                safetyURL.sendRedirect(response);
                return;
            }
            String publishId = (String)refInfo.get(PUBLISH_ID);
            String ctrlId = (String)refInfo.get(DEV_CTRL_ID);
            String formId = (String)refInfo.get(DEV_FORM_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId});
            AbstractQingAction.ISafetyURL safetyURL = null;
            if (resultMap.containsKey("errorCode")) {
                safetyURL = this.createSafetyURL(request, title + cardName, QING_CARD_ERROR_HTML);
                safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
                safetyURL.appendParamToUrl("errorCode", resultMap.get("errorCode").toString());
                safetyURL.appendParamToUrl(CARD_NAME, cardName);
                safetyURL.sendRedirect(response);
                return;
            }
            safetyURL = this.createSafetyURL(request, title + cardName, QING_CARD_HTML);
            String tag = UUID.randomUUID().toString();
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
            safetyURL.appendParamToUrl(CARD_NAME, StringUtils.encodeToBase64String((String)cardName));
            safetyURL.appendParamToUrl(CARD_CTRL_REF, ctrlRefId);
            safetyURL.appendParamToUrl(HAS_CUSTOM_SCHEMA, request.getParameter(HAS_CUSTOM_SCHEMA));
            safetyURL.appendParamToUrl(CTRL_NAME, request.getParameter(CTRL_NAME));
            String bizTag = request.getParameter(BIZ_TAG);
            if (StringUtils.isEmpty((CharSequence)bizTag)) {
                bizTag = this.getCardCtrlSchemaBizTag(publishId, formId, ctrlId, request);
            }
            safetyURL.appendParamToUrl(BIZ_TAG, bizTag);
            if (mobileCtrl) {
                boolean fullScreen = Boolean.parseBoolean(request.getParameter(FULLSCREEN));
                if (fullScreen) {
                    safetyURL.appendParamToUrl(CARD_SCENE, MOBILE_CTRL_FULLSCREEN);
                } else {
                    safetyURL.appendParamToUrl(CARD_SCENE, MOBILE_CTRL);
                }
            } else {
                safetyURL.appendParamToUrl(CARD_SCENE, DEV_CTRL);
                String schemaAdditionalTag = request.getParameter(SCHEMA_ADDITIONAL_TAG);
                if (StringUtils.isEmpty((CharSequence)schemaAdditionalTag)) {
                    schemaAdditionalTag = this.getCardCtrlSchemaAdditionalTag(formId, ctrlId, request);
                }
                safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, schemaAdditionalTag);
                safetyURL.appendParamToUrl(HAS_MAIN_VIEW, request.getParameter(HAS_MAIN_VIEW));
            }
            String pageId = request.getParameter(PAGE_ID);
            if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                safetyURL.appendParamToUrl("qingMsgNodeId", ctrlRefId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(parentPageId = request.getParameter(PARENT_PAGEID)))) {
                safetyURL.appendParamToUrl(PARENT_PAGEID, parentPageId);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Exception e2) {
            RemoteCallFailException e2;
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, cardName, QING_CARD_ERROR_HTML);
            if (!(e2 instanceof AbstractQingException)) {
                e2 = new RemoteCallFailException((Throwable)e2);
            }
            safetyURL.appendParamToUrl("errorCode", "" + ((AbstractQingException)e2).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e2.getMessage());
            safetyURL.appendParamToUrl(CARD_NAME, cardName);
            try {
                safetyURL.sendRedirect(response);
            }
            catch (IOException e1) {
                LogUtil.error((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void doEditSquareCardEntrance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doEditSquareAndAnalysisCardEntrance(request, response, QING_CARD_SQUARE_HTML);
    }

    public void doEditAnalysisCardEntrance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doEditSquareAndAnalysisCardEntrance(request, response, QING_CARD_ANALYSIS_HTML);
    }

    private void doEditSquareAndAnalysisCardEntrance(HttpServletRequest request, HttpServletResponse response, String htmlName) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String publishId = request.getParameter(PUBLISH_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            if (null == this.getRuntimePublishInfoAndCheckPerm(request, response)) {
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PUBLISH_ID, publishId);
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)LOAD_CARD_INFO, (Object[])new Object[]{params});
            if (resultMap.containsKey("errorCode")) {
                String errorCode = resultMap.get("errorCode").toString();
                this.handlerError(request, response, errorCode, "");
                return;
            }
            Map data = (Map)resultMap.get("data");
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, htmlName);
            String tag = request.getParameter(TAG);
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
            String themeId = (String)data.get(THEME_Id);
            String themeName = (String)data.get(THEME_NAME);
            safetyURL.appendParamToUrl(THEME_Id, themeId);
            safetyURL.appendParamToUrl(THEME_NAME, themeName);
            String publishSourceType = (String)data.get(PUBLISH_SOURCE_TYPE);
            safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
            String haveToCarryData = (String)data.get(HAVE_TO_CARRY_DATA);
            safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
            String isPreset = (String)data.get(IS_PRESET);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.appendParamToUrl(IS_FIRST_FROM_CACHE, TRUE);
            String cardScene = request.getParameter(CARD_SCENE);
            if (DEV_CTRL.equals(cardScene)) {
                if (QING_CARD_SQUARE_HTML.equals(htmlName)) {
                    safetyURL.appendParamToUrl(CARD_SCENE, cardScene);
                    safetyURL.appendParamToUrl(CARD_CTRL_PAGE_ID, request.getParameter(CARD_CTRL_PAGE_ID));
                    safetyURL.appendParamToUrl(HAS_MAIN_VIEW, request.getParameter(HAS_MAIN_VIEW));
                }
                safetyURL.appendParamToUrl(BIZ_TAG, request.getParameter(BIZ_TAG));
                safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, request.getParameter(SCHEMA_ADDITIONAL_TAG));
            } else {
                if (QING_CARD_SQUARE_HTML.equals(htmlName)) {
                    String gridContainerPageId = request.getParameter(GRID_CONTAINER_PAGE_ID);
                    String gridContainerCardId = request.getParameter(GRID_CONTAINER_CARD_ID);
                    safetyURL.appendParamToUrl(GRID_CONTAINER_PAGE_ID, gridContainerPageId);
                    safetyURL.appendParamToUrl(GRID_CONTAINER_CARD_ID, gridContainerCardId);
                }
                String cardId = request.getParameter(CARD_ID);
                safetyURL.appendParamToUrl(BIZ_TAG, publishId);
                safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, cardId);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    private String getCardCtrlSchemaAdditionalTag(String formId, String ctrlId, HttpServletRequest request) {
        if (Boolean.parseBoolean(request.getParameter(DESIGN_TIME))) {
            return "";
        }
        QingIntegratedContext qingContext = new QingIntegratedContext();
        StringBuilder sb = new StringBuilder();
        if (!this.hasCustomSchema(request)) {
            sb.append("_");
            sb.append(CARD_CTRL);
            sb.append('_');
            sb.append(formId);
            sb.append('_');
            sb.append(ctrlId);
        }
        sb.append("_");
        sb.append(qingContext.getTenantId());
        sb.append('_');
        sb.append(qingContext.getAccountId());
        sb.append('_');
        sb.append(qingContext.getUserId());
        return sb.toString();
    }

    private String getCardCtrlSchemaBizTag(String publishId, String formId, String ctrlId, HttpServletRequest request) {
        String bizTag = publishId;
        if (this.hasCustomSchema(request)) {
            StringBuilder sb = new StringBuilder();
            sb.append(bizTag);
            sb.append('_');
            sb.append(CARD_CTRL);
            sb.append('_');
            sb.append(formId);
            sb.append('_');
            sb.append(ctrlId);
            bizTag = sb.toString();
        }
        return bizTag;
    }

    private boolean hasCustomSchema(HttpServletRequest request) {
        String hasCustomSchema = request.getParameter(HAS_CUSTOM_SCHEMA);
        return StringUtils.isNotEmpty((CharSequence)hasCustomSchema) && !FALSE.equals(hasCustomSchema) && !UNDEFINED.equals(hasCustomSchema) && !NULL.equals(hasCustomSchema);
    }

    public void doEditCardCtrlAPEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String ctrlId = request.getParameter(DEV_CTRL_ID);
            String formId = request.getParameter(DEV_FORM_ID);
            Map refInfos = (Map)QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)GET_CARD_CTRL_REF_INFO_BY_CTRLID, (Object[])new Object[]{formId, ctrlId});
            if (refInfos == null || StringUtils.isEmpty((CharSequence)((CharSequence)refInfos.get(CARD_CTRL_REF)))) {
                this.handlerError(request, response, UNSET_CARD_SOURCE, "");
                return;
            }
            String publishId = (String)refInfos.get(PUBLISH_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId});
            if (resultMap.containsKey("errorCode")) {
                String errorCode = resultMap.get("errorCode").toString();
                Object errorMsg = resultMap.get(ERROR_MESSAGE);
                String errMsg = errorMsg == null ? "" : errorMsg.toString();
                this.handlerError(request, response, errorCode, errMsg);
                return;
            }
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, (String)resultMap.get(PUBLISH_NAME), QING_CARD_SQUARE_HTML);
            String tag = request.getParameter(TAG);
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
            safetyURL.appendParamToUrl(BIZ_TAG, publishId);
            safetyURL.appendParamToUrl(IS_FIRST_FROM_CACHE, TRUE);
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, request.getParameter(SCHEMA_ADDITIONAL_TAG));
            safetyURL.appendParamToUrl(CARD_CTRL_REF, (String)refInfos.get(CARD_CTRL_REF));
            String cardScene = request.getParameter(CARD_SCENE);
            safetyURL.appendParamToUrl(CARD_SCENE, cardScene);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doQingViewEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String billFormId = request.getParameter(BILL_FORM_ID);
            String pageId = request.getParameter(PAGE_ID);
            QingAction.checkLicenseForEmbeded((String)billFormId, (String)pageId, null);
            String title = Messages.getMLS((String)QING_VIEW_ID, (String)"\u8f7b\u5206\u6790\u89c6\u56fe-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title + billFormId, QING_EMBEDDED_VIEW_HTML);
            safetyURL.appendParamToUrl(PAGE_ID, pageId);
            safetyURL.appendParamToUrl(TAG, pageId);
            safetyURL.appendParamToUrl(BIZ_TAG, billFormId);
            safetyURL.appendParamToUrl(FORM_TYPE, QING_VIEW_VALUE);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doQingControlEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String billFormId = request.getParameter(BILL_FORM_ID);
            String schemaAdditionalTag = request.getParameter(SCHEMA_ADDITIONAL_TAG);
            String pageId = request.getParameter(PAGE_ID);
            String ctrKey = request.getParameter(CTR_KEY);
            QingAction.checkLicenseForEmbeded((String)billFormId, (String)pageId, (String)ctrKey);
            String title = Messages.getMLS((String)QING_ANALYSIS_CONTROL, (String)"\u8f7b\u5206\u6790\u63a7\u4ef6-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title + billFormId + "-" + ctrKey, QING_EMBEDDED_CTRL_HTML);
            safetyURL.appendParamToUrl(TAG, pageId);
            safetyURL.appendParamToUrl(PAGE_ID, pageId);
            safetyURL.appendParamToUrl(BIZ_TAG, billFormId);
            safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, schemaAdditionalTag);
            safetyURL.appendParamToUrl(FORM_TYPE, QING_VIEW_VALUE);
            safetyURL.appendParamToUrl(CTR_KEY, ctrKey);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doNocodecardDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String cardId = request.getParameter(CARD_ID);
            String paramCacheId = request.getParameter(PARAM_CACHE_ID);
            String kdString = Messages.getMLS((String)QING_NOCODE_CARD_ID, (String)"\u65e0\u4ee3\u7801\u7edf\u8ba1\u5361\u7247-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, kdString + cardId, "qing-nocode-card-designer.html");
            safetyURL.appendParamToUrl(CARD_ID, cardId);
            safetyURL.appendParamToUrl(PARAM_CACHE_ID, paramCacheId);
            String tag = request.getParameter(TAG);
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl("cardClientId", request.getParameter("cardClientId"));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doThemeManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String hasAIAnalysisEntrance;
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String defaultThemeGroupName = request.getParameter(DEFAULT);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((String)QING_HOME_PAGE_ID, (String)"\u8f7b\u5206\u6790\u5e94\u7528\u9996\u9875", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), QING_THEME_MANAGE_HTML);
            safetyURL.appendParamToUrl(DEFAULT, defaultThemeGroupName);
            try {
                QingAction.checkQingGPTLicense();
                hasAIAnalysisEntrance = TRUE;
            }
            catch (AbstractQingException e) {
                hasAIAnalysisEntrance = FALSE;
            }
            safetyURL.appendParamToUrl("hasAIAnalysisEntrance", hasAIAnalysisEntrance);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDataModelingEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String themeId = request.getParameter(THEME_ID);
            byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)CHECK_THEME_PERMISSION, (Object[])new Object[]{themeId});
            String res = new String(result, Charset.forName("utf-8"));
            Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
            if (resultMap.containsKey("errorCode")) {
                ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
                this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            } else {
                String title = request.getParameter(TITLE);
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_DATA_MODELING_HTML);
                String themeID = request.getParameter(THEME_ID);
                String isPreset = request.getParameter(IS_PRESET);
                safetyURL.appendParamToUrl(THEME_ID, themeID);
                safetyURL.appendParamToUrl(IS_PRESET, isPreset);
                safetyURL.sendRedirect(response);
            }
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doThemeAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        this.doThemeSquareAndAnalysisEntrance(request, response, QING_THEME_ANALYSIS_HTML);
    }

    public void doThemeSquareEntrance(HttpServletRequest request, HttpServletResponse response) {
        this.doThemeSquareAndAnalysisEntrance(request, response, QING_THEME_SQUARE_HTML);
    }

    private void doThemeSquareAndAnalysisEntrance(HttpServletRequest request, HttpServletResponse response, String htmlName) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            this.doThemeSquareAndAnalysisEntranceWithoutLicense(request, response, htmlName);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    private void doThemeSquareAndAnalysisEntranceWithoutLicense(HttpServletRequest request, HttpServletResponse response, String htmlName) throws QingLicenseException, IOException {
        LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
        String themeId = request.getParameter(THEME_Id);
        byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)CHECK_THEME_PERMISSION, (Object[])new Object[]{themeId});
        String res = new String(result, Charset.forName("utf-8"));
        Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
        if (resultMap.containsKey("errorCode")) {
            ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
            this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
        } else {
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, htmlName);
            String tag = UUID.randomUUID().toString();
            String themeName = request.getParameter(THEME_NAME);
            String isPreset = request.getParameter(IS_PRESET);
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(THEME_Id, themeId);
            safetyURL.appendParamToUrl(BIZ_TAG, themeId);
            safetyURL.appendParamToUrl(THEME_NAME, themeName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
    }

    public void doDashboardEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        String dsbId = request.getParameter(DASHBOARD_ID);
        String isPreset = request.getParameter(IS_PRESET);
        try {
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)CHECK_THEME_PERMISSION, (Object[])new Object[]{dsbId});
            String res = new String(result, Charset.forName("utf-8"));
            Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
            if (resultMap.containsKey("errorCode")) {
                ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
                this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            } else {
                String title = request.getParameter(TITLE);
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_THEME_DASHBOARD_HTML);
                safetyURL.appendParamToUrl(DASHBOARD_ID, dsbId);
                safetyURL.appendParamToUrl(IS_PRESET, isPreset);
                safetyURL.sendRedirect(response);
            }
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doThemeAIAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            QingAction.checkQingGPTLicense();
            this.doThemeSquareAndAnalysisEntranceWithoutLicense(request, response, "qing-theme-ai-analysis.html");
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doAnalysisCenterEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((String)QING_ANALYSIS_CENTER_ID, (String)"\u8f7b\u5206\u6790\u4e2d\u5fc3", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), QING_ANALYSISCENTER_HTML);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doPublishEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String publishId = request.getParameter(PUBLISH_ID);
            String appId = this.getCurrentAppId(request.getParameter(APP_ID));
            QingAction.checkLicenseForPublish((String)appId, (String)publishId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            Map<String, Object> publishInfoMap = this.getRuntimePublishInfoAndCheckPerm(request, response);
            this.sendRedirectToPublishEntrance(request, response, publishInfoMap);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doWorkbenchPublishEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String publishId = request.getParameter(PUBLISH_ID);
            String appId = this.getCurrentAppId(request.getParameter(APP_ID));
            QingAction.checkLicenseForPublish((String)appId, (String)publishId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            Map<String, Object> publishInfoMap = this.getRuntimePublishInfoAndCheckPermForWorkbench(request, response);
            this.sendRedirectToPublishEntrance(request, response, publishInfoMap);
        }
        catch (Exception e) {
            this.handlerExceptionWithErrorURL(request, response, "workbench-error.html", e);
        }
    }

    private Map<String, Object> getRuntimePublishInfoAndCheckPermForWorkbench(HttpServletRequest request, HttpServletResponse response) {
        byte[] result;
        String res;
        Map resultMap;
        String publishId = request.getParameter(PUBLISH_ID);
        String appId = request.getParameter(APP_ID);
        if (appId == null) {
            appId = "qing";
        }
        if ((resultMap = (Map)JsonUtil.decodeFromString((String)(res = new String(result = (byte[])QingMServiceDispatcher.dispatch((String)appId, (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId}), Charset.forName("utf-8"))), Map.class)).containsKey("errorCode")) {
            ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
            this.handlerErrorForWorkbench(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            resultMap = null;
        }
        return resultMap;
    }

    protected final void handlerErrorForWorkbench(HttpServletRequest request, HttpServletResponse response, String errorCode, String errorMessage) {
        try {
            String errorURL = "workbench-error.html";
            String title = Messages.getMLS((String)ERROR_PAGE_ID, (String)"\u9519\u8bef\u9875\u9762", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, errorURL);
            safetyURL.appendParamToUrl("errorCode", errorCode);
            safetyURL.appendParamToUrl(ERROR_MESSAGE, errorMessage);
            safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, request.getParameter(PUBLISH_SOURCE_TYPE));
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error((String)e1.getMessage(), (Throwable)e1);
        }
    }

    public void doPublishedEmailEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String publishId = request.getParameter(PUBLISH_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
            Map<String, Object> publishInfoMap = this.getRuntimePublishInfoAndCheckPerm(request, response);
            this.sendRedirectToPublishEntrance(request, response, publishInfoMap);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    private void sendRedirectToPublishEntrance(HttpServletRequest request, HttpServletResponse response, Map<String, Object> publishInfoMap) throws Exception {
        if (null != publishInfoMap) {
            String publishId = request.getParameter(PUBLISH_ID);
            String timedPush = request.getParameter(EMAIL_TIMED_PUSH_SCENE);
            String openFrom = request.getParameter(OPEN_FROM);
            Map data = (Map)publishInfoMap.get("data");
            AbstractQingAction.ISafetyURL safetyURL = null;
            String publishName = data.get(PUBLISH_NAME).toString();
            String publishSourceType = data.get(PUBLISH_SOURCE_TYPE).toString();
            String publishTargetType = data.get(PUBLISH_TARGET_TYPE).toString();
            String haveToCarryData = data.get(HAVE_TO_CARRY_DATA).toString();
            String isPreset = data.get(IS_PRESET).toString();
            String tagId = data.get(TAG_ID).toString();
            if ("6".equals(publishTargetType)) {
                String isAnonymousView = data.get(IS_ANONYMOUS_VIEW).toString();
                if (SUBJECT.equals(publishSourceType) || BILL.equals(publishSourceType)) {
                    safetyURL = this.createSafetyURL(request, publishName, QING_PUBLISH_EMAIL_ANALYSIS_HTML);
                    safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
                    safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                    safetyURL.appendParamToUrl(BIZ_TAG, publishId);
                    safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
                    safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
                    safetyURL.appendParamToUrl(IS_ANONYMOUS_VIEW, isAnonymousView);
                    safetyURL.appendParamToUrl(EMAIL_TIMED_PUSH_SCENE, timedPush);
                } else if (DASHBOARD.equals(publishSourceType)) {
                    safetyURL = this.createSafetyURL(request, publishName, QING_PUBLISH_DASHBOARD_HTML);
                    safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                    safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                    safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
                    safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
                    safetyURL.appendParamToUrl(IS_ANONYMOUS_VIEW, isAnonymousView);
                    safetyURL.appendParamToUrl(EMAIL_TIMED_PUSH_SCENE, timedPush);
                }
            } else if (DASHBOARD.equals(publishSourceType)) {
                safetyURL = this.createSafetyURL(request, publishName, QING_PUBLISH_DASHBOARD_HTML);
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
                safetyURL.appendParamToUrl(IS_PRESET, isPreset);
                safetyURL.appendParamToUrl(EMAIL_TIMED_PUSH_SCENE, timedPush);
            } else if (SUBJECT.equals(publishSourceType) || BILL.equals(publishSourceType)) {
                safetyURL = this.createSafetyURL(request, publishName, QING_PUBLISH_ANALYSIS_HTML);
                safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(BIZ_TAG, publishId);
                safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
                safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
                safetyURL.appendParamToUrl(IS_PRESET, isPreset);
                safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                safetyURL.appendParamToUrl(EMAIL_TIMED_PUSH_SCENE, timedPush);
                safetyURL.appendParamToUrl(OPEN_FROM, openFrom);
            } else if (EXTREPORT.equals(publishSourceType)) {
                this.opendExtReport(request, response, publishId, tagId, publishName, publishTargetType);
            }
            if (safetyURL != null) {
                safetyURL.sendRedirect(response);
            }
        }
    }

    public void doExtreportEntrance(HttpServletRequest request, HttpServletResponse response) {
        String publishId = request.getParameter(PUBLISH_ID);
        String extReportId = request.getParameter(EXTREPORT_ID);
        String extReportName = request.getParameter(EXTREPORT_NAME);
        try {
            String publishTargetType = request.getParameter(PUBLISH_TARGET_TYPE);
            if (null != publishTargetType) {
                String appId = this.getCurrentAppId(request.getParameter(APP_ID));
                QingAction.checkLicenseForPublish((String)appId, (String)publishId);
                if (request.getParameter(EXHIBITION_SCENE) != null && !request.getParameter(EXHIBITION_SCENE).contains("mobile")) {
                    LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
                }
                byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)appId, (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId});
                String res = new String(result, Charset.forName("utf-8"));
                Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
                Object safetyURL = null;
                if (resultMap.containsKey("errorCode")) {
                    this.handlerExtreportError(request, response, extReportName, resultMap.get("errorCode").toString(), "");
                    return;
                }
                Map data = (Map)resultMap.get("data");
                extReportId = data.get(TAG_ID).toString();
            } else {
                QingAction.checkQingReportLicense();
            }
            this.opendExtReport(request, response, publishId, extReportId, extReportName, publishTargetType);
        }
        catch (Exception e2) {
            RemoteCallFailException e2;
            if (!(e2 instanceof AbstractQingException)) {
                e2 = new RemoteCallFailException((Throwable)e2);
            }
            String errorCode = String.valueOf(((AbstractQingException)e2).getErrorCode());
            this.handlerExtreportError(request, response, extReportName, errorCode, e2.getMessage());
        }
    }

    private void opendExtReport(HttpServletRequest request, HttpServletResponse response, String publishId, String extReportId, String extReportName, String publishTargetType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        boolean isHyperlink = Boolean.parseBoolean(request.getParameter(IS_HYPER_LINK));
        String paramCacheId = request.getParameter(PARAM_CACHE_ID);
        String paramValues = request.getParameter(PARAM_VALUES);
        parameters.put(EXTREPORT_ID, extReportId);
        parameters.put(IS_HYPER_LINK, isHyperlink ? TRUE : FALSE);
        parameters.put(PARAM_CACHE_ID, paramCacheId);
        try {
            AbstractQingAction.ISafetyURL safetyURL;
            String res;
            Map resultMap;
            Object errCodeObj;
            byte[] data;
            QingIntegratedContext qingContext = new QingIntegratedContext();
            if (StringUtils.isNotBlank((CharSequence)paramValues)) {
                paramCacheId = this.cacheParamValues((QingContext)qingContext, paramValues);
            }
            if ((data = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)qingContext, (String)QING_REPORT_APPID, (String)"/qing_rpt/runtime.do", (String)INIT_EXTREPORT_METHOD, (Object[])new Object[]{parameters})) != null && data.length > 0 && (errCodeObj = (resultMap = (Map)JsonUtil.decodeFromString((String)(res = new String(data, StandardCharsets.UTF_8)), Map.class)).get("errorCode")) instanceof Double) {
                String errorCode = String.valueOf(((Double)errCodeObj).intValue());
                Object errorMsg = resultMap.get(ERROR_MESSAGE);
                this.handlerExtreportError(request, response, extReportName, errorCode, errorMsg == null ? "" : String.valueOf(errorMsg));
                return;
            }
            if (request.getParameter(EXHIBITION_SCENE) != null) {
                safetyURL = this.createSafetyURL(request, extReportName, EXTREPORT_RUNTIME_HTML_CARD);
                safetyURL.appendParamToUrl(EXHIBITION_SCENE, request.getParameter(EXHIBITION_SCENE));
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(EXTREPORT_ID, extReportId);
                safetyURL.appendParamToUrl(EXTREPORT_NAME, extReportName);
                safetyURL.appendParamToUrl(PARAM_CACHE_ID, paramCacheId);
                safetyURL.appendParamToUrl(APP_ID, QING_REPORT_APPID);
                safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                safetyURL.appendParamToUrl(IS_HYPER_LINK, isHyperlink ? TRUE : FALSE);
                safetyURL.appendParamToUrl(HYPER_LINK_LEVEL, request.getParameter(HYPER_LINK_LEVEL));
                safetyURL.appendParamToUrl(EXTREPORT_WIDGET_ID, request.getParameter(EXTREPORT_WIDGET_ID));
                String schemaBiztagId = request.getParameter("schemaBiztagId");
                if (!StringUtils.isEmpty((CharSequence)schemaBiztagId)) {
                    safetyURL.appendParamToUrl("schemaBiztagId", schemaBiztagId);
                }
                if (StringUtils.isNotBlank((CharSequence)request.getParameter(IS_FULL_SCREEN))) {
                    safetyURL.appendParamToUrl(IS_FULL_SCREEN, request.getParameter(IS_FULL_SCREEN));
                }
                String sharingTargetId = request.getParameter(SHARING_TARGET_ID);
                String dsbPublishTargetType = request.getParameter("dsbPublishTargetType");
                if (!StringUtils.isEmpty((CharSequence)sharingTargetId) && "6".equals(dsbPublishTargetType)) {
                    safetyURL.appendParamToUrl(HAS_SCHEME_EDIT_PERM, FALSE);
                }
                safetyURL.appendParamToUrl(ACCESS_TOKEN, RequestContext.get().getGlobalSessionId());
                safetyURL.appendParamToUrl(APP_TYPE, request.getParameter(APP_TYPE));
                safetyURL.sendRedirect(response);
            } else {
                safetyURL = this.createSafetyURL(request, extReportName, EXTREPORT_RUNTIME_HTML);
                safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
                safetyURL.appendParamToUrl(EXTREPORT_ID, extReportId);
                safetyURL.appendParamToUrl(PARAM_CACHE_ID, paramCacheId);
                safetyURL.appendParamToUrl(APP_ID, QING_REPORT_APPID);
                safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
                safetyURL.appendParamToUrl("schemaBiztagId", publishId);
                safetyURL.sendRedirect(response);
            }
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    private String cacheParamValues(QingContext qingContext, String paramValues) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        String paramCacheId = null;
        if (StringUtils.isNotBlank((CharSequence)paramValues)) {
            parameters.put(PARAM_VALUES, paramValues);
            byte[] data = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)qingContext, (String)QING_REPORT_APPID, (String)"/qing_rpt/runtime.do", (String)CACHE_PARAM_VALUES, (Object[])new Object[]{parameters});
            if (data != null && data.length > 0) {
                Map resultMap = (Map)JsonUtil.decodeFromString((String)new String(data, StandardCharsets.UTF_8), Map.class);
                Object errCodeObj = resultMap.get("errorCode");
                if (errCodeObj instanceof Double) {
                    int errorCode = ((Double)errCodeObj).intValue();
                    String errorMsg = (String)resultMap.get(ERROR_MESSAGE);
                    throw new AbstractQingException(errorMsg, errorCode);
                }
                paramCacheId = (String)resultMap.get("data");
            }
        }
        return paramCacheId;
    }

    public void doPublishContentEditEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            this.sendRedirectToPublishContentEditEntrance(request, response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    private void sendRedirectToPublishContentEditEntrance(HttpServletRequest request, HttpServletResponse response) throws IOException, AbstractQingException {
        String publishId = request.getParameter(PUBLISH_ID);
        QingAction.checkLicenseForPublish((String)"qing", (String)publishId);
        LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
        byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)GET_PUBLISH_INFO_FOR_EDIT_SCHEMA_METHOD, (Object[])new Object[]{publishId});
        String res = new String(result, Charset.forName("utf-8"));
        Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
        if (resultMap.containsKey("errorCode")) {
            ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
            this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            return;
        }
        Map publishInfo = (Map)resultMap.get("data");
        String schemaId = (String)publishInfo.get(SCHEMA_ID);
        String title = request.getParameter(TITLE);
        AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_PUBLISH_EDITCONTENT_HTML);
        safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
        safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
        safetyURL.appendParamToUrl(BIZ_TAG, schemaId);
        safetyURL.appendParamToUrl(SCHEMA_ID, schemaId);
        safetyURL.appendParamToUrl(SCHEMA_TYPE, (String)publishInfo.get(SCHEMA_TYPE));
        safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, (String)publishInfo.get(PUBLISH_SOURCE_TYPE));
        safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, (String)publishInfo.get(PUBLISH_TARGET_TYPE));
        safetyURL.appendParamToUrl(FROM_PAGE_ID, request.getParameter(FROM_PAGE_ID));
        safetyURL.appendParamToUrl(LAPP_ID, request.getParameter(LAPP_ID));
        safetyURL.appendParamToUrl(LAPP_USER_TYPE, request.getParameter(LAPP_USER_TYPE));
        safetyURL.appendParamToUrl(SUBSCRIBE_KEY, request.getParameter(SUBSCRIBE_KEY));
        safetyURL.appendParamToUrl(FROM_PAGE_CLIENT_ID, request.getParameter(CURRENT_PAGE_CLIENT_ID));
        safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, (String)publishInfo.get(HAVE_TO_CARRY_DATA));
        safetyURL.sendRedirect(response);
    }

    public void doTimedPushContentEditEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String pushTarget = request.getParameter(PUSH_TARGET);
            String configId = request.getParameter(CONFIG_ID);
            QingAction.checkLicenseForPush((String)pushTarget, (String)configId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            this.sendRedirectToTimedPushContentEditEntrance(request, response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    private void sendRedirectToTimedPushContentEditEntrance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pushTarget = request.getParameter(PUSH_TARGET);
        String configId = request.getParameter(CONFIG_ID);
        String title = request.getParameter(TITLE);
        AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_PUBLISH_EDITCONTENT_HTML);
        safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
        String error = request.getParameter("errorCode");
        if (!StringUtils.isBlank((CharSequence)error)) {
            this.handlerError(request, response, error, "");
            return;
        }
        String schemaType = request.getParameter(SCHEMA_TYPE);
        if (pushTarget.equals(LAPP)) {
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)CHECK_LAPP_PUSH_OWNERSHIP_METHOD, (Object[])new Object[]{configId});
            if (resultMap.containsKey("errorCode")) {
                this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
                return;
            }
            Boolean haveAuthority = (Boolean)resultMap.get("data");
            if (!haveAuthority.booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
            }
            safetyURL.appendParamToUrl(MANAGE_TYPE, LAPP_TIMED_PUSH);
            safetyURL.appendParamToUrl(PUSH_TARGET_TYPE, request.getParameter(PUSH_TARGET_TYPE));
            if ("0".equals(schemaType)) {
                schemaType = LONGER;
            } else if ("1".equals(schemaType)) {
                schemaType = SQUARE;
            } else if ("2".equals(schemaType)) {
                schemaType = DASHBOARD;
            }
        } else if (pushTarget.equals(EMAIL)) {
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)CHECK_EMAIL_PUSH_OWNERSHIP_METHOD, (Object[])new Object[]{configId});
            if (resultMap.containsKey("errorCode")) {
                this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
                return;
            }
            Boolean haveAuthority = (Boolean)resultMap.get("data");
            if (!haveAuthority.booleanValue()) {
                this.handlerError(request, response, "noPermission", "");
            }
            safetyURL.appendParamToUrl(MANAGE_TYPE, EMAIL_TIMED_PUSH);
            String publishSourceType = request.getParameter(PUBLISH_SOURCE_TYPE);
            safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
            if (publishSourceType.equals(DASHBOARD)) {
                schemaType = DASHBOARD;
            } else if ("0".equals(schemaType)) {
                schemaType = LONGER;
            }
        }
        safetyURL.appendParamToUrl(SCHEMA_TYPE, schemaType);
        safetyURL.appendParamToUrl(CONFIG_ID, configId);
        safetyURL.sendRedirect(response);
    }

    public void doPublishedDashboardAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String dsbPublishId = request.getParameter(PUBLISH_ID);
            QingAction.checkLicenseForPublish((String)"qing", (String)dsbPublishId);
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            if (null == this.getRuntimePublishInfoAndCheckPerm(request, response)) {
                return;
            }
            String ref = request.getParameter(REFERENCE);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PUBLISH_ID, dsbPublishId);
            params.put(REFERENCE, ref);
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_PUBLISH_DSB_REF_INFO_METHOD, (Object[])new Object[]{params});
            if (resultMap.containsKey("errorCode")) {
                String errorCode = resultMap.get("errorCode").toString();
                String errorMessage = resultMap.get(ERROR_MESSAGE).toString();
                this.handlerError(request, response, errorCode, errorMessage);
                return;
            }
            Map data = (Map)resultMap.get("data");
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_PUBLISH_DASHBOARD_ANALYSIS_HTML);
            String tag = request.getParameter(TAG);
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            String refUid = (String)data.get(REFERENCE_UUID);
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(DSB_PUBLISH_ID, dsbPublishId);
            safetyURL.appendParamToUrl(REFERENCE, ref);
            safetyURL.appendParamToUrl(REFERENCE_UUID, refUid);
            String schemaTag = (String)data.get(REF_PK);
            safetyURL.appendParamToUrl(SCHEMA_TAG, schemaTag);
            String themeId = (String)data.get(THEME_Id);
            String themeName = (String)data.get(THEME_NAME);
            safetyURL.appendParamToUrl(THEME_Id, themeId);
            safetyURL.appendParamToUrl(THEME_NAME, themeName);
            String bizTag = (String)data.get(BIZ_TAG);
            safetyURL.appendParamToUrl(BIZ_TAG, bizTag);
            String publishSourceType = (String)data.get(PUBLISH_SOURCE_TYPE);
            safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
            String haveToCarryData = (String)data.get(HAVE_TO_CARRY_DATA);
            safetyURL.appendParamToUrl(HAVE_TO_CARRY_DATA, haveToCarryData);
            String isPreset = (String)data.get(IS_PRESET);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            String publishTargetType = (String)data.get(PUBLISH_TARGET_TYPE);
            safetyURL.appendParamToUrl(PUBLISH_TARGET_TYPE, publishTargetType);
            String publishId = (String)data.get(PUBLISH_ID);
            safetyURL.appendParamToUrl(PUBLISH_ID, publishId);
            String timedPush = request.getParameter(EMAIL_TIMED_PUSH_SCENE);
            safetyURL.appendParamToUrl(EMAIL_TIMED_PUSH_SCENE, timedPush);
            safetyURL.appendParamToUrl(OPEN_FROM, request.getParameter(OPEN_FROM));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMapManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)CHECK_MAP_PERMISSION, (Object[])new Object[0]);
        if (resultMap.containsKey("errorCode")) {
            this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
            return;
        }
        Boolean haveAuthority = (Boolean)resultMap.get("data");
        if (!haveAuthority.booleanValue()) {
            this.handlerError(request, response, "noPermission", "");
        } else {
            try {
                QingAction.checkLicense();
                LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((String)MAP_HOME_PAGE_ID, (String)"\u5730\u56fe\u5e93\u9996\u9875", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), QING_MAP_MANAGE_HTML);
                safetyURL.sendRedirect(response);
            }
            catch (Exception e) {
                this.handlerExceptionForClosable(request, response, e);
            }
        }
    }

    public void doMapDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        String mapId = request.getParameter(MAP_ID);
        String isUser = request.getParameter(IS_USER);
        try {
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_MAP_DESIGNER_HTML);
            safetyURL.appendParamToUrl(MAP_ID, mapId);
            safetyURL.appendParamToUrl(IS_USER, isUser);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doImportQHFEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            String fileName = request.getParameter(FILE_NAME);
            Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)DO_IMPORT, (Object[])new Object[]{fileName});
            if (resultMap.containsKey("errorCode")) {
                String errorCode = resultMap.get("errorCode").toString();
                String errorMessage = String.valueOf(resultMap.get(ERROR_MESSAGE));
                this.handlerError(request, response, errorCode, errorMessage);
            } else {
                Map dataMap = (Map)resultMap.get("data");
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((String)IMPORT_QHF_ID, (String)"\u5168\u4fe1\u606f\u6a21\u677f\u5bfc\u5165", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), QING_QHF_HTML);
                safetyURL.appendParamToUrl(TAG, (String)dataMap.get(TAG));
                safetyURL.appendParamToUrl(SCENE_TYPE, (String)dataMap.get(SCENE_TYPE));
                safetyURL.sendRedirect(response);
            }
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doExhibitionQHFDmEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            this.sendRedirectToQHFDm(request, response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doExhibitionQHFPublishedDsbAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            String tag = request.getParameter(TAG);
            String dashboardUniqueId = request.getParameter(DASHBOARD_UNIQUE_ID);
            String ref = request.getParameter(REFERENCE);
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_QHF_PUBLISHED_DSB_ANALYSIS_HTML);
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(DASHBOARD_UNIQUE_ID, dashboardUniqueId);
            safetyURL.appendParamToUrl(REFERENCE, ref);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doManagementHandOverEntrance(HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getCurrentAppId(request.getParameter(APP_ID));
        Map resultMap = QingAction.handlerQingMServiceDispatcher((String)appId, (String)"QingService", (String)CHECK_HANDOVER_MANAGE_PERMISSION_METHOD, (Object[])new Object[0]);
        if (resultMap.containsKey("errorCode")) {
            this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
            return;
        }
        Boolean haveAuthority = (Boolean)resultMap.get("data");
        if (!haveAuthority.booleanValue()) {
            this.handlerError(request, response, "noHandOverPerm", Messages.getMLS((String)"noHandOverPerm", (String)"\u6ca1\u6709\u79fb\u4ea4\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS));
        } else {
            this.doCommonEntrance(request, response, QING_MANAGEMENT_HAND_OVER_HTML);
        }
    }

    public void doNocodeCardEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        String cardName = request.getParameter(CARD_NAME);
        String cardId = request.getParameter(CARD_ID);
        String cardScene = request.getParameter(CARD_SCENE);
        String kdString = Messages.getMLS((String)QING_NOCODE_CARD_ID, (String)"\u65e0\u4ee3\u7801\u7edf\u8ba1\u5361\u7247-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
        AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, kdString + cardName, "qing-nocode-card.html");
        safetyURL.appendParamToUrl(CARD_ID, cardId);
        safetyURL.appendParamToUrl(CARD_NAME, cardName);
        if (cardScene != null) {
            safetyURL.appendParamToUrl(CARD_SCENE, cardScene);
        }
        try {
            String tag = UUID.randomUUID().toString();
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e2) {
            RemoteCallFailException e2;
            if (!(e2 instanceof AbstractQingException)) {
                e2 = new RemoteCallFailException((Throwable)e2);
            }
            safetyURL.appendParamToUrl("errorCode", "" + ((AbstractQingException)e2).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e2.getMessage());
            safetyURL.appendParamToUrl(CARD_NAME, cardName);
            try {
                safetyURL.sendRedirect(response);
            }
            catch (IOException e1) {
                LogUtil.error((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private void sendRedirectToQHFDm(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tag = request.getParameter(TAG);
        String title = request.getParameter(TITLE);
        AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_QHF_DM_HTML);
        safetyURL.appendParamToUrl(TAG, tag);
        safetyURL.sendRedirect(response);
    }

    private final void handlerLappException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        LogUtil.error((String)e.getMessage(), (Throwable)e);
        try {
            String errorURL = this.getQingErrorUrl();
            AbstractQingAction.ISafetyURL safetyURL = this.createLappSafetyURL(request, Messages.getMLS((String)ERROR_PAGE_ID, (String)"\u9519\u8bef\u9875\u9762", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), errorURL);
            if (!(e instanceof AbstractQingException)) {
                e = new IntegratedRuntimeException(e);
            }
            safetyURL.appendParamToUrl("errorCode", "" + ((AbstractQingException)e).getErrorCode());
            safetyURL.appendParamToUrl(ERROR_MESSAGE, e.getMessage());
            safetyURL.sendRedirect(response);
        }
        catch (IOException e1) {
            LogUtil.error((String)e1.getMessage(), (Throwable)e1);
        }
    }

    private final Map<String, Object> getRuntimePublishInfoAndCheckPerm(HttpServletRequest request, HttpServletResponse response) {
        byte[] result;
        String res;
        Map resultMap;
        String publishId = request.getParameter(PUBLISH_ID);
        String appId = request.getParameter(APP_ID);
        if (appId == null) {
            appId = "qing";
        }
        if ((resultMap = (Map)JsonUtil.decodeFromString((String)(res = new String(result = (byte[])QingMServiceDispatcher.dispatch((String)appId, (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{publishId}), Charset.forName("utf-8"))), Map.class)).containsKey("errorCode")) {
            ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
            this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            resultMap = null;
        }
        return resultMap;
    }

    protected final AbstractQingAction.ISafetyURL createLappSafetyURL(HttpServletRequest request, String title, String targetURL) {
        String path = System.getProperty("qing.lightapp.publishurl");
        return this.createSafetyURL(request, title, targetURL, path);
    }

    public void doMacroDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getCurrentAppId(request.getParameter(APP_ID));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(APP_ID, appId);
        Map resultMap = QingAction.handlerQingMServiceDispatcher((String)appId, (String)"QingService", (String)CHECK_MACRO_PERMISSION_METHOD, (Object[])new Object[]{params});
        if (resultMap.containsKey("errorCode")) {
            this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
            return;
        }
        Boolean haveAuthority = (Boolean)resultMap.get("data");
        if (!haveAuthority.booleanValue()) {
            this.handlerError(request, response, "noPermission", "");
        } else {
            this.doCommonEntrance(request, response, QING_MACRO_DESIGNER_HTML);
        }
    }

    public void doResourceStatisticsEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_RESOURCE_STATISTICS_HTMl);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doDBManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getCurrentAppId(request.getParameter(APP_ID));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(APP_ID, appId);
        Map resultMap = QingAction.handlerQingMServiceDispatcher((String)appId, (String)"QingService", (String)CHECK_DBMANAGE_PERMISSION_METHOD, (Object[])new Object[]{params});
        if (resultMap.containsKey("errorCode")) {
            this.handlerError(request, response, resultMap.get("errorCode").toString(), "");
            return;
        }
        Boolean haveAuthority = (Boolean)resultMap.get("data");
        if (!haveAuthority.booleanValue()) {
            this.handlerError(request, response, "noPermission", "");
        } else {
            this.doCommonEntrance(request, response, QING_DB_MANAGE_HTML);
        }
    }

    public void doImageLibEntrance(HttpServletRequest request, HttpServletResponse response) {
        this.doCommonEntrance(request, response, QING_IMAGE_LIBRARY_HTML);
    }

    private void doCommonEntrance(HttpServletRequest request, HttpServletResponse response, String htmlName) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String appId = request.getParameter(APP_ID);
            String string = appId = StringUtils.isBlank((CharSequence)appId) ? "qing" : appId;
            if (QING_REPORT_APPID.equals(appId)) {
                QingAction.checkQingReportLicense();
                LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            } else if (QING_MODELER_APPID.equals(appId)) {
                QingAction.checkQingModelerLicense();
            } else {
                QingAction.checkLicense();
                LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            }
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, htmlName);
            if (QING_MANAGEMENT_HAND_OVER_HTML.equals(htmlName)) {
                String pageId = request.getParameter(PAGE_ID);
                safetyURL.appendParamToUrl(PAGE_ID, pageId);
            }
            safetyURL.appendParamToUrl(APP_ID, appId);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doGalleryEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            String title = request.getParameter(TITLE);
            String isGroup = request.getParameter(GALLERY_IS_GROUP);
            String isEntrance = request.getParameter(IS_GALLERY_ENTRANCE);
            String resourceId = request.getParameter(GALLERY_RESOURCE_ID);
            String name = request.getParameter(GALLERY_NAME);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, isEntrance == null ? QING_GALLERY_CLOUD_HTMl : QING_GALLERY_CLOUD_ENTRANCE_HTMl);
            safetyURL.appendParamToUrl(GALLERY_HOME_URL, SystemPropertyUtil.getString((String)QING_GALLERY_URL_KEY, (String)QING_GALLERY_URL));
            safetyURL.appendParamToUrl(GALLERY_RESOURCE_ID, resourceId);
            safetyURL.appendParamToUrl(GALLERY_IS_GROUP, isGroup);
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                safetyURL.appendParamToUrl(GALLERY_NAME, name);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doOfficialArticleEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            String appID = request.getParameter(APP_ID);
            if (QING_REPORT_APPID.equals(appID)) {
                QingAction.checkQingReportLicense();
            } else {
                QingAction.checkLicense();
            }
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String docIdType = request.getParameter(DOC_ID_TYPE);
            String docType = request.getParameter(DOC_ID);
            String host = SystemPropertyUtil.getString((String)QING_ARTICLE_URL_KEY, (String)QING_ARTICLE_URL);
            String articleUrl = host + "/qing-releasenote/officialArticleUrlEntrance.do";
            articleUrl = URLUtil.appendParamToUrl((String)articleUrl, (String)DOC_ID_TYPE, (String)docIdType);
            if (null != docType) {
                articleUrl = URLUtil.appendParamToUrl((String)articleUrl, (String)DOC_ID, (String)docType);
            }
            if (null != appID) {
                articleUrl = URLUtil.appendParamToUrl((String)articleUrl, (String)PRODUCT_ID, (String)appID);
            }
            response.sendRedirect(articleUrl);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    private boolean isLappPrivateEntrance(HttpServletRequest request) {
        String isQingLightAppShare = request.getParameter("qingLightAppShare");
        String publishId = request.getParameter(PUBLISH_ID);
        String accountIdsStr = System.getProperty("qing.lightapp.private.accountids");
        boolean isPrivate = false;
        if (StringUtils.isNotBlank((CharSequence)accountIdsStr)) {
            String[] accountIds = accountIdsStr.split(",");
            RequestContext requestContext = RequestContext.get();
            String currentAccountId = requestContext.getAccountId();
            for (String acccountId : accountIds) {
                if (!currentAccountId.equals(acccountId)) continue;
                isPrivate = true;
            }
        }
        return isPrivate && (StringUtils.isBlank((CharSequence)publishId) || TRUE.equals(isQingLightAppShare));
    }

    private void doLappPrivateEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String appType = request.getParameter(APP_TYPE);
            String requestUrl = request.getRequestURI() + "?" + request.getQueryString();
            if (requestUrl.contains(SHARING_TARGET_ID)) {
                String li = request.getParameter(LICENSE);
                String analysisId = request.getParameter("id");
                if (!(li = SphixUtil.aa((String)li)).startsWith(analysisId)) {
                    throw new InvalidCipherTextException();
                }
                HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
                String serviceType = StringUtils.encodeToBase64String((String)"/sharing/getShareUrlById");
                parameterMap.put("serviceType", new String[]{serviceType});
                parameterMap.put("requestUrl", new String[]{requestUrl});
                if (StringUtils.isBlank((CharSequence)appType)) {
                    appType = "yzj";
                }
                parameterMap.put(APP_TYPE, new String[]{appType});
                Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)"doLappPrivateInfo", (Object[])new Object[]{parameterMap});
                String redirectUrl = (String)resultMap.get("data");
                if (redirectUrl.contains("errorCode")) {
                    String errorCode = URLUtil.getUrlParam((String)redirectUrl, (String)"errorCode");
                    this.handlerError(request, response, errorCode);
                    return;
                }
                response.sendRedirect(redirectUrl);
                return;
            }
            AbstractQingAction.ISafetyURL safetyURL = this.createLappSafetyURL(request, Messages.getMLS((String)LIGHTAPP_RESOURCE_ID, (String)"\u79fb\u52a8\u8f7b\u5e94\u7528-", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS), "qing-lightapp-private.html");
            safetyURL.appendParamToUrl(APP_TYPE, appType);
            safetyURL.appendParamToUrl(ACCESS_TOKEN, RequestContext.get().getGlobalSessionId());
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerLappException(request, response, e);
        }
    }

    public void doLappPrivateInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map parameterMap = request.getParameterMap();
        byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)"qing", (String)"QingService", (String)"doLappPrivateInfo", (Object[])new Object[]{parameterMap});
        QingAction.writeSuccessJsonResponse((byte[])result, (HttpServletResponse)response, (boolean)true);
    }

    public void loadLappImg(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileType = request.getParameter("fileType");
        if ("lapp-thumbnail".equals(fileType)) {
            this.loadImg(request, response);
        }
    }

    public void doAccessAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        if (this.isUpgrading(request, response)) {
            return;
        }
        try {
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_ACCESSANALYSIS_HTML);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    private final void handlerExtreportError(HttpServletRequest request, HttpServletResponse response, String extReportName, String errorCode, String errorMessage) {
        try {
            String exhibitionScene = request.getParameter(EXHIBITION_SCENE);
            if (exhibitionScene != null && (exhibitionScene.toLowerCase().contains("widget") || exhibitionScene.toLowerCase().contains("card"))) {
                AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, extReportName, EXTREPORT_RUNTIME_HTML_CARD);
                safetyURL.appendParamToUrl(APP_ID, QING_REPORT_APPID);
                safetyURL.appendParamToUrl(CARD_NAME, request.getParameter(EXTREPORT_NAME));
                safetyURL.appendParamToUrl(EXHIBITION_SCENE, request.getParameter(EXHIBITION_SCENE));
                safetyURL.appendParamToUrl("errorCode", errorCode);
                safetyURL.appendParamToUrl(ERROR_MESSAGE, errorMessage);
                String extreportWidgetId = request.getParameter(EXTREPORT_WIDGET_ID);
                if (extreportWidgetId != null) {
                    safetyURL.appendParamToUrl(EXTREPORT_WIDGET_ID, extreportWidgetId);
                }
                safetyURL.sendRedirect(response);
            } else if (!errorMessage.equals("")) {
                this.handlerError(request, response, errorCode, errorMessage);
            } else {
                this.handlerError(request, response, errorCode);
            }
        }
        catch (IOException e1) {
            LogUtil.error((String)e1.getMessage(), (Throwable)e1);
        }
    }

    public void doFontLibEntrance(HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getCurrentAppId(request.getParameter(APP_ID));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(APP_ID, appId);
        Map resultMap = QingAction.handlerQingMServiceDispatcher((String)appId, (String)"QingService", (String)CHECK_FONT_LIBRARY_PERMISSION_METHOD, (Object[])new Object[]{params});
        if (resultMap.containsKey("errorCode")) {
            this.handlerError(request, response, resultMap.get("errorCode").toString(), resultMap.get("errorStackMessage").toString());
            return;
        }
        Boolean isAuthorized = (Boolean)resultMap.get("data");
        if (isAuthorized.booleanValue()) {
            this.doCommonEntrance(request, response, QING_FONT_LIBRARY_HTML);
        } else {
            this.handlerError(request, response, "noPermission", "Not font library manage permission...");
        }
    }

    public void doFontLibDetail(HttpServletRequest request, HttpServletResponse response) {
        try {
            String title = request.getParameter("TITLE");
            String fontId = request.getParameter("fontId");
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_FONT_LIBRARY_DETAIL);
            safetyURL.appendParamToUrl("fontId", fontId);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void loadFontFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        QingIntegratedContext qingContext = new QingIntegratedContext();
        QingAction.loadFontFile((QingContext)qingContext, (String)"qing", (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void loadFontLibCss(HttpServletRequest request, HttpServletResponse response) throws IOException {
        QingIntegratedContext qingContext = new QingIntegratedContext();
        QingAction.loadFontLibCss((QingContext)qingContext, (String)"qing", (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void loadFontLibJs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        QingIntegratedContext qingContext = new QingIntegratedContext();
        QingAction.loadFontLibJs((QingContext)qingContext, (String)"qing", (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void doWorkbenchEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String title = Messages.getMLS((String)"dataWorkbench", (String)"\u6570\u636e\u5de5\u4f5c\u53f0", (Messages.ProjectName)Messages.ProjectName.QING_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_WORKBENCH_HTML);
            safetyURL.appendParamToUrl("showAssistantEntrance", SystemPropertyUtil.getString((String)"qing.ai.analysis.dev", (String)FALSE));
            safetyURL.appendParamToUrl("showAssistantPanel", TRUE);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void doMetricSquareEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingAction.checkLicense();
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_METRIC_SQUARE_HTML);
            safetyURL.appendParamToUrl(METRIC_LIB_ID, request.getParameter(METRIC_LIB_ID));
            safetyURL.appendParamToUrl(TAG, UUID.randomUUID().toString());
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doWorkbenchWidgetAnalysisEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingAction.checkLicense();
            LoginUtil.checkReplicatedLogin((QingContext)new QingIntegratedContext());
            String refType = request.getParameter(REFTYPE);
            if ("appmenu_rpt".equals(refType) || "qingcenter_rpt".equals(refType)) {
                QingAction.checkQingReportLicense();
            }
            if ("metric_library".equals(refType)) {
                QingAction.checkQingModelerLicense();
            }
            String title = request.getParameter(TITLE);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_WORKBECNH_WIDGET_ANALYSIS_HTML);
            String widgetBizId = request.getParameter(WIDGET_BIZ_ID);
            if ("appmenu_qing".equals(refType) || "card".equals(refType) || "qingcenter_qing".equals(refType)) {
                Map resultMap = QingAction.handlerQingMServiceDispatcher((String)"qing", (String)"QingService", (String)GET_RUNTIME_PUBLISH_INFO, (Object[])new Object[]{widgetBizId});
                if (resultMap.containsKey("errorCode")) {
                    String errorCode = resultMap.get("errorCode").toString();
                    this.handlerError(request, response, errorCode, "");
                    return;
                }
                Map data = (Map)resultMap.get("data");
                String publishSourceType = data.get(PUBLISH_SOURCE_TYPE).toString();
                safetyURL.appendParamToUrl(PUBLISH_SOURCE_TYPE, publishSourceType);
            }
            safetyURL.appendParamToUrl(REFTYPE, refType);
            safetyURL.appendParamToUrl(WIDGET_BIZ_ID, widgetBizId);
            safetyURL.appendParamToUrl(WORKBENCH_ID, request.getParameter(WORKBENCH_ID));
            safetyURL.appendParamToUrl(OPEN_FROM, request.getParameter(OPEN_FROM));
            String tag = request.getParameter(TAG);
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            safetyURL.appendParamToUrl(TAG, tag);
            safetyURL.appendParamToUrl(BIZ_TAG, widgetBizId);
            safetyURL.appendParamToUrl(SCHEMA_ADDITIONAL_TAG, request.getParameter(SCHEMA_ADDITIONAL_TAG));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doLogException(Throwable e) {
        if (e instanceof QingLicenseException) {
            LogUtil.info((String)("QingLicenseException occurred: " + e.getMessage()));
        } else {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private static class EncryptAcessTokenURLAppender {
        private EncryptAcessTokenURLAppender() {
        }

        public static void appendParamToUrl(AbstractQingAction.ISafetyURL baseURL) {
            try {
                String accessToken = RequestContext.get().getGlobalSessionId();
                String value = accessToken + "~~" + System.currentTimeMillis();
                Base64.Encoder encoder = Base64.getEncoder();
                String encodeValue = encoder.encodeToString(value.getBytes("utf-8"));
                baseURL.appendParamToUrl(QingAction.TOKEN_PREFIX, encodeValue);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

