/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.watermark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.watermark.WaterMark;
import kd.bos.form.watermark.WaterMarkCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.utils.SearchResult;
import kd.bos.utils.WaterMarkLoadUtils;
import kd.bos.utils.WaterMarkSearchUtil;

public class WaterMarkPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String WM_TEXT_TYPE = "texttype";
    private static final String WM_TEXT = "text";
    private static final String WM_PICTURE = "picture";
    private static final String WM_TYPE = "type";
    private static final String WM_LEVEL = "level";
    private static final String WM_OBJECT = "object";
    private static final String WM_OBJECTID = "objectid";
    private static final String WM_FONTSIZE = "fontsize";
    private static final String WM_COLOR = "color";
    private static final String WM_GLOBALALPHA = "globalalpha";
    private static final String APPLY_RANGE = "applyrange";
    private static final String WATERMARK_RANGE = "watermarkrange";
    private static final String ADD_PREVIEW_WATERMARK = "addpreviewwatermark";
    private static final String ADD_DOWNLOAD_WATERMARK = "adddownloadwatermark";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_DELETE = "bar_delete";
    private static final String PICFORM_ID = "ide_pictureselector";
    private static final String KEY_VALUE = "value";
    private static final String KEY_TREE = "paratree";
    private static final String KEY_SEARCH = "searchap";
    private static final String CLOUD = "cloud";
    private static final String APP = "app";
    private static final String ROOT = "root";
    private static final String BOS_WATERMARK = "bos_watermark";
    private static final String BOS_WATERMARK_LANGUAGE = "bos-watermark";
    private static final String TREE_CACHE = "treenodecache";
    private static final String BOS_WATERMARK_PROJECT = "bos-watermark";
    private static final String WM_PLUGIN = "plugin";
    private static final String PAGE_LABEL = "pagelabel";
    private static final String ALL_PAGE_LABEL = "allpagelabel";
    private static final String BILL_PAGE_LABEL = "billpagelabel";
    private static final ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{WM_PICTURE, WM_PLUGIN});
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setTips();
        TreeNode root = this.buildRootNode();
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE);
        tree.addNode(root);
        tree.focusNode(root);
        tree.treeNodeClick("", root.getId());
        Container flexPanel = (Container)this.getControl("livepreviewpanel");
        ArrayList items = new ArrayList();
        HashMap<String, String> livepreview = new HashMap<String, String>();
        livepreview.put("key", "livepreview");
        livepreview.put("id", "livepreview");
        livepreview.put(WM_TYPE, "livepreview");
        items.add(livepreview);
        flexPanel.addControls(items);
        this.initValue(root);
    }

    public void afterBindData(EventObject e) {
        this.updateWaterMarkPreview();
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "picture": {
                this.showPicture();
                break;
            }
            case "plugin": {
                this.showPlugin(key);
                break;
            }
        }
    }

    private void showPlugin(String key) {
        Object value = this.getModel().getValue(key);
        String formId = this.getView().getFormShowParameter().getFormId();
        List<?> plugins = this.getPluginsArray(value);
        FormShowParameter formShowParameter = this.buildShowParams(formId, plugins, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(formShowParameter);
    }

    private void showPicture() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(PICFORM_ID);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, WM_PICTURE);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private List<?> getPluginsArray(Object val) {
        List plugins = new ArrayList();
        if (val != null && StringUtils.isNotEmpty((CharSequence)val.toString())) {
            plugins = SerializationUtils.fromJsonStringToList((String)val.toString(), Map.class);
        }
        return plugins;
    }

    private FormShowParameter buildShowParams(String formId, List<?> plugins, CloseCallBack callback) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("ide_plugins");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCustomParam(KEY_VALUE, plugins);
        showParam.setCustomParam("formId", (Object)formId);
        showParam.setCloseCallBack(callback);
        return showParam;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && "donothing_delete".equals(operateKey)) {
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u914d\u7f6e\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u914d\u7f6e\uff1f", (String)"WaterMarkPlugin_2", (String)"bos-watermark", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_delete", (IFormPlugin)this);
            this.getView().showConfirm(msg, options, ConfirmTypes.Save, confirmCallBacks);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (BAR_SAVE.equals(evt.getItemKey())) {
            this.saveSetting();
            return;
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree;
        String nodeId = (String)evt.getNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
        TreeNode node = root.getTreeNode(nodeId, 5);
        if (node == null) {
            return;
        }
        if (CLOUD.equals(node.getData()) && node.getChildren().isEmpty()) {
            WaterMarkLoadUtils.loadAppNodes(node);
            tree = (TreeView)this.getView().getControl(KEY_TREE);
            tree.addNode(node);
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        }
        if (APP.equals(node.getData()) && node.getChildren().isEmpty()) {
            WaterMarkLoadUtils.loadEntityNodes(node);
            tree = (TreeView)this.getView().getControl(KEY_TREE);
            tree.addNode(node);
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        }
        this.initValue(node);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u76f8\u5173\u7ed3\u679c\u3002", (String)"WaterMarkPlugin_4", (String)"bos-watermark", (Object[])new Object[0]));
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE);
        WaterMarkSearchUtil waterMarkSearchUtil = new WaterMarkSearchUtil();
        String searchUtilJson = this.getPageCache().get("searchUtil");
        if (searchUtilJson != null) {
            waterMarkSearchUtil = (WaterMarkSearchUtil)SerializationUtils.fromJsonString((String)searchUtilJson, WaterMarkSearchUtil.class);
        } else {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
            waterMarkSearchUtil.setRoot(root);
        }
        SearchResult searchResult = waterMarkSearchUtil.search(searchText);
        this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)waterMarkSearchUtil.getRoot()));
        this.getPageCache().put("searchUtil", SerializationUtils.toJsonString((Object)waterMarkSearchUtil));
        if (searchResult.isSuccess()) {
            tree.updateNode(waterMarkSearchUtil.getRoot());
            this.clickNode(tree, waterMarkSearchUtil.getRoot(), searchResult.getData());
            return;
        }
        if (searchResult.getErrorCode() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u76f8\u5173\u7ed3\u679c\u3002", (String)"WaterMarkPlugin_4", (String)"bos-watermark", (Object[])new Object[0]));
            return;
        }
        if (searchResult.getErrorCode() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22\u3002", (String)"WaterMarkPlugin_3", (String)"bos-watermark", (Object[])new Object[0]));
            waterMarkSearchUtil.clear(searchText);
            this.getPageCache().put("searchUtil", SerializationUtils.toJsonString((Object)waterMarkSearchUtil));
            return;
        }
    }

    private void clickNode(TreeView tree, TreeNode root, TreeNode node) {
        tree.focusNode(node);
        tree.treeNodeClick(node.getParentid(), node.getId());
        String id = node.getParentid();
        List childPathNodes = root.getChildPathNodes(id);
        for (TreeNode pathNode : childPathNodes) {
            tree.expand(pathNode.getId());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || null == returnData) {
            return;
        }
        Map value = (Map)returnData;
        switch (actionId) {
            case "picture": {
                this.callBackPicture(value);
                break;
            }
            case "plugin": {
                this.callBackPlugin(actionId, value);
                break;
            }
        }
    }

    private void callBackPlugin(String actionId, Map<String, Object> dataMap) {
        List plugins = (List)dataMap.get(KEY_VALUE);
        if (!CollectionUtils.isEmpty((Collection)plugins)) {
            this.getModel().setValue(actionId, (Object)SerializationUtils.toJsonString((Object)plugins));
        }
    }

    private void callBackPicture(Map<String, Object> value) {
        String picurl = (String)value.get(KEY_VALUE);
        if (StringUtils.isNotEmpty((CharSequence)picurl)) {
            this.getModel().setValue(WM_PICTURE, (Object)picurl);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            this.deleteSetting();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (WM_TYPE.equals(proName)) {
            this.setVisible();
        }
        if (WM_TEXT_TYPE.equals(proName)) {
            this.setVisible();
        }
        if (!(WM_OBJECT.equals(proName) || WM_OBJECTID.equals(proName) || WM_LEVEL.equals(proName))) {
            this.updateWaterMarkPreview();
        }
    }

    private void clearPreMsg() {
        IDataModel model = this.getModel();
        model.setValue(WM_TYPE, null);
        model.setValue(WM_TEXT, null);
        model.setValue(WM_FONTSIZE, (Object)"12px");
        model.setValue(WM_TEXT_TYPE, (Object)"3");
        model.setValue(WM_COLOR, (Object)"#333");
        model.setValue(WM_GLOBALALPHA, (Object)10);
        model.setValue(WM_PICTURE, null);
        model.setValue(WM_PLUGIN, null);
        model.setValue(ADD_PREVIEW_WATERMARK, (Object)true);
        model.setValue(ADD_DOWNLOAD_WATERMARK, (Object)false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    private void saveSetting() {
        String type = (String)this.getModel().getValue(WM_TYPE);
        String level = (String)this.getModel().getValue(WM_LEVEL);
        String objectId = (String)this.getModel().getValue(WM_OBJECTID);
        String textType = (String)this.getModel().getValue(WM_TEXT_TYPE);
        String text = (String)this.getModel().getValue(WM_TEXT);
        String picture = (String)this.getModel().getValue(WM_PICTURE);
        String fontsize = (String)this.getModel().getValue(WM_FONTSIZE);
        String color = (String)this.getModel().getValue(WM_COLOR);
        String plugin = (String)this.getModel().getValue(WM_PLUGIN);
        int globalalpha = (Integer)this.getModel().getValue(WM_GLOBALALPHA);
        boolean addPreviewWatermark = (Boolean)this.getModel().getValue(ADD_PREVIEW_WATERMARK);
        boolean addDownloadWatermark = (Boolean)this.getModel().getValue(ADD_DOWNLOAD_WATERMARK);
        QFilter[] filters = new QFilter[]{new QFilter(WM_LEVEL, "=", (Object)level), new QFilter(WM_OBJECTID, "=", (Object)objectId)};
        Map oldObjects = BusinessDataServiceHelper.loadFromCache((String)BOS_WATERMARK, (String)"id", (QFilter[])filters);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_WATERMARK);
        if (oldObjects != null && oldObjects.size() > 0) {
            Object[] oldIds = oldObjects.keySet().toArray();
            BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])oldIds);
        }
        DynamicObject newObject = new DynamicObject((DynamicObjectType)entityType);
        newObject.set(WM_LEVEL, (Object)level);
        newObject.set(WM_OBJECTID, (Object)objectId);
        newObject.set(WM_TEXT_TYPE, (Object)textType);
        newObject.set(WM_TEXT, (Object)text);
        newObject.set(WM_PICTURE, (Object)picture);
        newObject.set(WM_TYPE, (Object)type);
        newObject.set(WM_FONTSIZE, (Object)fontsize);
        newObject.set(WM_COLOR, (Object)color);
        newObject.set(WM_GLOBALALPHA, (Object)globalalpha);
        newObject.set(WM_PLUGIN, (Object)plugin);
        newObject.set(ADD_PREVIEW_WATERMARK, (Object)addPreviewWatermark);
        newObject.set(ADD_DOWNLOAD_WATERMARK, (Object)addDownloadWatermark);
        BusinessDataWriter.save((IDataEntityType)entityType, (Object[])new Object[]{newObject});
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        WaterMarkCache.deleteCache(tenantId, accountId, level, objectId);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
        TreeNode node = root.getTreeNode(objectId, 5);
        this.initValue(node);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_DELETE});
        this.createAppLog(new MultiLangEnumBridge("\u4fdd\u5b58", "WaterMarkPlugin_7", "bos-watermark"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "WaterMarkPlugin_8", "bos-watermark"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WaterMarkPlugin_0", (String)"bos-watermark", (Object[])new Object[0]), Integer.valueOf(1000));
    }

    private void createAppLog(MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge) {
        OpLogAppInfo appLogInfo = this.buildAppInfo(opNameBridge, opDescBridge);
        service.addLog((AppLogInfo)appLogInfo);
    }

    private OpLogAppInfo buildAppInfo(MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge) {
        String formId = this.getView().getFormShowParameter().getFormId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(WaterMarkPlugin.getBizAppId(this.getView(), this.getView().getEntityId()));
        appLogInfo.setBizObjID(formId);
        appLogInfo.setOpName("watermarkOp", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, new String[0]);
        return appLogInfo;
    }

    private static String getBizAppId(IFormView view, String entityNumber) {
        String appId = null;
        String appNumber = view.getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            return BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        if (StringUtils.isEmpty(appId)) {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            appId = abstractMetadata.getBizappId();
        }
        return appId;
    }

    private void deleteSetting() {
        String level = (String)this.getModel().getValue(WM_LEVEL);
        String objectId = (String)this.getModel().getValue(WM_OBJECTID);
        QFilter[] filters = new QFilter[]{new QFilter(WM_LEVEL, "=", (Object)level), new QFilter(WM_OBJECTID, "=", (Object)objectId)};
        Map oldObjects = BusinessDataServiceHelper.loadFromCache((String)BOS_WATERMARK, (String)"id", (QFilter[])filters);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_WATERMARK);
        if (oldObjects != null && oldObjects.size() > 0) {
            Object[] oldIds = oldObjects.keySet().toArray();
            BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])oldIds);
        }
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        WaterMarkCache.deleteCache(tenantId, accountId, level, objectId);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
        TreeNode node = root.getTreeNode(objectId, 5);
        this.initValue(node);
        this.createAppLog(new MultiLangEnumBridge("\u5220\u9664", "WaterMarkPlugin_10", "bos-watermark"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "WaterMarkPlugin_9", "bos-watermark"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WaterMarkPlugin_5", (String)"bos-watermark", (Object[])new Object[0]), Integer.valueOf(1000));
    }

    private void initValue(TreeNode node) {
        this.getPageCache().put("initValueEnd", "false");
        this.getModel().setValue(WM_LEVEL, node.getData());
        this.getModel().setValue(WM_OBJECT, (Object)node.getText());
        this.getModel().setValue(WM_OBJECTID, (Object)node.getId());
        this.generateRangeTips(node);
        QFilter[] filters = new QFilter[]{new QFilter(WM_LEVEL, "=", node.getData()), new QFilter(WM_OBJECTID, "=", (Object)node.getId())};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_WATERMARK, (String)"texttype,text,picture,type,fontsize,color,globalalpha,plugin,addpreviewwatermark,adddownloadwatermark", (QFilter[])filters);
        if (object != null && StringUtils.isNotBlank((Object)object.get(WM_TYPE))) {
            this.getModel().setValue(WM_TYPE, (Object)object.getString(WM_TYPE));
            this.getModel().setValue(WM_TEXT_TYPE, (Object)object.getString(WM_TEXT_TYPE));
            this.getModel().setValue(WM_TEXT, (Object)object.getString(WM_TEXT));
            this.getModel().setValue(WM_PICTURE, (Object)object.getString(WM_PICTURE));
            if (StringUtils.isNotBlank((CharSequence)object.getString(WM_FONTSIZE))) {
                this.getModel().setValue(WM_FONTSIZE, (Object)object.getString(WM_FONTSIZE));
            }
            if (StringUtils.isNotBlank((CharSequence)object.getString(WM_PLUGIN))) {
                this.getModel().setValue(WM_PLUGIN, (Object)object.getString(WM_PLUGIN));
            }
            if (StringUtils.isNotBlank((CharSequence)object.getString(WM_COLOR))) {
                this.getModel().setValue(WM_COLOR, (Object)object.getString(WM_COLOR));
            }
            if (object.getInt(WM_GLOBALALPHA) > 0) {
                this.getModel().setValue(WM_GLOBALALPHA, (Object)object.getInt(WM_GLOBALALPHA));
            }
            this.getModel().setValue(ADD_PREVIEW_WATERMARK, (Object)object.getBoolean(ADD_PREVIEW_WATERMARK));
            this.getModel().setValue(ADD_DOWNLOAD_WATERMARK, (Object)object.getBoolean(ADD_DOWNLOAD_WATERMARK));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_DELETE});
        } else {
            this.clearPreMsg();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_DELETE});
        }
        this.setVisible();
        this.getPageCache().put("initValueEnd", "true");
        this.updateWaterMarkPreview();
    }

    private void generateRangeTips(TreeNode node) {
        if (CLOUD.equals(node.getData()) || APP.equals(node.getData())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ALL_PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PAGE_LABEL});
        } else if (ROOT.equals(node.getData())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ALL_PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_PAGE_LABEL});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BILL_PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ALL_PAGE_LABEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PAGE_LABEL});
        }
        ((Label)this.getView().getControl(WATERMARK_RANGE)).setText(String.valueOf(node.getText()));
    }

    private void setVisible() {
        String type = (String)this.getModel().getValue(WM_TYPE);
        type = StringUtils.isNotEmpty((CharSequence)type) && "012345".contains(type) ? type : "0";
        String textType = (String)this.getModel().getValue(WM_TEXT_TYPE);
        textType = StringUtils.isNotEmpty((CharSequence)textType) && "123".contains(textType) ? textType : "3";
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_TEXT_TYPE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_TEXT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_PICTURE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_FONTSIZE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_COLOR});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_PLUGIN});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_GLOBALALPHA});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{APPLY_RANGE});
        if ("0".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_GLOBALALPHA});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipsflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{APPLY_RANGE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipsflex"});
        }
        if ("1".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_TEXT_TYPE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_FONTSIZE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_COLOR});
            if ("1".equals(textType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_TEXT});
            }
            return;
        }
        if ("2".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_PICTURE});
            return;
        }
        if ("34".contains(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_PICTURE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_TEXT_TYPE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_FONTSIZE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_COLOR});
            if ("1".equals(textType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_TEXT});
            }
            return;
        }
        if ("5".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{WM_PLUGIN});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{WM_GLOBALALPHA});
        }
    }

    private TreeNode buildRootNode() {
        TreeNode root = new TreeNode();
        root.setId("rootNode");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"WaterMarkPlugin_1", (String)"bos-watermark", (Object[])new Object[0]));
        root.setData((Object)ROOT);
        root.setParentid("");
        root.setIsOpened(true);
        WaterMarkLoadUtils.loadCloudNodes(root);
        return root;
    }

    private void updateWaterMarkPreview() {
        boolean updataWaterMark = "false".equals(this.getPageCache().get("initValueEnd"));
        if (updataWaterMark) {
            return;
        }
        WaterMark waterMark = new WaterMark();
        if (this.getModel().getValue(WM_TYPE) != null) {
            waterMark.setType((String)this.getModel().getValue(WM_TYPE));
            waterMark.setText((String)this.getModel().getValue(WM_TEXT));
            waterMark.setFontSize((String)this.getModel().getValue(WM_FONTSIZE));
            waterMark.setGlobalAlpha(((Integer)this.getModel().getValue(WM_GLOBALALPHA)).intValue());
            waterMark.setColor((String)this.getModel().getValue(WM_COLOR));
            waterMark.setPicture((String)this.getModel().getValue(WM_PICTURE));
            waterMark.setTextType((String)this.getModel().getValue(WM_TEXT_TYPE));
            if ("5".equals(waterMark.getType())) {
                waterMark.setPlugin((String)this.getModel().getValue(WM_PLUGIN));
            }
            waterMark.setAddPreviewWatermark(((Boolean)this.getModel().getValue(ADD_PREVIEW_WATERMARK)).booleanValue());
            waterMark.setAddDownloadWatermark(((Boolean)this.getModel().getValue(ADD_DOWNLOAD_WATERMARK)).booleanValue());
            waterMark = WaterMarkCache.setWaterMarkText(waterMark);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("livepreview", "setWatermarkPreview", new Object[]{waterMark});
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView tree = (TreeView)treeNodeEvent.getSource();
        String nodeId = (String)treeNodeEvent.getNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_CACHE), TreeNode.class);
        TreeNode node = root.getTreeNode(nodeId, 5);
        if (node == null) {
            return;
        }
        Object data = node.getData();
        if (CLOUD.equals(data) && node.getChildren().isEmpty()) {
            WaterMarkLoadUtils.loadAppNodes(node);
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        }
        if (APP.equals(data) && node.getChildren().isEmpty()) {
            WaterMarkLoadUtils.loadEntityNodes(node);
            this.getPageCache().put(TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        }
        tree.addNodes(node.getChildren());
    }

    private void setTips() {
        if (ResManager.getLanguage().equals("zh-CN")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipsflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipsforen"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipsforen"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipsflex"});
        }
    }
}

