/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.utils.SearchResult;
import kd.bos.utils.WaterMarkLoadUtils;

public class WaterMarkSearchUtil
implements Serializable {
    private static final long serialVersionUID = 2022046614691331240L;
    private TreeNode root;
    private Queue<TreeNode> searchNodesQueue = new LinkedList<TreeNode>();
    private String oldSearchText;
    private boolean searched = false;
    private boolean loadedAllApp = false;
    private boolean searchedEmpty = false;

    public WaterMarkSearchUtil() {
    }

    public WaterMarkSearchUtil(TreeNode root) {
        this.root = root;
    }

    private void loadAllApp() {
        if (this.loadedAllApp) {
            return;
        }
        List cloudTreeNodes = this.root.getChildren();
        for (TreeNode cloudTreeNode : cloudTreeNodes) {
            WaterMarkLoadUtils.loadAppNodes(cloudTreeNode);
        }
        this.loadedAllApp = true;
    }

    private void collectSearchNodes(String searchText) {
        if (this.searched) {
            return;
        }
        this.searchCloud(searchText);
        this.searchApp(searchText);
        this.searchEntity(searchText);
        this.searched = true;
        this.searchedEmpty = this.searchNodesQueue.isEmpty();
    }

    public SearchResult search(String searchText) {
        SearchResult result = new SearchResult();
        if (!StringUtils.equals((CharSequence)searchText, (CharSequence)this.oldSearchText)) {
            this.clear(searchText);
        }
        TreeNode searchNode = null;
        searchNode = this.searchNodesQueue.poll();
        if (searchNode != null) {
            result.setSuccess(true).setData(searchNode);
            return result;
        }
        this.collectSearchNodes(searchText);
        searchNode = this.searchNodesQueue.poll();
        if (searchNode != null) {
            result.setSuccess(true).setData(searchNode);
            return result;
        }
        int errCode = this.searchedEmpty ? 1 : 0;
        result.setSuccess(false).setErrorCode(errCode);
        return result;
    }

    public void clear(String searchText) {
        this.searchNodesQueue.clear();
        this.oldSearchText = searchText;
        this.searched = false;
    }

    private void searchCloud(String searchText) {
        List cloudNodes = this.root.getChildren();
        if (cloudNodes == null || cloudNodes.isEmpty()) {
            return;
        }
        ArrayList searchedCloud = new ArrayList(10);
        this.root.getTreeNodeListByText(searchedCloud, searchText, 1);
        this.searchNodesQueue.addAll(searchedCloud);
    }

    private void searchApp(String searchText) {
        Map<String, Set<String>> searchAppMap = WaterMarkLoadUtils.queryBizappByName(searchText);
        ArrayList searchedAppNodes = new ArrayList(10);
        HashSet searchedAppIds = new HashSet(16);
        for (Map.Entry<String, Set<String>> entry : searchAppMap.entrySet()) {
            TreeNode cloudNode = this.root.getTreeNode(entry.getKey());
            List<TreeNode> nodes = WaterMarkLoadUtils.loadAppNodes(cloudNode);
            Set appIds = nodes.stream().map(child -> child.getId()).collect(Collectors.toSet());
            searchedAppIds.addAll(appIds);
        }
        this.root.getTreeNodeListByText(searchedAppNodes, searchText, 2);
        List collect = searchedAppNodes.stream().filter(appNode -> searchedAppIds.contains(appNode.getId())).collect(Collectors.toList());
        this.searchNodesQueue.addAll(collect);
    }

    private void searchEntity(String searchText) {
        Map<String, Set<String>> searchEntityMap = WaterMarkLoadUtils.queryEntityByText(searchText);
        ArrayList searchEntityNodes = new ArrayList(10);
        HashSet searchEntityIds = new HashSet(16);
        for (Map.Entry<String, Set<String>> entry : searchEntityMap.entrySet()) {
            String appId = entry.getKey();
            String cloudId = WaterMarkLoadUtils.searchCloudIdByAppId(appId);
            TreeNode cloudNode = this.root.getTreeNode(cloudId);
            if (cloudNode == null) {
                return;
            }
            WaterMarkLoadUtils.loadAppNodes(cloudNode);
            TreeNode appNode = cloudNode.getTreeNode(appId);
            WaterMarkLoadUtils.loadEntityNodes(appNode);
            searchEntityIds.addAll(entry.getValue());
        }
        this.root.getTreeNodeListByText(searchEntityNodes, searchText, 3);
        List collect = searchEntityNodes.stream().filter(entityNode -> searchEntityIds.contains(entityNode.getId())).collect(Collectors.toList());
        this.searchNodesQueue.addAll(collect);
    }

    private boolean containsText(TreeNode node, String searchText) {
        return node.getText().contains(searchText);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public String getOldSearchText() {
        return this.oldSearchText;
    }

    public void setOldSearchText(String oldSearchText) {
        this.oldSearchText = oldSearchText;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public void setSearched(boolean searched) {
        this.searched = searched;
    }

    public boolean isLoadedAllApp() {
        return this.loadedAllApp;
    }

    public void setLoadedAllApp(boolean loadedAllApp) {
        this.loadedAllApp = loadedAllApp;
    }

    public Queue<TreeNode> getSearchNodesQueue() {
        return this.searchNodesQueue;
    }

    public void setSearchNodesQueue(Queue<TreeNode> searchNodesQueue) {
        this.searchNodesQueue = searchNodesQueue;
    }

    public boolean isSearchedEmpty() {
        return this.searchedEmpty;
    }

    public void setSearchedEmpty(boolean searchedEmpty) {
        this.searchedEmpty = searchedEmpty;
    }
}

