/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.attachment.dto.AttachmentEntityRelation;
import kd.bos.svc.attachment.dto.BatchDownloadAttDto;
import kd.bos.svc.attachment.dto.LocationLevel;
import kd.bos.svc.attachment.dto.QueryRange;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.EncryptDownloadUtil;
import kd.bos.web.actions.utils.FilePremissionUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchDownloadAttachment
extends FormOperate
implements IConfirmCallBack,
ICloseCallBack {
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final String CONTINUE_DOWNLOAD = "continue_download";
    private static final String BILL_FORM_ID = "billFormId";
    private static final String BATCHDOWNLOAD_ATTDTOLIST = "batchDownloadAttDtoList";
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static Log log = LogFactory.getLog(BatchDownloadAttachment.class);

    protected OperationResult invokeOperation() {
        OperationResult operationResult = new OperationResult();
        if (!(this.getView() instanceof IListView)) {
            return null;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        boolean mergeRow = this.isMergeRow(billList);
        QueryRange queryRange = this.getQueryRange(billList.getEntityId(), this.getListSelectedData());
        ArrayList<BatchDownloadAttDto> batchDownloadAttDtoList = new ArrayList<BatchDownloadAttDto>(10);
        Map<String, String> billPkNumberMapping = this.queryBillPkNumberMapping(billList);
        if (!this.queryBatchDownloadAttDtoList(batchDownloadAttDtoList, billList, billPkNumberMapping, queryRange, mergeRow)) {
            return null;
        }
        String billName = billList.getEntityType().getDisplayName().getLocaleValue();
        String detailMsg = this.checkNoDataForSelect(batchDownloadAttDtoList, billPkNumberMapping, billName);
        this.showConfirm(mergeRow, queryRange, this.prepareConfirmCallBackListener(billList, batchDownloadAttDtoList), detailMsg);
        return operationResult;
    }

    private Map<String, String> queryBillPkNumberMapping(BillList billList) {
        List<Object> selectedPkList = this.getSelectedPkList(billList);
        QFilter queryDataFilter = new QFilter("id", "in", selectedPkList);
        Map billDataMap = BusinessDataServiceHelper.loadFromCache((String)billList.getEntityId(), (QFilter[])new QFilter[]{queryDataFilter});
        LinkedHashMap<String, String> billPkNumberMapping = new LinkedHashMap<String, String>(selectedPkList.size());
        for (Object billPk : selectedPkList) {
            DynamicObject bill = (DynamicObject)billDataMap.get(billPk);
            String billNo = this.getBillNo(bill);
            billPkNumberMapping.put(String.valueOf(bill.getPkValue()), billNo);
        }
        return billPkNumberMapping;
    }

    private List<Object> getSelectedPkList(BillList billList) {
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Object> selectedPkList = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billPk = selectedRow.getPrimaryKeyValue();
            if (selectedPkList.contains(billPk)) continue;
            selectedPkList.add(billPk);
        }
        return selectedPkList;
    }

    private ConfirmCallBackListener prepareConfirmCallBackListener(BillList billList, List<BatchDownloadAttDto> batchDownloadAttDtoList) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONTINUE_DOWNLOAD, (IConfirmCallBack)this);
        HashMap<String, String> callBackParamMap = new HashMap<String, String>(2);
        callBackParamMap.put(BILL_FORM_ID, billList.getEntityId());
        callBackParamMap.put(BATCHDOWNLOAD_ATTDTOLIST, SerializationUtils.toJsonString(batchDownloadAttDtoList));
        confirmCallBacks.setOperateOption(callBackParamMap);
        return confirmCallBacks;
    }

    private boolean queryBatchDownloadAttDtoList(List<BatchDownloadAttDto> batchDownloadAttDtoList, BillList billList, Map<String, String> billPkNumberMapping, QueryRange queryRange, boolean mergeRow) {
        String billFormId = billList.getEntityId();
        ListSelectedRowCollection listSelectedData = billList.getSelectedRows();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        String[] pkValues = this.convertStringArray(primaryKeyValues);
        List<AttachmentEntityRelation> attEntityRelationList = this.queryAttEntityRelationList(billFormId);
        if (mergeRow) {
            this.downloadForAll(batchDownloadAttDtoList, billFormId, primaryKeyValues, pkValues, attEntityRelationList, billPkNumberMapping);
        } else {
            String entryEntityKey = listSelectedData.get(0).getEntryEntityKey();
            String subEntryEntityKey = listSelectedData.get(0).getSubEntryEntityKey();
            Object[] entryPKIds = listSelectedData.getEntryPrimaryKeyValues();
            Object[] subEntryPKIds = listSelectedData.getSubEntryPrimaryKeyValues();
            ArrayList<Object> entryPKList = new ArrayList<Object>(entryPKIds.length);
            Collections.addAll(entryPKList, entryPKIds);
            ArrayList<Object> subEntryPKList = new ArrayList<Object>(subEntryPKIds.length);
            Collections.addAll(subEntryPKList, subEntryPKIds);
            if (subEntryEntityKey != null ? !this.downloadForSubEntryEntity(batchDownloadAttDtoList, billFormId, attEntityRelationList, queryRange, mergeRow, entryEntityKey, subEntryEntityKey, subEntryPKIds, entryPKList, subEntryPKList, billPkNumberMapping) : (entryEntityKey != null ? !this.downloadForEntryEntity(batchDownloadAttDtoList, billFormId, attEntityRelationList, queryRange, mergeRow, entryEntityKey, entryPKIds, entryPKList, billPkNumberMapping) : !this.downloadForBillHead(batchDownloadAttDtoList, billFormId, attEntityRelationList, queryRange, mergeRow, primaryKeyValues, pkValues, billPkNumberMapping))) {
                return false;
            }
        }
        return this.checkBeforeCreateZip(batchDownloadAttDtoList, mergeRow, queryRange);
    }

    private String checkNoDataForSelect(List<BatchDownloadAttDto> batchDownloadAttDtoList, Map<String, String> billPkNumberMapping, String billName) {
        Set<String> pkSet = billPkNumberMapping.keySet();
        for (BatchDownloadAttDto batchDownloadAttDto : batchDownloadAttDtoList) {
            pkSet.remove(batchDownloadAttDto.getBillPkId());
        }
        StringBuilder builder = new StringBuilder();
        if (pkSet.size() != 0) {
            builder.append(ResManager.loadKDString((String)"\u65e0\u9644\u4ef6\u5355\u636e\u7684\u5355\u636e\u7f16\u53f7\u5982\u4e0b\uff1a", (String)"BatchDownloadAttachment_15", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            for (String pk : pkSet) {
                builder.append("\r\n");
                String billNo = billPkNumberMapping.get(pk);
                builder.append(billNo);
            }
        }
        return builder.toString();
    }

    private boolean isMergeRow(BillList billList) {
        ListUserOption listUserOption = billList.getListUserOption();
        if (listUserOption == null) {
            listUserOption = new ListUserOption();
        }
        return listUserOption.isMergeRow();
    }

    private QueryRange getQueryRange(String entityNum, ListSelectedRowCollection listSelectedData) {
        String entryEntityKey = listSelectedData.get(0).getEntryEntityKey();
        String subEntryEntityKey = listSelectedData.get(0).getSubEntryEntityKey();
        String minEntityKey = null;
        LocationLevel locationLevel = LocationLevel.HEAD;
        if (subEntryEntityKey != null) {
            minEntityKey = subEntryEntityKey;
            locationLevel = LocationLevel.SUBENTRY;
        } else if (entryEntityKey != null) {
            minEntityKey = entryEntityKey;
            locationLevel = LocationLevel.ENTRY;
        }
        if (LocationLevel.HEAD == locationLevel) {
            return new QueryRange(null, LocationLevel.HEAD);
        }
        String entryName = "DEFAULT_ENTRYNAME";
        try {
            entryName = ((EntityType)EntityMetadataCache.getDataEntityType((String)entityNum).getAllEntities().get(minEntityKey)).getDisplayName().getLocaleValue();
        }
        catch (Exception e) {
            log.error("query entryName error : " + e);
        }
        return new QueryRange(entryName, locationLevel);
    }

    private List<BatchDownloadAttDto> convertBatchDownloadAttDtoList(Map<Object, DynamicObject> attachmentPanelDataMap, Map<String, String> billPkNumberMapping) {
        ArrayList<BatchDownloadAttDto> batchDownloadAttDtoList = new ArrayList<BatchDownloadAttDto>(attachmentPanelDataMap.size());
        for (DynamicObject attObj : attachmentPanelDataMap.values()) {
            BatchDownloadAttDto batchDownloadAttDto = new BatchDownloadAttDto();
            batchDownloadAttDto.setFileName(attObj.getString("fattachmentname"));
            batchDownloadAttDto.setUrl(attObj.getString("ffileid"));
            batchDownloadAttDto.setFileSize(attObj.getLong("fattachmentsize"));
            String billPkId = attObj.getString("finterid");
            batchDownloadAttDto.setBillPkId(billPkId);
            batchDownloadAttDto.setBillNumber(billPkNumberMapping.get(billPkId));
            batchDownloadAttDtoList.add(batchDownloadAttDto);
        }
        return batchDownloadAttDtoList;
    }

    private List<BatchDownloadAttDto> convertBatchDownloadAttDtoList(DynamicObjectCollection attachmentFieldCollection, Object pkValue, Map<String, String> billPkNumberMapping) {
        ArrayList<BatchDownloadAttDto> batchDownloadAttDtoList = new ArrayList<BatchDownloadAttDto>(attachmentFieldCollection.size());
        for (DynamicObject attEntityObj : attachmentFieldCollection) {
            BatchDownloadAttDto batchDownloadAttDto = new BatchDownloadAttDto();
            DynamicObject attObj = attEntityObj.getDynamicObject("fbasedataid");
            batchDownloadAttDto.setFileName(attObj.getString("name"));
            batchDownloadAttDto.setUrl(attObj.getString("url"));
            batchDownloadAttDto.setFileSize(attObj.getLong("size"));
            batchDownloadAttDto.setBillPkId(String.valueOf(pkValue));
            String billNo = billPkNumberMapping.get(batchDownloadAttDto.getBillPkId());
            batchDownloadAttDto.setBillNumber(billNo);
            batchDownloadAttDtoList.add(batchDownloadAttDto);
        }
        return batchDownloadAttDtoList;
    }

    private String[] convertStringArray(Object[] sourceArray) {
        if (sourceArray == null || sourceArray.length < 1) {
            return null;
        }
        String[] stringArray = new String[sourceArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(sourceArray[i]);
        }
        return stringArray;
    }

    private String createZip(List<BatchDownloadAttDto> attDtoList, String entityNum, String password) throws IOException {
        String urlResult;
        Map<String, List<BatchDownloadAttDto>> dirMapping = this.groupAttDtoListForDir(attDtoList);
        FileService service = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String zipFileName = this.genZipFileName(entityNum);
        BatchDownloadRequest attachReq = new BatchDownloadRequest(zipFileName);
        BatchDownloadRequest.Dir[] attDirs = new BatchDownloadRequest.Dir[dirMapping.size()];
        int dirIndex = 0;
        for (Map.Entry<String, List<BatchDownloadAttDto>> dirMappingEntry : dirMapping.entrySet()) {
            String dirName = dirMappingEntry.getKey();
            List<BatchDownloadAttDto> batchDownloadAttDtoList = dirMappingEntry.getValue();
            BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir(dirName);
            BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[batchDownloadAttDtoList.size()];
            for (int i = 0; i < batchDownloadAttDtoList.size(); ++i) {
                BatchDownloadAttDto attDto = batchDownloadAttDtoList.get(i);
                String url = attDto.getUrl();
                String fileName = batchDownloadAttDtoList.get(i).getFileName();
                files[i] = new BatchDownloadRequest.File(fileName, url);
                dir.setFiles(files);
            }
            attDirs[dirIndex] = dir;
            ++dirIndex;
        }
        attachReq.setDirs(attDirs);
        FileOutputStream fos = null;
        FileInputStream fin = null;
        File temp = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)password)) {
                temp = new File(System.getProperty("java.io.tmpdir"), "BatchDownloadAttachment" + System.currentTimeMillis() + ".zip");
                EncryptDownloadUtil.batchDownloadEncrypt(attachReq, temp, password);
            } else {
                temp = File.createTempFile("BatchDownloadAttachment" + System.currentTimeMillis(), ".zip");
                fos = new FileOutputStream(temp);
                service.batchDownload(attachReq, (OutputStream)fos, null);
            }
            fin = new FileInputStream(temp);
            urlResult = tempFileCache.saveAsFullUrl(zipFileName, (InputStream)fin, 7200);
            this.cacheTempFilePermissionParam(urlResult, entityNum);
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fos);
                FileSecurityUtil.safeClose(fin);
                FileSecurityUtil.safeDeleteFile(temp);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose((Closeable)fos);
        FileSecurityUtil.safeClose((Closeable)fin);
        FileSecurityUtil.safeDeleteFile((File)temp);
        return urlResult;
    }

    private void cacheTempFilePermissionParam(String tempFileUrl, String entityNum) {
        String tempFileId = UrlUtil.getParam((String)tempFileUrl, (String)"id");
        Map<String, Object> refEntitiyMap = this.createPermissionEntityMap(entityNum);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    private Map<String, Object> createPermissionEntityMap(String entityNum) {
        HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(16);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        refEntitiyMap.put("permItem", "2NJ5XVVCMBCL");
        return refEntitiyMap;
    }

    private Map<String, List<BatchDownloadAttDto>> groupAttDtoListForDir(List<BatchDownloadAttDto> attDtoList) {
        HashMap<String, List<BatchDownloadAttDto>> dirMapping = new HashMap<String, List<BatchDownloadAttDto>>(16);
        for (BatchDownloadAttDto attDto : attDtoList) {
            String dirName = attDto.getDirName();
            if (!dirMapping.containsKey(dirName)) {
                ArrayList batchDownloadAttDtoList = new ArrayList(10);
                dirMapping.put(dirName, batchDownloadAttDtoList);
            }
            ((List)dirMapping.get(dirName)).add(attDto);
        }
        return dirMapping;
    }

    private String genZipFileName(String entityNum) {
        String billName = null;
        FormConfig formConfig = null;
        try {
            formConfig = FormMetadataCache.getFormConfig((String)entityNum);
            if (formConfig != null) {
                billName = formConfig.getCaption().getLocaleValue();
            }
        }
        catch (Exception e) {
            log.error("genZipFileName error is " + e);
        }
        String dateStr = new SimpleDateFormat("MMddHHmmss").format(new Date());
        return String.format(ResManager.loadKDString((String)"%1$s_\u6279\u91cf\u4e0b\u8f7d\u9644\u4ef6_%2$s.zip", (String)"BatchDownloadAttachment_8", (String)BOS_ATTACHMENT, (Object[])new Object[0]), billName, dateStr);
    }

    private List<AttachmentEntityRelation> queryAttEntityRelationList(String entityNum) {
        ArrayList<AttachmentEntityRelation> attEntityRelationList = new ArrayList<AttachmentEntityRelation>(10);
        Map allEntities = EntityMetadataCache.getDataEntityType((String)entityNum).getAllEntities();
        for (Map.Entry entityEntry : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entityEntry.getValue();
            Map fields = entityType.getFields();
            for (Map.Entry itemEntry : fields.entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)itemEntry.getValue();
                if (!(property instanceof AttachmentProp)) continue;
                String entryEntityKey = null;
                String entryEntityName = null;
                String subEntryEntityKey = null;
                String subEntryEntityName = null;
                if (entityType instanceof SubEntryType) {
                    subEntryEntityKey = entityType.getName();
                    subEntryEntityName = entityType.getDisplayName().getLocaleValue();
                    entryEntityKey = entityType.getParent().getName();
                    entryEntityName = entityType.getParent().getDisplayName().getLocaleValue();
                } else if (entityType instanceof EntryType) {
                    entryEntityKey = entityType.getName();
                    entryEntityName = entityType.getDisplayName().getLocaleValue();
                }
                AttachmentEntityRelation relation = new AttachmentEntityRelation(property.getName(), entityNum, entryEntityKey, entryEntityName, subEntryEntityKey, subEntryEntityName);
                attEntityRelationList.add(relation);
            }
        }
        return attEntityRelationList;
    }

    private List<AttachmentEntityRelation> queryAttRelationOfEntity(String entityKey, LocationLevel LocationLevel2, List<AttachmentEntityRelation> attEntityRelationList) {
        ArrayList<AttachmentEntityRelation> result = new ArrayList<AttachmentEntityRelation>(attEntityRelationList.size());
        for (AttachmentEntityRelation attEntityRelation : attEntityRelationList) {
            if (LocationLevel2 != attEntityRelation.getAttLocationLevel() || !entityKey.equals(attEntityRelation.getMainEntityKey()) && !entityKey.equals(attEntityRelation.getEntryEntityKey()) && !entityKey.equals(attEntityRelation.getSubEntryEntityKey())) continue;
            result.add(attEntityRelation);
        }
        return result;
    }

    public String getBillNo(DynamicObject dataEntity) {
        BasedataEntityType mainType;
        String billNo = "BILLNO";
        IDataEntityProperty billNoProp = null;
        IDataEntityType dType = dataEntity.getDataEntityType();
        if (dType instanceof BasedataEntityType) {
            mainType = (BasedataEntityType)dType;
            if (StringUtils.isNotBlank((CharSequence)mainType.getNameProperty())) {
                billNoProp = mainType.findProperty(mainType.getNumberProperty());
            }
        } else if (dType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(mainType = (BillEntityType)dType).getBillNo())) {
            billNoProp = mainType.findProperty(mainType.getBillNo());
        }
        if (billNoProp == null) {
            return billNo;
        }
        Object value = billNoProp.getValue((Object)dataEntity);
        if (value == null) {
            return billNo;
        }
        billNo = value.toString();
        return billNo;
    }

    private void showConfirm(boolean mergeRow, QueryRange queryRange, ConfirmCallBackListener confirmCallBacks, String detailMsg) {
        String msg = "";
        boolean hasNodataForSelect = StringUtils.isNotBlank((CharSequence)detailMsg);
        if (mergeRow) {
            msg = hasNodataForSelect ? ResManager.loadKDString((String)"\u52fe\u9009\u5355\u636e\u4e2d\u5b58\u5728\u4ee5\u4e0b\u65e0\u9644\u4ef6\u7684\u5355\u636e\uff0c\u662f\u5426\u8981\u4e0b\u8f7d\u5176\u4f59\u5355\u636e\u7684\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_12", (String)BOS_ATTACHMENT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f\u5426\u8981\u4e0b\u8f7d\u52fe\u9009\u5355\u636e\u7684\u6240\u6709\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        } else if (queryRange.getLocationLevel() == LocationLevel.HEAD) {
            msg = hasNodataForSelect ? ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684\u5355\u636e\u5934\u65e0\u9644\u4ef6\uff0c\u662f\u5426\u8981\u4e0b\u8f7d\u5176\u4f59\u5355\u636e\u5934\u7684\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_13", (String)BOS_ATTACHMENT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f\u5426\u8981\u4e0b\u8f7d\u52fe\u9009\u5355\u636e\u5934\u7684\u6240\u6709\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_2", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        } else if (queryRange.getLocationLevel() == LocationLevel.ENTRY) {
            msg = hasNodataForSelect ? String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684%1$s\u65e0\u9644\u4ef6\uff0c\u662f\u5426\u8981\u4e0b\u8f7d\u5176\u4f59%2$s\u7684\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_14", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName(), queryRange.getEntryName()) : String.format(ResManager.loadKDString((String)"\u662f\u5426\u8981\u4e0b\u8f7d\u52fe\u9009\u7684%s\u7684\u6240\u6709\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName());
        } else if (queryRange.getLocationLevel() == LocationLevel.SUBENTRY) {
            msg = hasNodataForSelect ? String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u7684%1$s\u65e0\u9644\u4ef6\uff0c\u662f\u5426\u8981\u4e0b\u8f7d\u5176\u4f59%2$s\u7684\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_14", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName(), queryRange.getEntryName()) : String.format(ResManager.loadKDString((String)"\u662f\u5426\u8981\u4e0b\u8f7d\u52fe\u9009\u7684%s\u7684\u6240\u6709\u9644\u4ef6\uff1f", (String)"BatchDownloadAttachment_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName());
        }
        this.getView().showConfirm(msg, detailMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, SerializationUtils.toJsonString((Object)confirmCallBacks.getOperateOption()));
    }

    private void showNoDataMessage(boolean mergeRow, QueryRange queryRange) {
        String msg = "";
        if (mergeRow) {
            msg = String.format(ResManager.loadKDString((String)"\u52fe\u9009\u5355\u636e\u4e0a\u4e0d\u5b58\u5728\u9644\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BatchDownloadAttachment_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName());
        } else if (queryRange.getLocationLevel() == LocationLevel.HEAD) {
            msg = ResManager.loadKDString((String)"\u52fe\u9009\u7684\u5355\u636e\u5934\u4e0a\u4e0d\u5b58\u5728\u9644\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BatchDownloadAttachment_5", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        } else if (queryRange.getLocationLevel() == LocationLevel.ENTRY || queryRange.getLocationLevel() == LocationLevel.SUBENTRY) {
            msg = String.format(ResManager.loadKDString((String)"\u52fe\u9009\u7684%s\u4e0a\u4e0d\u5b58\u5728\u9644\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BatchDownloadAttachment_6", (String)BOS_ATTACHMENT, (Object[])new Object[0]), queryRange.getEntryName());
        }
        this.getView().showTipNotification(msg);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackParamMapString = e.getCustomVaule();
        Map callBackParamMap = (Map)SerializationUtils.fromJsonString((String)callBackParamMapString, Map.class);
        String billFormId = (String)callBackParamMap.get(BILL_FORM_ID);
        String attDtoListString = (String)callBackParamMap.get(BATCHDOWNLOAD_ATTDTOLIST);
        List batchDownloadAttDtoList = SerializationUtils.fromJsonStringToList((String)attDtoListString, BatchDownloadAttDto.class);
        if (CONTINUE_DOWNLOAD.equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            if (AttachmentManageUtil.needEncrypt((IFormView)this.getView(), (boolean)false)) {
                FormShowParameter showParameter = AttachmentManageUtil.getFormParameterForEncrypt((String)"2");
                showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "encryptBatchDownload"));
                showParameter.setCustomParam(BILL_FORM_ID, (Object)billFormId);
                showParameter.setCustomParam(BATCHDOWNLOAD_ATTDTOLIST, (Object)attDtoListString);
                this.getView().showForm(showParameter);
                return;
            }
            this.continueDownload(billFormId, batchDownloadAttDtoList, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getView() == null) {
            return;
        }
        this.setView(event.getView());
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("encryptBatchDownload".equals(event.getActionId()) && returnData instanceof Map) {
            Map params = (Map)returnData;
            String password = params.get("password").toString();
            String billFormId = params.get(BILL_FORM_ID).toString();
            String attDtoListString = params.get(BATCHDOWNLOAD_ATTDTOLIST).toString();
            List batchDownloadAttDtoList = SerializationUtils.fromJsonStringToList((String)attDtoListString, BatchDownloadAttDto.class);
            this.continueDownload(billFormId, batchDownloadAttDtoList, password);
        }
    }

    private void continueDownload(String billFormId, List<BatchDownloadAttDto> batchDownloadAttDtoList, String password) {
        if (!this.preCheckPermission(billFormId)) {
            this.getView().showErrorNotification(FilePremissionUtil.genNoPermissionTips((String)billFormId, (String)"2NJ5XVVCMBCL"));
            return;
        }
        String zipFullUrl = null;
        try {
            zipFullUrl = this.createZip(batchDownloadAttDtoList, billFormId, password);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff1a " + e);
            String msg = ResManager.loadKDString((String)"\u751f\u6210ZIP\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"BatchDownloadAttachment_7", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        this.getView().download(zipFullUrl);
    }

    private boolean preCheckPermission(String entityNum) {
        boolean hasPermission;
        block3: {
            hasPermission = true;
            ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>(1);
            refEntityList.add(this.createPermissionEntityMap(entityNum));
            try {
                if (!FilePremissionUtil.hasEntityPermission(refEntityList).booleanValue()) {
                    hasPermission = false;
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
                if (!AttachExceptionHandler.noPermissionException((KDException)e).booleanValue()) break block3;
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    private void downloadForAll(List<BatchDownloadAttDto> batchDownloadAttDtoList, String billFormId, Object[] primaryKeyValues, String[] pkValues, List<AttachmentEntityRelation> attEntityRelationList, Map<String, String> billPkNumberMapping) {
        QFilter queryDataFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        Map billDataMap = BusinessDataServiceHelper.loadFromCache((String)billFormId, (QFilter[])new QFilter[]{queryDataFilter});
        QFilter qFilter = new QFilter("fbilltype", "=", (Object)billFormId).and(new QFilter("finterid", "in", (Object)pkValues));
        Map attachmentPanelDataMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (String)"finterid,ffileid,fattachmentname,fattachmentsize", (QFilter[])new QFilter[]{qFilter});
        batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attachmentPanelDataMap, billPkNumberMapping));
        for (Map.Entry billEntry : billDataMap.entrySet()) {
            DynamicObject bill = (DynamicObject)billEntry.getValue();
            for (AttachmentEntityRelation relation : attEntityRelationList) {
                DynamicObjectCollection entryBillCollection;
                LocationLevel locationLevel = relation.getAttLocationLevel();
                if (locationLevel == LocationLevel.HEAD) {
                    DynamicObjectCollection attFieldCollection = bill.getDynamicObjectCollection(relation.getAttKey());
                    batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
                    continue;
                }
                if (locationLevel == LocationLevel.ENTRY) {
                    entryBillCollection = bill.getDynamicObjectCollection(relation.getEntryEntityKey());
                    for (DynamicObject entryBill : entryBillCollection) {
                        DynamicObjectCollection attFieldCollection = entryBill.getDynamicObjectCollection(relation.getAttKey());
                        batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
                    }
                    continue;
                }
                if (locationLevel != LocationLevel.SUBENTRY) continue;
                entryBillCollection = bill.getDynamicObjectCollection(relation.getEntryEntityKey());
                for (DynamicObject entryBill : entryBillCollection) {
                    DynamicObjectCollection subEntryBillCollection = entryBill.getDynamicObjectCollection(relation.getSubEntryEntityKey());
                    for (DynamicObject subEntryBill : subEntryBillCollection) {
                        DynamicObjectCollection attFieldCollection = subEntryBill.getDynamicObjectCollection(relation.getAttKey());
                        batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
                    }
                }
            }
        }
    }

    private boolean downloadForBillHead(List<BatchDownloadAttDto> batchDownloadAttDtoList, String billFormId, List<AttachmentEntityRelation> attEntityRelationList, QueryRange queryRange, boolean mergeRow, Object[] primaryKeyValues, String[] pkValues, Map<String, String> billPkNumberMapping) {
        List<AttachmentEntityRelation> attachmentEntityRelations = this.queryAttRelationOfEntity(billFormId, LocationLevel.HEAD, attEntityRelationList);
        QFilter queryDataFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        Map billDataMap = BusinessDataServiceHelper.loadFromCache((String)billFormId, (QFilter[])new QFilter[]{queryDataFilter});
        if (CollectionUtils.isEmpty(attachmentEntityRelations) || MapUtils.isEmpty((Map)billDataMap)) {
            this.showNoDataMessage(mergeRow, queryRange);
            return false;
        }
        QFilter qFilter = new QFilter("fbilltype", "=", (Object)billFormId).and(new QFilter("finterid", "in", (Object)pkValues));
        Map attachmentPanelDataMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (String)"finterid,ffileid,fattachmentname,fattachmentsize", (QFilter[])new QFilter[]{qFilter});
        batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attachmentPanelDataMap, billPkNumberMapping));
        for (Map.Entry billEntry : billDataMap.entrySet()) {
            DynamicObject bill = (DynamicObject)billEntry.getValue();
            for (AttachmentEntityRelation relation : attachmentEntityRelations) {
                DynamicObjectCollection attFieldCollection = bill.getDynamicObjectCollection(relation.getAttKey());
                batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
            }
        }
        return true;
    }

    private boolean downloadForEntryEntity(List<BatchDownloadAttDto> batchDownloadAttDtoList, String billFormId, List<AttachmentEntityRelation> attEntityRelationList, QueryRange queryRange, boolean mergeRow, String entryEntityKey, Object[] entryPKIds, List<Object> entryPKList, Map<String, String> billPkNumberMapping) {
        List<AttachmentEntityRelation> attachmentEntityRelations = this.queryAttRelationOfEntity(entryEntityKey, LocationLevel.ENTRY, attEntityRelationList);
        QFilter queryDataFilter = new QFilter(entryEntityKey + ".id", "in", (Object)entryPKIds);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)billFormId, (QFilter[])new QFilter[]{queryDataFilter});
        if (CollectionUtils.isEmpty(attachmentEntityRelations) || MapUtils.isEmpty((Map)objectDynamicObjectMap)) {
            this.showNoDataMessage(mergeRow, queryRange);
            return false;
        }
        for (Map.Entry billEntry : objectDynamicObjectMap.entrySet()) {
            DynamicObject bill = (DynamicObject)billEntry.getValue();
            DynamicObjectCollection entryBillColllction = bill.getDynamicObjectCollection(entryEntityKey);
            for (DynamicObject entryBill : entryBillColllction) {
                if (!entryPKList.contains(entryBill.getPkValue())) continue;
                for (AttachmentEntityRelation relation : attachmentEntityRelations) {
                    DynamicObjectCollection attFieldCollection = entryBill.getDynamicObjectCollection(relation.getAttKey());
                    batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
                }
            }
        }
        return true;
    }

    private boolean downloadForSubEntryEntity(List<BatchDownloadAttDto> batchDownloadAttDtoList, String billFormId, List<AttachmentEntityRelation> attEntityRelationList, QueryRange queryRange, boolean mergeRow, String entryEntityKey, String subEntryEntityKey, Object[] subEntryPKIds, List<Object> entryPKList, List<Object> subEntryPKList, Map<String, String> billPkNumberMapping) {
        List<AttachmentEntityRelation> attachmentEntityRelations = this.queryAttRelationOfEntity(subEntryEntityKey, LocationLevel.SUBENTRY, attEntityRelationList);
        QFilter queryDataFilter = new QFilter(entryEntityKey + "." + subEntryEntityKey + ".id", "in", (Object)subEntryPKIds);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)billFormId, (QFilter[])new QFilter[]{queryDataFilter});
        if (CollectionUtils.isEmpty(attachmentEntityRelations) || MapUtils.isEmpty((Map)objectDynamicObjectMap)) {
            this.showNoDataMessage(mergeRow, queryRange);
            return false;
        }
        for (Map.Entry billEntry : objectDynamicObjectMap.entrySet()) {
            DynamicObject bill = (DynamicObject)billEntry.getValue();
            DynamicObjectCollection entryBillColllction = bill.getDynamicObjectCollection(entryEntityKey);
            for (DynamicObject entryBill : entryBillColllction) {
                if (!entryPKList.contains(entryBill.getPkValue())) continue;
                DynamicObjectCollection subEntryBillCollction = entryBill.getDynamicObjectCollection(subEntryEntityKey);
                for (DynamicObject subEntryBill : subEntryBillCollction) {
                    if (!subEntryPKList.contains(subEntryBill.getPkValue())) continue;
                    for (AttachmentEntityRelation relation : attachmentEntityRelations) {
                        DynamicObjectCollection attFieldCollection = subEntryBill.getDynamicObjectCollection(relation.getAttKey());
                        batchDownloadAttDtoList.addAll(this.convertBatchDownloadAttDtoList(attFieldCollection, bill.getPkValue(), billPkNumberMapping));
                    }
                }
            }
        }
        return true;
    }

    private boolean checkBeforeCreateZip(List<BatchDownloadAttDto> batchDownloadAttDtoList, boolean mergeRow, QueryRange queryRange) {
        if (CollectionUtils.isEmpty(batchDownloadAttDtoList)) {
            this.showNoDataMessage(mergeRow, queryRange);
            return false;
        }
        return this.checkFileCount(batchDownloadAttDtoList) && this.checkFileSize(batchDownloadAttDtoList);
    }

    private boolean checkFileCount(List<BatchDownloadAttDto> batchDownloadAttDtoList) {
        int totalCount = batchDownloadAttDtoList.size();
        if (totalCount > 1000) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e0b\u8f7d\u7684\u6587\u4ef6\u603b\u6570\u4e3a%1$s\uff0c\u8d85\u51fa\u5355\u6b21\u4e0b\u8f7d\u6587\u4ef6\u603b\u6570\u6700\u5927\u503c1000\u4e2a\uff0c\u4e0b\u8f7d\u5931\u8d25\uff0c\u5efa\u8bae\u60a8\u5206\u6279\u4e0b\u8f7d\u3002", (String)"BatchDownloadAttachment_10", (String)BOS_ATTACHMENT, (Object[])new Object[0]), totalCount));
            return false;
        }
        return true;
    }

    private boolean checkFileSize(List<BatchDownloadAttDto> batchDownloadAttDtoList) {
        long fileSizeLimit = this.getBatchDownloadFileSizeLimit();
        if (fileSizeLimit == 0L) {
            return true;
        }
        long totalFileSize = 0L;
        for (BatchDownloadAttDto batchDownloadAttDto : batchDownloadAttDtoList) {
            totalFileSize += batchDownloadAttDto.getFileSize();
        }
        if (totalFileSize > fileSizeLimit * 1024L * 1024L) {
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a%1$sMB\uff0c\u8d85\u51fa\u5355\u6b21\u6587\u4ef6\u4e0b\u8f7d\u6700\u5927\u503c%2$sMB\uff0c\u4e0b\u8f7d\u5931\u8d25\uff0c\u5efa\u8bae\u60a8\u5206\u6279\u4e0b\u8f7d\uff0c\u6216\u524d\u5f80\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u9644\u4ef6\u56fe\u7247\u53c2\u6570-\u9644\u4ef6\u4e0b\u8f7d\u9650\u5236-\u9644\u4ef6\u6279\u91cf\u4e0b\u8f7d\u5927\u5c0f\u9650\u5236\u4fee\u6539\u8bbe\u7f6e\u503c\u3002", (String)"BatchDownloadAttachment_11", (String)BOS_ATTACHMENT, (Object[])new Object[0]), totalFileSize / 1024L / 1024L, fileSizeLimit);
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    private long getBatchDownloadFileSizeLimit() {
        Object sizeMb = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"maxdownloadsize"});
        if (sizeMb != null && !"0".equals(sizeMb.toString())) {
            return Long.parseLong(String.valueOf(sizeMb));
        }
        return 1024L;
    }
}

