/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AttachPreviewConfigPlugin
extends AbstractFormPlugin
implements IDataModelChangeListener {
    private static final String PREVIEWTYPE = "previewtype";
    private static final String CONFIGFLEX = "configflex";
    private static final String YZJ_CONFIGFLEX = "flexpanelap";
    private static final String WPS_CONFIGFLEX = "wpsconfigflex";
    private static final String WPS_APPID = "wpsappid";
    private static final String WPS_APP_SECRET = "wpsappsecret";
    private static final String WPS_PREVIEW_STYLE = "wpspreviewstyle";
    private static final String URL = "url";
    private static final String CLIENT_ID = "clientid";
    private static final String CLIENT_SECRET = "clientsecret";
    private static final String T_ID = "tid";
    private static final String U_ID = "uid";
    private static final String T_ID_SECRET = "tidsecret";
    private static final String YZJ_PREVIEW_STYLE = "yzjpreviewstyle";
    private static final String YZJ_TIPS = "yzjtips";
    private static final String WPS_TIPS = "wpstips";
    private static final String CUSTOM_PREVIEW_EXT = "custompreviewext";
    private static final String YZJ_TIPS_DETAIL = "\u8bf7\u524d\u5f80\u91d1\u8776\u4e91\u793e\u533ahttps://vip.kingdee.com/article/400703227659736064?productLineId=29&isKnowledge=2\u67e5\u770b\u4e0b\u5217\u53c2\u6570\u7684\u914d\u7f6e\u65b9\u5f0f\u3002";
    private static final String WPS_TIPS_DETAIL = "\u8bf7\u524d\u5f80\u91d1\u8776\u4e91\u793e\u533ahttps://vip.kingdee.com/knowledge/specialDetail/294832938980257024?category=327807067010834432&id=391547168882254592&productLineId=29\u67e5\u770b\u4e0b\u5217\u53c2\u6570\u7684\u914d\u7f6e\u65b9\u5f0f\u3002";
    private static final String BOS_ATTACHMENT = "bos-attachment";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map data = this.getView().getFormShowParameter().getCustomParams();
        if (data == null) {
            this.getModel().setValue(PREVIEWTYPE, (Object)"0");
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIGFLEX});
            return;
        }
        Object previewType = data.get(PREVIEWTYPE);
        if (StringUtils.isBlank(previewType)) {
            previewType = "0";
        }
        this.showFlexByPreviewType(String.valueOf(previewType));
        this.autoFillConfig(String.valueOf(previewType), data);
    }

    private void autoFillConfig(String previewType, Map<String, Object> configMap) {
        this.getModel().setValue(PREVIEWTYPE, (Object)previewType);
        if ("1".equals(previewType)) {
            this.getModel().setValue(URL, configMap.get("yunHome.serverUrl"));
            this.getModel().setValue(CLIENT_ID, configMap.get("yunHome.apiGateway.clientId"));
            this.getModel().setValue(CLIENT_SECRET, configMap.get("yunHome.apiGateway.clientSecret"));
            this.getModel().setValue(T_ID, configMap.get("yunHome.apiGateway.tid"));
            this.getModel().setValue(U_ID, configMap.get("yunHome.apiGateway.uid"));
            this.getModel().setValue(T_ID_SECRET, configMap.get("yunHome.apiGateway.tidSecret"));
            this.getModel().setValue(YZJ_PREVIEW_STYLE, configMap.get("yunHome.apiGateway.yzjPreviewStyle") != null ? configMap.get("yunHome.apiGateway.yzjPreviewStyle") : "0");
            this.getModel().setValue(CUSTOM_PREVIEW_EXT, configMap.get("yunHome.customPreviewExt"));
        } else if ("2".equals(previewType)) {
            this.getModel().setValue(WPS_APPID, configMap.get("wps.appid"));
            this.getModel().setValue(WPS_APP_SECRET, configMap.get("wps.appsecret"));
            this.getModel().setValue(WPS_PREVIEW_STYLE, configMap.get("wps.previewstyle") != null ? configMap.get("wps.previewstyle") : "0");
        }
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Button)) {
            return;
        }
        Button btn = (Button)evt.getSource();
        if ("btnok".equals(btn.getKey())) {
            if (!this.checkMustInput()) {
                return;
            }
            Map<String, Object> returnConfigMap = this.createReturnConfig();
            this.getView().returnDataToParent(returnConfigMap);
            this.getView().close();
            return;
        }
        this.getView().returnDataToParent((Object)this.getView().getFormShowParameter().getCustomParams());
    }

    private Map<String, Object> createReturnConfig() {
        Object previewType = this.getModel().getValue(PREVIEWTYPE);
        Map<String, Object> returnConfigMap = new HashMap<String, Object>();
        if ("1".equals(previewType) || "2".equals(previewType)) {
            returnConfigMap.put("yunHome.serverUrl", this.getModel().getValue(URL));
            returnConfigMap.put("yunHome.apiGateway.clientId", this.getModel().getValue(CLIENT_ID));
            returnConfigMap.put("yunHome.apiGateway.clientSecret", this.getModel().getValue(CLIENT_SECRET));
            returnConfigMap.put("yunHome.apiGateway.tid", this.getModel().getValue(T_ID));
            returnConfigMap.put("yunHome.apiGateway.uid", this.getModel().getValue(U_ID));
            returnConfigMap.put("yunHome.apiGateway.tidSecret", this.getModel().getValue(T_ID_SECRET));
            returnConfigMap.put("yunHome.apiGateway.yzjPreviewStyle", this.getModel().getValue(YZJ_PREVIEW_STYLE));
            returnConfigMap.put("yunHome.customPreviewExt", this.getModel().getValue(CUSTOM_PREVIEW_EXT));
            returnConfigMap.put("wps.appid", this.getModel().getValue(WPS_APPID));
            returnConfigMap.put("wps.appsecret", this.getModel().getValue(WPS_APP_SECRET));
            returnConfigMap.put("wps.previewstyle", this.getModel().getValue(WPS_PREVIEW_STYLE));
        } else {
            returnConfigMap = this.getView().getFormShowParameter().getCustomParams();
        }
        returnConfigMap.put(PREVIEWTYPE, this.getModel().getValue(PREVIEWTYPE));
        return returnConfigMap;
    }

    private boolean checkMustInput() {
        Object previewType = this.getModel().getValue(PREVIEWTYPE);
        if ("1".equals(previewType)) {
            String clientId = (String)this.getModel().getValue(CLIENT_ID);
            if (StringUtils.isBlank((CharSequence)clientId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String clientSecret = (String)this.getModel().getValue(CLIENT_SECRET);
            if (StringUtils.isBlank((CharSequence)clientSecret)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_2", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String tid = (String)this.getModel().getValue(T_ID);
            if (StringUtils.isBlank((CharSequence)tid)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\uff08\u7ec4\u7ec7\uff09ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String uid = (String)this.getModel().getValue(U_ID);
            if (StringUtils.isBlank((CharSequence)uid)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String tidSecret = (String)this.getModel().getValue(T_ID_SECRET);
            if (StringUtils.isBlank((CharSequence)tidSecret)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\uff08\u7ec4\u7ec7\uff09\u5b89\u5168\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_5", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String url = (String)this.getModel().getValue(URL);
            if (StringUtils.isBlank((CharSequence)url)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_6", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
        } else if ("2".equals(previewType)) {
            String wpsappid = (String)this.getModel().getValue(WPS_APPID);
            if (StringUtils.isBlank((CharSequence)wpsappid)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_7", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String wpsappSecret = (String)this.getModel().getValue(WPS_APP_SECRET);
            if (StringUtils.isBlank((CharSequence)wpsappSecret)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_8", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
            String wpspreviewstyle = (String)this.getModel().getValue(WPS_PREVIEW_STYLE);
            if (StringUtils.isBlank((CharSequence)wpspreviewstyle)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u89c8\u9875\u9762\u6253\u5f00\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttachPreviewConfigPlugin_9", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (PREVIEWTYPE.equalsIgnoreCase(e.getProperty().getName())) {
            for (ChangeData data : e.getChangeSet()) {
                this.showFlexByPreviewType(String.valueOf(data.getNewValue()));
                this.autoFillConfig(String.valueOf(data.getNewValue()), this.getView().getFormShowParameter().getCustomParams());
            }
        }
    }

    private void showFlexByPreviewType(String previewType) {
        if ("1".equals(previewType)) {
            ((Label)this.getView().getControl(YZJ_TIPS)).setText(YZJ_TIPS_DETAIL);
            this.getView().setVisible(Boolean.TRUE, new String[]{CONFIGFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{YZJ_CONFIGFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{WPS_CONFIGFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{YZJ_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{WPS_TIPS});
            this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOM_PREVIEW_EXT});
        } else if ("2".equals(previewType)) {
            ((Label)this.getView().getControl(WPS_TIPS)).setText(WPS_TIPS_DETAIL);
            this.getView().setVisible(Boolean.TRUE, new String[]{CONFIGFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{YZJ_CONFIGFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{WPS_CONFIGFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{YZJ_TIPS});
            this.getView().setVisible(Boolean.TRUE, new String[]{WPS_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOM_PREVIEW_EXT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIGFLEX});
        }
    }
}

