/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.svc.watermark.IWaterMarkProxy;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AttachmentServiceImpl
implements IAttachmentService {
    private static final Log log = LogFactory.getLog(AttachmentServiceImpl.class);
    private static final String MAX_PLOADSIZE = "maxuploadsize";
    private static final String REDIS_ATT_FORBID_EXT_KEY = "sys_attservice_forbiddenext";
    private static final String REDIS_ATT_WHITE_LIST_KEY = "sys_attservice_whitelist";
    private static final int TIMEOUT_VAL = 1800;
    private static int TIMEOUT_SECONDS = Integer.getInteger("sys.attserviceparam.timeout", 1800);
    private static final int MAX_MEM_SIZE = 300;
    private static final int FILE_SIZE_MB = 0x100000;
    private LocalMemoryCache localCache;

    public AttachmentServiceImpl() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(TIMEOUT_SECONDS);
        info.setMaxMemSize(300);
        this.localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("sys_attsetting", "forbiddenext", info);
    }

    public Map<String, Object> getAttachmentInfoById(AttachmentType attachmentType, String pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AttachmentDto attachmentDto = new AttachmentDto();
        if (attachmentType == AttachmentType.attachmentpanel) {
            attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)pkId);
        }
        if (attachmentType == AttachmentType.attachmentfield) {
            attachmentDto = AttachmentFieldServiceHelper.getAttachmentInfoByAttPk((Object)pkId);
        }
        map.put("fileName", attachmentDto.getFilename());
        map.put("size", attachmentDto.getSize());
        map.put("path", attachmentDto.getResourcePath());
        return map;
    }

    public String createAttFilePath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }

    public Map<String, Object> getAttSetting() {
        String editType;
        boolean isWpsEdit;
        HashMap<String, Object> setting = new HashMap<String, Object>();
        ArrayList<String> forbiddenFileTypeList = new ArrayList<String>();
        long maxUploadSize = FileServiceFactory.getAttachmentFileService().maxUploadSize();
        if (maxUploadSize <= 0L) {
            maxUploadSize = 0x3200000L;
        }
        setting.put("attachmentUploadMaxSize", maxUploadSize);
        Map pubSysParam = ParameterReader.loadPublicParameterFromCache();
        if (pubSysParam != null) {
            Object forbidFileTypeParam = pubSysParam.get("forbidfiletype");
            if (null != forbidFileTypeParam && StringUtils.isNotEmpty((CharSequence)forbidFileTypeParam.toString())) {
                forbiddenFileTypeList.addAll(Arrays.asList(forbidFileTypeParam.toString().trim().split(",")));
            }
            String previewType = ParamUtil.getPreviewType();
            boolean wpsPreView = "21".equals(previewType);
            boolean onlyOfficePreview = "3".equals(previewType);
            boolean wpsV3Preview = ParamUtil.isWpsV3();
            String previewStyle = ParamUtil.getPreviewStyle();
            HashMap attPreviewMap = new HashMap();
            if (wpsPreView && wpsV3Preview) {
                previewType = this.getWpsV3Param(previewType);
            } else if (onlyOfficePreview) {
                Map param = ParamUtil.getOnlyOfficeParam((boolean)true);
                attPreviewMap.put("onlyofficeServerUrl", param.get("onlyOfficeServerUrl"));
            }
            attPreviewMap.put("previewType", previewType);
            attPreviewMap.put("previewStyle", previewStyle);
            attPreviewMap.put("allowFileSuffix", AttachmentKit.getAttExtPreviewSysParams().get("customExtList"));
            attPreviewMap.put("customPreviewUseDefaultType", this.getCustomPreviewUseDefaultType());
            setting.put("attPreview", attPreviewMap);
            if (pubSysParam.get(MAX_PLOADSIZE) != null && !"0".equals(pubSysParam.get(MAX_PLOADSIZE).toString())) {
                long mb = ((Integer)pubSysParam.get(MAX_PLOADSIZE)).intValue();
                setting.put("attachmentUploadMaxSize", Math.min(mb * 0x100000L, maxUploadSize));
            }
        }
        List<String> sysForbiddenExt = this.getForbiddenExtFromCache();
        List<String> whiteTypeList = this.getWhiteTypeListFromCache();
        forbiddenFileTypeList.addAll(sysForbiddenExt);
        setting.put("forbidfiletype", forbiddenFileTypeList.stream().distinct().collect(Collectors.toList()));
        if (!whiteTypeList.isEmpty()) {
            setting.put("whitelist", whiteTypeList);
        }
        if ((isWpsEdit = "21".equals(editType = ParamUtil.getEditType())) && ParamUtil.isWpsV3()) {
            editType = this.getWpsV3Param(editType);
        }
        setting.put("officeEditMode", editType);
        if ("3".equals(editType)) {
            Map param = ParamUtil.getOnlyOfficeParam((boolean)true);
            setting.put("onlyofficeServerUrl", param.get("onlyOfficeServerUrl"));
        }
        return setting;
    }

    private String getCustomPreviewUseDefaultType() {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        return (String)customParameterFromCache.get("CUSTOM_PREVIEW_USE_DEFAULT_TYPE");
    }

    private String getWpsV3Param(String type) {
        HashMap<String, String> editParam = new HashMap<String, String>();
        editParam.put("type", type);
        editParam.put("appId", ParamUtil.getWpsV3AppId());
        return SerializationUtils.toJsonString(editParam);
    }

    private List<String> getForbiddenExtFromCache() {
        Object str = this.localCache.get(REDIS_ATT_FORBID_EXT_KEY);
        ArrayList<String> sysForbiddenExt = new ArrayList();
        if (StringUtils.isNotBlank((Object)str)) {
            sysForbiddenExt = SerializationUtils.fromJsonStringToList((String)str.toString(), String.class);
            return sysForbiddenExt;
        }
        try {
            sysForbiddenExt = FileServiceFactory.getAttachmentFileService().getForbiddenExtensions();
            this.localCache.put(REDIS_ATT_FORBID_EXT_KEY, (Object)SerializationUtils.toJsonString(sysForbiddenExt));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u670d\u52a1\u9ed1\u540d\u5355\u5931\u8d25\uff0cmsg:" + e.getMessage(), (Throwable)e);
        }
        return sysForbiddenExt;
    }

    private List<String> getWhiteTypeListFromCache() {
        Object whiteStr = this.localCache.get(REDIS_ATT_WHITE_LIST_KEY);
        ArrayList<String> whiteTypeList = new ArrayList();
        if (StringUtils.isNotBlank((Object)whiteStr)) {
            whiteTypeList = SerializationUtils.fromJsonStringToList((String)whiteStr.toString(), String.class);
            return whiteTypeList;
        }
        try {
            whiteTypeList = FileServiceFactory.getAttachmentFileService().getAllowExtensions();
            this.localCache.put(REDIS_ATT_WHITE_LIST_KEY, (Object)SerializationUtils.toJsonString(whiteTypeList));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u670d\u52a1\u767d\u540d\u5355\u5931\u8d25\uff0cmsg:" + e.getMessage(), (Throwable)e);
        }
        return whiteTypeList;
    }

    public Object getAttachmentWaterMark(String formId) {
        IWaterMarkProxy waterMarkService = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
        return waterMarkService.getAttachmentWaterMark(formId);
    }

    public boolean isEncrptyPath() {
        if (RequestContext.get() == null) {
            return false;
        }
        String accountId = RequestContext.get().getAccountId();
        String accountStr = System.getProperty("attachment.encrptypath.accountids", "[]");
        List accounts = SerializationUtils.fromJsonStringToList((String)accountStr, String.class);
        if (accounts.contains(accountId)) {
            return true;
        }
        return this.isSysEncryptPath();
    }

    private Boolean isSysEncryptPath() {
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && cache.get("encrptypath") != null) {
            return Boolean.parseBoolean(cache.get("encrptypath").toString());
        }
        return false;
    }

    public boolean isImageEncrptyPath() {
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && cache.get("imageencrptypath") != null) {
            return Boolean.parseBoolean(cache.get("imageencrptypath").toString());
        }
        return false;
    }

    @SdkInternal
    public boolean checkFilePermission() {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        return securityParam.size() == 0 ? Boolean.parseBoolean(System.getProperty("check.file.permission", "true")) : Boolean.parseBoolean(String.valueOf(securityParam.get("attpermission")));
    }

    @SdkInternal
    public boolean checkTempFilePermission() {
        return Boolean.parseBoolean(System.getProperty("check.tempfile.permission", "true"));
    }

    @SdkInternal
    public void copyAttachmentField(DynamicObjectCollection oldDynObjColl, DynamicObjectCollection newDynObjColl) {
        this.doCopyAttachmentField(oldDynObjColl, newDynObjColl, null);
    }

    @SdkInternal
    public void copyAttachmentField(DynamicObjectCollection oldDynObjColl, DynamicObjectCollection newDynObjColl, String pageId) {
        this.doCopyAttachmentField(oldDynObjColl, newDynObjColl, pageId);
    }

    private void doCopyAttachmentField(DynamicObjectCollection oldDynObjColl, DynamicObjectCollection newDynObjColl, String pageId) {
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        Boolean isDoLog = Boolean.parseBoolean((String)customParameterFromCache.get("Attachment_LOG_EXT"));
        if (isDoLog.booleanValue()) {
            log.debug("oldDynObjColl:" + SerializationUtils.toJsonString((Object)oldDynObjColl));
            log.debug("newDynObjColl:" + SerializationUtils.toJsonString((Object)newDynObjColl));
        }
        int count = oldDynObjColl.size();
        ArrayList<DynamicObject> copyAttFiledList = new ArrayList<DynamicObject>(10);
        log.debug("before genLongIds" + System.currentTimeMillis());
        long[] genLongIds = ORM.create().genLongIds("bd_attachment", count);
        log.debug("after genLongIds" + System.currentTimeMillis());
        for (int i = 0; i < count; ++i) {
            DynamicObject oldDynObj = (DynamicObject)oldDynObjColl.get(i);
            log.debug("before OrmUtils.clone1" + System.currentTimeMillis());
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)oldDynObj, (boolean)false, (boolean)true);
            log.debug("aftere OrmUtils.clone1" + System.currentTimeMillis());
            copyDynObj.getDataEntityState().setDirty(true);
            DynamicObject attachmentField = copyDynObj.getDynamicObject("fbasedataid");
            DynamicObject attachment = this.getNewAttachDynamicObject(genLongIds[i], attachmentField, pageId);
            if (attachment == null) continue;
            copyAttFiledList.add(attachment);
            copyDynObj.set("fbasedataid_id", (Object)genLongIds[i]);
            newDynObjColl.add((Object)copyDynObj);
        }
        if (!copyAttFiledList.isEmpty()) {
            log.debug("before ORM.create().save ," + System.currentTimeMillis());
            DynamicObject[] copyAttFileds = copyAttFiledList.toArray(new DynamicObject[copyAttFiledList.size()]);
            ORM.create().save(copyAttFileds);
            log.debug("after ORM.create().save ," + System.currentTimeMillis());
            List<AttachmentInfo> attachmentInfoList = AttachmentServiceImpl.attFieldObjToAttachmentInfo(copyAttFiledList, pageId);
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)"IAttachmentManagerService");
            managerService.afterDoOperation(attachmentInfoList, AttachmentOpType.Upload);
        }
        if (isDoLog.booleanValue()) {
            log.debug("newDynObjColl2:" + SerializationUtils.toJsonString((Object)newDynObjColl));
        }
    }

    private static List<AttachmentInfo> attFieldObjToAttachmentInfo(List<DynamicObject> attObjList, String pageId) {
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(attObjList.size());
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        IFormView formView = sm.getViewNoPlugin(pageId);
        boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(formView instanceof IMobileView);
        Date today = new Date();
        for (int i = 0; i < attObjList.size(); ++i) {
            DynamicObject attObj = attObjList.get(i);
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
            attachmentInfo.setExt(attObj.getString("type"));
            attachmentInfo.setFileName(attObj.getString("name"));
            attachmentInfo.setFileSize(Long.valueOf(attObj.getLong("size")));
            attachmentInfo.setDownloadUrl(attObj.getString("url"));
            attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace("download.do", "preview.do"));
            attachmentInfo.setMark(attObj.getString("description"));
            attachmentInfo.setCreateTime(attObj.getDate("createtime"));
            attachmentInfo.setCreateUserId(String.valueOf(RequestContext.get().getCurrUserId()));
            attachmentInfo.setModifyTime(today);
            attachmentInfo.setEntityNum(formView.getEntityId());
            attachmentInfo.setAttPkId(Long.valueOf(attObj.getLong("id")));
            attachmentInfo.setClient(isWeb ? "web" : "mobile");
            resultList.add(attachmentInfo);
        }
        return resultList;
    }

    @SdkInternal
    public List<Object> newAndCarryAttachmentField(DynamicObject dataEntity, DynamicProperty attachmentProperty) {
        return this.doNewAndCarryAttachmentField(dataEntity, attachmentProperty, null);
    }

    @SdkInternal
    public List<Object> newAndCarryAttachmentField(DynamicObject dataEntity, DynamicProperty attachmentProperty, String pageId) {
        return this.doNewAndCarryAttachmentField(dataEntity, attachmentProperty, pageId);
    }

    private List<Object> doNewAndCarryAttachmentField(DynamicObject dataEntity, DynamicProperty attachmentProperty, String pageId) {
        DynamicObjectCollection fldValue = (DynamicObjectCollection)attachmentProperty.getValue((Object)dataEntity);
        ArrayList<Object> ids = new ArrayList<Object>(10);
        if (CollectionUtils.isEmpty((Collection)fldValue)) {
            return ids;
        }
        boolean copyEnble = Boolean.parseBoolean(System.getProperty("file.addnewcopy.enable", "true"));
        if (!copyEnble) {
            for (DynamicObject obj : fldValue) {
                Object o = ((MulBasedataProp)attachmentProperty).getRefBaseProp().getValue((Object)obj);
                ids.add(((DynamicObject)o).getPkValue());
            }
            return ids;
        }
        log.debug("before genLongIds" + System.currentTimeMillis());
        long[] genLongIds = ORM.create().genLongIds("bd_attachment", fldValue.size());
        log.debug("after genLongIds" + System.currentTimeMillis());
        ArrayList<DynamicObject> copyAttFiledList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < fldValue.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)fldValue.get(i);
            Object value = ((MulBasedataProp)attachmentProperty).getRefBaseProp().getValue((Object)dynamicObject);
            if (!(value instanceof DynamicObject)) {
                return new ArrayList<Object>(10);
            }
            DynamicObject attachmentField = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)value), (boolean)false, (boolean)true);
            attachmentField.getDataEntityState().setDirty(true);
            log.debug("before OrmUtils.clone2" + System.currentTimeMillis());
            ids.add(genLongIds[i]);
            DynamicObject attachment = this.getNewAttachDynamicObject(genLongIds[i], attachmentField, pageId);
            if (attachment == null) continue;
            copyAttFiledList.add(attachment);
        }
        if (!copyAttFiledList.isEmpty()) {
            log.debug("before ORM.create().save ," + System.currentTimeMillis());
            DynamicObject[] copyAttFileds = copyAttFiledList.toArray(new DynamicObject[copyAttFiledList.size()]);
            SaveServiceHelper.save((DynamicObject[])copyAttFileds);
            log.debug("after ORM.create().save ," + System.currentTimeMillis());
            List<AttachmentInfo> attachmentInfoList = AttachmentServiceImpl.attFieldObjToAttachmentInfo(copyAttFiledList, pageId);
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)"IAttachmentManagerService");
            managerService.afterDoOperation(attachmentInfoList, AttachmentOpType.Upload);
        }
        return ids;
    }

    private DynamicObject getNewAttachDynamicObject(long genLongId, DynamicObject attachmentField, String pageId) {
        if (attachmentField == null) {
            return null;
        }
        DynamicObject attachment = (DynamicObject)OrmUtils.clone((IDataEntityBase)attachmentField, (boolean)false, (boolean)true);
        log.debug("aftere OrmUtils.clone2" + System.currentTimeMillis());
        String newPath = this.getPath(attachmentField);
        if (newPath == null) {
            return null;
        }
        log.debug("after fileService.upload ," + System.currentTimeMillis());
        attachment.set("url", (Object)newPath);
        attachment.set("id", (Object)genLongId);
        attachment.set("number", (Object)UUID.randomUUID());
        attachment.set("uid", (Object)AttachmentServiceHelper.generateUid());
        attachment.set("status", (Object)"B");
        attachment.set("tempfile", (Object)"0");
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            attachment.set("pageid", (Object)pageId);
        }
        return attachment;
    }

    private String getPath(DynamicObject attachmentField) {
        String path = attachmentField.getString("url");
        log.debug("getPath start = " + path);
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("decode\u89e3\u6790path\u5f02\u5e38 \uff1a " + path);
        }
        if (path.contains("tempfile/download.do")) {
            return path;
        }
        path = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(path);
        if (path.contains("download.do?path=")) {
            path = path.split("download.do\\?path=")[1];
            while (path.startsWith("//")) {
                path = path.replaceFirst("//", "/");
            }
        }
        log.debug("after getRealPath = " + path);
        if (StringUtils.isBlank((CharSequence)path) || !path.contains("/")) {
            return null;
        }
        String fileName = path.substring(path.lastIndexOf("/") + 1);
        log.debug("before fileService.getInputStream path = " + path + " ," + System.currentTimeMillis());
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(path);
        log.debug("after fileService.getInputStream path = " + path + " ," + System.currentTimeMillis());
        path = this.dealPath(path);
        FileItemExt item = new FileItemExt(fileName, path, in);
        item.setSource(FileSource.ATTACHMENT_FIELD);
        item.setCreateNewFileWhenExists(true);
        log.debug("before fileService.upload ," + System.currentTimeMillis());
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        int timeout = 7200;
        String newPath = cache.saveAsUrl(item.getFileName(), in, timeout);
        String address = RequestContext.get().getClientFullContextPath();
        if (!address.endsWith("/")) {
            address = address + "/";
        }
        newPath = address + newPath;
        return newPath;
    }

    private String dealPath(String path) {
        if (StringUtils.isBlank((CharSequence)path) || !path.contains(".") || !path.contains("/")) {
            return path;
        }
        String ext = path.substring(path.lastIndexOf("."));
        String prefixPath = path.substring(0, path.lastIndexOf("/") + 1);
        return prefixPath + Uuid8.generateShortUuid() + "_COPY" + ext;
    }

    public void writeBillFileMapping(List<AttachmentInfo> infos) {
        BillFileMappingWriter.write(infos);
    }

    public boolean hasWF(String pageId) {
        return FilePremissionUtil.tryGetHasRightValue((String)pageId);
    }
}

