/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.UUID;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.file.security.FileChecker;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.AttachFileService;
import kd.bos.service.attachment.AttachmentServiceImpl;

public class FilePathService
implements FileServiceExt {
    private static Log log = LogFactory.getLog(FilePathService.class);
    private AttachManageService manageService = new AttachManageService();

    private String createAttId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private boolean encrptyPath() {
        AttachmentServiceImpl service = new AttachmentServiceImpl();
        return service.isEncrptyPath();
    }

    public String getRealPath(String pathOrId) {
        if (AttachFileService.enableAttachmentCenter()) {
            return this.manageService.getAttachPath(pathOrId);
        }
        if (StringUtils.isBlank((CharSequence)pathOrId)) {
            return pathOrId;
        }
        if (pathOrId.contains(".")) {
            return pathOrId;
        }
        String sql = "select fpath from t_bas_filepathmapping where FFILEID = ? ";
        Object[] params = new SqlParameter[1];
        String filedId = pathOrId;
        try {
            filedId = URLDecoder.decode(pathOrId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        int lastIndex = filedId.lastIndexOf(47);
        if (lastIndex > -1 && filedId.length() > lastIndex + 1) {
            filedId = pathOrId.substring(lastIndex + 1);
        }
        params[0] = new SqlParameter(":FFILEID", 12, (Object)filedId);
        String realPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            String path = null;
            while (rs.next()) {
                path = rs.getString("fpath");
            }
            return path;
        });
        if (StringUtils.isBlank((CharSequence)realPath)) {
            return pathOrId;
        }
        return realPath;
    }

    public InputStream checkFile(InputStream inputStream, String fileName) {
        return FileChecker.fileSecurityVerification(inputStream, fileName);
    }

    public String save(String path) {
        if (AttachFileService.enableAttachmentCenter()) {
            return path;
        }
        if (!this.encrptyPath()) {
            return path;
        }
        String attId = this.createAttId();
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>();
        SqlParameter[] value = new SqlParameter[3];
        long id = DB.genLongId((String)"t_bas_filepathmapping");
        value[0] = new SqlParameter(":FID", -5, (Object)id);
        value[1] = new SqlParameter(":FFILEID", 12, (Object)attId);
        value[2] = new SqlParameter(":FPATH", -9, (Object)path);
        params.add(value);
        String sql = "INSERT INTO t_bas_filepathmapping(FID,FFILEID,FPATH) VALUES (?, ?, ?)";
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return attId;
    }
}

