/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment.extend.action;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.extend.action.IFileActionExtension;

public class FileActionExtensionFactory {
    private static Log logger = LogFactory.getLog(FileActionExtensionFactory.class);
    private static final String CLASSNAME_KEY = "file.action.ext.impl.classname";

    public static IFileActionExtension getFileActionExtension() {
        String className;
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        String string = className = securityParam.size() == 0 ? System.getProperty(CLASSNAME_KEY) : String.valueOf(securityParam.get("downloadimpldetail"));
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                return (IFileActionExtension)Class.forName(className).newInstance();
            }
            catch (Exception var2) {
                logger.error("init class " + className + " error:", (Throwable)var2);
            }
        }
        return FileActionExtensionFactory.getDefaultFileActionExtension();
    }

    public static IFileActionExtension getDefaultFileActionExtension() {
        return new DefaultFileActionExtension();
    }

    static class DefaultFileActionExtension
    implements IFileActionExtension {
        DefaultFileActionExtension() {
        }

        @Override
        public String getFileName(String path, String fileName) {
            return fileName;
        }

        @Override
        public String getFileName(String fileName) {
            return fileName;
        }
    }
}

