/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment.extend.permission;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionParam;
import kd.bos.service.attachment.extend.permission.IFilePermissionExtension;
import kd.bos.service.attachment.extend.permission.PermissionResult;

public class FilePermissionExtensionFactory {
    private static Log logger = LogFactory.getLog(FilePermissionExtensionFactory.class);
    private static final String CLASSNAME_KEY = "file.permission.ext.impl.classname";

    public static IFilePermissionExtension getFilePermissionExtension() {
        String className;
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        String string = className = securityParam.size() == 0 ? System.getProperty(CLASSNAME_KEY) : String.valueOf(securityParam.get("attpermissionimpldetail"));
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                return (IFilePermissionExtension)Class.forName(className).newInstance();
            }
            catch (Exception var2) {
                logger.error("init class " + className + " error:", (Throwable)var2);
            }
        }
        return FilePermissionExtensionFactory.getDefaultFilePermissionExtension();
    }

    public static IFilePermissionExtension getDefaultFilePermissionExtension() {
        return new DefaultFilePermissionExtension();
    }

    static class DefaultFilePermissionExtension
    implements IFilePermissionExtension {
        DefaultFilePermissionExtension() {
        }

        @Override
        public void dealPermissionParam(List<FilePermissionParam> filePermissionParamList) {
        }

        @Override
        public PermissionResult checkPermission(FilePermissionParam filePermissionParam) {
            return PermissionResult.pass();
        }
    }
}

