/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.validate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;

public class TempAttTimeOutValidator
extends AbstractValidator {
    public void validate() {
        if (this.getDataEntities().length <= 0) {
            return;
        }
        if (Boolean.parseBoolean(System.getProperty("op.tempattvalidator.disable"))) {
            return;
        }
        ExtendedDataEntity entity = this.getDataEntities()[0];
        Boolean hasTimeoutAtt = false;
        StringBuilder timeoutMessage = new StringBuilder(ResManager.loadKDString((String)"\u4e34\u65f6\u9644\u4ef6\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4ee5\u4e0b\u6587\u4ef6:\r\n", (String)"TempAttTimeOutValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]));
        if (this.getOption().containsVariable("AttachmentField")) {
            String pageId;
            String attachmentFieldString = this.getOption().getVariableValue("AttachmentField");
            Map attachmentField = (Map)SerializationUtils.fromJsonString((String)attachmentFieldString, Map.class);
            IAttachmentFieldModelProxy attachmentFieldService = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
            List timeOutAttList = attachmentFieldService.getTimeOutAttList(pageId = attachmentField.get("PageId").toString());
            if (!CollectionUtils.isEmpty((Collection)timeOutAttList)) {
                for (DynamicObject attDynamicObj : timeOutAttList) {
                    timeoutMessage.append(attDynamicObj.getLocaleString("name").getLocaleValue()).append("\r\n");
                    hasTimeoutAtt = true;
                }
            }
        }
        if (this.getOption().containsVariable("AttachmentPanel")) {
            String attachmentPanelString = this.getOption().getVariableValue("AttachmentPanel");
            Map attachmentPanel = (Map)SerializationUtils.fromJsonString((String)attachmentPanelString, Map.class);
            Map attachmentInfo = (Map)attachmentPanel.get("AttachmentInfo");
            for (Map.Entry info : attachmentInfo.entrySet()) {
                List attachments = (List)info.getValue();
                for (Map attach : attachments) {
                    TempFileCache downLoad;
                    String tempUrl = (String)attach.get("url");
                    if (!StringUtils.isNotBlank((CharSequence)tempUrl) || !tempUrl.contains("configKey") || (downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache()).exists(tempUrl)) continue;
                    timeoutMessage.append(attach.get("name")).append("\r\n");
                    hasTimeoutAtt = true;
                }
            }
        }
        if (hasTimeoutAtt.booleanValue()) {
            entity.setValidataErrorCode(ValidataErrorCode.AttTimeout);
            this.addErrorMessage(entity, timeoutMessage.toString());
        }
    }
}

