/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;

public class AttachmentWebApiPlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(AttachmentWebApiPlugin.class);
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private String formNumber = null;
    private String entityNumber = null;
    private String userId = null;
    private Object billPkId = null;
    private List<Object> attKeys = new ArrayList<Object>();
    private List<Object> attFieldKeys = new ArrayList<Object>();
    private List<Object> attPanelKeys = new ArrayList<Object>();
    private AttachmentType type = AttachmentType.attachmentpanel;
    private String appNum = null;
    private StringBuilder errMsgBuild = new StringBuilder();
    private boolean success = true;

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            if (!this.validParam(params)) {
                return ApiResult.fail((String)this.errMsgBuild.toString());
            }
            this.prepareProperty();
            StringBuilder builder = new StringBuilder();
            if (!this.checkPermission()) {
                return ApiResult.fail((String)this.errMsgBuild.toString());
            }
            List<Map<String, Object>> data = this.loadAttInfo();
            log.info("load attachment info: " + SerializationUtils.toJsonString(data));
            return ApiResult.success(data);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private boolean validParam(Map<String, Object> params) {
        if (params == null) {
            this.errMsgBuild.append(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u53c2\u6570", (String)"NO_PARAMS", (String)"bos-attachment", (Object[])new Object[0]));
            this.success = false;
            return false;
        }
        if (StringUtils.isNotBlank((Object)params.get("formNumber"))) {
            this.formNumber = params.get("formNumber").toString();
        }
        if (StringUtils.isNotBlank((Object)params.get("entityNumber"))) {
            this.entityNumber = params.get("entityNumber").toString();
        }
        if (StringUtils.isBlank((CharSequence)this.formNumber) && StringUtils.isBlank((CharSequence)this.entityNumber)) {
            this.errMsgBuild.append(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801\u6216\u5b9e\u4f53\u7f16\u7801(formNumber/entityNumber) \u672a\u4f20\u5165\u3002", (String)"NO_FORMENTITYNUMBER", (String)"bos-attachment", (Object[])new Object[0]));
            this.success = false;
            return false;
        }
        if (!StringUtils.isNotBlank((Object)params.get("billPkId"))) {
            this.errMsgBuild.append(ResManager.loadKDString((String)"\u8868\u5355\u5185\u7801 (billPkId) \u672a\u4f20\u5165\u3002", (String)"NO_BILLPKID", (String)"bos-attachment", (Object[])new Object[0]));
            this.success = false;
            return false;
        }
        this.billPkId = params.get("billPkId");
        String string = this.userId = params.get("userId") == null ? null : params.get("userId").toString();
        if (this.userId == null) {
            this.userId = RequestContext.get().getUserId();
        }
        if (StringUtils.isNotBlank((Object)params.get("attType"))) {
            this.type = AttachmentType.getTypeByValue((String)params.get("attType").toString());
        }
        if (StringUtils.isNotBlank((Object)params.get("attKeys"))) {
            this.attKeys = (List)params.get("attKeys");
        } else {
            this.type = AttachmentType.attachmentpanel;
        }
        if (StringUtils.isNotBlank((Object)params.get("appId"))) {
            this.appNum = params.get("appId").toString();
        }
        return true;
    }

    private void prepareProperty() {
        if (StringUtils.isNotBlank((CharSequence)this.entityNumber)) {
            if (this.attKeys != null && this.attKeys.size() > 0) {
                String entityId = MetadataDao.getIdByNumber((String)this.entityNumber, (MetaCategory)MetaCategory.Entity);
                AbstractMetadata metadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
                this.classifyAttType(metadata, this.attKeys);
            }
            return;
        }
        String formId = MetadataDao.getIdByNumber((String)this.formNumber, (MetaCategory)MetaCategory.Form);
        AbstractMetadata metadata = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        if (metadata instanceof FormMetadata) {
            FormMetadata formMetadata = (FormMetadata)metadata;
            this.classifyAttType(metadata, this.attKeys);
            if (formMetadata.getId().equals(formMetadata.getEntityId())) {
                this.entityNumber = this.formNumber;
            } else if (StringUtils.isNotBlank((CharSequence)formMetadata.getEntityId())) {
                this.entityNumber = MetadataDao.getEntityNumberById((String)formMetadata.getEntityId());
            } else {
                throw new KDException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u4f53", (String)"NO_ENTITY", (String)"bos-attachment", (Object[])new Object[0]));
            }
        }
        if (this.appNum == null) {
            String entityId = MetadataDao.getIdByNumber((String)this.entityNumber, (MetaCategory)MetaCategory.Entity);
            this.appNum = metadata.getBizappId();
        }
    }

    private void classifyAttType(AbstractMetadata meta, List<Object> keys) {
        ArrayList<String> attPanels = new ArrayList<String>();
        if (meta instanceof FormMetadata) {
            for (ControlAp control : ((FormMetadata)meta).getItems()) {
                if (!(control instanceof AttachmentPanelAp)) continue;
                attPanels.add(control.getKey());
            }
        }
        for (Object key : this.attKeys) {
            String keyString = key.toString();
            if (meta instanceof EntityMetadata) {
                if (((EntityMetadata)meta).getFieldByKey(keyString) instanceof AttachmentField) {
                    this.attFieldKeys.add(keyString);
                    continue;
                }
                this.attPanelKeys.add(keyString);
                continue;
            }
            if (!(meta instanceof FormMetadata)) continue;
            if (attPanels.contains(keyString)) {
                this.attPanelKeys.add(keyString);
                continue;
            }
            this.attFieldKeys.add(keyString);
        }
    }

    private boolean checkPermission() {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean hasViewPerm = permissionService.hasViewPermission(Long.parseLong(this.userId), this.appNum, this.entityNumber);
        if (!hasViewPerm) {
            this.errMsgBuild.append(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8868\u5355\u201d\u7684\u201c\u8bbf\u95ee\u201d\u6743\u9650\u3002", (String)"NO_FORM_PERMISSION", (String)"bos-attachment", (Object[])new Object[0]));
            this.success = hasViewPerm;
            return hasViewPerm;
        }
        boolean hasFilePerm = true;
        if (this.type == AttachmentType.attachmentfield && this.attFieldKeys != null && !this.attFieldKeys.isEmpty()) {
            String mainOrg = EntityMetadataCache.getDataEntityType((String)this.entityNumber).getMainOrg();
            long orgId = StringUtils.isNotBlank((CharSequence)mainOrg) ? this.getMainOrgId(mainOrg) : RequestContext.get().getOrgId();
            FieldControlRule rule = PermissionServiceHelper.getFieldControlRule((long)Long.parseLong(this.userId), (long)orgId, (String)this.appNum, (String)this.entityNumber);
            if (rule == null) {
                return hasViewPerm;
            }
            for (Object key : this.attFieldKeys) {
                this.errMsgBuild.append(ResManager.loadKDString((String)"\u65e0\u5b57\u6bb5\u8bbf\u95ee\u6743\u9650\uff0c\u5b57\u6bb5key:", (String)"NO_FILED_PERMISSION", (String)"bos-attachment", (Object[])new Object[0]));
                if (!rule.getCanNotReadFields().contains(key)) continue;
                this.errMsgBuild.append(key).append(';');
                hasFilePerm = false;
            }
        }
        this.success = hasViewPerm && hasFilePerm;
        return hasViewPerm && hasFilePerm;
    }

    private long getMainOrgId(String mainOrg) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.billPkId, (String)this.entityNumber);
        long orgId = -1L;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }

    private List<Map<String, Object>> loadAttInfo() {
        ArrayList<Map<String, Object>> result;
        block5: {
            block4: {
                QFilter[] filters = new QFilter[3];
                result = new ArrayList<Map<String, Object>>();
                if (this.type != AttachmentType.attachmentpanel) break block4;
                filters[0] = new QFilter("FBillType", "=", (Object)this.entityNumber);
                filters[1] = new QFilter("FInterID", "=", (Object)String.valueOf(this.billPkId));
                String attEntityNumber = "bos_attachment";
                String select = "fattachmentsize,fattachmentpanel,fattachmentname,ffileid,id";
                if (this.attPanelKeys != null && this.attPanelKeys.size() > 0) {
                    filters[2] = this.attPanelKeys.size() == 1 ? new QFilter(FATTACHMENTPANEL, "=", this.attPanelKeys.get(0)) : new QFilter(FATTACHMENTPANEL, "in", this.attPanelKeys);
                }
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)attEntityNumber, (String)select, (QFilter[])filters);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("attKey", String.valueOf(dynamicObject.getString(FATTACHMENTPANEL)));
                    data.put("attId", String.valueOf(dynamicObject.get("id")));
                    data.put("fileName", dynamicObject.getString("fattachmentname"));
                    data.put("size", dynamicObject.get("fattachmentsize"));
                    String domainUrl = UrlService.getDomainContextUrl();
                    String downloadUrl = domainUrl + "/attachment/download.do?id=" + String.valueOf(dynamicObject.get("id")) + "&type=" + this.type.getValue();
                    data.put("downloadUrl", downloadUrl);
                    result.add(data);
                }
                break block5;
            }
            if (this.type != AttachmentType.attachmentfield || this.attFieldKeys == null || this.attFieldKeys.isEmpty()) break block5;
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)this.billPkId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityNumber));
            for (Object field : this.attFieldKeys) {
                String fieldString = field.toString();
                DynamicObjectCollection collect = bill.getDynamicObjectCollection(fieldString);
                for (DynamicObject dynamicObject : collect) {
                    HashMap<String, Object> data = new HashMap<String, Object>(16);
                    data.put("attKey", String.valueOf(fieldString));
                    data.put("attId", String.valueOf(dynamicObject.get("id")));
                    data.put("fileName", dynamicObject.getString("name"));
                    data.put("size", dynamicObject.get("size"));
                    String domainUrl = UrlService.getDomainContextUrl();
                    String downloadUrl = domainUrl + "/attachment/download.do?id=" + String.valueOf(dynamicObject.get("id")) + "&type=" + this.type.getValue();
                    data.put("downloadUrl", downloadUrl);
                    result.add(data);
                }
            }
        }
        return result;
    }
}

