/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.preview;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.tomcat.util.codec.binary.Base64;

public class WpsPerviewSignture {
    private static Log log = LogFactory.getLog(WpsPerviewSignture.class);

    public static String getSignature(Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>(16);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder contents = new StringBuilder();
        for (String key : keys) {
            if (key.equals("_w_signature")) continue;
            contents.append(key).append("=").append(params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] byArray = WpsPerviewSignture.hmacSha1(appSecret.getBytes(), contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])byArray);
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        return sign;
    }

    public static byte[] hmacSha1(byte[] key, byte[] data) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error((Throwable)e);
        }
        return null;
    }
}

