/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.preview;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.SyncStatus;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.attachment.preview.WpsPerviewSignture;
import kd.bos.svc.attachment.preview.WpsPreviewInfo;
import kd.bos.svc.attachment.service.ThirdPreviewAndEditServiceFactory;
import kd.bos.svc.attachment.service.args.SaveEditFileArgs;
import kd.bos.svc.attachment.wps.dto.WpsFileInfo;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.url.UrlService;
import kd.bos.web.actions.utils.AttachmentUtil;

public class WpsPreviewHandle {
    private static DistributeSessionlessCache fileInfoRedisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("FILEINFO", new DistributeCacheHAPolicy(true, true));
    private static final DistributeSessionlessCache wpsOldCallbackFileInfo = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("wpsOldCallbackFileInfo", new DistributeCacheHAPolicy(true, true));
    private static Log log = LogFactory.getLog(WpsPreviewHandle.class);
    private static final Map<String, Set<String>> fileTypeMapping = new HashMap<String, Set<String>>(4);

    public static Map<String, Object> createWpsPreViewResult(String path, Map<String, Object> previewSetting) throws Exception {
        return WpsPreviewHandle.createWpsPreViewResult(path, previewSetting, new Watermark());
    }

    public static Map<String, Object> createWpsPreViewResult(String path, Map<String, Object> previewSetting, Watermark watermark) throws Exception {
        Object appId = previewSetting.getOrDefault("wps.appid", "");
        Object appSecret = previewSetting.getOrDefault("wps.appsecret", "");
        String wpsPreviewUrl = WpsPreviewHandle.createWpsPreViewUrl(path, appId, appSecret, false, "", watermark);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("status", "success");
        resultMap.put("url", wpsPreviewUrl);
        resultMap.put("support", true);
        if ("NOTSUPPORT".equals(wpsPreviewUrl)) {
            resultMap.put("status", "error");
            resultMap.put("support", false);
        }
        return resultMap;
    }

    protected static String createWpsPreViewUrl(String path, Object appId, Object appSecret, boolean isEdit, String rootPageId, Watermark watermark) throws Exception {
        WpsPreviewInfo wpsPreviewInfo = WpsPreviewHandle.queryBillFillMapping(path);
        String fileName = wpsPreviewInfo.getName();
        log.debug("createWpsPreViewUrl get filename is:" + fileName);
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!isEdit && !WpsPreviewHandle.supportWpsPreview(fileType)) {
            return "NOTSUPPORT";
        }
        String wpsFileInfoId = WpsPreviewHandle.convertBillFillMapping(wpsPreviewInfo, isEdit, watermark);
        String attPkId = wpsPreviewInfo.getId();
        String type = WpsPreviewHandle.getFileType(fileName);
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("_w_appid", String.valueOf(appId));
        paramMap.put("_w_id", wpsFileInfoId);
        String customParam = ParamUtil.getParamByType((String)"2", (!isEdit ? 1 : 0) != 0);
        if (null != customParam && customParam.contains("_w_")) {
            String[] customParamArray;
            for (String oneParam : customParamArray = customParam.split("&")) {
                String[] oneParamSplit;
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)oneParam) || !oneParam.contains("_w_") || (oneParamSplit = oneParam.split("=")).length != 2 || !oneParamSplit[0].contains("_w_")) continue;
                paramMap.put(oneParamSplit[0], oneParamSplit[1]);
            }
        }
        if (isEdit) {
            paramMap.put("_w_fname", fileName);
        }
        String signature = WpsPerviewSignture.getSignature(paramMap, String.valueOf(appSecret));
        String isPreview = isEdit ? "0" : "1";
        String wpsPreviewUrl = "https://wwo.wps.cn/office/" + type + "/" + attPkId + "?_w_appid=" + appId + "&_w_id=" + wpsFileInfoId + "&_w_signature=" + signature + "&isPreview=" + isPreview;
        if (isEdit) {
            wpsPreviewUrl = wpsPreviewUrl + "&p=" + rootPageId + "&_w_fname=" + fileName;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customParam)) {
            wpsPreviewUrl = wpsPreviewUrl + customParam;
        }
        return AttachmentServiceHelper.getEncreptURL((String)wpsPreviewUrl);
    }

    protected static String getFileType(String fileName) {
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileExt)) {
            return "w";
        }
        for (Map.Entry<String, Set<String>> entry : fileTypeMapping.entrySet()) {
            if (!entry.getValue().contains(fileExt.toLowerCase(Locale.ENGLISH))) continue;
            return entry.getKey();
        }
        return "w";
    }

    protected static String convertBillFillMapping(WpsPreviewInfo wpsPreviewInfo, boolean isEdit, Watermark watermark) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        HashMap<String, Object> fileMap = new HashMap<String, Object>(16);
        HashMap<String, String> userMap = new HashMap<String, String>(16);
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String userName = requestContext.getUserName();
        long now = WpsPreviewHandle.getSecondTimestamp();
        String id = wpsPreviewInfo.getId();
        fileMap.put("id", id);
        fileMap.put("name", wpsPreviewInfo.getName());
        fileMap.put("version", WpsPreviewHandle.getSecondTimestamp());
        fileMap.put("size", wpsPreviewInfo.getSize());
        fileMap.put("creator", userId);
        fileMap.put("create_time", now);
        fileMap.put("modifier", userId);
        fileMap.put("modify_time", now);
        String attUrl = wpsPreviewInfo.getDownloadUrl();
        if (wpsPreviewInfo.getDownloadUrl() != null && wpsPreviewInfo.getDownloadUrl().contains("tempfile/download.do?configKey")) {
            attUrl = AttachmentServiceHelper.getEncreptURL((String)attUrl);
        } else {
            attUrl = AttachmentUtil.encodePath(attUrl);
            attUrl = AttachmentServiceHelper.getEncreptURL((String)UrlService.getAttachmentFullUrl((String)attUrl));
        }
        attUrl = AttachmentUtil.addDownloadSourceParam(attUrl, "&isFromWps=1");
        attUrl = AttachmentPreviewUtil.getReplaceUrl((String)attUrl, (String)"0", (!isEdit ? 1 : 0) != 0);
        fileMap.put("download_url", attUrl);
        if (!isEdit && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)watermark.getValue())) {
            fileMap.put("watermark", watermark);
        }
        resultMap.put("file", fileMap);
        userMap.put("id", userId);
        userMap.put("name", userName);
        if (isEdit) {
            userMap.put("permission", "write");
        } else {
            userMap.put("permission", "read");
        }
        resultMap.put("user", userMap);
        resultMap.put("code", 200);
        resultMap.put("message", "sucess");
        String jsonResult = SerializationUtils.toJsonString(resultMap);
        String uuid = UUID.randomUUID().toString();
        log.debug("\u83b7\u53d6fileInfoForWps\u53c2\u6570\u5b8c\u6210\uff0ckey is " + uuid + " , value is " + jsonResult);
        if (isEdit) {
            wpsOldCallbackFileInfo.put("EDIT" + uuid, (Object)jsonResult, 8, TimeUnit.HOURS);
        } else {
            wpsOldCallbackFileInfo.put("PREVIEW" + uuid, (Object)jsonResult, 5, TimeUnit.MINUTES);
        }
        return uuid;
    }

    protected static WpsPreviewInfo queryBillFillMapping(String path) throws Exception {
        WpsPreviewInfo wpsPreviewInfo = path.contains("tempfile/download.do?configKey") ? WpsPreviewHandle.getWpsPreviewInfoByTempFile(path) : WpsPreviewHandle.getWpsPreviewInfoByFile(path);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)wpsPreviewInfo.getName()) || wpsPreviewInfo.getSize() == 0L) {
            wpsPreviewInfo = WpsPreviewHandle.tryToCreateWpsPreview(path);
        }
        return wpsPreviewInfo;
    }

    private static WpsPreviewInfo tryToCreateWpsPreview(String path) {
        log.debug("try to get fileInfo, path is " + path);
        try {
            String attPkId = UUID.randomUUID().toString().replace("-", "");
            Long size = Long.parseLong(String.valueOf(AttachmentServiceHelper.getFileSizeByPath((String)path)));
            String name = path.substring(path.lastIndexOf("/") + 1);
            return new WpsPreviewInfo(attPkId, path, name, size);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDException("can not get wpsPreviewUrl param : " + e);
        }
    }

    private static WpsPreviewInfo getWpsPreviewInfoByFile(String path) {
        String attPkId = "";
        String name = "";
        Long size = 0L;
        QFilter pathEquals = new QFilter("path", "=", (Object)path);
        QFilter syncStatusEquals = new QFilter("syncStatus", "=", (Object)SyncStatus.Success.getValue());
        String selectFields = "attPkId,fieldtype,filename,path";
        QFilter[] qFilters = new QFilter[]{pathEquals, syncStatusEquals};
        DynamicObject billFileMapping = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_bill_file_mapping", (String)selectFields, (QFilter[])qFilters);
        if (billFileMapping == null) {
            return new WpsPreviewInfo(attPkId, path, name, size);
        }
        String fieldtype = billFileMapping.getString("fieldtype");
        name = billFileMapping.getString("filename");
        Long attPkIdObj = billFileMapping.getLong("attPkId");
        attPkId = String.valueOf(attPkIdObj);
        if (FieldType.AttachmentPanel.getValue().equals(fieldtype)) {
            selectFields = "fattachmentsize";
            DynamicObject attachmentPanel = BusinessDataServiceHelper.loadSingleFromCache((Object)attPkIdObj, (String)"bos_attachment", (String)selectFields);
            size = attachmentPanel.getLong(selectFields);
        } else if (FieldType.AttachmentEdit.getValue().equals(fieldtype)) {
            selectFields = "size";
            DynamicObject attachmentPanel = BusinessDataServiceHelper.loadSingleFromCache((Object)attPkIdObj, (String)"bd_attachment", (String)selectFields);
            size = attachmentPanel.getLong(selectFields);
        }
        return new WpsPreviewInfo(attPkId, path, name, size);
    }

    private static WpsPreviewInfo getWpsPreviewInfoByTempFile(String path) {
        String attPkId = "";
        String name = "";
        Long size = 0L;
        String tempFileId = UrlUtil.getParam((String)path, (String)"id");
        String fileInfoMapJson = (String)fileInfoRedisCache.get("FileInfo:" + tempFileId);
        log.debug("get fileInfoMapJson is " + fileInfoMapJson);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileInfoMapJson)) {
            Map fileInfoMap = (Map)SerializationUtils.fromJsonString((String)fileInfoMapJson, Map.class);
            attPkId = String.valueOf(fileInfoMap.get("uid"));
            name = String.valueOf(fileInfoMap.get("name"));
            size = Long.parseLong(String.valueOf(fileInfoMap.get("size")));
        }
        return new WpsPreviewInfo(attPkId, path, name, size);
    }

    private static long getSecondTimestamp() {
        Date date = new Date();
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Long.parseLong(timestamp.substring(0, length - 3));
        }
        return 0L;
    }

    public static String getFileInfoById(String id, String isPreview) {
        String callbackInfo;
        boolean preview = org.apache.commons.lang3.StringUtils.equals((CharSequence)isPreview, (CharSequence)"1");
        if (preview) {
            callbackInfo = (String)wpsOldCallbackFileInfo.get("PREVIEW" + id);
            wpsOldCallbackFileInfo.put("PREVIEW" + id, (Object)callbackInfo, 5, TimeUnit.MINUTES);
        } else {
            log.debug("start callback wps public old edit info");
            callbackInfo = (String)wpsOldCallbackFileInfo.get("EDIT" + id);
            wpsOldCallbackFileInfo.put("EDIT" + id, (Object)callbackInfo, 8, TimeUnit.HOURS);
        }
        log.debug("wps public old callback file info is:" + callbackInfo);
        return callbackInfo;
    }

    public static boolean supportWpsPreview(String fileExt) {
        for (String type : SupportPreviewTypeConstant.wpsPublicSupportPreview) {
            if (!type.equalsIgnoreCase(fileExt)) continue;
            return true;
        }
        return false;
    }

    protected static String saveFileAndSendMessage(String identifyType, String fileName, InputStream in, String wId, Integer version) throws IOException {
        return WpsPreviewHandle.saveFileAndSendMessage(identifyType, fileName, in, wId, version, null);
    }

    protected static String saveFileAndSendMessage(String identifyType, String fileName, InputStream in, String wId, Integer version, String customEditInfo) throws IOException {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        long size = in.available();
        String tempUrl = cache.saveAsFullUrl(fileName, in, 7200);
        if (StringUtils.isNotBlank((CharSequence)identifyType)) {
            MsgSendFactory.getSender().send(identifyType, SerializationUtils.toJsonString(AttachmentUtil.assembleParam(tempUrl, wId)));
        }
        WpsFileInfo wpsFileInfo = new WpsFileInfo(wId, fileName, version, size, EncreptSessionUtils.encryptSession((String)tempUrl));
        HashMap<String, WpsFileInfo> resultMap = new HashMap<String, WpsFileInfo>(2);
        resultMap.put("file", wpsFileInfo);
        SaveEditFileArgs saveEditFileArgs = new SaveEditFileArgs(customEditInfo, tempUrl, fileName, identifyType);
        ThirdPreviewAndEditServiceFactory.getService().saveEditFile(saveEditFileArgs);
        return SerializationUtils.toJsonString(resultMap);
    }

    protected static int getCurrentFileVersion(String fileId) {
        DynamicObject attachVersionInfo = WpsPreviewHandle.getFileVersionDyn(fileId);
        if (null != attachVersionInfo) {
            return attachVersionInfo.getInt("version");
        }
        return 1;
    }

    protected static int updateFileVersion(String fileId, String editType) {
        int version;
        DynamicObject attachVersionInfo = WpsPreviewHandle.getFileVersionDyn(fileId);
        if (null == attachVersionInfo) {
            version = 2;
            DynamicObject newAttachVersionInfo = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment_version", (boolean)true, (OperateOption)OperateOption.create());
            newAttachVersionInfo.set("attachid", (Object)fileId);
            newAttachVersionInfo.set("version", (Object)version);
            newAttachVersionInfo.set("edittype", (Object)editType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAttachVersionInfo});
        } else {
            version = attachVersionInfo.getInt("version") + 1;
            attachVersionInfo.set("version", (Object)version);
            SaveServiceHelper.update((DynamicObject)attachVersionInfo);
        }
        return version;
    }

    private static DynamicObject getFileVersionDyn(String fileId) {
        QFilter qFilter = new QFilter("attachid", "=", (Object)fileId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_attachment_version", (QFilter[])qFilters);
    }

    static {
        String[] wFileTypes = "doc,dot,wps,wpt,docx,dotx,docm,dotm,rtf,txt,xml,mhtml,mht,html,htm,uof".split(",");
        HashSet<String> wSet = new HashSet<String>(Arrays.asList(wFileTypes));
        fileTypeMapping.put("w", wSet);
        String[] sFileTypes = "xls,xlt,et,xlsx,xltx,csv,xlsm,xltm,ett".split(",");
        HashSet<String> sSet = new HashSet<String>(Arrays.asList(sFileTypes));
        fileTypeMapping.put("s", sSet);
        String[] pFileTypes = "ppt,pptx,pptm,ppsx,ppsm,pps,potx,potm,dpt,dps,pot".split(",");
        HashSet<String> pSet = new HashSet<String>(Arrays.asList(pFileTypes));
        fileTypeMapping.put("p", pSet);
        String[] fFileTypes = "pdf".split(",");
        HashSet<String> fSet = new HashSet<String>(Arrays.asList(fFileTypes));
        fileTypeMapping.put("f", fSet);
    }
}

