/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.path.DecodeFileFactory;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.attachment.service.KKFileViewPreviewService;
import kd.bos.svc.attachment.service.args.KKFileViewPreviewArgs;
import kd.bos.url.UrlService;

public class KKFileViewPreviewServiceImpl
implements KKFileViewPreviewService {
    private static final Log log = LogFactory.getLog(KKFileViewPreviewServiceImpl.class);

    @Override
    public Map<String, Object> getPreviewResult(KKFileViewPreviewArgs previewArgs) {
        String path = previewArgs.getPath();
        String fileName = previewArgs.getFileName();
        path = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
        boolean isTemp = path.contains("tempfile/download.do?configKey");
        return this.getKKFileViewConvertResult(path, fileName, isTemp, previewArgs.getWatermarkInfos());
    }

    private Map<String, Object> getKKFileViewConvertResult(String path, String fileName, boolean isTemp, Map<String, Object> watermarkInfos) {
        HashMap<String, Object> previewResult = new HashMap<String, Object>();
        String url = "";
        try {
            url = this.getKKFileViewConvertUrl(path, fileName, isTemp, watermarkInfos);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), ExceptionUtil.setErrorInfo((String)e.getMessage()));
            return previewResult;
        }
        previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.URL.getEnumName());
        previewResult.put(PreviewParams.RESULT.getEnumName(), url);
        return previewResult;
    }

    private String getKKFileViewConvertUrl(String path, String fileName, boolean isTemp, Map<String, Object> watermarkInfos) {
        String kkViewUrl = this.getKKFileViewUrl();
        String fileUrl = "";
        String watermarkParams = "";
        try {
            if (!isTemp) {
                path = path.replaceAll("//", "/");
                path = UrlService.getAttachmentDownloadUrl((String)path);
            }
            fileUrl = EncreptSessionUtils.encryptSession((String)path);
            fileUrl = fileUrl + "&source=preview&fullfilename=" + fileName;
            fileUrl = Base64.getEncoder().encodeToString(fileUrl.getBytes(StandardCharsets.UTF_8));
            watermarkParams = this.getWatermarkParams(watermarkInfos);
            fileUrl = URLEncoder.encode(fileUrl, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9884\u89c8\u94fe\u63a5\u5931\u8d25\u3002", (Throwable)e);
            throw new KDException(new ErrorCode("PREVIEW_ERROR", ResManager.loadKDString((String)"\u9884\u89c8\u5931\u8d25\u3002", (String)"KKFileViewPreviewServiceImpl_0", (String)"bos-attachment", (Object[])new Object[0])), new Object[0]);
        }
        return kkViewUrl + "?url=" + fileUrl + watermarkParams;
    }

    private String getWatermarkParams(Map<String, Object> watermarkInfos) throws UnsupportedEncodingException {
        Object globalAlpha;
        Object color;
        Object isAddWaterMark = watermarkInfos.get("isAddWaterMark");
        if (!Boolean.parseBoolean(String.valueOf(isAddWaterMark))) {
            return "";
        }
        StringBuilder watermarkUrl = new StringBuilder();
        Object text = watermarkInfos.get("text");
        if (StringUtils.isBlank((Object)text)) {
            return "";
        }
        watermarkUrl.append("&watermarkTxt=").append(URLEncoder.encode(((String)text).replaceAll("\n", ""), StandardCharsets.UTF_8.name()));
        Object fontSize = watermarkInfos.get("fontSize");
        if (StringUtils.isNotBlank((Object)fontSize)) {
            watermarkUrl.append("&watermarkFontsize=").append(URLEncoder.encode(fontSize.toString(), StandardCharsets.UTF_8.name()));
        }
        if (StringUtils.isNotBlank((Object)(color = watermarkInfos.get("color")))) {
            watermarkUrl.append("&watermarkColor=").append(URLEncoder.encode((String)color, StandardCharsets.UTF_8.name()));
        }
        if (StringUtils.isNotBlank((Object)(globalAlpha = watermarkInfos.get("globalAlpha")))) {
            double alpha = Double.parseDouble(globalAlpha.toString()) / 100.0;
            watermarkUrl.append("&watermarkAlpha=").append(URLEncoder.encode(Double.toString(alpha), StandardCharsets.UTF_8.name()));
        }
        return watermarkUrl.toString();
    }

    private String getKKFileViewUrl() {
        IParameterReaderService parameterReaderService = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);
        Map fileServerConfig = parameterReaderService.loadPublicParameterFromCache("bos_fileserverconfig");
        Object kkFileViewUrl = fileServerConfig.get("kkfileviewurl");
        if (StringUtils.isBlank(kkFileViewUrl)) {
            throw new KDException(new ErrorCode("PREVIEW_ERROR", ResManager.loadKDString((String)"\u672a\u914d\u7f6ekkFileView\u670d\u52a1\u8bbf\u95ee\u5730\u5740\u3002", (String)"KKFileViewPreviewServiceImpl_1", (String)"bos-attachment", (Object[])new Object[0])), new Object[0]);
        }
        String url = (String)kkFileViewUrl;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url + "/onlinePreview";
    }
}

