/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.yozo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.form.attachment.util.YozoPreviewConvertMapping;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.preview.WpsPreviewInfo;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.FilePathUtil;
import org.apache.commons.lang.StringEscapeUtils;

public class YozoDocumentHandle
extends WpsPreviewHandle {
    private static final Log log = LogFactory.getLog(YozoDocumentHandle.class);
    private static final String WO_API = "/api.do";
    private static final String FCS_API_PREVIEW = "/composite/httpfile";
    private static final String PICTURE_SUPPORT = "png,jpg,jpeg,gif,bmp";

    public static Map<String, Object> createYozoPreViewResult(String fileName, String path) {
        return YozoDocumentHandle.createYozoPreViewResult(fileName, path, new HashMap<String, Object>());
    }

    public static Map<String, Object> createYozoPreViewResult(String fileName, String path, Map<String, Object> watermark) {
        String yozoPreviewUrl = YozoDocumentHandle.getPreviewUrl(fileName, path, watermark);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("status", "success");
        resultMap.put("url", yozoPreviewUrl);
        resultMap.put("support", true);
        if (StringUtils.isBlank((String)yozoPreviewUrl)) {
            resultMap.put("status", "error");
            resultMap.put("support", false);
        }
        return resultMap;
    }

    private static String getPreviewUrl(String fileName, String path, Map<String, Object> watermark) {
        String address = ParamUtil.getYozoPreviewServerAddress();
        String requestUrl = address + FCS_API_PREVIEW;
        String response = "";
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (PICTURE_SUPPORT.contains(ext.toLowerCase(Locale.ENGLISH))) {
            return "";
        }
        YozoPreviewConvertMapping mapping = YozoPreviewConvertMapping.getInstance();
        int convert = mapping.getConvertType(ext);
        try {
            String downloadUrl = YozoDocumentHandle.getDownloadUrl(path);
            downloadUrl = EncreptSessionUtils.encryptSession((String)downloadUrl);
            downloadUrl = AttachmentUtil.addDownloadSourceParam(downloadUrl, "&isFromYozo=1");
            downloadUrl = AttachmentPreviewUtil.getReplaceUrl((String)downloadUrl, (String)"0", (boolean)true);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("convertType", convert);
            param.put("fileUrl", downloadUrl);
            param.put("isPrint", 1);
            if (YozoDocumentHandle.checkCanAddWatermark(convert) && null != watermark.get("wmContent")) {
                param.put("wmContent", watermark.get("wmContent"));
                param.put("wmSize", watermark.get("wmSize"));
                param.put("wmColor", watermark.get("wmColor"));
                param.put("wmTransparency", watermark.get("wmTransparency"));
            }
            response = HttpClientUtils.post((String)requestUrl, null, param);
        }
        catch (Exception e) {
            log.error("get yozo preview url failed:", (Throwable)e);
        }
        String previewUrl = "";
        if (StringUtils.isNotBlank((String)response)) {
            log.debug("get yozo previewUrl response is:" + response);
            JSONObject jsonObject = JSON.parseObject((String)response);
            if (jsonObject.get((Object)"errorcode") instanceof Integer && (Integer)jsonObject.get((Object)"errorcode") == 0) {
                Object data = jsonObject.get((Object)"data");
                if (data instanceof JSONObject) {
                    previewUrl = ((JSONObject)data).getString("viewUrl");
                    previewUrl = AttachmentPreviewUtil.getReplaceUrl((String)previewUrl, (String)"1", (boolean)true);
                    return previewUrl;
                }
            } else {
                return String.valueOf(jsonObject.get((Object)"message"));
            }
        }
        return previewUrl;
    }

    private static boolean checkCanAddWatermark(int convertType) {
        for (int type : SupportPreviewTypeConstant.yozoSupportWatermarkType) {
            if (type != convertType) continue;
            return true;
        }
        return false;
    }

    public static String getEditUrlForYozo(String url, String rootPageId) throws Exception {
        log.debug("getEditUrlForYozo param url is:" + url);
        String path = UrlUtil.getParam((String)url, (String)"path");
        path = FilePathUtil.dealPath((String)URLDecoder.decode(path, "UTF-8"), (String)"attach");
        log.debug("getEditUrlForYozo path is:" + path);
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
        }
        WpsPreviewInfo wpsPreviewInfo = YozoDocumentHandle.queryBillFillMapping(path);
        String fileName = wpsPreviewInfo.getName();
        log.debug("getEditUrlForYozo get filename is:" + fileName);
        return YozoDocumentHandle.getEditUrl(fileName, path, wpsPreviewInfo.getId(), rootPageId);
    }

    public static String getNewEditUrlForYozo(String url, String rootPageId, String fileName, Integer size) {
        String fileId = UUID.randomUUID().toString().replace("-", "");
        WpsPreviewInfo wpsPreviewInfo = new WpsPreviewInfo(fileId, url, fileName, size.intValue());
        return YozoDocumentHandle.getEditUrl(fileName, url, wpsPreviewInfo.getId(), rootPageId);
    }

    public static String saveDocument(String identifyType, String fileName, InputStream in, String fileId) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = cache.saveAsFullUrl(fileName, in, 7200);
        if (StringUtils.isNotBlank((String)identifyType)) {
            MsgSendFactory.getSender().send(identifyType, SerializationUtils.toJsonString(AttachmentUtil.assembleParam(tempUrl, fileId)));
        }
        return "ok";
    }

    private static String getEditUrl(String fileName, String path, String fileId, String rootPageId) {
        String response = YozoDocumentHandle.requestYozoEditApi(fileName, path, 1, fileId, rootPageId);
        if (StringUtils.isNotBlank((String)response)) {
            Object data;
            log.debug("get yozo edit response is:" + response);
            JSONObject jsonObject = JSON.parseObject((String)response);
            if ("0".equals(jsonObject.get((Object)"errorCode")) && (data = jsonObject.get((Object)"result")) instanceof JSONObject) {
                String editUrl = ((JSONObject)data).getString("urls");
                editUrl = AttachmentPreviewUtil.getReplaceUrl((String)editUrl, (String)"1", (boolean)false);
                return editUrl;
            }
        }
        return "";
    }

    private static String requestYozoEditApi(String fileName, String path, int method, String fileId, String rootPageId) {
        String response = "";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fileId", fileId);
        if (method == 1) {
            String downLoadUrl = path.contains("tempfile/download.do?configKey") ? path : UrlService.getAttachmentFullUrl((String)path);
            downLoadUrl = EncreptSessionUtils.encryptSession((String)downLoadUrl);
            downLoadUrl = AttachmentUtil.addDownloadSourceParam(downLoadUrl, "&isFromYozo=1");
            downLoadUrl = AttachmentPreviewUtil.getReplaceUrl((String)downLoadUrl, (String)"0", (boolean)false);
            param.put("userRight", 0);
            param.put("userId", RequestContext.get().getUserId());
            param.put("filePath", downLoadUrl);
            param.put("fileName", fileName);
            param.put("saveFlag", true);
            String domainUrl = UrlService.getDomainContextUrl();
            String callbackUrl = domainUrl + "/attachment/v1/3rd/file/save?isYozo=1&fileId=" + fileId + "&p=" + rootPageId;
            callbackUrl = EncreptSessionUtils.encryptSession((String)callbackUrl);
            param.put("callbackUrl", callbackUrl);
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("params", param);
        params.put("method", Integer.valueOf(method));
        String paramStr = SerializationUtils.toJsonString(params);
        try {
            paramStr = URLEncoder.encode(StringEscapeUtils.unescapeJavaScript((String)paramStr), "UTF-8");
        }
        catch (Exception e) {
            log.error("paramStr encode failed:", (Throwable)e);
        }
        HashMap<String, String> finalParam = new HashMap<String, String>();
        finalParam.put("jsonParams", paramStr);
        String address = ParamUtil.getYozoEditServerAddress();
        String requestUrl = address + WO_API;
        try {
            response = HttpClientUtils.post((String)requestUrl, null, finalParam);
        }
        catch (Exception e) {
            log.error("get yozo edit url failed:", (Throwable)e);
        }
        return response;
    }

    private static String getDownloadUrl(String path) throws UnsupportedEncodingException {
        String downloadUrl = path.contains("tempfile/download.do?configKey") ? path : UrlService.getAttachmentFullUrl((String)URLEncoder.encode(path, "utf-8"));
        return downloadUrl;
    }
}

