/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;

public class FileContentTypeFactory {
    private static Map<String, FileContentType> fileContentTypesAboutSuffix;

    private FileContentTypeFactory() {
    }

    public static Optional<String> getFileContentTypeBySuffix(String fileSuffix) {
        if (StringUtils.isBlank((CharSequence)fileSuffix)) {
            return Optional.empty();
        }
        FileContentType fileContentType = fileContentTypesAboutSuffix.get(fileSuffix = fileSuffix.toLowerCase());
        if (fileContentType != null) {
            return Optional.of(fileContentType.getContentType());
        }
        return Optional.empty();
    }

    static {
        LinkedList<FileContentType> fileContentTypes = new LinkedList<FileContentType>();
        fileContentTypes.add(new FileContentType("jpg", "image/jpeg"));
        fileContentTypes.add(new FileContentType("jpeg", "image/jpeg"));
        fileContentTypes.add(new FileContentType("jpe", "image/jpeg"));
        fileContentTypes.add(new FileContentType("jfif", "image/jpeg"));
        fileContentTypes.add(new FileContentType("gif", "image/gif"));
        fileContentTypes.add(new FileContentType("bmp", "image/bmp"));
        fileContentTypes.add(new FileContentType("dib", "image/bmp"));
        fileContentTypes.add(new FileContentType("png", "image/png"));
        fileContentTypes.add(new FileContentType("rle", "image/rle"));
        fileContentTypes.add(new FileContentType("emf", "image/x-emf"));
        fileContentTypes.add(new FileContentType("pcx", "image/x-pcx"));
        fileContentTypes.add(new FileContentType("dcx", "application/x-dcx"));
        fileContentTypes.add(new FileContentType("pic", "image/pict"));
        fileContentTypes.add(new FileContentType("tga", "image/x-tga"));
        fileContentTypes.add(new FileContentType("tif", "image/tiff"));
        fileContentTypes.add(new FileContentType("wmf", "image/x-wmf"));
        fileContentTypes.add(new FileContentType("pdf", "application/pdf"));
        fileContentTypes.add(new FileContentType("pptx", "application/pdf"));
        fileContentTypes.add(new FileContentType("ppt", "application/pdf"));
        fileContentTypes.add(new FileContentType("doc", "application/pdf"));
        fileContentTypes.add(new FileContentType("docx", "application/pdf"));
        fileContentTypes.add(new FileContentType("txt", "text/plain"));
        fileContentTypesAboutSuffix = fileContentTypes.stream().collect(Collectors.toMap(FileContentType::getFileSuffix, fileContentType -> fileContentType));
    }

    static class FileContentType {
        private String fileSuffix;
        private String contentType;

        public FileContentType(String fileSuffix, String contentType) {
            this.fileSuffix = fileSuffix;
            this.contentType = contentType;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

