/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class FileUploadUrlUtil {
    private static boolean FILEUPLOAD_WITHURL = true;
    private static String IMAGE_FORMAT = "/%s/api/image/%s/%s";
    private static String ATTACHMENT_FORMAT = "/%s/%s/%s/api/attachment/%s/%s";
    private static String DEFAULT_TENANTID = "tenantapi";
    private static String DEFAULT_ACCOUNTID = "accountapi";

    public static boolean isFileUploadWithUrl() {
        return FILEUPLOAD_WITHURL;
    }

    public static String getImageRandomUrl(String fileName) {
        String monthStr = FileUploadUrlUtil.getMonthStr();
        return String.format(IMAGE_FORMAT, monthStr, FileUploadUrlUtil.createRandomId(), fileName);
    }

    public static String getAttachmentRandomUrl(String fileName) {
        String tenantId = null;
        String accountId = null;
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            tenantId = rc.getTenantId();
            accountId = rc.getAccountId();
        }
        if (StringUtils.isEmpty(tenantId)) {
            tenantId = DEFAULT_TENANTID;
        }
        if (StringUtils.isEmpty(accountId)) {
            accountId = DEFAULT_ACCOUNTID;
        }
        String monthStr = FileUploadUrlUtil.getMonthStr();
        return String.format(ATTACHMENT_FORMAT, tenantId, accountId, monthStr, FileUploadUrlUtil.createRandomId(), fileName);
    }

    private static String getMonthStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        String monthStr = sf.format(cale.getTime());
        return monthStr;
    }

    private static String createRandomId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    static {
        ConfigurationUtil.observeBoolean((String)"fileUpload.withUrl", (boolean)FILEUPLOAD_WITHURL, b -> {
            FILEUPLOAD_WITHURL = b;
        });
    }
}

