/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PictureResourceListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String STR = ";\r\n";
    private static final String VALUES = " VALUES ";

    public void setFilter(SetFilterEvent e) {
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isEmpty((CharSequence)currentIsv) || "kingdee".equalsIgnoreCase(currentIsv)) {
            e.addCustomQFilter(new QFilter("isv", "=", (Object)currentIsv).or("isv", "=", (Object)""));
            e.setOrderBy("fcreatedate desc");
        } else {
            e.addCustomQFilter(new QFilter("isv", "=", (Object)currentIsv));
            e.setOrderBy("fcreatedate desc");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("barbatchimport".equals(evt.getItemKey())) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchinput"));
            param.setFormId("ide_importresource");
            this.getView().showForm(param);
        } else if ("bargensql".equals(evt.getItemKey())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PictureResourceListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Object[] pkids = selectedRows.getPrimaryKeyValues();
            Map objs = BusinessDataServiceHelper.loadFromCache((Object[])pkids, (String)"ide_pictureresediter");
            StringBuilder sb = new StringBuilder();
            sb.append("/*  creator\uff1a").append(RequestContext.get().getUserName()).append("\r\n");
            sb.append(ResManager.loadKDString((String)"\u672c\u811a\u672c\u4e3a\u9884\u63d2\u811a\u672c\uff0c\u53ef\u653e\u5165\u5b89\u88c5\u90e8\u7f72\u5305\u5185\u90e8\u7f72\u5230\u6b63\u5f0f\u73af\u5883\u3002\r\n", (String)"PictureResourceListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            sb.append("********************************************************************* \r\n ");
            sb.append("*/ \r\n ");
            String currentIsv = ISVService.getISVInfo().getId();
            if (!StringUtils.isEmpty((CharSequence)currentIsv) && !"kingdee".equalsIgnoreCase(currentIsv)) {
                QFilter filter = new QFilter("number", "=", (Object)currentIsv);
                DynamicObjectCollection categoryObjs = QueryServiceHelper.query((String)"bos_resourcecategory", (String)"id, name, number, enable, status, level, isleaf, parent, longnumber, modifytime, createtime,creator", (QFilter[])new QFilter[]{filter});
                for (DynamicObject dynObj : categoryObjs) {
                    String categoryString = this.genResCategorySql(dynObj);
                    sb.append(categoryString);
                }
            }
            for (DynamicObject obj : objs.values()) {
                String ssql = this.genResSql(obj);
                if (!StringUtils.isNotEmpty((CharSequence)ssql)) continue;
                sb.append(ssql);
            }
            this.exportSql(sb.toString().getBytes());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("batchinput".equals(e.getActionId())) {
            ((IListView)this.getView()).refresh();
        }
    }

    private String genResCategorySql(DynamicObject obj) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM t_bas_resourcecategory WHERE flongnumber = ");
        sb.append("'").append(obj.getString("longnumber")).append("'");
        sb.append(STR);
        sb.append("INSERT INTO t_bas_resourcecategory(FID,FISLEAF,FLEVEL,FPARENTID,FLONGNUMBER,FNUMBER,fcreatetime,fmodifytime,fenable,fstatus, fcreatorid)");
        sb.append(VALUES);
        sb.append(" (");
        sb.append(obj.get("id")).append(" , ");
        sb.append("0").append(" , ");
        sb.append("'").append(obj.getString("level")).append("'").append(" , ");
        sb.append("'").append(obj.get("parent")).append("'").append(" , ");
        sb.append("'").append(obj.getString("longnumber")).append("'").append(" , ");
        sb.append("'").append(obj.getString("number")).append("'").append(" , ");
        Date createtime = obj.getDate("createtime") == null ? new Date() : obj.getDate("createtime");
        sb.append("{ts");
        sb.append("'").append(df.format(createtime)).append("'");
        sb.append("} , ");
        Date modifyTime = obj.getDate("modifytime") == null ? new Date() : obj.getDate("modifytime");
        sb.append("{ts");
        sb.append("'").append(df.format(modifyTime)).append("'");
        sb.append("} , ");
        sb.append("'").append(obj.get("enable")).append("'").append(" , ");
        sb.append("'C'").append(" , ");
        sb.append("'").append(obj.get("creator")).append("'");
        sb.append(" );");
        sb.append("\r\n");
        sb.append("DELETE FROM t_bas_resourcecategory_l WHERE fid =");
        sb.append(obj.get("id"));
        sb.append(STR);
        sb.append("INSERT INTO t_bas_resourcecategory_l (FPKID, FID, FLOCALEID, FNAME, FFULLNAME)");
        sb.append(VALUES);
        sb.append(" (");
        sb.append("'").append(DBServiceHelper.genStringId()).append("'").append(",");
        sb.append(obj.get("id")).append(",");
        sb.append("'zh_CN'").append(",");
        sb.append("'").append(obj.get("name")).append("'").append(" , ");
        sb.append("'").append(obj.get("name")).append("'");
        sb.append(" );");
        sb.append("\r\n");
        return sb.toString();
    }

    private String genResSql(DynamicObject obj) {
        if (obj.get("categoryid") == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM t_bas_pictureresource WHERE FURL0 =");
        sb.append("'").append(obj.getString("furl0")).append("'");
        sb.append(STR);
        sb.append("INSERT INTO t_bas_pictureresource (FID, FISV,FNUMBER,FURL0, FTYPE, FFORMAT, FPATH, FCREATEDATE, fcategoryid)");
        sb.append(VALUES);
        sb.append(" (");
        sb.append(obj.getPkValue()).append(" , ");
        sb.append("'").append(obj.getString("isv")).append("'").append(" , ");
        sb.append("'").append(obj.getString("fnumber")).append("'").append(" , ");
        sb.append("'").append(obj.getString("furl0")).append("'").append(" , ");
        sb.append("'").append(obj.getString("ftype")).append("'").append(" , ");
        sb.append("'").append(obj.getString("FFORMAT")).append("'").append(" , ");
        sb.append("'").append(obj.getString("FPATH")).append("'").append(" , ");
        sb.append("{ts");
        sb.append("'").append(df.format(obj.getDate("fcreatedate"))).append("'");
        sb.append("} , ");
        sb.append(((DynamicObject)obj.get("categoryid")).getPkValue());
        sb.append(" );");
        sb.append("\r\n");
        sb.append("DELETE FROM t_bas_pictureresource_l WHERE fid =");
        sb.append(obj.getPkValue());
        sb.append(STR);
        sb.append("INSERT INTO t_bas_pictureresource_l (FPKID, FID, FLOCALEID, FDESCRIPTION, FNAME)");
        sb.append(VALUES);
        sb.append(" (");
        sb.append("'").append(DBServiceHelper.genStringId()).append("'").append(",");
        sb.append(obj.getPkValue()).append(",");
        sb.append("'zh_CN'").append(",");
        sb.append("'").append(obj.getLocaleString("fname")).append("'").append(" , ");
        sb.append("'").append(obj.getLocaleString("fname")).append("'");
        sb.append(" );");
        sb.append("\r\n");
        return sb.toString();
    }

    private void exportSql(byte[] sql) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_X.X.X_bos_image.sql", sql, 5000);
        this.getView().openUrl(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u9ed8\u8ba4\u5bfc\u51fa\u8def\u5f84\u4e3aC:\\Users\\\u7528\u6237\u540d\\Downloads\u3002", (String)"PictureResourceListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    delfile.delete();
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                PictureResourceListPlugin.deleteKd(fileList[i]);
            }
            file.delete();
        }
    }
}

