/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SelectPicPathPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ClickListener {
    private static final String APP_TREE_VIEW = "apptreeview";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String VISIBLE = "visible";
    private static final String DEPLOY_STATUS = "deploystatus";

    public void initialize() {
        this.addClickListeners(new String[]{"btnconfilm", "btncancel"});
        TreeView cloudtree = (TreeView)this.getView().getControl("cloudtreeview");
        cloudtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView apptree = (TreeView)this.getView().getControl(APP_TREE_VIEW);
        apptree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        TreeNode cloudNode = this.buildCloudNode();
        TreeView cloudTree = (TreeView)this.getView().getControl("cloudtreeview");
        cloudTree.addNode(cloudNode);
    }

    public void afterBindData(EventObject e) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree;
        List selectedNode;
        Object nodeId = evt.getNodeId();
        if (evt.getParentNodeId().equals("/biz")) {
            this.showAppTree(nodeId.toString());
        }
        if ((selectedNode = (tree = (TreeView)this.getView().getControl(APP_TREE_VIEW)).getTreeState().getSelectedNodes()) != null && selectedNode.size() > 0) {
            Map node = (Map)selectedNode.get(0);
            String text = (String)node.get("text");
            this.getPageCache().put("name", text);
        }
        this.getModel().setValue("path", nodeId);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnconfilm".equals(c.getKey())) {
            String name = this.getPageCache().get("name");
            HashMap<String, String> retMap = new HashMap<String, String>();
            retMap.put("path", this.getModel().getValue("path").toString().toLowerCase());
            retMap.put("name", name);
            this.getView().returnDataToParent(retMap);
        }
        this.getView().close();
    }

    private void showAppTree(String cloudNodeId) {
        TreeNode appNode = this.buildAppNode(cloudNodeId);
        TreeView appTree = (TreeView)this.getView().getControl(APP_TREE_VIEW);
        appTree.deleteAllNodes();
        appTree.addNode(appNode);
    }

    private TreeNode buildCloudNode() {
        TreeNode root = new TreeNode();
        root.setId("/biz");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"SelectPicPathPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setData((Object)"biz");
        root.setIsOpened(true);
        List<TreeNode> cloudNode = this.getCloudData();
        this.buildNode(root, cloudNode);
        return root;
    }

    private TreeNode buildAppNode(String cloudNodeId) {
        TreeNode root = new TreeNode();
        root.setId(cloudNodeId);
        root.setText(ResManager.loadKDString((String)"\u5e94\u7528", (String)"SelectPicPathPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setData((Object)"biz");
        root.setIsOpened(true);
        List<TreeNode> appNode = this.getAppData(cloudNodeId);
        this.buildNode(root, appNode);
        return root;
    }

    private TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        this.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            if (!leafNodeMap.containsKey(parentID)) continue;
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    private void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                this.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    private List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode commonNode = new TreeNode();
        commonNode.setId("/common/");
        commonNode.setText(ResManager.loadKDString((String)"\u516c\u5171", (String)"SelectPicPathPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        commonNode.setParentid("/biz");
        commonNode.setData((Object)"common");
        commonNode.setIsOpened(true);
        cloudNode.add(commonNode);
        ORM orm = ORM.create();
        String fields = "id, number, name";
        String orderby = "";
        QFilter[] filters = null;
        if (VISIBLE.equalsIgnoreCase(this.getPageCache().get(VISIBLE))) {
            QFilter f1 = new QFilter(VISIBLE, "=", (Object)"1");
            filters = new QFilter[]{f1};
        } else if ("all".equalsIgnoreCase(this.getPageCache().get(VISIBLE))) {
            filters = new QFilter[]{};
        }
        try (DataSet ds = orm.queryDataSet("bos_devportal_bizcloud", "bos_devportal_bizcloud", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = "/" + row.getString("number") + "/";
                node.setText(row.getString("name"));
                node.setParentid("/biz");
                node.setId(nodeID);
                node.setData((Object)"cloud");
                cloudNode.add(node);
            }
            ArrayList<TreeNode> arrayList = cloudNode;
            return arrayList;
        }
    }

    private List<TreeNode> getAppData(String cloudNodeId) {
        QFilter f1;
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        String visible = this.getPageCache().get(VISIBLE);
        String deploystatus = this.getPageCache().get(DEPLOY_STATUS);
        ORM orm = ORM.create();
        String fields = "id,number, name, bizcloud.id, bizcloud.number";
        String orderby = "";
        QFilter[] filters = null;
        if ("all".equalsIgnoreCase(visible) && "all".equalsIgnoreCase(deploystatus)) {
            filters = new QFilter[]{};
        } else if (VISIBLE.equalsIgnoreCase(visible) && "all".equalsIgnoreCase(deploystatus)) {
            f1 = new QFilter(VISIBLE, "=", (Object)"1");
            filters = new QFilter[]{f1};
        } else if ("all".equalsIgnoreCase(visible) && DEPLOY_STATUS.equalsIgnoreCase(deploystatus)) {
            f1 = new QFilter(DEPLOY_STATUS, "=", (Object)"2");
            filters = new QFilter[]{f1};
        } else if (VISIBLE.equalsIgnoreCase(visible) && DEPLOY_STATUS.equalsIgnoreCase(deploystatus)) {
            f1 = new QFilter(VISIBLE, "=", (Object)"1");
            QFilter f2 = new QFilter(DEPLOY_STATUS, "=", (Object)"2");
            filters = new QFilter[]{f1, f2};
        }
        try (DataSet ds = orm.queryDataSet("bos_devportal_bizapp", "bos_devportal_bizapp", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String parentId = "/" + row.getString("bizcloud.number") + "/";
                if (!cloudNodeId.equals(parentId)) continue;
                String nodeID = parentId + row.getString("number") + "/";
                node.setId(nodeID);
                node.setParentid(parentId);
                node.setText(row.getString("name"));
                node.setData((Object)"app");
                appNode.add(node);
            }
        }
        return appNode;
    }
}

