/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture.common;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.isv.ISVService;

public class PictureResourceKit {
    private static final String IMAGE = "image";
    private static String AllowSavaRegex = "[\\w\\s\\-\\/]*";

    public static boolean checkPathValidity(String path) {
        return path.matches(AllowSavaRegex);
    }

    public static boolean checkPathCategoryValidity(String path) {
        String[] split;
        String firstLevel;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!("images".equals(firstLevel = (split = path.split("/"))[1]) || "icons".equals(firstLevel) || "kingdee".equals(firstLevel))) {
            return false;
        }
        if ("kingdee".equals(firstLevel) && split.length < 4) {
            return false;
        }
        return !"kingdee".equals(firstLevel) || "images".equals(split[3]);
    }

    public static boolean isKingdeeIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            currentIsv = "kingdee";
        }
        return "kingdee".equalsIgnoreCase(currentIsv);
    }

    public static String getLongNumber(IFormView view, String type) {
        Object modelType = view.getFormShowParameter().getCustomParams().get("modelType");
        Object isPc = view.getFormShowParameter().getCustomParams().get("isPC");
        StringBuilder sb = new StringBuilder();
        if (IMAGE.equals(type)) {
            sb.append("images");
        } else {
            sb.append("icons");
        }
        sb.append(".");
        if ("MobileBillFormModel".equals(modelType) || "MobileFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType)) {
            sb.append("mobile");
        } else if (isPc == null || ((Boolean)isPc).booleanValue()) {
            sb.append("pc");
        } else {
            sb.append("mobile");
        }
        return sb.toString();
    }
}

