/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class CarouselFigureManagerListPlugin
extends StandardTreeListPlugin {
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String MASTERID = "masterid";
    private static final String BIZOBJECT = "bizobject";
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";
    private static final String NUMBER = "number";
    private static final String BOS_PICTURE = "bos-picture";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "toolbarap"});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btnreplace".equals(evt.getItemKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_replacecarouselbase");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("640px");
            formShowParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm(formShowParameter);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode node = this.getTreeListView().getTreeModel().getRoot().getTreeNode(e.getNodeId().toString(), 5);
        e.setChildNodes(node.getChildren());
    }

    private void initTree() {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CarouselFigureManagerListPlugin_0", (String)BOS_PICTURE, (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        Map<String, String> originExtendAppRelMap = this.getOriginExtendAppRelMap();
        Map<String, List<TreeNode>> billNodesMap = this.getBillNodesMap(originExtendAppRelMap);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = "cloud_" + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                TreeNode app = (TreeNode)appIterator.next();
                String appNodeId = "app_" + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                List<String> appIds = this.getAppIdsBy(appNodeId);
                ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>(10);
                for (String appId : appIds) {
                    List<TreeNode> billNodeList = billNodesMap.get("app_" + appId);
                    if (billNodeList == null) continue;
                    billNodes.addAll(billNodeList);
                }
                if (billNodes == null || billNodes.isEmpty()) {
                    appIterator.remove();
                    continue;
                }
                app.setChildren(billNodes);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Map<String, String> getOriginExtendAppRelMap() {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        for (DynamicObject app : allApps) {
            String nodeId = "app_" + app.getString("id");
            originExtendAppRelMap.put(nodeId, nodeId);
        }
        return originExtendAppRelMap;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = this.getFilter(nodeId);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }

    private QFilter getFilter(String nodeId) {
        if (this.isTopNode(nodeId)) {
            return null;
        }
        if (nodeId.contains("cloud_")) {
            return new QFilter(BIZOBJECT, "in", this.getBillIdInCloud(nodeId));
        }
        if (nodeId.contains("app_")) {
            return new QFilter(BIZOBJECT, "in", this.getBillIdInApp(nodeId));
        }
        return new QFilter(BIZOBJECT, "=", (Object)nodeId);
    }

    private List<String> getBillIdInApp(String appNodeId) {
        List<String> appIds = this.getAppIdsBy(appNodeId);
        List<TreeNode> billNodes = this.getBillNodesBy(appIds);
        return billNodes.stream().map(node -> node.getId()).collect(Collectors.toList());
    }

    private List<String> getBillIdInCloud(String cloudNodeId) {
        String cloudId = StringUtils.substringAfter((String)cloudNodeId, (String)"_");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT C.FID ").append("FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID ").append("LEFT JOIN t_meta_mainentityinfo C  ON C.FBIZAPPID = B.FID ").append("WHERE A.FID = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, (ResultSetHandler)action);
    }

    private List<String> getAppIdsBy(String appNodeId) {
        String appId = StringUtils.substringAfter((String)appNodeId, (String)"_");
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString(MASTERID);
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString(MASTERID);
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    private List<TreeNode> getBillNodesBy(List<String> appIds) {
        if (appIds == null || appIds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        String fields = "id, number, name, bizappid";
        QFilter appIdFilter = new QFilter(BIZAPPID, "in", appIds);
        QFilter[] filters = new QFilter[]{appIdFilter};
        ArrayList<TreeNode> billNodes = new ArrayList<TreeNode>();
        try (DataSet ds = ORM.create().queryDataSet(BOS_ENTITYOBJECT, BOS_ENTITYOBJECT, fields, filters, null);){
            for (Row row : ds) {
                String nodeId = row.getString("id");
                String name = row.getString("name");
                String parentId = "app_" + row.getString(BIZAPPID);
                String data = row.getString(NUMBER);
                TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
                billNodes.add(node);
            }
        }
        return billNodes;
    }

    private Map<String, List<TreeNode>> getBillNodesMap(Map<String, String> originExtendAppRelMap) {
        HashMap<String, List<TreeNode>> billNodesMap = new HashMap<String, List<TreeNode>>();
        String fields = "id, number, name, bizappid";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter[] filters = new QFilter[]{modelTypeFilter};
        try (DataSet ds = ORM.create().queryDataSet(BOS_ENTITYOBJECT, BOS_ENTITYOBJECT, fields, filters, orderby);){
            for (Row row : ds) {
                String nodeId = row.getString("id");
                String name = row.getString("name");
                String parentId = "app_" + row.getString(BIZAPPID);
                String data = row.getString(NUMBER);
                TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
                String masterId = originExtendAppRelMap.get(parentId);
                if (StringUtils.isBlank((CharSequence)masterId)) continue;
                ArrayList<TreeNode> nodes = (ArrayList<TreeNode>)billNodesMap.get(masterId);
                if (nodes == null) {
                    nodes = new ArrayList<TreeNode>();
                    billNodesMap.put(masterId, nodes);
                }
                nodes.add(node);
            }
        }
        return billNodesMap;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }

    public Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ListSelectedRow lsr = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        ret.put(NUMBER, lsr.getNumber());
        ret.put("name", lsr.getName());
        return ret;
    }
}

