/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.servicehelper.ConfigServiceHelper;
import kd.bos.upload.UploadOption;
import kd.bos.url.UrlService;

public class CarsouelBasePlugin
extends AbstractFormPlugin
implements UploadListener,
IDataModelChangeListener,
RowClickEventListener {
    private static final String IMAGEAP = "imageap";
    private static final String ENTRYENTITY = "entryentity";
    private static Log log = LogFactory.getLog(CarsouelBasePlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{IMAGEAP});
        IImage btn = (IImage)this.getControl(IMAGEAP);
        btn.addUploadListener((UploadListener)this);
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
        CardEntry ct = (CardEntry)this.getControl(ENTRYENTITY);
        ct.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"buttonpreview", "buttondelete", "carouselfigureap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty() instanceof IPictureProp && e.getChangeSet().length > 0 && e.getChangeSet()[0].getNewValue() == null) {
            this.getModel().deleteEntryRow(ENTRYENTITY, e.getChangeSet()[0].getRowIndex());
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control && ((Control)evt.getSource()).getKey().equals("buttonpreview")) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
            int rowIndex = grid.getEntryState().getFocusRow();
            Object url = this.getModel().getValue("picturefield", rowIndex);
            if (StringUtils.isNotBlank((Object)url)) {
                String[] urls = new String[]{this.getPreUrl((String)url)};
                this.getView().showPictureView(urls, 1);
            }
        } else if (evt.getSource() instanceof Control && ((Control)evt.getSource()).getKey().equals("buttondelete")) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
            int rowIndex = grid.getEntryState().getFocusRow();
            this.getModel().deleteEntryRow(ENTRYENTITY, rowIndex);
        } else {
            UploadOption option = new UploadOption();
            option.setMultiple(true);
            option.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u56fe\u7247", (String)"CarsouelBasePlugin_0", (String)"bos-picture", (Object[])new Object[0]));
            option.setSuffix(".png,.jpg,.JPG,.PNG");
            option.setUrl("image/uploadImage.do");
            this.getView().showUpload(option, IMAGEAP);
        }
    }

    private String getPreUrl(String path) {
        return UrlService.getCheckAuthImageUrl((String)path);
    }

    public void upload(UploadEvent evt) {
        Object[] values = evt.getUrls();
        StringBuilder urlParam = new StringBuilder();
        for (Object value : values) {
            Map valueMap = (Map)value;
            String url = valueMap.get("url") == null ? "" : (String)valueMap.get("url");
            urlParam.append(url);
        }
        if (urlParam.length() == 0) {
            log.warn("CarsouelBase url is blank");
            return;
        }
        this.getModel().forceClearNoDataRow();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRYENTITY);
        int index = doc.size();
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value;
            value = (Map)values[i];
            this.getModel().setValue("picturefield", value.get("url"), index + i);
        }
    }

    private String getSuffix() {
        return ConfigServiceHelper.getGlobalConfiguration((String)"imageServer.tcpUrl").toString();
    }
}

