/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.UUID;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.attachment.manage.ImageManageService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.AttachFileService;

public class ImageFilePathService
implements FileServiceExt {
    public static final String FFILEID = ":FFILEID";
    private static Log log = LogFactory.getLog(ImageFilePathService.class);
    private static int SECRETKEY = 611;
    private static AttachManageService managerService = new ImageManageService();

    private String createAttId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getRealPath(String pathOrId) {
        if (AttachFileService.enableAttachmentCenter()) {
            return managerService.getAttachPath(pathOrId);
        }
        if (StringUtils.isBlank((CharSequence)pathOrId) || !this.checkEncrptyPath(pathOrId).booleanValue()) {
            return pathOrId;
        }
        String sql = "select fpath from t_bas_imagefilepathmapping where FFILEID = ? ";
        Object[] params = new SqlParameter[1];
        if (pathOrId.contains("_thumbnails_")) {
            String[] pathOrIdArr = pathOrId.split("_thumbnails_");
            String uuidOrPath = pathOrIdArr[0].replace("/", "");
            params[0] = new SqlParameter(FFILEID, 12, (Object)uuidOrPath);
            String realPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
                String path = null;
                while (rs.next()) {
                    path = rs.getString("fpath");
                }
                return path;
            });
            if (StringUtils.isNotBlank((CharSequence)realPath)) {
                realPath = realPath.substring(0, realPath.lastIndexOf("."));
                return realPath + "_thumbnails_" + pathOrIdArr[1];
            }
            return pathOrId;
        }
        String filedId = pathOrId;
        try {
            filedId = URLDecoder.decode(pathOrId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        int lastIndex = filedId.lastIndexOf("/");
        if (lastIndex > -1 && filedId.length() > lastIndex + 1) {
            filedId = pathOrId.substring(lastIndex + 1);
        }
        if (filedId.contains(".")) {
            filedId = filedId.substring(0, filedId.lastIndexOf("."));
        }
        params[0] = new SqlParameter(FFILEID, 12, (Object)filedId);
        String realPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            String path = null;
            while (rs.next()) {
                path = rs.getString("fpath");
            }
            return path;
        });
        if (StringUtils.isBlank((CharSequence)realPath)) {
            return pathOrId;
        }
        return realPath;
    }

    public InputStream checkFile(InputStream inputStream, String s) {
        return inputStream;
    }

    public String save(String path) {
        if (AttachFileService.enableAttachmentCenter()) {
            return path;
        }
        if (!this.imageEncrptyPath()) {
            return path;
        }
        String attId = this.createAttId();
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>();
        SqlParameter[] value = new SqlParameter[3];
        long id = DB.genLongId((String)"t_bas_imagefilepathmapping");
        value[0] = new SqlParameter(":FID", -5, (Object)id);
        value[1] = new SqlParameter(FFILEID, 12, (Object)attId);
        value[2] = new SqlParameter(":FPATH", -9, (Object)path);
        params.add(value);
        String sql = "INSERT INTO t_bas_imagefilepathmapping(FID,FFILEID,FPATH) VALUES (?, ?, ?)";
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        attId = attId + path.substring(path.lastIndexOf("."));
        return attId;
    }

    private boolean imageEncrptyPath() {
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        return service.isImageEncrptyPath();
    }

    public InputStream encode(String orignalPath, InputStream in) {
        String fileName = orignalPath.substring(StringUtils.lastIndexOf((CharSequence)orignalPath, (CharSequence)"/") + 1);
        if (fileName.startsWith("kdimg") || orignalPath.endsWith("kdimg")) {
            try {
                return ImageFilePathService.XORCode(in);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return in;
            }
        }
        return in;
    }

    public InputStream decode(String orignalPath, InputStream in) {
        String fileName = orignalPath.substring(StringUtils.lastIndexOf((CharSequence)orignalPath, (CharSequence)"/") + 1);
        if (fileName.startsWith("kdimg") || orignalPath.endsWith("kdimg")) {
            try {
                return ImageFilePathService.XORCode(in);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return in;
            }
        }
        return in;
    }

    private static InputStream XORCode(InputStream in) throws Exception {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read()) != -1) {
            out.write(len ^ SECRETKEY);
        }
        ByteArrayInputStream resultIn = new ByteArrayInputStream(out.toByteArray());
        in.close();
        out.close();
        return resultIn;
    }

    private Boolean checkEncrptyPath(String path) {
        String resultPath = path;
        while (resultPath.startsWith("/")) {
            resultPath = resultPath.replaceFirst("/", "");
        }
        return !resultPath.contains("/");
    }
}

