/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import com.google.common.io.ByteStreams;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.file.security.FileChecker;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.fileservice.FileService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.service.attachment.extend.action.FileActionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionParam;
import kd.bos.service.attachment.extend.permission.FileTypeEnum;
import kd.bos.service.attachment.extend.permission.PermissionResult;
import kd.bos.service.image.ImgFileService;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.FileRecord;
import kd.bos.servicehelper.util.FileRecordUtil;
import kd.bos.util.ImageUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.AttachmentAction;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.CtsyActionDispatchServiceHelper;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.bos.web.actions.utils.FileReqLimitUtil;
import kd.bos.web.actions.utils.FileTypeUtil;
import kd.bos.web.actions.utils.FileUploadUrlUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.math.NumberUtils;

@SdkPublic
public class ImageAction {
    private static final Log log = LogFactory.getLog(ImageAction.class);
    private static final String THUMBNAILS_IDENTITY = "_thumbnails_";
    private static final String THUMBNAILS_TAG = "thumbnailsTag";
    private static final String THUMBNAILS_SCALE = "scale";
    private static final String THUMBNAILS_PARAMS = "thumbparam";
    public static final String FMT_IMAGE = "/%s/%s/%s/%s";
    private static final String STATUS = "status";
    private static final String SUCCESS = "success";
    private static boolean enableLog = Boolean.parseBoolean(System.getProperty("imageAction.logCostTime.enable", "true"));
    private static final List<String> supportFormat = Arrays.asList(".bmp", ".gif", ".jpg", ".png", ".jpeg");
    private static final long IMAGE_CACHE_MILLSECONDS = 259200000L;
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String UTF_8 = "UTF-8";
    private static final String ANDORID = "Andorid";
    private static final String ANDROID = "Android";
    private static final String ATTACHMENT_FILENAME = "attachment;filename=\"";
    private static final String STRING = "attachment;filename*=UTF-8''";
    private static final String BOS_PICTURE = "bos-picture";
    private static final String IMAGELIST_THUMBNAILS_SCALEPIC = "_thumbnails_scalePic";
    private static final String IMAGELIST_THUMBNAILS_MOBLIEIMAGELIST = "_thumbnails_moblieImageList";
    private ImgFileService imgFileService;

    protected FileService getFileService() {
        return new ImgFileService();
    }

    public void uploadImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest((HttpServletRequest)request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        catch (Exception e) {
            log.error("uploadImage ctsy dispatch failed", (Throwable)e);
        }
        FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);
        String appId = fileItem.getAppId();
        String fId = fileItem.getFId();
        boolean uncompresspic = Boolean.parseBoolean(request.getParameter("uncompresspic"));
        boolean encryptStorage = Boolean.parseBoolean(request.getParameter("encryptStorage"));
        HashMap<String, Object> uploadParam = new HashMap<String, Object>(16);
        uploadParam.put("uncompresspic", uncompresspic);
        uploadParam.put("encryptStorage", encryptStorage);
        if (enableLog) {
            log.info("imageupload.received time : " + new Date().getTime());
        }
        String fileName = fileItem.getFileName();
        fileItem.setPath(this.getImagePath(fileItem));
        if (!FileUploadUrlUtil.isFileUploadWithUrl()) {
            fileItem.setPath(FileUploadUrlUtil.getImageRandomUrl((String)fileName));
        }
        if (!AttachmentAction.fileExtCheck((String)fileName, (HttpServletResponse)response)) {
            return;
        }
        String speSymbol = AttachmentAction.checkSpeSymbol((String)fileName, (HttpServletResponse)response);
        if (StringUtils.isNotBlank((CharSequence)speSymbol)) {
            AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentAction_15", (String)"bos-webactions", (Object[])new Object[0]), speSymbol));
            return;
        }
        int fileByteSize = fileItem.getInputStream().available();
        if (!this.checkImgMaxSize(response, fileName, fileByteSize)) {
            return;
        }
        if (FileReqLimitUtil.checkLimitReq((String)"uploadFile", (int)fileByteSize)) {
            AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)AttachmentUtil.getUploadOrDownloadLimitTips((String)"uploadlimit"));
            return;
        }
        try (InputStream inputStream1 = fileItem.getInputStream();
             ByteArrayOutputStream baos = FileTypeUtil.cloneInputStream((InputStream)inputStream1);
             ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
             ByteArrayInputStream inputStream_check = new ByteArrayInputStream(baos.toByteArray());){
            String path;
            block88: {
                if (!this.checkImage(inputStream_check)) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put(STATUS, "error");
                    result.put("description", ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u7c7b\u578b\uff1a\u201c.jpg\u201d\u3001\u201c.jpeg\u201d\u3001\u201c.png\u201d\u3001\u201c.bmp\u201d\u3001\u201c.gif\u201d\u3002", (String)"DESCRIPTION1", (String)BOS_PICTURE, (Object[])new Object[0]));
                    String suffix = request.getParameter("suffix");
                    if (StringUtils.isNotBlank((CharSequence)suffix)) {
                        List<String> userSuffixConfig = null;
                        userSuffixConfig = suffix.contains(",") ? Arrays.asList(suffix.split(",")) : Collections.singletonList(suffix);
                        List forbidenList = ListUtils.retainAll(userSuffixConfig, supportFormat);
                        if (forbidenList.size() != 0) {
                            result.put("description", String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u7c7b\u578b\uff1a%s", (String)"DESCRIPTION2", (String)BOS_PICTURE, (Object[])new Object[0]), org.apache.commons.lang.StringUtils.join(new LinkedHashSet(forbidenList), (String)",")));
                        }
                    }
                    String jsonResult = SerializationUtils.toJsonString(result);
                    ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
                }
                path = fileItem.getPath();
                try {
                    path = this.dealPath(path);
                }
                catch (KDException e) {
                    if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block88;
                    if (inputStream_check != null) {
                        if (var19_26 != null) {
                            try {
                                ((InputStream)inputStream_check).close();
                            }
                            catch (Throwable jsonResult) {
                                var19_26.addSuppressed(jsonResult);
                            }
                        } else {
                            ((InputStream)inputStream_check).close();
                        }
                    }
                    if (inputStream != null) {
                        if (var17_22 != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable jsonResult) {
                                var17_22.addSuppressed(jsonResult);
                            }
                        } else {
                            ((InputStream)inputStream).close();
                        }
                    }
                    if (baos != null) {
                        if (var15_18 != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable jsonResult) {
                                var15_18.addSuppressed(jsonResult);
                            }
                        } else {
                            baos.close();
                        }
                    }
                    if (inputStream1 != null) {
                        if (var13_14 != null) {
                            try {
                                inputStream1.close();
                            }
                            catch (Throwable jsonResult) {
                                var13_14.addSuppressed(jsonResult);
                            }
                        } else {
                            inputStream1.close();
                        }
                    }
                    return;
                }
            }
            InputStream img = FileChecker.addSecurityWaterMark((String)fileName, (InputStream)inputStream);
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String dateStr = this.getDateStr();
            path = String.format(FMT_IMAGE, tenantId, accountId, dateStr, path);
            fileItem = this.createFileItem(fileName, path, img);
            fileItem.setFId(fId);
            fileItem.setAppId(appId);
            fileItem.setCreateNewFileWhenExists(true);
        }
        String thumbnailsParamsStr = request.getParameter(THUMBNAILS_PARAMS);
        if (StringUtils.isBlank((CharSequence)thumbnailsParamsStr) || "[]".equals(thumbnailsParamsStr)) {
            this.upload(fileItem, request, response, uploadParam);
        } else {
            this.upload(fileItem, thumbnailsParamsStr, request, response, uploadParam);
        }
    }

    private String getImagePath(FileItem fileItem) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)fileItem.getAppId())) {
            sb.append(fileItem.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)fileItem.getFId())) {
            sb.append("/").append(fileItem.getFId());
        }
        sb.append("/").append("images");
        String uuid = UUID.randomUUID().toString().replace("-", "");
        sb.append("/").append(uuid).append("/").append(fileItem.getFileName());
        return sb.toString();
    }

    private boolean checkImgMaxSize(HttpServletResponse response, String fileName, long imageSize) throws IOException {
        long maxSize = this.getImgMaxSize();
        if (imageSize > maxSize) {
            FileReqLimitUtil.writeOverMaxSize((HttpServletResponse)response, (String)fileName, (long)imageSize, (long)maxSize);
            return false;
        }
        return FileReqLimitUtil.checkTotalFileSize((HttpServletResponse)response, (String)"uploadImage", (long)imageSize, (long)(maxSize * 3L), (String)fileName, (boolean)false);
    }

    private long getImgMaxSize() {
        long mcSizeMb;
        Object sizeMb = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"maxuploadimagesize"});
        long l = mcSizeMb = this.getFileService().maxUploadSize() == 0L ? 0x3200000L : this.getFileService().maxUploadSize();
        if (sizeMb != null && !"0".equals(sizeMb.toString())) {
            long size = Long.parseLong(String.valueOf(sizeMb));
            return Math.min(size * 1024L * 1024L, mcSizeMb);
        }
        return mcSizeMb;
    }

    private boolean checkImage(InputStream inputStream) {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            return image != null;
        }
        catch (IOException ex) {
            log.error("kd.bos.web.actions.ImageAction.checkImage", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(FileItem fileItem, HttpServletRequest request, HttpServletResponse response, Map<String, Object> uploadParam) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            try (InputStream in = fileItem.getInputStream();){
                String path = fileItem.getPath();
                if (enableLog) {
                    log.info("imageupload.beforupload time : " + new Date().getTime());
                }
                String url = "";
                FileItem item = this.createFileItem(fileItem.getFileName(), ImageAction.processPathString(path, null, fileItem.getFileName()), in);
                long compressPicSize = AttachmentServiceHelper.getCompressPicSize();
                int fileSize = in.available() / 1024;
                Object encryptStorageParam = uploadParam.get("encryptStorage");
                boolean encryptStorage = Boolean.parseBoolean(String.valueOf(encryptStorageParam));
                if (encryptStorage) {
                    String pathPreffix = item.getPath().substring(0, StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/"));
                    String pathTwo = item.getPath().substring(StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/") + 1);
                    String kdImgPath = pathPreffix + "/kdimg" + pathTwo;
                    item = this.createFileItem(item.getFileName(), kdImgPath, fileItem.getInputStream());
                }
                log.info("before upload size is " + item.getInputStream().available());
                url = (Boolean)uploadParam.get("uncompresspic") == false && compressPicSize != 0L && (long)fileSize > compressPicSize ? this.getFileService().compressPicUpload(item, compressPicSize) : this.getFileService().upload(item);
                if (enableLog) {
                    log.info("imageupload.afterupload time : " + new Date().getTime());
                }
                result.put("url", url);
                result.put("filename", fileItem.getFileName());
                result.put(STATUS, SUCCESS);
                FileRecord fileRecord = new FileRecord();
                fileRecord.setUrl(url);
                fileRecord.setType("1");
                fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                fileRecord.setCreateTime(new Date());
                FileRecordUtil.doLog(Collections.singletonList(fileRecord));
                FilePermissionParam filePermissionParam = new FilePermissionParam(fileItem.getFId(), fileItem.getAppId(), url, FileTypeEnum.IMAGE, request);
                AttachmentAction.getFilePermissionExtension().dealPermissionParam(Collections.singletonList(filePermissionParam));
                String jsonResult = SerializationUtils.toJsonString(result);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
            }
            catch (Exception e) {
                this.handleException(e, response);
            }
        }
        finally {
            try {
                fileItem.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public void downloadImage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String path;
            block12: {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest((HttpServletRequest)request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction((HttpServletRequest)request, (HttpServletResponse)response);
                    return;
                }
                if (FileReqLimitUtil.checkLimitReq((String)"download", (int)0)) {
                    AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)AttachmentUtil.getUploadOrDownloadLimitTips((String)"downloadlimit"));
                    return;
                }
                if (StringUtils.isBlank((CharSequence)request.getParameter("path"))) {
                    AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11path\u53c2\u6570\u3002", (String)"AttachmentAction_17", (String)"bos-webactions", (Object[])new Object[0]));
                    return;
                }
                path = URLDecoder.decode(request.getParameter("path"), UTF_8);
                try {
                    path = this.dealPath(path);
                    path = path.replace("..", "");
                }
                catch (KDException e) {
                    log.warn((Throwable)e);
                    if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block12;
                    return;
                }
            }
            path = this.tryGetAvailablePath(path);
            if (StringUtils.isBlank((CharSequence)path)) {
                AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)ResManager.loadKDString((String)"\u56fe\u7247\u4e0d\u5b58\u5728\u3002", (String)"ImageAction_3", (String)BOS_PICTURE, (Object[])new Object[0]));
                return;
            }
            String userAgent = request.getHeader("USER-AGENT");
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            response.setCharacterEncoding(UTF_8);
            response.setContentType(this.getContentType(fileName));
            FilePermissionParam filePermissionParam = new FilePermissionParam(request.getParameter("fId"), request.getParameter("appId"), path, FileTypeEnum.IMAGE, request);
            PermissionResult permissionResult = AttachmentAction.getFilePermissionExtension().checkPermission(filePermissionParam);
            if (!permissionResult.getHasPermission().booleanValue()) {
                AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)permissionResult.getMsg());
                return;
            }
            fileName = FileActionExtensionFactory.getFileActionExtension().getFileName(path, fileName);
            if (StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent.contains(ANDORID) || userAgent.contains(ANDROID))) {
                response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20") + "\"");
            } else {
                response.addHeader(CONTENT_DISPOSITION, STRING + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
            }
            this.getFileService().download(path, response, userAgent);
            if (response != null) {
                response.setDateHeader("Expires", System.currentTimeMillis() + 259200000L);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)ResManager.loadKDString((String)"\u56fe\u7247\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ImageAction_1", (String)BOS_PICTURE, (Object[])new Object[0]));
        }
    }

    private String tryGetAvailablePath(String path) {
        if (this.getFileService().exists(path)) {
            return path;
        }
        boolean isMobImageListThumbnailsPicture = path.contains(IMAGELIST_THUMBNAILS_MOBLIEIMAGELIST);
        if (isMobImageListThumbnailsPicture) {
            log.info("isMobImageListThumbnailsPicture,path is " + path);
            return this.tryGetAvailablePath(path, IMAGELIST_THUMBNAILS_MOBLIEIMAGELIST, IMAGELIST_THUMBNAILS_SCALEPIC);
        }
        boolean isPCImageListThumbnailsPicture = path.contains(IMAGELIST_THUMBNAILS_SCALEPIC);
        if (isPCImageListThumbnailsPicture) {
            log.info("isPCImageListThumbnailsPicture,path is " + path);
            return this.tryGetAvailablePath(path, IMAGELIST_THUMBNAILS_SCALEPIC, IMAGELIST_THUMBNAILS_MOBLIEIMAGELIST);
        }
        return "";
    }

    private String tryGetAvailablePath(String path, String notFindThumbnailsSuffix, String replaceThumbnailsSuffix) {
        if (StringUtils.isBlank((CharSequence)path) || !path.contains("/")) {
            return "";
        }
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        if (!fileName.contains(notFindThumbnailsSuffix)) {
            return "";
        }
        String replaceFileName = fileName.replace(notFindThumbnailsSuffix, replaceThumbnailsSuffix);
        String pathPrefix = path.substring(0, path.lastIndexOf(47) + 1);
        path = pathPrefix + replaceFileName;
        if (this.getFileService().exists(path)) {
            return path;
        }
        replaceFileName = fileName.replace(notFindThumbnailsSuffix, "");
        path = pathPrefix + replaceFileName;
        if (this.getFileService().exists(path)) {
            return path;
        }
        return "";
    }

    public void removeImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path;
        block10: {
            try {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest((HttpServletRequest)request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction((HttpServletRequest)request, (HttpServletResponse)response);
                    return;
                }
            }
            catch (Exception e) {
                log.error("removeImage ctsy dispatch failed", (Throwable)e);
            }
            path = request.getParameter("path");
            try {
                path = this.dealPath(path);
                this.checkImagePermission(request, path, "4715a0df000000ac");
            }
            catch (KDException e) {
                if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block10;
                return;
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String thumbParam = request.getParameter(THUMBNAILS_PARAMS);
            if (StringUtils.isBlank((CharSequence)thumbParam) || "[]".equals(thumbParam)) {
                this.getFileService().delete(path);
                BillFileMappingWriter.removeMappingRecord((String)path, (String)"image");
            } else {
                List thumbnailsParams = (List)SerializationUtils.fromJsonString((String)thumbParam, List.class);
                List<String> correlationURLs = this.getCorrelationURLs(path, thumbnailsParams);
                for (String url : correlationURLs) {
                    this.getFileService().delete(url);
                    BillFileMappingWriter.removeMappingRecord((String)path, (String)"image");
                }
            }
            result.put(STATUS, SUCCESS);
            String jsonResult = SerializationUtils.toJsonString(result);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
        }
        catch (Exception e) {
            this.handleException(e, response);
        }
    }

    private void checkImagePermission(HttpServletRequest request, String path, String permissionItem) {
        if (FilePremissionUtil.tryGetHasRightValue((HttpServletRequest)request).booleanValue()) {
            return;
        }
        List refList = FilePremissionUtil.getFileRefListByPath((String)path, (Boolean)Boolean.FALSE);
        Map whiteLists = BusinessDataServiceHelper.loadFromCache((String)"bos_picture_white_list", (String)"id, whiteentity", (QFilter[])new QFilter[0]);
        ArrayList<String> entityNumber = new ArrayList<String>(2);
        for (DynamicObject whiteList : whiteLists.values()) {
            DynamicObject whiteEntity = whiteList.getDynamicObject("whiteentity");
            String number = whiteEntity.getString("number");
            entityNumber.add(number);
        }
        for (Map refMap : refList) {
            refMap.put("permItem", permissionItem);
            String entityNum = (String)refMap.get("entityNum");
            if (!entityNumber.contains(entityNum)) continue;
            return;
        }
        Boolean hasPermission = FilePremissionUtil.hasEntityPermission((List)refList);
        if (!hasPermission.booleanValue()) {
            throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void upload(FileItem fileItem, String thumbnailParamsStr, HttpServletRequest request, HttpServletResponse response, Map<String, Object> uploadParam) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<FileRecord> recordList = new ArrayList<FileRecord>(10);
        ArrayList<FilePermissionParam> permissionParamList = new ArrayList<FilePermissionParam>(10);
        log.info("thumbnails params\uff1a" + thumbnailParamsStr);
        try {
            try (InputStream inputStream = fileItem.getInputStream();){
                List thumbnailsParams = (List)SerializationUtils.fromJsonString((String)thumbnailParamsStr, List.class);
                byte[] srcPicData = ByteStreams.toByteArray((InputStream)inputStream);
                try (ByteArrayInputStream srcPicStream = new ByteArrayInputStream(srcPicData);){
                    FileItem newItem = this.createFileItem(fileItem.getFileName(), ImageAction.processPathString(fileItem.getPath(), null, fileItem.getFileName()), srcPicStream);
                    List<FileItem> picList = this.createThumbnails(newItem, thumbnailsParams, srcPicData);
                    picList.add(0, newItem);
                    if (enableLog) {
                        log.info("imageupload.beforeupload time : " + new Date().getTime());
                    }
                    Object encryptStorageParam = uploadParam.get("encryptStorage");
                    boolean encryptStorage = Boolean.parseBoolean(String.valueOf(encryptStorageParam));
                    FileItem[] picItems = new FileItem[picList.size()];
                    if (encryptStorage) {
                        int i = 0;
                        for (FileItem item : picList) {
                            String pathPreffix = item.getPath().substring(0, StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/"));
                            String pathTwo = item.getPath().substring(StringUtils.lastIndexOf((CharSequence)item.getPath(), (CharSequence)"/") + 1);
                            String kdImgPath = pathPreffix + "/kdimg" + pathTwo;
                            picItems[i] = item = this.createFileItem(item.getFileName(), kdImgPath, item.getInputStream());
                            ++i;
                        }
                    } else {
                        picItems = picList.toArray(new FileItem[picList.size()]);
                    }
                    List urls = this.getFileService().upload(picItems);
                    if (enableLog) {
                        log.info("imageupload.afterupload time : " + new Date().getTime());
                    }
                    result.put("url", urls.get(0));
                    result.put("filename", fileItem.getFileName());
                    result.put(STATUS, SUCCESS);
                    for (String url : urls) {
                        FileRecord fileRecord = new FileRecord();
                        fileRecord.setUrl(url);
                        fileRecord.setType("1");
                        fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                        fileRecord.setCreateTime(new Date());
                        recordList.add(fileRecord);
                        FilePermissionParam filePermissionParam = new FilePermissionParam(fileItem.getFId(), fileItem.getAppId(), url, FileTypeEnum.IMAGE, request);
                        permissionParamList.add(filePermissionParam);
                    }
                    FileRecordUtil.doLog(recordList);
                    AttachmentAction.getFilePermissionExtension().dealPermissionParam(permissionParamList);
                }
                log.info("doJson");
                String jsonResult = SerializationUtils.toJsonString(result);
                log.info("doJson:" + result);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
            }
            catch (Exception e) {
                this.handleException(e, response);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{ResManager.loadKDString((String)"\u5e8f\u5217\u5316\u7ed3\u679c\u5931\u8d25\uff01", (String)"ImageAction_0", (String)"bos-webactions", (Object[])new Object[0])});
        }
        finally {
            try {
                fileItem.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    private void handleException(Exception e, HttpServletResponse response) throws IOException {
        log.error((Throwable)e);
        if (e instanceof KDException && AttachExceptionHandler.dealException((KDException)((KDException)((Object)e)), (HttpServletResponse)response).booleanValue()) {
            return;
        }
        AttachmentAction.writeErrorMessage((HttpServletResponse)response, (String)ResManager.loadKDString((String)"\u56fe\u7247\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ImageAction_1", (String)BOS_PICTURE, (Object[])new Object[0]));
    }

    private List<FileItem> createThumbnails(FileItem srcPic, List<Map<String, Object>> thumbnailParams, byte[] srcPicBtyes) throws IOException {
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>(10);
        for (int i = 0; i < thumbnailParams.size(); ++i) {
            ByteArrayInputStream bis = new ByteArrayInputStream(srcPicBtyes);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Map<String, Object> thumbnailsParam = thumbnailParams.get(i);
            String thumbTag = (String)thumbnailsParam.get(THUMBNAILS_TAG);
            if (StringUtils.isBlank((CharSequence)thumbTag)) {
                throw new IllegalArgumentException("params error: thumbnails tag is blank");
            }
            String scale = (String)thumbnailsParam.get(THUMBNAILS_SCALE);
            Integer width = (Integer)thumbnailsParam.get("width");
            Integer height = (Integer)thumbnailsParam.get("height");
            double rotateDegree = 0.0;
            if (bis.available() > 0x500000) {
                this.createThumbnailsForBigImage(bos, width, height, Double.parseDouble(scale), srcPicBtyes);
            } else {
                this.createThumbnailsForSmallImage(bis, bos, scale, width, height, rotateDegree);
            }
            String tmpUrl = ImageAction.processPathString(srcPic.getPath(), thumbTag, srcPic.getFileName());
            fileItems.add(this.createFileItem(srcPic.getFileName(), tmpUrl, new ByteArrayInputStream(bos.toByteArray())));
        }
        return fileItems;
    }

    private void createThumbnailsForSmallImage(ByteArrayInputStream bis, ByteArrayOutputStream bos, String scale, Integer width, Integer height, double rotateDegree) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)scale) && NumberUtils.isNumber((String)scale)) {
            if (rotateDegree > 1.0) {
                ImageUtils.rotateAndscale((InputStream)bis, (OutputStream)bos, (double)rotateDegree, (double)Double.parseDouble(scale));
            } else {
                ImageUtils.scale((InputStream)bis, (OutputStream)bos, (double)Double.parseDouble(scale));
            }
        } else if (width != null && height != null) {
            ImageUtils.scale((InputStream)bis, (OutputStream)bos, (int)width, (int)height);
        } else {
            throw new IllegalArgumentException("params error: thumbnails scale is Illegal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThumbnailsForBigImage(OutputStream out, Integer widthDist, Integer heightDist, Double rate, byte[] srcPicBytes) throws IOException {
        int srcWidth = 0;
        int srcHeight = 0;
        Graphics graphics = null;
        try {
            ImageIcon imageIcon = new ImageIcon(srcPicBytes);
            Image srcImage = imageIcon.getImage();
            srcWidth = imageIcon.getIconWidth();
            srcHeight = imageIcon.getIconHeight();
            if (srcWidth == 0 || srcHeight == 0 || srcWidth == -1 || srcHeight == -1) {
                return;
            }
            if (rate != null && rate > 0.0) {
                widthDist = (int)((double)srcWidth * rate);
                heightDist = (int)((double)srcHeight * rate);
            }
            BufferedImage bufferedImage = new BufferedImage(widthDist, heightDist, 1);
            graphics = bufferedImage.getGraphics();
            graphics.drawImage(srcImage, 0, 0, widthDist, heightDist, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            srcImage.flush();
            bufferedImage.flush();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            out.close();
        }
    }

    private String getOriginalPictrue(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.contains((CharSequence)url, (CharSequence)THUMBNAILS_IDENTITY)) {
            String subString = StringUtils.substringAfterLast((String)url, (String)THUMBNAILS_IDENTITY);
            String thumbTag = StringUtils.substringBeforeLast((String)subString, (String)".");
            url = StringUtils.replaceOnce((String)url, (String)(THUMBNAILS_IDENTITY + thumbTag), (String)"");
        }
        return url;
    }

    private List<String> getCorrelationURLs(String url, List<Map<String, String>> thumbnailsParams) {
        ArrayList<String> urls = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String originalPictrue = this.getOriginalPictrue(url);
            for (Map<String, String> thumbnailsParameter : thumbnailsParams) {
                String thumbnailsTag = thumbnailsParameter.get(THUMBNAILS_TAG);
                String thumbnailsURL = ImageAction.processPathString(originalPictrue, thumbnailsTag, "");
                urls.add(thumbnailsURL);
            }
            urls.add(originalPictrue);
        }
        return urls;
    }

    private static String processPathString(String srcPath, String thumbnailsTag, String fileName) {
        boolean isMatch = true;
        String distPath = srcPath.replace("//", "/");
        if (!distPath.contains(".")) {
            distPath = String.format("%s%s", distPath, fileName);
            isMatch = supportFormat.stream().anyMatch(format -> fileName.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        } else {
            isMatch = supportFormat.stream().anyMatch(format -> srcPath.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        }
        if (!isMatch) {
            String msgformat = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u7c7b\u578b\uff1a%s", (String)"ImageAction_2", (String)BOS_PICTURE, (Object[])new Object[0]);
            String msg = String.format(msgformat, org.apache.commons.lang.StringUtils.join((Object[])supportFormat.toArray()));
            throw new KDBizException(new ErrorCode("NOSUPPORT_PICTURE_FORMAT", msg), new Object[0]);
        }
        String ext = distPath.substring(StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
        if (StringUtils.isNotBlank((CharSequence)thumbnailsTag)) {
            String prefix = distPath.substring(0, StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
            distPath = String.format("%s_thumbnails_%s%s", prefix, thumbnailsTag, ext);
        }
        return distPath;
    }

    private String getContentType(String fileName) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("jpeg")) {
            return IMAGE_JPEG;
        }
        if (ext.equalsIgnoreCase("jpg")) {
            return "image/jpg";
        }
        if (ext.equalsIgnoreCase("jpe")) {
            return "image/jpe";
        }
        if (ext.equalsIgnoreCase("jfif")) {
            return "image/jfif";
        }
        if (ext.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (ext.equalsIgnoreCase("bmp")) {
            return "image/bmp";
        }
        if (ext.equalsIgnoreCase("dib")) {
            return "image/dib";
        }
        if (ext.equalsIgnoreCase("png")) {
            return "image/png";
        }
        if (ext.equalsIgnoreCase("rle")) {
            return "image/rle";
        }
        if (ext.equalsIgnoreCase("emf")) {
            return "image/x-emf";
        }
        if (ext.equalsIgnoreCase("pcx")) {
            return "image/x-pcx";
        }
        if (ext.equalsIgnoreCase("dcx")) {
            return "application/x-dcx";
        }
        if (ext.equalsIgnoreCase("pic")) {
            return "image/pict";
        }
        if (ext.equalsIgnoreCase("tga")) {
            return "image/x-tga";
        }
        if (ext.equalsIgnoreCase("tif")) {
            return "image/tiff";
        }
        if (ext.equalsIgnoreCase("wmf")) {
            return "image/x-wmf";
        }
        return IMAGE_JPEG;
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    private FileItem createFileItem(String fileName, String path, InputStream in) {
        FileItemExt fileItemExt = new FileItemExt(fileName, path, in);
        fileItemExt.setSource(FileSource.PICTURE_FIELD);
        return fileItemExt;
    }

    private String dealPath(String path) {
        return ((ImgFileService)this.getFileService()).dealPath(path);
    }
}

