/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.export.util;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.BidiMap;

public class ConvertUtil {
    private static Log log = LogFactory.getLog(ConvertUtil.class);

    public static String convertFileNameFromUrl(String url, String defaultName, String prefix) {
        String fileName = defaultName;
        if (StringUtils.isBlank((CharSequence)url)) {
            return fileName;
        }
        try {
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            log.error("[\u5bfc\u51fa\u56fe\u7247\uff0c\u540d\u79f0\u8f6c\u6362\u5f02\u5e38\uff1aurl\uff1a]" + url + "Exception \uff1a" + e);
        }
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return fileName;
        }
        return prefix + "_" + fileName;
    }

    public static String convertImageNameFromUrl(String url, String defaultName, String prefix) {
        String fileName = defaultName;
        if (StringUtils.isBlank((CharSequence)url)) {
            return fileName;
        }
        url = FileServiceFactory.getImageFileService().getFileServiceExt().getRealPath(url);
        try {
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            log.error("[\u5bfc\u51fa\u56fe\u7247\uff0c\u540d\u79f0\u8f6c\u6362\u5f02\u5e38\uff1aurl\uff1a]" + url + "Exception \uff1a" + e);
        }
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return fileName;
        }
        return prefix + "_" + fileName;
    }

    public static String convertAttNameFromUrl(String url, String defaultName, String prefix) {
        String fileName = defaultName;
        if (StringUtils.isBlank((CharSequence)url)) {
            return fileName;
        }
        url = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(url);
        try {
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            log.error("[\u5bfc\u51fa\u56fe\u7247/\u9644\u4ef6\uff0c\u540d\u79f0\u8f6c\u6362\u5f02\u5e38\uff1aurl\uff1a]" + url + "Exception \uff1a" + e);
        }
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return fileName;
        }
        return prefix + "_" + fileName;
    }

    public static String collectSingleUrl(BidiMap<String, String> exportAttMessageMap, String attUrl, String billNo) {
        if (StringUtils.isEmpty((CharSequence)attUrl)) {
            return null;
        }
        if (!exportAttMessageMap.containsKey((Object)attUrl)) {
            String nameFromUrl = ConvertUtil.convertAttNameFromUrl(attUrl, "", billNo);
            String finalName = ConvertUtil.renameForDuplicateName(nameFromUrl, exportAttMessageMap);
            exportAttMessageMap.put((Object)attUrl, (Object)finalName);
            return finalName;
        }
        return (String)exportAttMessageMap.get((Object)attUrl);
    }

    private static String renameForDuplicateName(String nameFromUrl, BidiMap<String, String> exportMessageMap) {
        String[] splits = nameFromUrl.trim().split("\\.");
        if (splits.length < 2) {
            return ConvertUtil.buildFileName(nameFromUrl, "", 0, exportMessageMap);
        }
        nameFromUrl = nameFromUrl.trim().substring(0, nameFromUrl.lastIndexOf("."));
        String suffix = splits[splits.length - 1];
        return ConvertUtil.buildFileName(nameFromUrl, suffix, 0, exportMessageMap) + "." + suffix;
    }

    private static String buildFileName(String fileName, String suffix, Integer index, BidiMap<String, String> exportPictureMessageMap) {
        String tmpFileName = fileName;
        if (index != 0) {
            tmpFileName = fileName + "(" + index + ")";
        }
        if (!exportPictureMessageMap.containsValue((Object)(tmpFileName + "." + suffix))) {
            return tmpFileName;
        }
        index = index + 1;
        fileName = ConvertUtil.buildFileName(fileName, suffix, index, exportPictureMessageMap);
        return fileName;
    }
}

