/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.exportentry;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.dto.ExportEntryProcess;
import kd.bos.form.dto.ExportEntryTemplateResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.exportentry.ExportEntryTemplateThread;
import kd.bos.form.exportentry.ImportEntryModelExporter;
import kd.bos.form.exportentry.ImportEntryWriterBuilder;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.util.ExportLogUtil;
import kd.bos.form.util.ImportAndExportEntryUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExportEntryByTemplateProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener,
ICloseCallBack {
    private static final String PROGRESS_BAR = "progressbarap";
    public static final String ALL_ENTRY_ROW_COUNT = "allEntryRowCount";
    public static final String BILL_FORM_ID = "BillFormId";
    public static final String TOP_PAGE_ID = "topPageId";
    public static final String DATA_EXPORTER = "dataExporter";
    public static final String DOWNLOAD_URL = "downloadUrl";
    public static final String ENTRY_TOTAL_ROW_LIST = "entryTotalRowList";
    public static final String ENTRYENTITY = "entryentity";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ExportEntryByTemplateThreadPool", (int)2, (int)6);
    protected static ThreadPool threadPoolForStart = ThreadPools.newCachedThreadPool((String)"ExportEntryByTemplateThreadForStart", (int)1, (int)6);
    private static final Log log = LogFactory.getLog(ExportEntryByTemplateProgressPlugin.class);
    private static final String EXPORT_LABEL = "exportlabel";
    private static final String ENTRY_NAME = "entryname";
    private static final String PROCESS = "process";
    private static final String ENTRY_PROGRESS = "progress";
    private static final String COMFIRMED = "Comfirmed";
    private static final String CLOSE_CONFIRM = "CLOSE_CONFIRM";
    private static final String PASSWORD = "password";
    private static Pattern FileNamePattern = Pattern.compile("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]");
    private static Pattern BlankPattern = Pattern.compile(" ");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.start();
        IFormView currentView = this.getView();
        FormShowParameter showParameter = currentView.getFormShowParameter();
        Object billFormId = showParameter.getCustomParam(BILL_FORM_ID);
        final Object templateId = showParameter.getCustomParam("templateId");
        String topPageId = (String)showParameter.getCustomParam(TOP_PAGE_ID);
        final String password = (String)showParameter.getCustomParam(PASSWORD);
        final IFormView topView = currentView.getView(topPageId);
        if (StringUtils.isEmpty((String)topPageId)) {
            return;
        }
        ExportWriterFormat exportWriterFormat = new ImportEntryWriterBuilder().build(billFormId.toString(), (Long)templateId);
        this.initParamForProgress(exportWriterFormat, topPageId, billFormId, topView);
        final RequestContext requestContext = RequestContext.get();
        threadPoolForStart.submit(new Callable(){

            public Object call() throws Exception {
                RequestContext.copyAndSet((RequestContext)requestContext);
                ExportEntryByTemplateProgressPlugin.this.startExport(topView, templateId, password);
                return null;
            }
        });
    }

    private void initParamForProgress(ExportWriterFormat exportWriterFormatParent, String topPageId, Object billFormId, IFormView topView) {
        Integer allEntryRowCount = 0;
        this.getPageCache().put(TOP_PAGE_ID, topPageId);
        this.getPageCache().put(BILL_FORM_ID, billFormId.toString());
        ArrayList<Integer> entryRowNumList = new ArrayList<Integer>(exportWriterFormatParent.next.size());
        for (ExportWriterFormat exportWriterFormat : exportWriterFormatParent.next) {
            int total = this.getTotal(topView, exportWriterFormat.name);
            allEntryRowCount = allEntryRowCount + total;
            entryRowNumList.add(total);
        }
        this.getPageCache().put(ALL_ENTRY_ROW_COUNT, allEntryRowCount.toString());
        this.getPageCache().put(ENTRY_TOTAL_ROW_LIST, SerializationUtils.toJsonString(entryRowNumList));
        this.initProgressMsg(exportWriterFormatParent.next, entryRowNumList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startExport(IFormView topView, Object templateId, String password) {
        String billFormId = this.getPageCache().get(BILL_FORM_ID);
        if (StringUtils.isEmpty((String)billFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5f02\u5e38\u3002", (String)"ExportEntryByTemplateProgressPlugin_0", (String)"bos-export", (Object[])new Object[0]));
            return;
        }
        DynamicObject exportLogObj = null;
        try {
            SXSSFSheet table;
            SXSSFRow formulaRowOne;
            String caption = topView.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            exportLogObj = ExportLogUtil.buildExportLogObj(caption, "5", topView.getFormShowParameter().getFormId());
            exportLogObj.set("total", (Object)this.getPageCache().get(ALL_ENTRY_ROW_COUNT));
            ExportWriterFormat exportWriterFormatParent = new ImportEntryWriterBuilder().build(billFormId, (Long)templateId);
            ImportEntryModelExporter dataExporter = new ImportEntryModelExporter(exportWriterFormatParent);
            dataExporter.init(billFormId);
            dataExporter.write();
            Map<ExportWriterFormat, SXSSFSheet> entrySheetMap = dataExporter.getEntrySheetMap();
            CountDownLatch countDownLatch = new CountDownLatch(entrySheetMap.size());
            ArrayList<Future> threadFutureList = new ArrayList<Future>(entrySheetMap.size());
            IPageCache pageCache = this.getPageCache();
            String entryTotalRowListJson = this.getPageCache().get(ENTRY_TOTAL_ROW_LIST);
            List entryTotalRowList = (List)SerializationUtils.fromJsonString((String)entryTotalRowListJson, List.class);
            RequestContext requestContext = RequestContext.get();
            int entryThreadIndex = 0;
            for (ExportWriterFormat writerFormat : exportWriterFormatParent.next) {
                String name = writerFormat.name;
                EntryGrid entryGrid = (EntryGrid)topView.getControl(name);
                int total = (Integer)entryTotalRowList.get(entryThreadIndex);
                if (total > 0) {
                    Future future = threadPool.submit((Callable)new ExportEntryTemplateThread(requestContext, countDownLatch, dataExporter.getWb(), entryGrid, pageCache, writerFormat, entrySheetMap.get(writerFormat), this.isSplit(topView, entryGrid.getEntryKey()), total, entryThreadIndex));
                    threadFutureList.add(future);
                } else {
                    countDownLatch.countDown();
                }
                ++entryThreadIndex;
            }
            boolean await = countDownLatch.await(60L, TimeUnit.MINUTES);
            StringBuilder errorMsgSb = new StringBuilder();
            if (!await) {
                errorMsgSb.append(ResManager.loadKDString((String)"\u7ebf\u7a0b\u672a\u6b63\u5e38\u7ed3\u675f", (String)"ExportEntryByTemplateProgressPlugin_2", (String)"bos-export", (Object[])new Object[0]));
            }
            for (Future exportEntryTemplateResultFuture : threadFutureList) {
                ExportEntryTemplateResult exportEntryTemplateResult = (ExportEntryTemplateResult)exportEntryTemplateResultFuture.get();
                if (exportEntryTemplateResult.isCompleted()) continue;
                errorMsgSb.append(String.format(ResManager.loadKDString((String)"%1$s\u5bfc\u51fa\u5931\u8d25\uff1a%2$s", (String)"ExportEntryByTemplateProgressPlugin_1", (String)"bos-export", (Object[])new Object[0]), this.getEntryName(exportEntryTemplateResult.getEntryKey(), topView.getModel()), exportEntryTemplateResult.getErrorMsg()));
            }
            int completeRowCount = 0;
            for (int i = 0; i < entryTotalRowList.size(); ++i) {
                String exportEntryProcessJson = this.getPageCache().get("export_process_" + i);
                if (StringUtils.isEmpty((String)exportEntryProcessJson)) continue;
                ExportEntryProcess exportEntryProcess = (ExportEntryProcess)SerializationUtils.fromJsonString((String)exportEntryProcessJson, ExportEntryProcess.class);
                completeRowCount += exportEntryProcess.getProcess();
            }
            exportLogObj.set("complete", (Object)completeRowCount);
            if (!errorMsgSb.toString().isEmpty()) {
                topView.showErrorNotification(errorMsgSb.toString());
                exportLogObj.set("logs", (Object)errorMsgSb);
                this.getView().sendFormAction(topView);
                this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
                this.getView().close();
            }
            if (null != (formulaRowOne = (table = dataExporter.getWb().getSheet("table")).getRow(1))) {
                SXSSFCell formulaCellOne = formulaRowOne.getCell(1);
                formulaCellOne.setCellValue(pageCache.get("hasMatchId") == null ? 0.0 : 1.0);
            }
            String url = dataExporter.flush(this.getModel().getDataEntityType(), this.getFileName(templateId));
            String downloadUrl = url = UrlService.getAttachmentFullUrl((String)url);
            if (StringUtils.isNotEmpty((String)password)) {
                downloadUrl = downloadUrl + "&password=" + password;
            }
            this.getPageCache().put(DOWNLOAD_URL, downloadUrl);
            this.getPageCache().saveChanges();
            exportLogObj.set("downloadurl", (Object)url);
            if (exportLogObj == null) return;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (exportLogObj == null) return;
            exportLogObj.set("logs", (Object)e);
            return;
        }
        finally {
            if (exportLogObj != null) {
                ExportLogUtil.saveExportLog(exportLogObj);
            }
        }
        ExportLogUtil.saveExportLog(exportLogObj);
        return;
    }

    private String getFileName(Object templateId) {
        DynamicObject templateDyo = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importentry_template", (String)"name");
        ILocaleString name = templateDyo.getLocaleString("name");
        String fileName = ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5bfc\u51fa\u6a21\u677f_", (String)"ExportEntryTemplate_6", (String)"bos-export", (Object[])new Object[0]);
        fileName = fileName + name.getLocaleValue();
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        String nowDateFormat = format.format(now);
        fileName = fileName + String.format("_%s", nowDateFormat);
        fileName = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW ? BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("") : FileNamePattern.matcher(fileName).replaceAll("");
        int length = fileName.getBytes().length;
        if (length >= 255) {
            String billFormId = this.getPageCache().get(BILL_FORM_ID);
            fileName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_%1$s_%2$s", (String)"ExportListTask_1", (String)"bos-export", (Object[])new Object[0]), billFormId, nowDateFormat);
            fileName = BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("_");
        }
        return fileName;
    }

    private void initProgressMsg(List<ExportWriterFormat> exportWriterFormatList, List<Integer> entryRowNumList) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        this.getModel().clearNoDataRow();
        for (int i = 0; i < exportWriterFormatList.size(); ++i) {
            if (entryRowNumList.get(i) == 0) continue;
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            String exporting = "";
            this.getModel().setValue(PROCESS, (Object)String.format(ResManager.loadKDString((String)"%1$s/%2$s\u884c", (String)"ExportEntryTemplate_8", (String)"bos-export", (Object[])new Object[0]), 0, entryRowNumList.get(i)), row);
            exporting = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa", (String)"ExportEntryTemplate_3", (String)"bos-export", (Object[])new Object[0]);
            cardEntry.setCustomProperties(ENTRYENTITY, row, ImportAndExportEntryUtil.getImportingOrExportingStyles(EXPORT_LABEL, ENTRY_NAME, PROCESS));
            String displayName = exportWriterFormatList.get((int)i).displayName;
            this.getModel().setValue(ENTRY_NAME, (Object)displayName, row);
            this.getModel().setValue(EXPORT_LABEL, (Object)exporting, row);
        }
    }

    private void updateProgress(CardEntry cardEntry, int entryIndex, int progress, int total) {
        String exporting = "";
        if (progress > 0 && progress < total) {
            this.getModel().setValue(PROCESS, (Object)String.format(ResManager.loadKDString((String)"%1$s/%2$s\u884c", (String)"ExportEntryTemplate_8", (String)"bos-export", (Object[])new Object[0]), progress, total), entryIndex);
            exporting = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa", (String)"ExportEntryTemplate_3", (String)"bos-export", (Object[])new Object[0]);
            cardEntry.setCustomProperties(ENTRYENTITY, entryIndex, ImportAndExportEntryUtil.getImportingOrExportingStyles(EXPORT_LABEL, ENTRY_NAME, PROCESS));
        }
        if (progress == total) {
            this.getModel().setValue(PROCESS, (Object)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ExportEntryTemplate_4", (String)"bos-export", (Object[])new Object[0]), entryIndex);
            cardEntry.setCustomProperties(ENTRYENTITY, entryIndex, ImportAndExportEntryUtil.getImportedOrExportedStyles(EXPORT_LABEL, ENTRY_NAME, PROCESS));
        }
        this.getModel().setValue(EXPORT_LABEL, (Object)exporting, entryIndex);
    }

    private void endExportEntryRowStyle() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        int[] entryRowArr = new int[entryRowCount];
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue(PROCESS, (Object)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ExportEntryTemplate_4", (String)"bos-export", (Object[])new Object[0]), i);
            entryRowArr[i] = i;
            cardEntry.setCustomProperties(ENTRYENTITY, i, ImportAndExportEntryUtil.getImportedOrExportedStyles(EXPORT_LABEL, ENTRY_NAME, PROCESS));
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String entryTotalRowListJson = this.getPageCache().get(ENTRY_TOTAL_ROW_LIST);
        if (StringUtils.isEmpty((String)entryTotalRowListJson)) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        List entryTotalRowList = (List)SerializationUtils.fromJsonString((String)entryTotalRowListJson, List.class);
        int curEntryRowCount = 0;
        int indexForProcess = 0;
        for (int i = 0; i < entryTotalRowList.size(); ++i) {
            String exportEntryProcessJson = this.getPageCache().get("export_process_" + i);
            if (StringUtils.isEmpty((String)exportEntryProcessJson)) continue;
            ExportEntryProcess exportEntryProcess = (ExportEntryProcess)SerializationUtils.fromJsonString((String)exportEntryProcessJson, ExportEntryProcess.class);
            if ((Integer)entryTotalRowList.get(i) > 0) {
                this.updateProgress(cardEntry, indexForProcess, exportEntryProcess.getProcess(), exportEntryProcess.getTotal());
                ++indexForProcess;
            }
            curEntryRowCount += exportEntryProcess.getProcess();
        }
        String allEntryRowCount = this.getPageCache().get(ALL_ENTRY_ROW_COUNT);
        Integer allEntryRowCountInteger = Integer.valueOf(allEntryRowCount);
        progressEvent.setProgress((int)Math.min(99.0, (double)curEntryRowCount / (double)allEntryRowCountInteger.intValue() * 100.0));
        String url = this.getPageCache().get(DOWNLOAD_URL);
        if (StringUtils.isNotEmpty((String)url)) {
            this.endExportEntryRowStyle();
            progressEvent.setProgress(100);
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.getView().download(url);
            this.getView().sendFormAction(this.getView());
            this.getView().close();
        }
    }

    private boolean isSplit(IFormView view, String entryKey) {
        int count = view.getModel().getEntryRowCount(entryKey);
        try {
            return count > this.getModel().getEntryPageSize() && (Boolean.TRUE.equals(view.getModel().getContextVariable("MODEL_INIT_LOADSPLITPAGE")) || Boolean.parseBoolean(System.getProperty("billmodel.splitpage", "false")));
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getTotal(IFormView view, String entryKey) {
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        int row = view.getModel().getEntryRowCount(entryKey);
        if (grid.getEntryState().getSelectedRows().length > 0) {
            row = grid.getEntryState().getSelectedRows().length;
        }
        return row;
    }

    private String getEntryName(String entryKey, IDataModel dataModel) {
        LocaleString caption = dataModel.getProperty(entryKey).getDisplayName();
        if (caption != null) {
            return StringUtils.isEmpty((String)caption.toString()) ? entryKey : caption.getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u65e0\u5355\u636e\u4f53\u540d\u79f0\u3002", (String)"ExcortEntry_1", (String)"bos-export", (Object[])new Object[0]);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!COMFIRMED.equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, "Comfirming");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5bfc\u51fa\u6570\u636e\uff0c\u5173\u95ed\u5c06\u7ec8\u6b62\u5bfc\u51fa\u6570\u636e\uff0c\u60a8\u786e\u8ba4\u5173\u95ed\u5417\uff1f", (String)"ExportEntryConfigPlugin_0", (String)"bos-export", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            this.close();
        }
    }

    private void close() {
        if (!"Comfirming".equals(this.getPageCache().get(CLOSE_CONFIRM))) {
            this.getPageCache().put(CLOSE_CONFIRM, COMFIRMED);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ExportDataProgressFormPlugin_9", (String)"bos-export", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }
}

