/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.exportentry;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.service.metadata.export.ExportWriterFormat;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ImportEntryModelExporter
extends ExcelWriter
implements Closeable {
    private static final Log log = LogFactory.getLog(ImportEntryModelExporter.class);
    protected static final String BOS_IMPORT = "bos-import";
    private ExportWriterFormat format;
    private final ExportWriterFormat parentFormat;
    private ExportSheetStyle sheetStyle;
    private final Map<ExportWriterFormat, SXSSFSheet> entrySheetMap = new HashMap<ExportWriterFormat, SXSSFSheet>();
    private SXSSFSheet sheet;
    private SXSSFSheet itemsSheet;
    private SXSSFSheet baseDataSheet;
    private SXSSFSheet tableSheet;
    private SXSSFRow tableRow;
    private SXSSFRow entityRow;
    private SXSSFRow tipRow;
    private SXSSFRow numberRow;
    private SXSSFRow nameRow;
    private int itemCol = 0;
    private int baseDataCol = 0;
    private int colNum;
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private final String InputType = "InputType";
    private final String DROPDOWNITEMSSHEET = "dropdown_items_sheet";
    private final String BASEDATAITEMSSHEET = "basedata_items_sheet";
    private static final String ENTITY_IS_MUST_INPUT = "ismustinput";
    private static final String ENTITY_PROP_NAME = "propName";
    private static final String ENTITY_DISPLAY_NAME = "displayname";
    private static final String ENTITY_TEMP_LATEDESCKEY = "EntityDescription";

    @Override
    protected SXSSFWorkbook getWb() {
        return super.getWb();
    }

    public ImportEntryModelExporter(ExportWriterFormat parentFormat) {
        this.parentFormat = parentFormat;
    }

    public void init(String entityId) {
        this.wb = new SXSSFWorkbook(5000);
        this.wb.setCompressTempFiles(true);
        this.createSheetStyle(entityId);
        for (ExportWriterFormat exportWriterFormat : this.parentFormat.next) {
            this.createDataSheet(exportWriterFormat);
            this.format = exportWriterFormat;
        }
        this.createTableSheet();
        this.createItemSheet();
        this.createBaseDataSheet();
        this.tableRow = this.getOrCreateRowIfAbsent(this.tableSheet, 0);
    }

    private void createDataSheet(ExportWriterFormat entryFormat) {
        String name = entryFormat.displayName.replace("*", "");
        this.entrySheetMap.put(entryFormat, this.wb.createSheet(name + " # " + entryFormat.name));
    }

    private void createItemSheet() {
        this.itemsSheet = this.wb.createSheet("dropdown_items_sheet");
        this.itemsSheet.setRandomAccessWindowSize(-1);
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)this.itemsSheet), true);
    }

    private void createBaseDataSheet() {
        this.baseDataSheet = this.wb.createSheet("basedata_items_sheet");
        this.baseDataSheet.setRandomAccessWindowSize(-1);
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)this.baseDataSheet), true);
    }

    private void createTableSheet() {
        this.tableSheet = this.wb.createSheet("table");
        this.tableSheet.setRandomAccessWindowSize(-1);
        this.wb.setSheetHidden(this.wb.getSheetIndex((Sheet)this.tableSheet), this.parentFormat.next.size() > 0);
    }

    private void createSheetStyle(String entityId) {
        this.sheetStyle = new ExportSheetStyle(this.wb, entityId);
    }

    private SXSSFRow getOrCreateRowIfAbsent(SXSSFSheet sheet, int rowIndex) {
        if (rowIndex >= 0x100000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_3", (String)"bos-export", (Object[])new Object[0]), 0x100000));
        }
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public void write() {
        for (Map.Entry<ExportWriterFormat, SXSSFSheet> entryFormatEntry : this.entrySheetMap.entrySet()) {
            this.colNum = 0;
            this.format = entryFormatEntry.getKey();
            for (ExportWriterFormat exportWriterFormat : this.format.next) {
                exportWriterFormat.col -= this.format.col;
            }
            this.format.col = 0;
            this.sheet = entryFormatEntry.getValue();
            this.entityRow = this.getOrCreateRowIfAbsent(this.sheet, 0);
            this.tipRow = this.getOrCreateRowIfAbsent(this.sheet, 1);
            this.numberRow = this.getOrCreateRowIfAbsent(this.sheet, 2);
            this.nameRow = this.getOrCreateRowIfAbsent(this.sheet, 3);
            this.writeHead();
        }
        this.writeTableName();
    }

    private void writeHead() {
        this.writeEntityRow();
        this.writeTipRow();
        this.writePropertyNumber();
        this.writePropertyName();
    }

    private void writeAllCellModel(Consumer<ExportWriterFormat> consumer) {
        consumer.accept(this.format);
        for (ExportWriterFormat subEntryFormat : this.format.next) {
            consumer.accept(subEntryFormat);
        }
    }

    private void writeTableName() {
        this.createCellForTableNameHead(this.parentFormat);
    }

    private void writeEntityRow() {
        this.writeAllCellModel(this::createCellForHead);
    }

    private void createCellForHead(ExportWriterFormat format) {
        this.writeEntityOrName(format, this.entityRow);
    }

    private void writeEntityOrName(ExportWriterFormat format, SXSSFRow row) {
        int col = 0;
        if (format.next.size() == 0) {
            col = format.col;
        }
        CellStyle cellStyle = format.displayName != null && format.displayName.startsWith("*") ? this.sheetStyle.getTextHighLightStyle() : this.sheetStyle.getTextStyle();
        row.getSheet().setColumnWidth(col, this.calcColumnWidth(format.displayName + " # " + format.name, 0, 0));
        SXSSFCell cell = ImportEntryModelExporter.createCell(this.wb, row, col, cellStyle);
        cell.setCellValue(format.displayName + " # " + format.name);
    }

    private void createCellForTableNameHead(ExportWriterFormat format) {
        this.writeEntityOrName(format, this.tableRow);
    }

    private void writeTipRow() {
        this.writeAllCellModel(this::createCellForTips);
    }

    private void createCellForTips(ExportWriterFormat format) {
        int col = 0;
        if (format.next.size() == 0) {
            col = format.col;
        }
        List<String> fieldNumbers = format.fields;
        for (int i = 0; i < fieldNumbers.size(); ++i) {
            String fieldNumber = fieldNumbers.get(i);
            Map<String, Object> property = format.properties.get(fieldNumber);
            String entityDesc = (String)property.get(ENTITY_TEMP_LATEDESCKEY);
            if (i + col == 0) {
                CellStyle textHighLightStyle = this.sheetStyle.getTextHighLightStyle();
                textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
                textHighLightStyle.setWrapText(true);
                SXSSFCell cell = ImportEntryModelExporter.createCell(this.wb, this.tipRow, 0, textHighLightStyle);
                cell.setCellValue(this.buildTip(this.tipRow, entityDesc));
                continue;
            }
            ImportEntryModelExporter.createCell(this.wb, this.tipRow, i + col, this.sheetStyle.getTextStyle()).setCellValue(entityDesc);
        }
    }

    private String buildTip(SXSSFRow tipRow, String entityDesc) {
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        tips.add(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"ImportConfig_4", (String)BOS_IMPORT, (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"ImportConfig_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            tips.add("-----------");
            tips.add(entityDesc);
            tips.add("");
        }
        tips.add("");
        tips.add("");
        int radit = this.addTips(strb, tips);
        Optional maxLengthStr = tips.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return 1;
            }
            return -1;
        });
        tipRow.setHeightInPoints((float)radit * tipRow.getSheet().getDefaultRowHeightInPoints());
        tipRow.getSheet().setColumnWidth(0, this.calcColumnWidth(maxLengthStr.orElse(""), 0, 0));
        return strb.toString();
    }

    private int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append("\r\n");
        }
        strb.delete(strb.length() - "\r\n".length(), strb.length());
        return tips.size();
    }

    private int calcColumnWidth(String caption, int defColWidth, int designatedColWidth) {
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    private void createColStyle(ExportWriterFormat format, String fieldNumber) {
        ExportSheetStyle styles = new ExportSheetStyle(this.wb, null);
        Map<String, Object> property = format.properties.get(fieldNumber);
        if (null != property) {
            Object inputType = property.get("InputType");
            if ("date".equals(inputType)) {
                this.sheet.setDefaultColumnStyle(this.colNum, styles.getDateStyle());
            } else if ("datetime".equals(inputType)) {
                this.sheet.setDefaultColumnStyle(this.colNum, styles.getDatetimeStyle());
            } else if ("decimal".equals(inputType)) {
                this.sheet.setDefaultColumnStyle(this.colNum, styles.getDecimalStyle(this.wb, (Map)property.get("DecimalFormat")));
            } else {
                this.sheet.setDefaultColumnStyle(this.colNum, styles.getTextStyle());
            }
        } else {
            this.sheet.setDefaultColumnStyle(this.colNum, styles.getTextStyle());
        }
    }

    private void writePropertyNumber() {
        this.writeAllCellModel(this::createCellForEntityNumber);
    }

    private void createCellForEntityNumber(ExportWriterFormat format) {
        List<String> fieldNumbers = format.fields;
        fieldNumbers = this.rebuildFieldNumbers(format, fieldNumbers);
        Map<String, Map<String, Object>> baseDataFields = this.rebuildProperties(format);
        for (int i = 0; i < fieldNumbers.size(); ++i) {
            String fieldNumber = fieldNumbers.get(i);
            SXSSFCell cell = ImportEntryModelExporter.createCell(this.wb, this.numberRow, this.colNum, this.sheetStyle.getTitleStyle());
            cell.setCellValue(fieldNumber);
            this.createColStyle(format, fieldNumber);
            this.numberRow.getSheet().setColumnWidth(this.colNum, this.calcColumnWidth(fieldNumber, 0, 0));
            this.createCellForItem(format, fieldNumber);
            this.createBaseDataForProperty(baseDataFields, fieldNumber);
            this.createCellForIdColCountFormula(fieldNumber, cell.getColumnIndex());
            ++this.colNum;
        }
    }

    private void createCellForIdColCountFormula(String fieldNumber, int columnIndex) {
        if (fieldNumber.endsWith("$matchid$")) {
            SXSSFRow row = this.tableSheet.createRow(this.tableSheet.getLastRowNum() + 1);
            SXSSFCell cellFieldNumber = row.createCell(0);
            cellFieldNumber.setCellStyle(this.sheetStyle.getTextStyle());
            cellFieldNumber.setCellValue(fieldNumber);
            SXSSFCell cellFormula = row.createCell(1);
            String columnLabel = ListDataExporter.getColumnLabel(columnIndex + 1);
            String formula = String.format("COUNTA('%1$s'!%2$s5:%2$s1048576)", this.sheet.getSheetName(), columnLabel, columnLabel);
            cellFormula.setCellFormula(formula);
        }
    }

    private List<String> rebuildFieldNumbers(ExportWriterFormat format, List<String> fieldNumbers) {
        ArrayList<String> newFieldNames = new ArrayList<String>(fieldNumbers.size());
        for (String fieldNumber : fieldNumbers) {
            Map<String, Object> property = format.properties.get(fieldNumber);
            if (property == null) continue;
            Object inputType = property.get("InputType");
            if ("id".equals(inputType) || "pid".equals(inputType)) {
                fieldNumber = fieldNumber.replace('.', '_');
                newFieldNames.add(fieldNumber);
                continue;
            }
            if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                List<String> splitCols = format.flexColumn.get(fieldNumber);
                if (CollectionUtils.isEmpty(splitCols)) continue;
                newFieldNames.addAll(splitCols);
                continue;
            }
            newFieldNames.add(fieldNumber);
        }
        return newFieldNames;
    }

    private Map<String, Map<String, Object>> rebuildProperties(ExportWriterFormat format) {
        Map<String, Map<String, Object>> properties = format.properties;
        HashMap<String, Map<String, Object>> newProperties = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> property : properties.entrySet()) {
            Object inputType = property.getValue().get("InputType");
            Object importProp = property.getValue().get("ImportProp");
            if (!"basedata".equals(inputType) || !(importProp instanceof List) || ((List)importProp).isEmpty()) continue;
            newProperties.put(property.getKey() + "." + ((List)importProp).get(0), property.getValue());
        }
        return newProperties;
    }

    private void writePropertyName() {
        this.writeAllCellModel(this::createCellForEntityName);
    }

    private void createCellForEntityName(ExportWriterFormat format) {
        SXSSFCell cell;
        int col = 0;
        if (format.next.size() == 0) {
            col = format.col;
        }
        List<String> fieldNumbers = format.fields;
        List<Map<String, Object>> fieldNames = this.rebuildFieldNames(format, fieldNumbers);
        for (int i = 0; i < fieldNames.size(); ++i) {
            Map<String, Object> fieldDetail = fieldNames.get(i);
            String fieldName = String.valueOf(fieldDetail.get(ENTITY_DISPLAY_NAME));
            Boolean mustInput = (Boolean)fieldDetail.get(ENTITY_IS_MUST_INPUT);
            fieldName = (mustInput != false ? "*" : "") + fieldName;
            cell = ImportEntryModelExporter.createCell(this.wb, this.nameRow, i + col, mustInput != false ? this.sheetStyle.getTitleMustInputStyle() : this.sheetStyle.getTitleStyle("default"));
            cell.setCellValue(fieldName);
        }
        List<String> fieldDescs = this.rebuildFieldDescs(format, fieldNumbers);
        for (int i = 0; i < fieldDescs.size(); ++i) {
            int colTip = format.col + i;
            String fieldDesc = fieldDescs.get(i);
            cell = this.nameRow.getCell(colTip);
            this.bindCellDesc(this.sheet, cell, colTip, this.nameRow.getRowNum(), fieldDesc);
        }
    }

    private List<Map<String, Object>> rebuildFieldNames(ExportWriterFormat format, List<String> fieldNumbers) {
        ArrayList<Map<String, Object>> newFieldNames = new ArrayList<Map<String, Object>>(fieldNumbers.size());
        for (String fieldNumber : fieldNumbers) {
            HashMap<String, Object> fieldDetails = new HashMap<String, Object>();
            Map<String, Object> property = format.properties.get(fieldNumber);
            if (property == null) continue;
            Object inputType = property.get("InputType");
            Boolean isMustInput = Boolean.valueOf(String.valueOf(property.get(ENTITY_IS_MUST_INPUT)));
            if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                List<String> splitColDisplayKey = format.flexColumn.get(fieldNumber);
                List<String> splitColDisplayNames = format.flexColumnDisplay.get(fieldNumber);
                if (CollectionUtils.isEmpty(splitColDisplayNames)) continue;
                for (int i = 0; i < splitColDisplayKey.size(); ++i) {
                    HashMap<String, Object> splitColFieldDetails = new HashMap<String, Object>();
                    splitColFieldDetails.put(ENTITY_PROP_NAME, splitColDisplayKey.get(i));
                    splitColFieldDetails.put(ENTITY_DISPLAY_NAME, splitColDisplayNames.get(i));
                    splitColFieldDetails.put(ENTITY_IS_MUST_INPUT, false);
                    if (i == 0) {
                        splitColFieldDetails.put(ENTITY_IS_MUST_INPUT, isMustInput);
                    }
                    newFieldNames.add(splitColFieldDetails);
                }
                continue;
            }
            fieldDetails.put(ENTITY_PROP_NAME, fieldNumber);
            fieldDetails.put(ENTITY_DISPLAY_NAME, property.get("DisplayName"));
            fieldDetails.put(ENTITY_IS_MUST_INPUT, isMustInput);
            newFieldNames.add(fieldDetails);
        }
        return newFieldNames;
    }

    private List<String> rebuildFieldDescs(ExportWriterFormat format, List<String> fieldNumbers) {
        ArrayList<String> newFieldDescs = new ArrayList<String>(fieldNumbers.size());
        for (String fieldNumber : fieldNumbers) {
            Map<String, Object> fieldMsgMap = format.properties.get(fieldNumber);
            if (fieldMsgMap != null && fieldMsgMap.get("InputDesc") != null) {
                newFieldDescs.add(fieldMsgMap.get("InputDesc").toString());
                continue;
            }
            List<String> splitColDescs = format.flexColumnDesc.get(fieldNumber);
            if (CollectionUtils.isEmpty(splitColDescs)) {
                newFieldDescs.add("");
                continue;
            }
            newFieldDescs.addAll(splitColDescs);
        }
        return newFieldDescs;
    }

    private void bindCellDesc(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String fieldDesc) {
        if (!StringUtils.isBlank((CharSequence)fieldDesc)) {
            SXSSFDrawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
            comment.setString((RichTextString)new XSSFRichTextString(fieldDesc));
            cell.setCellComment(comment);
        }
    }

    private void createCellForItem(ExportWriterFormat format, String fieldName) {
        Map<String, Object> property = format.properties.get(fieldName);
        if (null == property) {
            return;
        }
        Object inputType = property.get("InputType");
        if (!(inputType instanceof String[]) || "MulComboProp".equals(property.get("PropType"))) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (((String[])inputType).length > 0 && ((String[])inputType)[0].indexOf("#") != -1) {
            Arrays.stream((String[])inputType).forEach(obj -> items.add(obj.split(" # ", -1)[0]));
        }
        if (!items.isEmpty()) {
            items.add(0, format.name + " # " + fieldName);
            for (int j = 0; j < items.size(); ++j) {
                SXSSFRow itemRow = ImportEntryModelExporter.getRow(this.itemsSheet, j);
                SXSSFCell itemRowCell = itemRow.createCell(this.itemCol);
                itemRowCell.setCellValue((String)items.get(j));
            }
            this.createDropdownList(this.sheet, this.colNum, items, this.itemCol, "dropdown_items_sheet");
            ++this.itemCol;
        }
    }

    private void createBaseDataForProperty(Map<String, Map<String, Object>> baseDataFields, String fieldNumber) {
        if (!baseDataFields.containsKey(fieldNumber)) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        Map<String, Object> propertyValue = baseDataFields.get(fieldNumber);
        Object inputValues = propertyValue.get("InputValues");
        if (inputValues instanceof List && !((List)inputValues).isEmpty()) {
            items.addAll((List)inputValues);
        }
        if (!items.isEmpty()) {
            items.add(0, fieldNumber);
            for (int j = 0; j < items.size(); ++j) {
                SXSSFRow itemRow = ImportEntryModelExporter.getRow(this.baseDataSheet, j);
                SXSSFCell itemRowCell = itemRow.createCell(this.baseDataCol);
                itemRowCell.setCellValue((String)items.get(j));
            }
            this.createDropdownList(this.sheet, this.colNum, items, this.baseDataCol, "basedata_items_sheet");
            ++this.baseDataCol;
        }
    }

    private void createDropdownList(SXSSFSheet sheet, int currCol, List<String> items, int itemCol, String sheetName) {
        String currColLabel = ImportEntryModelExporter.getColumnLabel(itemCol + 1);
        String strFormula = String.format(sheetName + "!$%s$%d:$%s$%d", currColLabel, 2, currColLabel, items.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(4, 10000, currCol, currCol);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    @Override
    public void close() throws IOException {
        if (this.wb != null) {
            this.wb.close();
        }
    }

    public Map<ExportWriterFormat, SXSSFSheet> getEntrySheetMap() {
        return this.entrySheetMap;
    }
}

