/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.exportentry;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.importentry.strategy.BeforeDownloadImportEntryTemplateEvent;
import kd.bos.form.plugin.importentry.strategy.ImportEntryTemplateListener;
import kd.bos.form.util.ExportEntryUtil;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ImportEntryWriterBuilder {
    private static final String BOS_EXPORT = "bos-export";
    private static final String NUMBER = "number";
    private static final Log log = LogFactory.getLog(ImportEntryWriterBuilder.class);
    private static final String INPUT_TYPE_KEY = "InputType";
    private static final String INPUT_PROPKEY = "ImportProp";
    private static final String INPUT_PROPNAME = "ImportPropName";
    private static final String INPUT_DESC_KEY = "InputDesc";
    private static final String INPUT_DATA_KEY = "DataKey";
    private static final String INPUT_DECIMAL_FORMAT = "DecimalFormat";
    private static final String COLWIDTH_KEY = "ColWidth";
    private static final String INPUT_VALUES = "InputValues";
    private static final String ENTITY_TEMP_LATEDESCKEY = "EntityDescription";
    private static final String ENTITY_IS_MUST_INPUT = "ismustinput";
    private final String kdName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_2", (String)"bos-export", (Object[])new Object[0]);
    private final String kdCode = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)"bos-export", (Object[])new Object[0]);
    private static final String BOS_IMPORT = "bos-import";

    public ExportWriterFormat build(String formId, long templateId) {
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importentry_template");
        if (templateData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6a21\u677f\u6570\u636e", (String)"ImportEntryWriterBuilder_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        Map<String, DynamicObject> fieldSetMapping = this.createDataEntityAtEntityFields(templateData);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        ExportWriterFormat writer = new ExportWriterFormat(mainEntityType.getName(), mainEntityType.getDisplayName().toString(), 0);
        List<EnabledLang> enableLangs = this.getEnabledLangs(formId);
        int flexPropGroups = ExportEntryUtil.getFlexPropGroups(formId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        this.parse(writer, (DynamicObjectType)mainEntityType, fieldSetMapping, enableLangs, flexPropGroups, entityMetadata);
        writer.setDescription(templateData.getString("comment"));
        List plugins = new ArrayList();
        String importTemplatePlugins = templateData.getString("plugin");
        List pluginsTmp = JSONObject.parseArray((String)importTemplatePlugins, Plugin.class);
        if (pluginsTmp != null) {
            plugins = pluginsTmp;
        }
        HashMap<String, List<String>> baseDataDropDownValues = new HashMap<String, List<String>>();
        HashMap<String, String> baseDataImportType = new HashMap<String, String>();
        for (Plugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            ImportEntryTemplateListener importEntryTemplatePlugin = null;
            try {
                importEntryTemplatePlugin = (ImportEntryTemplateListener)TypesContainer.createInstance((String)plugin.getClassName());
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6a21\u677f\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a%2$s", (String)"ImportConfig_2", (String)BOS_IMPORT, (Object[])new Object[0]), plugin.getClassName(), ResManager.loadKDString((String)"\u63d2\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportConfig_3", (String)BOS_IMPORT, (Object[])new Object[0]))), new Object[0]);
            }
            this.setBaseDataImportType(writer, baseDataImportType);
            importEntryTemplatePlugin.beforeSetBaseData(new BeforeDownloadImportEntryTemplateEvent(mainEntityType, baseDataDropDownValues, baseDataImportType));
            this.setBaseDataImportValues(writer, baseDataDropDownValues);
        }
        return writer.ready(fieldSetMapping.keySet());
    }

    private Map<String, DynamicObject> createDataEntityAtEntityFields(DynamicObject templateData) {
        LinkedHashMap<String, DynamicObject> fieldSetMapping = new LinkedHashMap<String, DynamicObject>();
        DynamicObjectCollection templateEntry = templateData.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject row : templateEntry) {
            String entityNumber = row.getString("entitynumber");
            if (StringUtils.isBlank((CharSequence)entityNumber) || Boolean.TRUE.compareTo(row.getBoolean("isimport")) != 0) continue;
            fieldSetMapping.put(entityNumber, row);
        }
        return fieldSetMapping;
    }

    private List<EnabledLang> getEnabledLangs(String formId) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
        Map settingOfMultilang = exportService.getSettingOfMultilang(formId);
        if (CollectionUtils.isEmpty((Map)settingOfMultilang)) {
            return multiLangEnabledLang;
        }
        ArrayList<EnabledLang> result = new ArrayList<EnabledLang>(multiLangEnabledLang.size());
        for (EnabledLang enabledLang : multiLangEnabledLang) {
            if (enabledLang.getIsDefault().booleanValue()) {
                result.add(enabledLang);
                continue;
            }
            String key = enabledLang.getNumber().toLowerCase();
            if (!settingOfMultilang.getOrDefault(key, Boolean.TRUE).booleanValue()) continue;
            result.add(enabledLang);
        }
        return result;
    }

    private int parse(ExportWriterFormat writer, DynamicObjectType entityType, Map<String, DynamicObject> fieldSet, List<EnabledLang> enableLangs, int flexGroups, EntityMetadata entityMetadata) {
        int col = writer.col;
        String ID2 = "id";
        String PID = "pid";
        for (IDataEntityProperty prop : entityType.getProperties()) {
            boolean isIDOrPID;
            if (prop instanceof LinkEntryProp) continue;
            boolean isID = ID2.equalsIgnoreCase(prop.getName());
            boolean isPID = PID.equalsIgnoreCase(prop.getName());
            boolean bl = isIDOrPID = isID || isPID;
            if (!isIDOrPID && (prop instanceof FieldProp && ((FieldProp)prop).isSysField() || prop instanceof LongProp || prop instanceof AttachmentProp || prop instanceof DynamicLocaleProperty || prop instanceof IFieldHandle && !this.isFieldExportable(prop) || prop instanceof FlexProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((FlexProp)prop).getBasePropertyKey()) || prop instanceof ItemClassProp && !this.isControlFieldExportable((IDataEntityType)entityType, ((ItemClassProp)prop).getTypePropName()))) continue;
            String propName = prop.getName();
            if (isIDOrPID && !(entityType instanceof MainEntityType)) {
                propName = prop.getParent().getName() + ".$matchid$";
            }
            if (prop instanceof EntryProp) {
                ExportWriterFormat subWriter = new ExportWriterFormat(propName, (((EntryProp)prop).isEntryMustInput() ? "*" : "") + prop.getDisplayName().toString(), col + 1);
                int subCol = this.parse(subWriter, ((EntryProp)prop).getDynamicCollectionItemPropertyType(), fieldSet, enableLangs, flexGroups, entityMetadata);
                if (subCol - col >= 1 && subWriter.fields.size() > 0) {
                    writer.next.add(subWriter);
                    col = subCol;
                    continue;
                }
                col += 2;
                continue;
            }
            if (!(prop instanceof IFieldHandle) || !isIDOrPID && !((IFieldHandle)prop).isImportable() && !((IFieldHandle)prop).isExportable() || !fieldSet.isEmpty() && !fieldSet.containsKey(propName)) continue;
            String currLang = RequestContext.getOrCreate().getLang().name();
            DynamicObject templateRow = fieldSet.get(propName);
            ArrayList<String> props = new ArrayList<String>();
            ArrayList<String> dataKeyProps = new ArrayList<String>();
            ArrayList<String> propDisplayNames = new ArrayList<String>();
            boolean isBasedata = prop instanceof IBasedataField;
            boolean isMultiLang = prop instanceof MuliLangTextProp;
            boolean isLargeText = prop instanceof LargeTextProp;
            if (isBasedata && templateRow != null) {
                this.prepareBasedataProps(props, dataKeyProps, propDisplayNames, templateRow, prop, currLang);
            } else if (isLargeText) {
                this.prepareLargeTextProps(props, propDisplayNames, prop, propName);
            }
            HashMap<String, Object> property = new HashMap<String, Object>(16);
            property.put("propName", propName);
            if (templateRow != null) {
                property.put(ENTITY_TEMP_LATEDESCKEY, templateRow.getString(ENTITY_TEMP_LATEDESCKEY));
                property.put(ENTITY_IS_MUST_INPUT, templateRow.getString(ENTITY_IS_MUST_INPUT));
            }
            LocaleString displayName = null;
            if (isID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u5339\u914did", (String)"ExportEntryWriterBuilder_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isPID) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportEntryWriterBuilder_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else if (prop instanceof FieldProp) {
                displayName = prop.getDisplayName();
            } else if (prop instanceof BasedataProp) {
                displayName = prop.getDisplayName();
            } else if (prop instanceof MulBasedataProp) {
                displayName = prop.getDisplayName();
            }
            property.put("DisplayName", displayName == null ? "" : displayName.toString());
            if (isID) {
                property.put(INPUT_TYPE_KEY, ID2);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e\u65f6\uff0c\u8be5\u5b57\u6bb5\u662f\u5339\u914d\u6570\u636e\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u65b0\u589e\u6570\u636e\u65f6\u65e0\u9700\u5bfc\u5165\u8be5\u5b57\u6bb5", (String)"ExportEntryWriterBuilder_8", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isPID) {
                property.put(INPUT_TYPE_KEY, PID);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801\u662f\u6811\u5f62\u5355\u636e\u4f53\u4e0a\u7ea7\u884c\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u3002", (String)"ImportEntryWriterBuilder_2", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else if (isLargeText) {
                property.put(INPUT_TYPE_KEY, "largetext");
            } else if (isMultiLang) {
                property.put(INPUT_TYPE_KEY, "multilang");
            } else if (prop instanceof TextProp || prop instanceof VarcharProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_12", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof AdminDivisionProp) {
                property.put(INPUT_TYPE_KEY, "varchar");
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6587\u672c\uff0c\u793a\u4f8b\uff1a\u4e2d\u56fd/\u5e7f\u4e1c/\u6df1\u5733/\u5357\u5c71/\u79d1\u6280\u56ed", (String)"ExportWriterBuilder_28", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof DecimalProp) {
                property.put(INPUT_TYPE_KEY, "decimal");
                HashMap<String, Integer> decimalformat = new HashMap<String, Integer>();
                decimalformat.put("precision", ((DecimalProp)prop).getScale());
                property.put(INPUT_DECIMAL_FORMAT, decimalformat);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u6570\u5b57", (String)"ExportWriterBuilder_13", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (isBasedata) {
                property.put(INPUT_TYPE_KEY, prop instanceof FlexProp ? "flex" : "basedata");
                property.put(INPUT_PROPKEY, props);
                property.put(INPUT_PROPNAME, propDisplayNames);
            } else if (prop instanceof TimeProp) {
                Optional<Entity> firstEntity;
                property.put(INPUT_TYPE_KEY, "time");
                if (StringUtils.isNotEmpty((CharSequence)((TimeProp)prop).getRelateTimeRange()) && (firstEntity = entityMetadata.getEntitys().stream().filter(i -> StringUtils.equals((CharSequence)i.getKey(), (CharSequence)prop.getParent().getName())).findFirst()).isPresent()) {
                    Entity entity = firstEntity.get();
                    for (EntityItem item : entity.getItems()) {
                        if (!(item instanceof TimeRangeField)) continue;
                        if (((TimeRangeField)item).getStartDateFieldKey().equals(prop.getName())) {
                            property.put("PropType", ((TimeRangeField)item).getKey());
                            property.put("isStart", "true");
                            continue;
                        }
                        if (!((TimeRangeField)item).getEndDateFieldKey().equals(prop.getName())) continue;
                        property.put("PropType", ((TimeRangeField)item).getKey());
                        property.put("isStart", "false");
                    }
                }
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a12:00:00", (String)"ExportWriterBuilder_14", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof DateProp) {
                property.put(INPUT_TYPE_KEY, "date");
                ImportEntryWriterBuilder.putDatePropRangeFieldName(entityMetadata, prop, property);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"ExportWriterBuilder_15", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof DateTimeProp) {
                property.put(INPUT_TYPE_KEY, "datetime");
                ImportEntryWriterBuilder.putDatePropRangeFieldName(entityMetadata, prop, property);
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a2018-05-01 12:00:00", (String)"ExportWriterBuilder_16", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof BooleanProp) {
                property.put("PropType", "BooleanProp");
                property.put(INPUT_TYPE_KEY, new String[]{ResManager.loadKDString((String)"\u662f", (String)"ExportWriterBuilder_17", (String)BOS_EXPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"ExportWriterBuilder_18", (String)BOS_EXPORT, (Object[])new Object[0])});
                property.put(INPUT_DESC_KEY, ResManager.loadKDString((String)"\u9009\u9879\uff0c\u662f/\u5426", (String)"ExportWriterBuilder_19", (String)BOS_EXPORT, (Object[])new Object[0]));
            } else if (prop instanceof ComboProp) {
                try {
                    ArrayList itemList = new ArrayList(((ComboProp)prop).getComboItems());
                    for (int index = 0; index < itemList.size(); ++index) {
                        if (((ValueMapItem)itemList.get(index)).isItemVisible()) continue;
                        itemList.remove(index);
                    }
                    String[] items = new String[itemList.size()];
                    CharSequence[] itemDesc = new String[itemList.size()];
                    for (int index = 0; index < itemList.size(); ++index) {
                        items[index] = ((ValueMapItem)itemList.get(index)).getName() + " # " + ((ValueMapItem)itemList.get(index)).getValue();
                        itemDesc[index] = ((ValueMapItem)itemList.get(index)).getName().toString();
                    }
                    property.put(INPUT_TYPE_KEY, items);
                    property.put("PropType", "ComboProp");
                    if (prop instanceof MulComboProp) {
                        property.put("PropType", "MulComboProp");
                        if (itemDesc.length == 0) {
                            property.put(INPUT_DESC_KEY, String.format(ResManager.loadKDString((String)"\u591a\u4e2a\u9009\u9879\u4ee5\u2018,\u2019\u5206\u9694", (String)"ImportEntryWriterBuilder_8", (String)BOS_IMPORT, (Object[])new Object[0]), new Object[0]));
                        } else {
                            property.put(INPUT_DESC_KEY, String.format(ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a%s\uff0c\u591a\u4e2a\u9009\u9879\u4ee5\u201c,\u201d\u5206\u9694\u3002", (String)"ImportEntryWriterBuilder_5", (String)BOS_IMPORT, (Object[])new Object[0]), String.join((CharSequence)"\u3001", itemDesc)));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u62c9\u5217\u8868%1$s\u7684\u9009\u9879\u5931\u8d25\uff1akey=%2$s", (String)"ImportEntryWriterBuilder_6", (String)BOS_IMPORT, (Object[])new Object[0]), prop.getDisplayName(), prop.getName()));
                }
            }
            if (isMultiLang) {
                property.put(INPUT_DATA_KEY, currLang);
            } else if (isLargeText) {
                property.put(INPUT_DATA_KEY, "largetext");
            } else if (prop instanceof FlexProp) {
                property.put(INPUT_DATA_KEY, "value");
            } else if (prop instanceof IBasedataField) {
                ArrayList<String> mulDataKey = null;
                if (prop instanceof MulBasedataProp) {
                    mulDataKey = new ArrayList<String>(props.size());
                    for (String p : props) {
                        mulDataKey.add("fbasedataid." + p);
                    }
                }
                property.put(INPUT_DATA_KEY, mulDataKey == null ? dataKeyProps : mulDataKey);
            }
            if (isBasedata || isMultiLang || isLargeText) {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<String> display = new ArrayList<String>();
                ArrayList<String> desc = new ArrayList<String>();
                if (prop instanceof FlexProp) {
                    for (int i2 = 0; i2 < flexGroups; ++i2) {
                        items.add(propName);
                        display.add(prop.getDisplayName().getLocaleValue());
                        desc.add("");
                        items.add(propName + ".number");
                        display.add(this.codeToName(NUMBER));
                        desc.add(ResManager.loadKDString((String)"\u5982\u679c\u5f39\u6027\u57df\u7c7b\u578b\u4e3a\u6587\u672c\u6216\u6570\u503c\u7c7b\u578b\uff0c\u4e0d\u9700\u8981\u7ef4\u62a4\u8be5\u5217\u6570\u636e", (String)"ExportWriterBuilder_20", (String)BOS_EXPORT, (Object[])new Object[0]));
                        items.add(propName + ".name");
                        display.add(this.codeToName("name"));
                        desc.add("");
                    }
                } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
                    boolean isMulBasedata = prop instanceof MulBasedataProp;
                    String basedataColumnKey = propName;
                    String basedataColumnName = prop.getDisplayName().getLocaleValue();
                    if (props.isEmpty()) {
                        if (prop instanceof ItemClassProp) {
                            this.setItemClassProps(propName, prop, basedataColumnName, items, display, desc);
                        } else {
                            this.setDefaultBasedataProps(propName, prop, items, display, desc);
                        }
                    } else {
                        for (String p : props) {
                            items.add((String)basedataColumnKey + "." + p);
                            if (!desc.isEmpty()) continue;
                            desc.add(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u652f\u6301\u5f55\u5165%2$s", (String)"ImportEntryWriterBuilder_7", (String)BOS_IMPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0]), "name".equals(p) ? this.kdName : this.kdCode));
                        }
                        for (int i3 = 0; i3 < propDisplayNames.size(); ++i3) {
                            display.add(basedataColumnName + "." + (String)propDisplayNames.get(i3));
                        }
                    }
                } else if (isMultiLang) {
                    String comment = ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportWriterBuilder_12", (String)BOS_EXPORT, (Object[])new Object[0]);
                    for (EnabledLang lang : enableLangs) {
                        if (lang.number.equals(currLang)) {
                            items.add(0, propName + "." + lang.number);
                            display.add(0, this.getDisplayName(prop) + "." + lang.name);
                            desc.add(0, comment);
                            continue;
                        }
                        items.add(propName + "." + lang.number);
                        display.add(this.getDisplayName(prop) + "." + lang.name);
                        desc.add(comment);
                    }
                } else if (isLargeText) {
                    for (String p : props) {
                        items.add(p);
                    }
                    for (int i4 = 0; i4 < propDisplayNames.size(); ++i4) {
                        display.add((String)propDisplayNames.get(i4));
                    }
                }
                writer.flexColumn.put(propName, items);
                writer.flexColumnDisplay.put(propName, display);
                writer.flexColumnDesc.put(propName, desc);
                col += items.size();
            } else {
                ++col;
            }
            writer.fields.add(propName);
            writer.properties.put(propName, property);
        }
        return col;
    }

    private static void putDatePropRangeFieldName(EntityMetadata entityMetadata, IDataEntityProperty prop, Map<String, Object> property) {
        Optional<Entity> firstEntity;
        if (StringUtils.isNotEmpty((CharSequence)((DateTimeProp)prop).getRelateDateTimeRange()) && (firstEntity = entityMetadata.getEntitys().stream().filter(i -> StringUtils.equals((CharSequence)i.getKey(), (CharSequence)prop.getParent().getName())).findFirst()).isPresent()) {
            Entity entity = firstEntity.get();
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof DateRangeField)) continue;
                if (((DateRangeField)item).getStartDateFieldKey().equals(prop.getName())) {
                    property.put("PropType", ((DateRangeField)item).getKey());
                    property.put("isStart", "true");
                    continue;
                }
                if (!((DateRangeField)item).getEndDateFieldKey().equals(prop.getName())) continue;
                property.put("PropType", ((DateRangeField)item).getKey());
                property.put("isStart", "false");
            }
        }
    }

    private void setDefaultBasedataProps(String propName, IDataEntityProperty prop, List<String> items, List<String> display, List<String> desc) {
        boolean isMulBasedata = prop instanceof MulBasedataProp;
        String basedataColumnName = prop.getDisplayName().getLocaleValue();
        String bdNumProp = this.getBasedataNumberProp((IBasedataField)prop);
        String bdNameProp = this.getBasedataNameProp((IBasedataField)prop);
        String disPlayNumber = basedataColumnName + this.appendName((IBasedataField)prop, bdNumProp);
        String disPlayName = basedataColumnName + this.appendName((IBasedataField)prop, bdNameProp);
        items.add(propName + "." + bdNumProp);
        display.add(disPlayNumber);
        desc.add(String.format(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportWriterBuilder_23", (String)BOS_EXPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0])));
        items.add(propName + "." + bdNameProp);
        display.add(disPlayName);
        desc.add(String.format(ResManager.loadKDString((String)"%s\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0", (String)"ExportWriterBuilder_24", (String)BOS_EXPORT, (Object[])new Object[0]), isMulBasedata ? ResManager.loadKDString((String)"\u591a\u4e2a\u57fa\u7840\u8d44\u6599\u7528\u9017\u53f7\u5206\u9694", (String)"ExportWriterBuilder_21", (String)BOS_EXPORT, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ExportWriterBuilder_22", (String)BOS_EXPORT, (Object[])new Object[0])));
    }

    private void setItemClassProps(String propName, IDataEntityProperty prop, String basedataColumnName, List<String> items, List<String> display, List<String> desc) {
        String bdNumProp = this.getBasedataNumberProp((IBasedataField)prop);
        String bdNameProp = this.getBasedataNameProp((IBasedataField)prop);
        String disPlayNumber = ResManager.loadKDString((String)"%s\u3001\u7f16\u7801", (String)"ImportEntryWriterBuilder_0", (String)BOS_EXPORT, (Object[])new Object[0]);
        String disPlayName = ResManager.loadKDString((String)"%s\u3001\u540d\u79f0", (String)"ImportEntryWriterBuilder_1", (String)BOS_EXPORT, (Object[])new Object[0]);
        items.add(propName + "." + bdNumProp);
        display.add(disPlayNumber);
        desc.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u7f16\u7801", (String)"ExportWriterBuilder_26", (String)BOS_EXPORT, (Object[])new Object[0]));
        items.add(propName + "." + bdNameProp);
        display.add(disPlayName);
        desc.add(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165\u540d\u79f0", (String)"ExportWriterBuilder_27", (String)BOS_EXPORT, (Object[])new Object[0]));
    }

    private void prepareLargeTextProps(List<String> props, List<String> propDisplayNames, IDataEntityProperty prop, String propName) {
        props.add(propName);
        propDisplayNames.add(this.getDisplayName(prop));
        props.add(propName + "_tag");
        propDisplayNames.add(this.getDisplayName((IDataEntityProperty)prop.getParent().getProperties().get((Object)(propName + "_tag"))));
    }

    private void prepareBasedataProps(List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, DynamicObject templateRow, IDataEntityProperty prop, String currLang) {
        String imptPropName = templateRow.getString("importprop");
        if (prop instanceof ItemClassProp) {
            this.prepareItemClassProps(props, dataKeyProps, propDisplayNames, imptPropName, currLang);
            return;
        }
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
        switch (imptPropName) {
            case "number": {
                if (imptPropName.equals(refPropType.getNumberProperty())) break;
                imptPropName = refPropType.getNumberProperty();
                break;
            }
            case "name": {
                if (imptPropName.equals(refPropType.getNameProperty())) break;
                imptPropName = refPropType.getNameProperty();
                break;
            }
        }
        DataEntityPropertyCollection properties = refPropType.getProperties();
        IDataEntityProperty refprop = (IDataEntityProperty)properties.get((Object)imptPropName);
        if (StringUtils.isNotBlank((CharSequence)imptPropName)) {
            props.add(imptPropName);
            dataKeyProps.add(refprop instanceof MuliLangTextProp ? imptPropName + "." + currLang : imptPropName);
            propDisplayNames.add(refprop != null ? this.getDisplayName(refprop) : imptPropName);
        }
    }

    private void prepareItemClassProps(List<String> props, List<String> dataKeyProps, List<String> propDisplayNames, String imptPropName, String currLang) {
        if (StringUtils.isNotEmpty((CharSequence)imptPropName)) {
            props.add(imptPropName);
            dataKeyProps.add("name".equals(imptPropName) ? imptPropName + "." + currLang : imptPropName);
            propDisplayNames.add(this.kdCode);
        }
    }

    private String getBasedataNumberProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNumberProperty();
    }

    private String getBasedataNameProp(IBasedataField prop) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        return entityType.getNameProperty();
    }

    private boolean isFieldExportable(IDataEntityProperty prop) {
        return ((IFieldHandle)prop).isImportable();
    }

    private boolean isControlFieldExportable(IDataEntityType entityType, String propName) {
        if (StringUtils.isNotBlank((CharSequence)propName)) {
            if (entityType == null) {
                return false;
            }
            IFieldHandle prop = (IFieldHandle)entityType.getProperties().get((Object)propName);
            if (prop == null) {
                return this.isControlFieldExportable(entityType.getParent(), propName);
            }
            return prop.isImportable();
        }
        return true;
    }

    private String appendName(IBasedataField prop, String propName) {
        BasedataEntityType entityType = (BasedataEntityType)prop.getComplexType();
        DynamicProperty bdProp = entityType.getProperty(propName);
        if (entityType.getProperty(propName) != null) {
            return "." + bdProp.getDisplayName();
        }
        return "." + propName;
    }

    private String codeToName(String code) {
        String columnName = code;
        if (NUMBER.equals(code)) {
            columnName = this.kdCode;
        } else if ("name".equals(code)) {
            columnName = this.kdName;
        }
        return columnName;
    }

    private String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        LocaleString displayName = prop.getDisplayName();
        if (StringUtils.isBlank((Object)displayName)) {
            return prop.getName();
        }
        return displayName.toString();
    }

    private void setBaseDataImportType(ExportWriterFormat format, Map<String, String> baseDataImportType) {
        if (format == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> property : format.properties.entrySet()) {
            Object importProp;
            Object inputType = property.getValue().get(INPUT_TYPE_KEY);
            if (inputType == null || !inputType.toString().equals("basedata") || !((importProp = property.getValue().get(INPUT_PROPKEY)) instanceof List) || ((List)importProp).isEmpty()) continue;
            baseDataImportType.put(property.getKey(), ((List)importProp).get(0).toString());
        }
        for (ExportWriterFormat exportWriterFormat : format.next) {
            this.setBaseDataImportType(exportWriterFormat, baseDataImportType);
        }
    }

    private void setBaseDataImportValues(ExportWriterFormat format, Map<String, List<String>> baseDataDropDownValues) {
        if (format == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> property : format.properties.entrySet()) {
            Object importProp;
            Object inputType = property.getValue().get(INPUT_TYPE_KEY);
            if (inputType == null || !inputType.toString().equals("basedata") || !((importProp = property.getValue().get(INPUT_PROPKEY)) instanceof List) || ((List)importProp).isEmpty()) continue;
            property.getValue().put(INPUT_VALUES, baseDataDropDownValues.getOrDefault(property.getKey(), new ArrayList()));
        }
        for (ExportWriterFormat exportWriterFormat : format.next) {
            this.setBaseDataImportValues(exportWriterFormat, baseDataDropDownValues);
        }
    }
}

