/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mservice;

import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;

public class ImportPermissionService {
    private static final Log log = LogFactory.getLog(ImportPermissionService.class);
    private final String NO_OPERATE_PERMISSION_MSG_TYPE = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1\u201d\u7684\u201c%2\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ImportStartPlugin_1", (String)"bos-import", (Object[])new Object[0]);

    public boolean validatePermission(ImportPermissionParam permissionParam) {
        if (StringUtils.isBlank((CharSequence)permissionParam.getPermissionItemId())) {
            return true;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)permissionParam.getRealEntityId());
        if (!mainEntityType.getPermissionControlType().isControlFunction()) {
            return true;
        }
        if (mainEntityType.getPermissionControlType().isAnonymousUserControl() && RequestContext.get().getUserId().equalsIgnoreCase("-1")) {
            return true;
        }
        this.checkRightInListForm(mainEntityType, permissionParam.getResult(), permissionParam.getPermissionItemId(), permissionParam.getRealEntityId(), permissionParam.getCurrentEntityId(), permissionParam.getOperateName(), permissionParam.getMainOrgIds(), permissionParam.getBizAppId());
        return permissionParam.getResult().isSuccess();
    }

    private int checkRightInListForm(MainEntityType mainEntityType, OperationResult result, String permissionItemId, String realPermissionEntityId, String entityId, String operateName, List<Long> mainOrgIds, String bizAppId) {
        mainOrgIds.removeIf(Objects::isNull);
        if (mainOrgIds.isEmpty()) {
            mainOrgIds.add(0L);
        }
        this.doPermission(result, permissionItemId, mainOrgIds, realPermissionEntityId, entityId, operateName, bizAppId);
        return 1;
    }

    private void doPermission(OperationResult result, String permissionItemId, List<Long> orgIds, String realPermissionEntityId, String entityId, String operateName, String bizAppId) {
        if (this.checkFunctionPermission(orgIds, permissionItemId, realPermissionEntityId, bizAppId) != 1) {
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", ResManager.loadResFormat((String)this.NO_OPERATE_PERMISSION_MSG_TYPE, (String)"FormOperate_5", (String)"bos-form-core", (Object[])new Object[]{FormMetadataCache.getFormConfig((String)entityId).getCaption().toString(), operateName}), ErrorLevel.Error);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError("permission", validateResult);
        }
    }

    private int checkFunctionPermission(List<Long> orgIds, String permissionItemId, String realPermissionEntityId, String bizAppId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.checkPermission(Long.valueOf(userId), ImportPermissionService.getPermType(realPermissionEntityId), orgIds, bizAppId, realPermissionEntityId, permissionItemId);
    }

    public static String getPermType(String realPermissionEntityId) {
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)realPermissionEntityId);
            PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
            String dimType = permissionControlType.getDimension();
            if (StringUtils.isBlank((CharSequence)dimType)) {
                log.info("get dimType is empty");
                return "DIM_ORG";
            }
            return dimType;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "DIM_ORG";
        }
    }

    public void doFailCheckRight(IFormView view, OperationResult result) {
        List errList = result.getValidateResult().getValidateErrors();
        StringBuilder sb = new StringBuilder();
        for (ValidateResult errResult : errList) {
            for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                sb.append(errInfo.getMessage());
            }
        }
        view.showErrorNotification(sb.toString());
    }
}

