/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.AttachmentManageUtil;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.list.IListView;

public class ExportEntry
extends EntryGridOperate
implements IConfirmCallBack,
ICloseCallBack {
    private static final String CONFIRM_EXPORT = "confirm_exprot";
    private static final String EXPORT_ENTRYKEY = "EXPORT_ENTRYKEY";
    private static final String EXPORT_PAGEID = "EXPORT_PAGEID";
    public static final String BOS_EXPORT = "bos-export";
    public static final String PLUGINS = "plugins";

    public boolean needSelectData() {
        return false;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (this.getView() instanceof IListView) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u8868\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"ExportEntry_6", (String)BOS_EXPORT, (Object[])new Object[0]));
            return false;
        }
        return super.beforeInvokeOperation(result);
    }

    public OperationResult invokeOperation() {
        int row;
        IFormView view = this.getView();
        String entryKey = this.getEntryKey();
        Object pluginsObj = this.getParameter().get(PLUGINS);
        String pluginsStr = pluginsObj == null ? "" : JSONObject.toJSONString(pluginsObj);
        view.getPageCache().put(PLUGINS, pluginsStr);
        view.getPageCache().put(EXPORT_ENTRYKEY, entryKey);
        view.getPageCache().put(EXPORT_PAGEID, this.getPageId());
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid instanceof CardEntry) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5361\u7247\u5355\u636e\u4f53\u4e0d\u652f\u6301\u5bfc\u51fa\u64cd\u4f5c\u3002", (String)"ExportEntry_0", (String)BOS_EXPORT, (Object[])new Object[0]), Integer.valueOf(3000));
            return null;
        }
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("types", new String[]{"cw", "cv", "cs", "cwg"});
        proxy.invokeControlMethod(this.getEntryKey(), "getGridInfo", new Object[]{map});
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_EXPORT, (AbstractOperate)this);
        int rowCount = view.getModel().getEntryRowCount(entryKey);
        int n = row = rowCount == 0 ? view.getModel().getEntryRowCount(entryKey) : rowCount;
        if (grid.getEntryState().getSelectedRows().length > 0) {
            row = grid.getEntryState().getSelectedRows().length;
        }
        if (row == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ExportEntry_1", (String)BOS_EXPORT, (Object[])new Object[0]));
            return null;
        }
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5c06\u5bfc\u51fa{0}\u884c\u6570\u636e\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5f00\u59cb\u6267\u884c\u3002", (String)"ExportEntry_3", (String)BOS_EXPORT, (Object[])new Object[0]), row);
        this.saveCacheForPermission();
        view.showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
        return null;
    }

    private void saveCacheForPermission() {
        if (this.getView() instanceof IBillView) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            this.getView().getPageCache().put("MainOrgIds_entry", this.mainOrgId == null ? "" : String.valueOf(this.mainOrgId));
            this.getView().getPageCache().put("CheckRightAppId_entry", formShowParameter.getCheckRightAppId());
            this.getView().getPageCache().put("RealPermissionEntityId_entry", this.getRealPermissionEntityId());
            this.getView().getPageCache().put("BillFormId_entry", this.getView().getEntityId());
            FormConfig formConfig = formShowParameter.getFormConfig();
            this.getView().getPageCache().put("OperateName_entry", formConfig == null ? "" : formConfig.getCaption().getLocaleValue());
            this.getView().getPageCache().put("PermissionItemId_entry", this.getPermissionItemId());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (CONFIRM_EXPORT.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            if (!this.checkPermission()) {
                return;
            }
            if (AttachmentManageUtil.needEncrypt((IFormView)this.getView(), (boolean)true)) {
                this.showEncryptForm();
                return;
            }
            this.showExportEntry(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getView() == null) {
            return;
        }
        this.setView(event.getView());
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("encryptExportEntry".equals(event.getActionId())) {
            Map params = (Map)returnData;
            Object password = params.get("password");
            this.showExportEntry(password);
        }
    }

    private void showExportEntry(Object password) {
        String entryKey = this.getView().getPageCache().get(EXPORT_ENTRYKEY);
        String pageId = this.getView().getPageCache().get(EXPORT_PAGEID);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_exportentryconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("entrykey", (Object)entryKey);
        showParameter.setCustomParam("pageid", (Object)pageId);
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("settingkey", (Object)this.getView().getFormShowParameter().getSettingKey());
        showParameter.setCustomParam("password", password);
        showParameter.setCustomParam("PermissionItemId_entry", (Object)this.getView().getPageCache().get("PermissionItemId_entry"));
        this.getView().showForm(showParameter);
    }

    private void showEncryptForm() {
        FormShowParameter showParameterEncrypt = new FormShowParameter();
        showParameterEncrypt.getOpenStyle().setShowType(ShowType.Modal);
        showParameterEncrypt.setFormId("bos_file_encrypt_confirm");
        showParameterEncrypt.setCustomParam("encryptType", (Object)"1");
        showParameterEncrypt.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "encryptExportEntry"));
        this.getView().showForm(showParameterEncrypt);
    }

    private boolean checkPermission() {
        if (this.getView().getFormShowParameter().isCancelDataRight()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportEntry_4", (String)BOS_EXPORT, (Object[])new Object[0]));
            return false;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() != 0) {
            FormConfig config = formShowParameter.getFormConfig();
            String formName = config.getCaption().toString();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExportEntry_5", (String)BOS_EXPORT, (Object[])new Object[0]), formName));
            return false;
        }
        return this.hasPermission();
    }

    private boolean hasPermission() {
        ImportPermissionParam.Buidler importPermissionParamBuidler;
        ImportPermissionService importPermissionService;
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        String orgIdsStr = view.getPageCache().get("MainOrgIds_entry");
        ArrayList<Long> mainOrgList = new ArrayList<Long>(0);
        if (StringUtils.isNotBlank((CharSequence)orgIdsStr)) {
            mainOrgList.add(Long.parseLong(orgIdsStr.trim()));
        }
        if (!(importPermissionService = new ImportPermissionService()).validatePermission((importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId(view.getPageCache().get("CheckRightAppId_entry")).setMainOrgIds(mainOrgList).setRealEntityId(view.getPageCache().get("RealPermissionEntityId_entry")).setCurrentEntityId(view.getPageCache().get("BillFormId_entry")).setOperateName(view.getPageCache().get("OperateName_entry")).setPermissionItemId(view.getPageCache().get("PermissionItemId_entry")).setResult(result)).build())) {
            importPermissionService.doFailCheckRight(this.getView(), result);
            return false;
        }
        return true;
    }
}

