/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.expt;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.lang.Lang;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class ExportDataProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String EXPORTAPP = "imp-exp";
    private static Log log = LogFactory.getLog(ExportDataProgressFormPlugin.class);
    private static final String BOS_EXPORT = "bos-export";
    public static final String FORMID_EXPORTDATAPROGRESS = "bos_exportdataprogress";
    public static final String CUSTPARAM_CONTEXT = "requestcontext";
    public static final String CUSTPARAM_BYLIST = "byList";
    public static final String CUSTPARAM_ENTITYNAME = "entityname";
    public static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";
    public static final String CUSTPARAM_TEMPLATEID = "templateId";
    public static final String CUSTPARAM_FILLPARENT = "fillparent";
    public static final String CACHEKEY_JOBFORMINFO = "export_jobforminfo";
    public static final String CACHEKEY_TASKID = "export_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String BACKGROUND_ACTIONID = "background_actionid";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_BILLNAME = "listname";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String KEY_INITTIPS = "inittips";
    private static final String KEY_PROGRESSDATAS = "progressdatas";
    private static final String KEY_LOGID = "logid";
    private static final String CONFIRMED_TOBACKGROUND_OR_SUSPEND = "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND";
    private static final String CONFIRMED_SUSPEND = "CLOSE_CONFIRMED_SUSPEND";
    private static final String CONFIRMED_TOBACKGROUND = "CLOSE_CONFIRMED_TOBACKGROUND";
    private boolean canClose = false;

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        if (StringUtils.isBlank((CharSequence)suspending)) {
            return false;
        }
        return Boolean.parseBoolean(suspending);
    }

    private void setSuspending(boolean suspending) {
        this.getPageCache().put(this.getCurrentAppCacheKey(), String.valueOf(suspending));
    }

    private boolean checkCustParams() {
        if (StringUtils.isBlank((CharSequence)this.getEntityNumber())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"ExportDataProgressFormPlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]), CUSTPARAM_ENTITYNUMBER));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s\u3002", (String)"ExportDataProgressFormPlugin_0", (String)BOS_EXPORT, (Object[])new Object[0]), CUSTPARAM_ENTITYNAME));
            return false;
        }
        return true;
    }

    private String getEntityNumber() {
        return (String)this.getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNUMBER);
    }

    private String getEntityName() {
        return (String)this.getFormShowParameter().getCustomParam(CUSTPARAM_ENTITYNAME);
    }

    private boolean getByList() {
        String byList = (String)this.getFormShowParameter().getCustomParam(CUSTPARAM_BYLIST);
        if (StringUtils.isBlank((CharSequence)byList)) {
            return false;
        }
        return Boolean.parseBoolean(byList);
    }

    private Long getTemplateId() {
        String templateId = (String)this.getFormShowParameter().getCustomParam(CUSTPARAM_TEMPLATEID);
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return 0L;
        }
        return Long.valueOf(templateId);
    }

    private boolean getFillParent() {
        String fillparent = (String)this.getFormShowParameter().getCustomParam(CUSTPARAM_FILLPARENT);
        if (StringUtils.isBlank((CharSequence)fillparent)) {
            return false;
        }
        return Boolean.parseBoolean(fillparent);
    }

    private String getTaskId() {
        if (this.getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    private JobFormInfo buildJobFormInfo() {
        if (!this.checkCustParams()) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa - %s", (String)"ExportDataProgressFormPlugin_1", (String)BOS_EXPORT, (Object[])new Object[0]), this.getEntityName()));
        LocaleString tmpLocalString = ResManager.getLocaleString((String)"\u5bfc\u51fa - %s", (String)"ExportDataProgressFormPlugin_1", (String)BOS_EXPORT);
        for (Map.Entry entry : tmpLocalString.entrySet()) {
            tmpLocalString.setItem((String)entry.getKey(), (Object)String.format((String)entry.getValue(), this.getEntityName()));
        }
        jobInfo.setlName(tmpLocalString);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)routeAppId)) {
            String subRouteAppId = routeAppId + ".export";
            if (subRouteAppId.equals(ServiceLookup.getServiceAppId((String)subRouteAppId))) {
                routeAppId = subRouteAppId;
            } else if (ServiceLookup.hasDeployedAppId((String)EXPORTAPP)) {
                routeAppId = EXPORTAPP;
            }
        }
        log.info("buildJobFormInfo ---- routeAppId : " + routeAppId);
        jobInfo.setAppId(routeAppId);
        if (this.getByList()) {
            jobInfo.setTaskClassname("kd.bos.mvc.export.ExportListTask");
        } else {
            jobInfo.setTaskClassname("kd.bos.mvc.export.ExportDataTask");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CUSTPARAM_CONTEXT, RequestContext.get());
        params.put(CUSTPARAM_BYLIST, this.getByList());
        params.put(CUSTPARAM_TEMPLATEID, this.getTemplateId());
        params.put(CUSTPARAM_FILLPARENT, this.getFillParent());
        params.put(CUSTPARAM_ENTITYNUMBER, this.getEntityNumber());
        params.put(CUSTPARAM_ENTITYNAME, this.getEntityName());
        params.put("parentpageid", this.getFormShowParameter().getParentPageId());
        params.put("EXPORT_LIST_TYPE", this.getFormShowParameter().getCustomParam("EXPORT_LIST_TYPE"));
        params.put("achieveKey", this.getFormShowParameter().getCustomParam("achieveKey"));
        params.put("routeKey", this.getFormShowParameter().getCustomParam("routeKey"));
        params.put("billViewExport", this.getFormShowParameter().getCustomParam("billViewExport"));
        params.put("hasDownloadAttachmentPerm", this.getFormShowParameter().getCustomParam("hasDownloadAttachmentPerm"));
        params.put("password", this.getFormShowParameter().getCustomParam("password"));
        params.put("PermissionItemId", this.getFormShowParameter().getCustomParam("PermissionItemId"));
        params.put("concurrentID", this.getFormShowParameter().getCustomParam("concurrentID"));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getFormShowParameter().getCustomParams());
        if (this.getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", BACKGROUND_ACTIONID);
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.expt.ExportTaskClick");
        jobFormInfo.setTimeout(600);
        return jobFormInfo;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getFormShowParameter().getCustomParams().containsKey(CACHEKEY_JOBFORMINFO) ? (String)this.getFormShowParameter().getCustomParam(CACHEKEY_JOBFORMINFO) : this.getPageCache().get(CACHEKEY_JOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "tobackgroud"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initLabelText();
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    private void initLabelText() {
        Label title = (Label)this.getControl(KEY_BILLNAME);
        String text = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa%s\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"ExportDataProgressFormPlugin_5", (String)BOS_EXPORT, (Object[])new Object[0]), this.getEntityName());
        title.setText(text);
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        log.info("kd.bos.form.plugin.expt.ExportDataProgressFormPlugin.onProgress taskId : " + taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, e);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            e.setProgress(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isStart() || this.isSuspending()) {
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            HashMap<Integer, String> btNameMap = new HashMap<Integer, String>(16);
            btNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8f6c\u5165\u540e\u53f0", (String)"ExportDataProgressFormPlugin_10", (String)BOS_EXPORT, (Object[])new Object[0]));
            btNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"ExportDataProgressFormPlugin_11", (String)BOS_EXPORT, (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b63\u5728\u51c6\u5907\u5bfc\u51fa\u6570\u636e\uff0c\u60a8\u70b9\u51fb\u4e86\u5173\u95ed\uff0c\u8bf7\u786e\u8ba4\u662f\u7ec8\u6b62\u8fd8\u662f\u8f6c\u5165\u540e\u53f0?", (String)"ExportDataProgressFormPlugin_2", (String)BOS_EXPORT, (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND_OR_SUSPEND, (IFormPlugin)this), btNameMap);
            this.stopBar();
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        String callBackId;
        super.confirmCallBack(messageboxclosedevent);
        switch (callBackId = messageboxclosedevent.getCallBackId()) {
            case "CLOSE_CONFIRMED_TOBACKGROUND_OR_SUSPEND": {
                this.confirmToBackGroundOrSuspend(messageboxclosedevent);
                break;
            }
            case "CLOSE_CONFIRMED_TOBACKGROUND": {
                this.confirmToBackGround(messageboxclosedevent);
                break;
            }
            case "CLOSE_CONFIRMED_SUSPEND": {
                this.confirmSuspend(messageboxclosedevent);
                break;
            }
        }
    }

    private void confirmSuspend(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.suspendExport();
        }
    }

    private void confirmToBackGround(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        }
    }

    private void confirmToBackGroundOrSuspend(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            this.suspendExport();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        String totalCount = data.containsKey(KEY_TOTAL) ? String.valueOf(data.get(KEY_TOTAL)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"ExportDataProgressFormPlugin_3", (String)BOS_EXPORT, (Object[])new Object[0]);
        String completeCount = data.containsKey(KEY_COMPLETE) ? String.valueOf(data.get(KEY_COMPLETE)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"ExportDataProgressFormPlugin_3", (String)BOS_EXPORT, (Object[])new Object[0]);
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(totalCount);
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(completeCount);
        if (data.containsKey(KEY_TOTAL)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INITTIPS});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESSDATAS, notHidden);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        Object logId = taskData.get(KEY_LOGID);
        DynamicObject exportLog = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_exportlog", (QFilter[])new QFilter[]{new QFilter("id", "=", logId)});
        String logs = exportLog != null ? exportLog.getString("logs") : "";
        this.releaseLimitLock();
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (StringUtils.isNotBlank((CharSequence)logs)) {
                log.error(taskInfo.getFailureReason());
                this.getView().showMessage(logs);
            } else if (StringUtils.isNotBlank((CharSequence)taskInfo.getFailureReason())) {
                this.getView().showMessage(taskInfo.getFailureReason());
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataProgressFormPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
            this.getView().close();
            this.stopBar();
            this.createOperationLogByExportDetail(Boolean.FALSE, taskInfo);
            return;
        }
        if (taskData.containsKey("fail")) {
            boolean fail = (Boolean)taskData.get("fail");
            String failmessage = (String)taskData.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.getView().showErrorNotification(failmessage);
                this.stopBar();
                this.createOperationLogByExportDetail(Boolean.FALSE, taskInfo);
                return;
            }
        }
        if (!isFinished) {
            e.setProgress(99);
            this.showExportDetails(taskInfo);
            return;
        }
        IFormView view = this.getView();
        this.downloadFile(view, taskData);
        this.getView().sendFormAction(view);
        e.setProgress(100);
        this.stopBar();
        this.closeForm();
        this.createOperationLogByExportDetail(Boolean.TRUE, taskInfo);
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
    }

    private void releaseLimitLock() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getFormShowParameter().getCustomParam("concurrentID")))) {
            ConcurrencyLimiter.release((String)((String)this.getFormShowParameter().getCustomParam("concurrentID")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(IFormView view, Map<String, Object> taskData) {
        try {
            String url;
            if (this.getCurrentAppCache().get(this.getCurrentAppCacheKey(), String.class) != null || this.isSuspending()) {
                this.deleteExportLogAndShowTipNotification(taskData.get(KEY_LOGID), view);
            } else if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
                view.download(url);
            }
        }
        finally {
            this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
            this.getPageCache().remove(this.getCurrentAppCacheKey());
        }
    }

    private void deleteExportLogAndShowTipNotification(Object logId, IFormView view) {
        view.hideLoading();
        this.setSuspending(false);
        String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ExportDataProgressFormPlugin_6", (String)BOS_EXPORT, (Object[])new Object[0]);
        view.showTipNotification(msg);
        this.suspendLog();
        BusinessDataServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bos_exportlog").getDataEntityType(), (Object[])new Object[]{logId});
    }

    private void createOperationLogByExportDetail(Boolean success, TaskInfo taskInfo) {
        MultiLangEnumBridge opDesc;
        MultiLangEnumBridge opName;
        Map<String, Object> data = this.getTaskCustData(taskInfo);
        String completeCount = data.containsKey(KEY_COMPLETE) ? String.valueOf(data.get(KEY_COMPLETE)) : ResManager.loadKDString((String)"\u672a\u77e5", (String)"ExportDataProgressFormPlugin_3", (String)BOS_EXPORT, (Object[])new Object[0]);
        String exportType = (String)this.getFormShowParameter().getCustomParam("EXPORT_LIST_TYPE");
        String opDescArg = "";
        if (this.getByList()) {
            opName = ImportOperationLog.OperationEnum.EXPORT_LIST_RESULT.getOpNameBridge();
            if (success.booleanValue()) {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_LIST_RESULT.getOpDescFormatBridge();
                opDescArg = completeCount;
            } else {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_LIST_FAIL.getOpDescFormatBridge();
            }
        } else if ("IMPT".equals(exportType)) {
            opName = ImportOperationLog.OperationEnum.EXPORT_BY_IMPORT_TEMPLATE_RESULT.getOpNameBridge();
            if (success.booleanValue()) {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_BY_IMPORT_TEMPLATE_RESULT.getOpDescFormatBridge();
                opDescArg = completeCount;
            } else {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_BY_IMPORT_TEMPLATE_FAIL.getOpDescFormatBridge();
            }
        } else if ("EXPT".equals(exportType)) {
            opName = ImportOperationLog.OperationEnum.EXPORT_BY_EXPORT_TEMPLATE_RESULT.getOpNameBridge();
            if (success.booleanValue()) {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_BY_EXPORT_TEMPLATE_RESULT.getOpDescFormatBridge();
                opDescArg = completeCount;
            } else {
                opDesc = ImportOperationLog.OperationEnum.EXPORT_BY_EXPORT_TEMPLATE_FAIL.getOpDescFormatBridge();
            }
        } else {
            log.warn(" createOperationLogByExportDetail type is not support ");
            return;
        }
        ImportOperationLog.getInstance().createAppLog(this.getView().getFormShowParameter().getAppId(), this.getEntityNumber(), opName, opDesc, opDescArg);
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    private String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskId()) ? "_" + this.getTaskId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        return data;
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (TaskClientProxy.isExistTask((String)taskId)) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u7ec8\u6b62\u5bfc\u51fa\u4efb\u52a1\u5417\uff1f", (String)"ExportDataProgressFormPlugin_12", (String)BOS_EXPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_SUSPEND, (IFormPlugin)this));
            return;
        }
        if ("tobackgroud".equals(controlKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5c06\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u5417\uff1f", (String)"ExportDataProgressFormPlugin_13", (String)BOS_EXPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND, (IFormPlugin)this));
        }
    }

    private void suspendExport() {
        this.getCurrentAppCache().put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ExportDataProgressFormPlugin_9", (String)BOS_EXPORT, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            this.suspendLog();
        }
        this.setStart(true);
        this.releaseLimitLock();
        TaskClientProxy.delTask((JobFormInfo)this.getJobFormInfo(), (String)this.getTaskId(), null);
        this.closeForm();
    }

    private void suspendLog() {
        ImportOperationLog.getInstance().createAppLog(this.getEntityNumber(), ImportOperationLog.OperationEnum.EXPORT_SUSPEND.getOpNameBridge(), ImportOperationLog.OperationEnum.EXPORT_SUSPEND.getOpDescFormatBridge(), new String[0]);
    }
}

