/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.parameter;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.plugin.parameter.IExportConfigKeyEnum;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ImportAndExportConfigCache {
    private static final String PREFIX_REDIS = "IMPORT_AND_EXPORT_CONFIG_";
    private static final String PREFIX_MULTILANG = "IMPORT_AND_EXPORT_CONFIG_MULTILANG_";
    private static final String PREFIX_AUTOLINE = "IMPORT_AND_EXPORT_CONFIG_AUTOLINE_";
    private static final String PREFIX_AUTO_FILL_SUPER_INFO = "IMPORT_AND_EXPORT_CONFIG_AUTO_FILL_SUPER_INFO_";
    private static final String PREFIX_EXPORT_CSV = "IMPORT_AND_EXPORT_CONFIG_EXPORT_CSV_";
    private static final String PREFIX_EXPORT_IMG = "IMPORT_AND_EXPORT_CONFIG_EXPORT_IMG_";
    private static final String PREFIX_EXPORT_ATT = "IMPORT_AND_EXPORT_CONFIG_EXPORT_ATT_";
    private static final String PREFIX_MONITOR_ENABLE_ = "IMPORT_AND_EXPORT_CONFIG_MONITOR_ENABLE_";
    public static final String MULTILANG_CONTROL_PREFIX_KEY = "lang_";
    public static final String CHECKBOX_KEY_IMPORT_TEMPLATE = "forimporttemplate";
    public static final String CHECKBOX_KEY_EXPORT_TEMPLATE = "forexporttemplate";
    public static final String CHECKBOX_KEY_LIST_TEMPLATE = "forlisttemplate";
    public static final String CHECKBOX_KEY_CSV_EXPORT_TEMPLATE = "forcsvexporttemplate";
    public static final String CHECKBOX_KEY_CSV_LIST = "forcsvlist";
    public static final String CHECKBOX_KEY_IMG = "forimgexport";
    public static final String CHECKBOX_KEY_ATT = "forattexport";
    public static final String CHECKBOX_KEY_IMG_NAME_TYPE = "combofieldpicname";
    public static final String CHECKBOX_KEY_ATT_NAME_TYPE = "combofieldattname";
    public static final String CHECKBOX_KEY_MONITOR_ENABLE = "monitorenable";
    public static final String MULTI_CONTROL_SPLIT_KEY = ",";
    public static final String CHECKBOX_SELECT_SPLIT_KEY = ":";
    public static final String DEFAULT_COMBO_FIELD_PIC_NAME = "0";
    public static final String DEFAULT_COMBO_FIELD_ATT_NAME = "0";
    public static final String DB_FIELD_OF_EXPORT_MULTILANG = "export_multilang";
    public static final String DB_FIELD_OF_AUTOLINE = "export_autoline";
    public static final String DB_FIELD_OF_AUTO_FILL_SUPER_INFO = "export_autofillsuperinfo";
    public static final String DB_FIELD_OF_EXPORT_CSV = "export_csv";
    public static final String DB_FIELD_OF_EXPORT_IMG = "export_img";
    public static final String DB_FIELD_OF_EXPORT_ATT = "export_att";
    public static final String DB_FIELD_OF_MONITOR_ENABLE = "monitorenable";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("IMPORT_AND_EXPORT_CONFIG", new DistributeCacheHAPolicy(true, true));
    private static final String LOAD_CACHE_TAG = "DISTRIBUTE_CACHE_IS_LOAD";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportAndExportConfigCache_0", (String)"bos-export", (Object[])new Object[0]));
        }
        return acctId;
    }

    private List<String> getCacheKeyList(String entityId) {
        IExportConfigKeyEnum[] enums = IExportConfigKeyEnum.values();
        String nextKey = ImportAndExportConfigCache.getAcctId() + entityId + RequestContext.get().getCurrUserId();
        List<String> res = Arrays.stream(enums).map(e -> e.getCACHE_KEY() + nextKey).collect(Collectors.toList());
        return res;
    }

    @Deprecated
    public void save(String entityId, Map<String, String> params) {
        this.saveToDB(entityId, params);
        List<String> cacheKeyList = this.getCacheKeyList(entityId);
        cache.remove(cacheKeyList.toArray(new String[cacheKeyList.size()]));
    }

    public void save(String cachePreFix, String entityId, Map<String, String> params) {
        this.saveToDB(entityId, params);
        cache.remove(cachePreFix + ImportAndExportConfigCache.getAcctId() + entityId + RequestContext.get().getCurrUserId());
    }

    private void saveToDB(String entityId, Map<String, String> params) {
        String paramStr = String.join((CharSequence)MULTI_CONTROL_SPLIT_KEY, params.keySet());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_impt_user_config_data", (String)("id, " + paramStr), (QFilter[])new QFilter("bizobject", "=", (Object)entityId).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())).toArray());
        if (dynamicObject == null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_impt_user_config_data");
            dynamicObject = new DynamicObject((DynamicObjectType)entityType);
            dynamicObject.set("bizobject", (Object)entityId);
            dynamicObject.set("enable", (Object)Character.valueOf('1'));
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("name", (Object)entityType.getDisplayName());
            dynamicObject.set("number", (Object)ID.genStringId());
            dynamicObject.set("user", (Object)RequestContext.get().getCurrUserId());
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            dynamicObject.set(entry.getKey(), (Object)entry.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public Map<String, Boolean> getMultilangConfig(String entityId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        Optional<String> multilangCache = this.getConfigCache(entityId, PREFIX_MULTILANG, DB_FIELD_OF_EXPORT_MULTILANG);
        multilangCache.ifPresent(s -> {
            String[] multiControls;
            for (String multiControl : multiControls = s.split(MULTI_CONTROL_SPLIT_KEY)) {
                String[] checkBoxMap = multiControl.split(CHECKBOX_SELECT_SPLIT_KEY);
                result.put(checkBoxMap[0], Boolean.valueOf(checkBoxMap[1]));
            }
        });
        return result;
    }

    public Optional<Boolean> getAutoLineConfig(String entityId) {
        Optional<String> autoLineCache = this.getConfigCache(entityId, PREFIX_AUTOLINE, DB_FIELD_OF_AUTOLINE);
        return autoLineCache.map(Boolean::valueOf);
    }

    public Map<String, Boolean> getAutoFillSuperInfoConfig(String entityId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        Optional<String> autoFillSuperInfoCache = this.getConfigCache(entityId, PREFIX_AUTO_FILL_SUPER_INFO, DB_FIELD_OF_AUTO_FILL_SUPER_INFO);
        autoFillSuperInfoCache.ifPresent(s -> {
            String[] multiControls;
            for (String multiControl : multiControls = s.split(MULTI_CONTROL_SPLIT_KEY)) {
                String[] checkBoxMap = multiControl.split(CHECKBOX_SELECT_SPLIT_KEY);
                result.put(checkBoxMap[0], Boolean.valueOf(checkBoxMap[1]));
            }
        });
        return result;
    }

    public Map<String, Boolean> getExportCsv(String entityId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        Optional<String> exportCsvCache = this.getConfigCache(entityId, PREFIX_EXPORT_CSV, DB_FIELD_OF_EXPORT_CSV);
        exportCsvCache.ifPresent(s -> {
            String[] multiControls;
            for (String multiControl : multiControls = s.split(MULTI_CONTROL_SPLIT_KEY)) {
                String[] checkBoxMap = multiControl.split(CHECKBOX_SELECT_SPLIT_KEY);
                result.put(checkBoxMap[0], Boolean.valueOf(checkBoxMap[1]));
            }
        });
        return result;
    }

    public Map<String, String> getExportImg(String entityId) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        Optional<String> exportImgCache = this.getConfigCache(entityId, PREFIX_EXPORT_IMG, DB_FIELD_OF_EXPORT_IMG);
        exportImgCache.ifPresent(s -> {
            String[] multiControls;
            for (String multiControl : multiControls = s.split(MULTI_CONTROL_SPLIT_KEY)) {
                String[] checkBoxMap = multiControl.split(CHECKBOX_SELECT_SPLIT_KEY);
                if (checkBoxMap.length > 1) {
                    result.put(checkBoxMap[0], checkBoxMap[1]);
                    continue;
                }
                result.put(checkBoxMap[0], "0");
            }
        });
        return result;
    }

    public Map<String, String> getExportAtt(String entityId) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        Optional<String> exportImgCache = this.getConfigCache(entityId, PREFIX_EXPORT_ATT, DB_FIELD_OF_EXPORT_ATT);
        exportImgCache.ifPresent(s -> {
            String[] multiControls;
            for (String multiControl : multiControls = s.split(MULTI_CONTROL_SPLIT_KEY)) {
                String[] checkBoxMap = multiControl.split(CHECKBOX_SELECT_SPLIT_KEY);
                if (checkBoxMap.length > 1) {
                    result.put(checkBoxMap[0], checkBoxMap[1]);
                    continue;
                }
                result.put(checkBoxMap[0], "0");
            }
        });
        return result;
    }

    public Optional<Boolean> getMonitorEnable(String entityId) {
        Optional<String> monitorEnableCache = this.getConfigCache(entityId, PREFIX_MONITOR_ENABLE_, "monitorenable");
        return monitorEnableCache.map(Boolean::valueOf);
    }

    public Optional<String> getConfigCache(String entityId, IExportConfigKeyEnum iExportConfigKeyEnum) {
        return this.getConfigCache(entityId, iExportConfigKeyEnum.getCACHE_KEY(), iExportConfigKeyEnum.getFIELD_KEY());
    }

    private Optional<String> getConfigCache(String entityId, String prefixKey, String selectKey) {
        String completeKey = prefixKey + ImportAndExportConfigCache.getAcctId() + entityId + RequestContext.get().getCurrUserId();
        String searchFromDistribute = (String)cache.get(completeKey);
        if (LOAD_CACHE_TAG.equals(searchFromDistribute)) {
            return Optional.empty();
        }
        if (StringUtils.isNotBlank((CharSequence)searchFromDistribute)) {
            return Optional.of(searchFromDistribute);
        }
        DynamicObject dataInfo = BusinessDataServiceHelper.loadSingle((String)"bos_impt_user_config_data", (String)selectKey, (QFilter[])new QFilter("bizobject", "=", (Object)entityId).and(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())).toArray());
        if (dataInfo != null && StringUtils.isNotBlank((CharSequence)(searchFromDistribute = dataInfo.getString(selectKey)))) {
            cache.put(completeKey, (Object)searchFromDistribute);
            return Optional.of(searchFromDistribute);
        }
        cache.put(completeKey, (Object)LOAD_CACHE_TAG);
        return Optional.empty();
    }

    public void resetMonitorEnable(String entityId) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("monitorenable", "false");
        this.saveToDB(entityId, params);
        cache.remove(PREFIX_MONITOR_ENABLE_ + ImportAndExportConfigCache.getAcctId() + entityId + RequestContext.get().getCurrUserId());
    }
}

