/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.util;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ImportOperationLog {
    private static ImportOperationLog importOperationLog = new ImportOperationLog();
    private ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
    public static final String BOS_EXPORT = "bos-export";

    private ImportOperationLog() {
    }

    public static ImportOperationLog getInstance() {
        return importOperationLog;
    }

    @Deprecated
    public void createAppLog(String bizObjID, String opName, String opDesc) {
        this.createAppLog(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID), bizObjID, opName, opDesc);
    }

    @Deprecated
    public void createAppLog(IFormView view, String bizObjID, String opName, String opDesc) {
        this.createAppLog(ImportOperationLog.getBizAppId(view, bizObjID), bizObjID, opName, opDesc);
    }

    @Deprecated
    public void createAppLog(String bizAppId, String bizObjID, String opName, String opDesc) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(ImportOperationLog.limitLength(opDesc));
        this.service.addLog(appLogInfo);
    }

    public void createAppLog(String bizObjID, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        this.createAppLog(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID), bizObjID, opNameBridge, opDescBridge, opDescArgs);
    }

    public void createAppLog(IFormView view, String bizObjID, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        this.createAppLog(ImportOperationLog.getBizAppId(view, bizObjID), bizObjID, opNameBridge, opDescBridge, opDescArgs);
    }

    public void createAppLog(String bizAppId, String bizObjID, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setOpName("importOpLog", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        this.service.addLog((AppLogInfo)appLogInfo);
    }

    public OpLogAppInfo reBuildAppInfo(String operateKey, LocaleString operateName, AppLogInfo logInfo) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(logInfo.getBizAppID());
        appLogInfo.setBizObjID(logInfo.getBizObjID());
        appLogInfo.setOpName(operateKey, operateName.getLocaleValue_zh_CN());
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u70b9\u51fb\u201c%s\u201d\u6309\u94ae\u6267\u884c\u6210\u529f\u3002", "ExportList_15", BOS_EXPORT), new String[]{operateName.getLocaleValue()});
        return appLogInfo;
    }

    private static String getBizAppId(IFormView view, String entityNumber) {
        String appId = null;
        String appNumber = view.getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            return BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        if (StringUtils.isEmpty(appId)) {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            appId = abstractMetadata.getBizappId();
        }
        return appId;
    }

    private static String limitLength(String desc) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)desc) && desc.length() > 250) {
            desc = desc.substring(0, 250);
        }
        return desc;
    }

    public static enum OperationEnum {
        IMPORT_SUCCESS(1, new MultiLangEnumBridge("\u5bfc\u5165", "ImportOperationLog_1", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u6267\u884c\u6210\u529f", "ImportOperationLog_2", "bos-export")),
        IMPORT_FAIL(2, new MultiLangEnumBridge("\u5bfc\u5165", "ImportOperationLog_1", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u6267\u884c\u5931\u8d25", "ImportOperationLog_3", "bos-export")),
        UPLOAD_FILE_SUCCESS(3, new MultiLangEnumBridge("\u4e0a\u4f20\u6587\u4ef6", "ImportOperationLog_4", "bos-export"), new MultiLangEnumBridge("\u4e0a\u4f20\u6587\u4ef6%s\u6210\u529f", "ImportOperationLog_5", "bos-export")),
        UPLOAD_FILE_FAIL(4, new MultiLangEnumBridge("\u4e0a\u4f20\u6587\u4ef6", "ImportOperationLog_4", "bos-export"), new MultiLangEnumBridge("\u4e0a\u4f20\u6587\u4ef6%s\u5931\u8d25", "ImportOperationLog_6", "bos-export")),
        IMPORT_START_SUCCESS(5, new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165", "ImportOperationLog_7", "bos-export"), new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165\u6267\u884c\u6210\u529f", "ImportOperationLog_8", "bos-export")),
        IMPORT_START_FAIL(6, new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165", "ImportOperationLog_7", "bos-export"), new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165\u6267\u884c\u5931\u8d25", "ImportOperationLog_9", "bos-export")),
        EXPORT_LIST_SUCCESS(7, new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa", "ImportOperationLog_10", "bos-export"), new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa\u6267\u884c\u6210\u529f", "ImportOperationLog_11", "bos-export")),
        EXPORT_LIST_FAIL(8, new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa", "ImportOperationLog_10", "bos-export"), new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa\u6267\u884c\u5931\u8d25", "ImportOperationLog_12", "bos-export")),
        EXPORT_LIST_RESULT(34, new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa", "ImportOperationLog_10", "bos-export"), new MultiLangEnumBridge("\u6309\u5217\u8868\u5bfc\u51fa\u6570\u636e\u6210\u529f%s\u6761", "ImportOperationLog_32", "bos-export")),
        EXPORT_BY_IMPORT_TEMPLATE_SUCCESS(9, new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_13", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u7248\u5bfc\u51fa\u6267\u884c\u6210\u529f", "ImportOperationLog_14", "bos-export")),
        EXPORT_BY_IMPORT_TEMPLATE_FAIL(10, new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_13", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u7248\u5bfc\u51fa\u6267\u884c\u5931\u8d25", "ImportOperationLog_15", "bos-export")),
        EXPORT_BY_IMPORT_TEMPLATE_RESULT(35, new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_13", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u6570\u636e\u6210\u529f%s\u6761", "ImportOperationLog_58", "bos-export")),
        EXPORT_BY_EXPORT_TEMPLATE_SUCCESS(11, new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_16", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u7248\u5bfc\u51fa\u6267\u884c\u6210\u529f", "ImportOperationLog_17", "bos-export")),
        EXPORT_BY_EXPORT_TEMPLATE_FAIL(12, new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_16", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u7248\u5bfc\u51fa\u6267\u884c\u5931\u8d25", "ImportOperationLog_18", "bos-export")),
        EXPORT_BY_EXPORT_TEMPLATE_RESULT(36, new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u7248\u5bfc\u51fa", "ImportOperationLog_13", "bos-export"), new MultiLangEnumBridge("\u6309\u5bfc\u51fa\u6a21\u677f\u5bfc\u51fa\u6570\u636e\u6210\u529f%s\u6761", "ImportOperationLog_33", "bos-export")),
        VIEW_IMPORT_RESULT_SUCCESS(13, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", "ImportOperationLog_19", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u6267\u884c\u6210\u529f", "ImportOperationLog_34", "bos-export")),
        VIEW_IMPORT_RESULT_FAIL(14, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", "ImportOperationLog_19", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u6267\u884c\u5931\u8d25", "ImportOperationLog_35", "bos-export")),
        VIEW_EXPORT_RESULT_SUCCESS(15, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", "ImportOperationLog_20", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u6267\u884c\u6210\u529f", "ImportOperationLog_36", "bos-export")),
        VIEW_EXPORT_RESULT_FAIL(16, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", "ImportOperationLog_20", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u6267\u884c\u5931\u8d25", "ImportOperationLog_37", "bos-export")),
        DOWNLOAD_FROM_VIEW_EXPORT_RESULT_SUCCESS(17, new MultiLangEnumBridge("\u4e0b\u8f7d", "ImportOperationLog_21", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d%s\u6210\u529f", "ImportOperationLog_38", "bos-export")),
        DOWNLOAD_FROM_VIEW_EXPORT_RESULT_FAIL(18, new MultiLangEnumBridge("\u4e0b\u8f7d", "ImportOperationLog_21", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d%s\u5931\u8d25", "ImportOperationLog_39", "bos-export")),
        DOWNLOAD_IMPORT_FILE_FROM_VIEW_IMPORT_RESULT_SUCCESS(19, new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6", "ImportOperationLog_22", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6%s\u6210\u529f", "ImportOperationLog_40", "bos-export")),
        DOWNLOAD_IMPORT_FILE_FROM_VIEW_IMPORT_RESULT_FAIL(20, new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6", "ImportOperationLog_22", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6%s\u5931\u8d25", "ImportOperationLog_41", "bos-export")),
        DOWNLOAD_EXPORT_FILE_FROM_VIEW_EXPORT_RESULT_SUCCESS(21, new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6", "ImportOperationLog_23", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6%s\u6210\u529f", "ImportOperationLog_42", "bos-export")),
        DOWNLOAD_EXPORT_FILE_FROM_VIEW_EXPORT_RESULT_FAIL(22, new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6", "ImportOperationLog_23", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6%s\u5931\u8d25", "ImportOperationLog_43", "bos-export")),
        EXPORT_ERROR_DATA_FROM_VIEW_EXPORT_RESULT_SUCCESS(23, new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportOperationLog_24", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u6210\u529f", "ImportOperationLog_44", "bos-export")),
        EXPORT_ERROR_DATA_FROM_VIEW_EXPORT_RESULT_FAIL(24, new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportOperationLog_24", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u5bfc\u51fa\u9519\u8bef\u6570\u636e%s\u5931\u8d25", "ImportOperationLog_45", "bos-export")),
        EXPORT_ERROR_DATA_FROM_IMPORT_STOP_SUCCESS(25, new MultiLangEnumBridge("\u5bfc\u51faExcel\u9519\u8bef\u6570\u636e", "ImportOperationLog_25", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u5bfc\u51faExcel\u9519\u8bef\u6570\u636e%s\u6210\u529f", "ImportOperationLog_46", "bos-export")),
        EXPORT_ERROR_DATA_FROM_IMPORT_STOP_FAIL(26, new MultiLangEnumBridge("\u5bfc\u51faExcel\u9519\u8bef\u6570\u636e", "ImportOperationLog_25", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u5bfc\u51faExcel\u9519\u8bef\u6570\u636e%s\u5931\u8d25", "ImportOperationLog_47", "bos-export")),
        VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_SUCCESS(27, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", "ImportOperationLog_26", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u6267\u884c\u6210\u529f", "ImportOperationLog_48", "bos-export")),
        VIEW_IMPORT_RESULT_FROM_IMPORT_STOP_FAIL(28, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", "ImportOperationLog_26", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u4e2d\u6b62\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u6267\u884c\u5931\u8d25", "ImportOperationLog_49", "bos-export")),
        IMPORT_AGAIN_FROMIMPORT_STOP_SUCCESS(29, new MultiLangEnumBridge("\u7ee7\u7eed\u5bfc\u5165", "ImportOperationLog_27", "bos-export"), new MultiLangEnumBridge("\u7ee7\u7eed\u5bfc\u5165\u6210\u529f", "ImportOperationLog_50", "bos-export")),
        IMPORT_AGAIN_FROMIMPORT_STOP_FAIL(30, new MultiLangEnumBridge("\u7ee7\u7eed\u5bfc\u5165", "ImportOperationLog_27", "bos-export"), new MultiLangEnumBridge("\u7ee7\u7eed\u5bfc\u5165\u5931\u8d25", "ImportOperationLog_51", "bos-export")),
        IMPORT_RESULT_SUCCESS(31, new MultiLangEnumBridge("\u5bfc\u5165\u5b8c\u6210", "ImportOperationLog_28", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u6570\u636e\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", "ImportOperationLog_52", "bos-export")),
        IMPORT_RESULT_FAIL(32, new MultiLangEnumBridge("\u5bfc\u5165\u5b8c\u6210", "ImportOperationLog_28", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u6570\u636e\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", "ImportOperationLog_52", "bos-export")),
        IMPORT_RESULT(33, new MultiLangEnumBridge("\u5bfc\u5165\u5b8c\u6210", "ImportOperationLog_28", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u6570\u636e\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", "ImportOperationLog_52", "bos-export")),
        IMPORT_NOPERMISSION_FAIL(37, new MultiLangEnumBridge("\u5f00\u59cb\u5bfc\u5165", "ImportOperationLog_28", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\uff0c\u64cd\u4f5c\u5458\u6ca1\u6709\u5bfc\u5165\u6743\u9650", "ImportOperationLog_53", "bos-export")),
        DOWNLOAD_CLICK_SUCCESS(38, new MultiLangEnumBridge("\u7acb\u5373\u4e0b\u8f7d", "ImportOperationLog_30", "bos-export"), new MultiLangEnumBridge("\u7acb\u5373\u4e0b\u8f7d\u6267\u884c\u6210\u529f", "ImportOperationLog_54", "bos-export")),
        DOWNLOAD_CLICK_FAIL(39, new MultiLangEnumBridge("\u7acb\u5373\u4e0b\u8f7d", "ImportOperationLog_30", "bos-export"), new MultiLangEnumBridge("\u7acb\u5373\u4e0b\u8f7d\u6267\u884c\u5931\u8d25", "ImportOperationLog_55", "bos-export")),
        EXPORT_SUSPEND(40, new MultiLangEnumBridge("\u5bfc\u51fa\u7ec8\u6b62", "ImportOperationLog_31", "bos-export"), new MultiLangEnumBridge("\u5bfc\u51fa\u7ec8\u6b62\u6210\u529f", "ImportOperationLog_56", "bos-export")),
        IMPORT_SUSPEND(41, new MultiLangEnumBridge("\u5bfc\u5165\u7ec8\u6b62", "ImportOperationLog_59", "bos-export"), new MultiLangEnumBridge("\u5bfc\u5165\u7ec8\u6b62\u6210\u529f", "ImportOperationLog_57", "bos-export")),
        IMPORT_RESULT_VIEW(42, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", "ImportOperationLog_60", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u6210\u529f", "ImportOperationLog_61", "bos-export")),
        EXPORT_RESULT_VIEW(43, new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", "ImportOperationLog_62", "bos-export"), new MultiLangEnumBridge("\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c\u6210\u529f", "ImportOperationLog_63", "bos-export"));

        private int type;
        private MultiLangEnumBridge opNameBridge;
        private MultiLangEnumBridge opDescFormatBridge;

        private OperationEnum(int type, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescFormatBridge) {
            this.type = type;
            this.opNameBridge = opNameBridge;
            this.opDescFormatBridge = opDescFormatBridge;
        }

        @Deprecated
        public String getOpName() {
            return this.opNameBridge.loadKDString();
        }

        @Deprecated
        public String getOpDescFormat() {
            return this.opDescFormatBridge.loadKDString();
        }

        public MultiLangEnumBridge getOpNameBridge() {
            return this.opNameBridge;
        }

        public MultiLangEnumBridge getOpDescFormatBridge() {
            return this.opDescFormatBridge;
        }
    }
}

