/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.formplugin.ExportLogDeleteFileTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.svc.util.TimeFilterLimitUtils;

public class ExportLogListPlugin
extends AbstractListPlugin {
    private static final String IS_FROM_LOG_MENU = "isfromlogmenu";
    private static final String BT_DELETE_DATA = "deletedata";
    private static final String BT_DELETE_FILE = "deletefile";

    private boolean isFromLogMenu() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isfromMenu = formShowParameter.getCustomParam(IS_FROM_LOG_MENU);
        return StringUtils.equals((CharSequence)"true", (CharSequence)((String)isfromMenu));
    }

    public void initialize() {
        super.initialize();
        if (!this.isFromLogMenu()) {
            return;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin("kd.bos.log.formplugin.ExportLogDeleteFileTreeListPlugin");
        if (plugin != null) {
            return;
        }
        this.getView().addPlugin((IFormPlugin)new ExportLogDeleteFileTreeListPlugin());
    }

    public void afterCreateNewData(EventObject e) {
        if (!this.isFromLogMenu()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BT_DELETE_DATA, BT_DELETE_FILE});
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (!(formShowParameter instanceof ListShowParameter)) {
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            listShowParameter.setMultiSelect(false);
            ListGridView listGridView = this.getListGridView();
            if (listGridView == null) {
                return;
            }
            listGridView.setShowSelCheckbox(false);
            return;
        }
        String candelete = System.getProperty("import.candeletefile", "false");
        if (StringUtils.equals((CharSequence)"false", (CharSequence)candelete)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BT_DELETE_DATA, BT_DELETE_FILE});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"listoperationcolumnap"});
    }

    private ListGridView getListGridView() {
        String listGridViewKey = this.getBillList().getListGridViewKey();
        List items = this.getBillList().getItems();
        for (Control item : items) {
            if (!StringUtils.equals((CharSequence)item.getKey(), (CharSequence)listGridViewKey) || !(item instanceof ListGridView)) continue;
            return (ListGridView)item;
        }
        return null;
    }

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ExportLogListDataProviderImpl());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        e.getParameter().getCustomParams().put("ParentEntityId", formShowParameter.getCustomParam("ParentEntityId"));
    }

    private String getUseTime(Date createtime, Date finishTime) {
        String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"ExportLogListPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0]);
        String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"ExportLogListPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]);
        String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ExportLogListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]);
        String useTime = "1" + secondDes;
        if (null != createtime && null != finishTime) {
            long between = (finishTime.getTime() - createtime.getTime()) / 1000L;
            if (between != 0L) {
                StringBuilder sb = new StringBuilder();
                long hour = between / 3600L;
                long minute = between % 3600L / 60L;
                long second = between % 60L;
                if (hour != 0L) {
                    sb.append(hour).append(hourDes);
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else if (minute != 0L) {
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else {
                    sb.append(second).append(secondDes);
                }
                useTime = sb.toString();
            }
        } else {
            useTime = "";
        }
        return useTime;
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        ArrayList<String> timeFieldList = new ArrayList<String>(10);
        timeFieldList.add("finishtime");
        if (!TimeFilterLimitUtils.check((List)qfilters, timeFieldList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708", (String)"LogOperactionListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]), TimeFilterLimitUtils.getQueryMonthInterval()));
        }
    }

    class ExportLogListDataProviderImpl
    extends ListDataProvider {
        ExportLogListDataProviderImpl() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection obiects = super.getData(arg0, arg1);
            DynamicSimpleProperty property = new DynamicSimpleProperty();
            property.setName("usetime");
            obiects.getDynamicObjectType().addProperty((DynamicProperty)property);
            for (int i = 0; i < obiects.size(); ++i) {
                DynamicObject object = (DynamicObject)obiects.get(i);
                if (!object.containsProperty("createtime") || !object.containsProperty("finishtime")) continue;
                String useTime = ExportLogListPlugin.this.getUseTime(object.getDate("createtime"), object.getDate("finishtime"));
                object.set("usetime", (Object)useTime);
            }
            return obiects;
        }
    }
}

